/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emas.sm.applications;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import se.ericsson.cello.emas.sm.applications.CorruptedUPsTable;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.mgr.TimeConverter;
import se.ericsson.cello.support.mgr.cellomom.CVActionMainResult;
import se.ericsson.cello.support.mgr.cellomom.CVActionResultInformation;
import se.ericsson.cello.support.mgr.cellomom.CVInvokedAction;
import se.ericsson.cello.support.proxy.CSException;
import se.ericsson.cello.support.proxy.MOProxy;
import se.ericsson.cello.support.proxy.NameValue;
import se.ericsson.cello.support.proxy.Struct;

public class ResultPrintoutHelper {
    private static String pathToDetailedInfo = null;
    private static String HTML_LineBreaker = "<br>";
    private static String CommonLineBreaker = "\n";
    private static String NoLineBreaker = "";

    protected static String processResult(ResourceBundle myBundle) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ResultPrintoutHelper.processActionResult(myBundle, false));
        stringBuffer.append("\n------------------------------------\n");
        stringBuffer.append(ResultPrintoutHelper.processAdditionalActionResultData(myBundle));
        return stringBuffer.toString();
    }

    protected static String processActionResult(ResourceBundle myBundle, boolean useHtml) {
        StringBuffer stringBuffer = new StringBuffer();
        String lineBreaker = CommonLineBreaker;
        if (useHtml) {
            lineBreaker = HTML_LineBreaker;
        }
        try {
            MOProxy cvMO = MOProxy.getRoot().getChildren(2, "ConfigurationVersion", "", null)[0];
            Struct actionResult = (Struct)cvMO.getAttribute("actionResult");
            if (actionResult != null) {
                NameValue cvActionMainResult = actionResult.getNameValue("mainResult");
                String mainResult = cvActionMainResult.getValue().toString();
                stringBuffer.append("actionResult:" + lineBreaker + lineBreaker);
                ResultPrintoutHelper.appendToSb(actionResult.getNameValue("actionId"), stringBuffer, lineBreaker);
                NameValue myNameValueTime = actionResult.getNameValue("time");
                String timeConverted = new TimeConverter().formatTime(myNameValueTime.getValue().toString());
                NameValue myNameValueTimeConverted = new NameValue(myNameValueTime.getName(), (Object)timeConverted);
                ResultPrintoutHelper.appendToSb(myNameValueTimeConverted, stringBuffer, lineBreaker);
                Object ob = actionResult.getElementValue("invokedAction");
                String translate = CVInvokedAction.get((Object)ob).toString();
                stringBuffer.append("invokedAction = " + ob + " (" + ResultPrintoutHelper.getString(translate, myBundle) + ")" + lineBreaker);
                ob = actionResult.getElementValue("mainResult");
                translate = CVActionMainResult.get((Object)ob).toString();
                stringBuffer.append("mainResult = " + ob + " (" + ResultPrintoutHelper.getString(translate, myBundle) + ")" + lineBreaker);
                ResultPrintoutHelper.appendToSb(actionResult.getNameValue("configurationVersionName"), stringBuffer, lineBreaker);
                NameValue nameValuePathToDetailedInfo = actionResult.getNameValue("pathToDetailedInformation");
                pathToDetailedInfo = nameValuePathToDetailedInfo.getValue().toString();
                if (useHtml) {
                    ResultPrintoutHelper.appendToSbDetailedInfoAsHyperlink(nameValuePathToDetailedInfo, stringBuffer);
                } else {
                    ResultPrintoutHelper.appendToSb(nameValuePathToDetailedInfo, stringBuffer, lineBreaker);
                }
            }
        }
        catch (NoSuchFieldException e) {
            Log.logError((String)"Error building fault information", (Throwable)e);
        }
        catch (CSException e) {
            Log.logError((String)"Error getting the ConfigurationVersion MO", (Throwable)e);
        }
        return stringBuffer.toString();
    }

    protected static String processAdditionalActionResultData(ResourceBundle myBundle) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            MOProxy cvMO = MOProxy.getRoot().getChildren(2, "ConfigurationVersion", "", null)[0];
            Struct[] additionalActionResultData = (Struct[])cvMO.getAttribute("additionalActionResultData");
            if (additionalActionResultData != null) {
                stringBuffer.append("additionalActionResultData [" + additionalActionResultData.length + "]:\n\n");
                for (int i = 0; i < additionalActionResultData.length; ++i) {
                    Object ob = additionalActionResultData[i].getElementValue("information");
                    String translate = CVActionResultInformation.get((Object)ob).toString();
                    stringBuffer.append("information = " + ob + " (" + ResultPrintoutHelper.getString(translate, myBundle) + ")\n");
                    ResultPrintoutHelper.appendToSb(additionalActionResultData[i].getNameValue("additionalInformation"), stringBuffer, CommonLineBreaker);
                    stringBuffer.append("\n\n");
                }
            } else {
                stringBuffer.append("\nadditionalActionResultData is null\n");
            }
        }
        catch (NoSuchFieldException e) {
            Log.logError((String)"Error building fault information", (Throwable)e);
        }
        catch (CSException e) {
            Log.logError((String)"Error getting the ConfigurationVersion MO", (Throwable)e);
        }
        return stringBuffer.toString();
    }

    protected static String[] processMissingUPs() {
        StringBuffer stringBuffer = new StringBuffer();
        String[] result = null;
        try {
            MOProxy cvMO = MOProxy.getRoot().getChildren(2, "ConfigurationVersion", "", null)[0];
            Struct[] missingUpgradePackages = (Struct[])cvMO.getAttribute("missingUpgradePackages");
            if (missingUpgradePackages != null) {
                result = new String[missingUpgradePackages.length];
                for (int i = 0; i < missingUpgradePackages.length; ++i) {
                    stringBuffer = new StringBuffer();
                    ResultPrintoutHelper.appendToSb(missingUpgradePackages[i].getNameValue("productInfo"), stringBuffer, CommonLineBreaker);
                    NameValue myNameValueDate = missingUpgradePackages[i].getNameValue("productionDate");
                    String dateConverted = new TimeConverter().formatTime(myNameValueDate.getValue().toString());
                    NameValue myNameValueDateConverted = new NameValue(myNameValueDate.getName(), (Object)dateConverted);
                    ResultPrintoutHelper.appendToSb(myNameValueDateConverted, stringBuffer, CommonLineBreaker);
                    ResultPrintoutHelper.appendToSb(missingUpgradePackages[i].getNameValue("productName"), stringBuffer, CommonLineBreaker);
                    ResultPrintoutHelper.appendToSb(missingUpgradePackages[i].getNameValue("productNumber"), stringBuffer, CommonLineBreaker);
                    ResultPrintoutHelper.appendToSb(missingUpgradePackages[i].getNameValue("productRevision"), stringBuffer, CommonLineBreaker);
                    result[i] = stringBuffer.toString();
                }
            }
        }
        catch (NoSuchFieldException e) {
            Log.logError((String)"Error building fault information", (Throwable)e);
        }
        catch (CSException e) {
            Log.logError((String)"Error getting the ConfigurationVersion MO", (Throwable)e);
        }
        return result;
    }

    protected static CorruptedUPsTable[] processCorruptedUPs() {
        StringBuffer stringBuffer = new StringBuffer();
        CorruptedUPsTable[] result = null;
        try {
            MOProxy cvMO = MOProxy.getRoot().getChildren(2, "ConfigurationVersion", "", null)[0];
            Struct[] corruptedUpgradePackages = (Struct[])cvMO.getAttribute("corruptedUpgradePackages");
            if (corruptedUpgradePackages != null) {
                result = new CorruptedUPsTable[corruptedUpgradePackages.length];
                for (int i = 0; i < corruptedUpgradePackages.length; ++i) {
                    stringBuffer = new StringBuffer();
                    ResultPrintoutHelper.appendToSb(corruptedUpgradePackages[i].getNameValue("productInfo"), stringBuffer, CommonLineBreaker);
                    NameValue myNameValueDate = corruptedUpgradePackages[i].getNameValue("productionDate");
                    String dateConverted = new TimeConverter().formatTime(myNameValueDate.getValue().toString());
                    NameValue myNameValueDateConverted = new NameValue(myNameValueDate.getName(), (Object)dateConverted);
                    ResultPrintoutHelper.appendToSb(myNameValueDateConverted, stringBuffer, CommonLineBreaker);
                    NameValue adminProductData_ProductName = corruptedUpgradePackages[i].getNameValue("productName");
                    NameValue adminProductData_ProductNumber = corruptedUpgradePackages[i].getNameValue("productNumber");
                    NameValue adminProductData_ProductRevision = corruptedUpgradePackages[i].getNameValue("productRevision");
                    ResultPrintoutHelper.appendToSb(adminProductData_ProductName, stringBuffer, CommonLineBreaker);
                    ResultPrintoutHelper.appendToSb(adminProductData_ProductNumber, stringBuffer, CommonLineBreaker);
                    ResultPrintoutHelper.appendToSb(adminProductData_ProductRevision, stringBuffer, NoLineBreaker);
                    result[i] = new CorruptedUPsTable();
                    result[i].upIdentifier = adminProductData_ProductNumber.getValue().toString() + adminProductData_ProductRevision.getValue().toString();
                    result[i].corruptedUP_data = stringBuffer.toString();
                }
            }
        }
        catch (NoSuchFieldException e) {
            Log.logError((String)"Error building fault information", (Throwable)e);
        }
        catch (CSException e) {
            Log.logError((String)"Error getting the ConfigurationVersion MO", (Throwable)e);
        }
        return result;
    }

    public static String getPathToDetailedInformation() {
        try {
            MOProxy cvMO = MOProxy.getRoot().getChildren(2, "ConfigurationVersion", "", null)[0];
            Struct actionResult = (Struct)cvMO.getAttribute("actionResult");
            if (actionResult != null) {
                NameValue nameValuePathToDetailedInfo = actionResult.getNameValue("pathToDetailedInformation");
                pathToDetailedInfo = nameValuePathToDetailedInfo.getValue().toString();
            }
        }
        catch (Exception e) {
            Log.logError((String)"Error getting attribute actionResult information", (Throwable)e);
        }
        return pathToDetailedInfo;
    }

    private static void appendToSb(NameValue addThis, StringBuffer strBf, String lineBreaker) {
        strBf.append(addThis.getName() + " = " + addThis.getValue().toString() + lineBreaker);
    }

    private static void appendToSbDetailedInfoAsHyperlink(NameValue addThis, StringBuffer strBf) {
        String myHyperlink = "";
        pathToDetailedInfo = addThis.getValue().toString();
        if (pathToDetailedInfo != null && !pathToDetailedInfo.equals("")) {
            myHyperlink = "<a href=\"pathToDetailedInfoHyperlink\">" + pathToDetailedInfo + "</a><br>";
        }
        strBf.append(addThis.getName() + " = " + myHyperlink);
    }

    private static String getString(String key, ResourceBundle bundle) {
        String str = null;
        try {
            str = bundle.getString(key);
        }
        catch (MissingResourceException mre) {
            Log.logError((String)"Error getting the string for the bundle", (Throwable)mre);
        }
        return str;
    }
}

