/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emas.sm.applications;

import javax.swing.SwingUtilities;
import se.ericsson.cello.emas.sm.applications.HardSoftSelection;
import se.ericsson.cello.emas.sm.applications.UpgradePackageController;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.infra.AbstractApplicationController;
import se.ericsson.cello.support.gui.guilib.infra.AbstractController;
import se.ericsson.cello.support.proxy.CSException;
import se.ericsson.cello.support.proxy.MOProxy;
import se.ericsson.cello.support.proxy.NameValue;

public class UpgradePackageInstallController
extends AbstractApplicationController {
    private MOProxy upgradePackageMo;
    private static final NameValue[] NO_ARGS = new NameValue[0];
    private String upgradePackageUserLabel = "";
    private String ftpServer = "";
    private static final int UPGRADE_TIMEOUT = 5000;

    protected void init() {
        String ldn = (String)this.getParameter("LDNLIST");
        this.upgradePackageMo = new MOProxy(ldn);
        try {
            boolean isParameterOk;
            boolean bl = isParameterOk = ldn != null && !ldn.equals("") && this.upgradePackageMo != null && this.upgradePackageMo.isExisting() && this.upgradePackageMo.getType().equals("UpgradePackage");
            if (isParameterOk) {
                this.upgradePackageUserLabel = (String)this.upgradePackageMo.getAttribute("userLabel");
                this.ftpServer = (String)this.upgradePackageMo.getAttribute("ftpServerIpAddress");
                Object[] messageArguments = new Object[]{this.upgradePackageUserLabel, this.ftpServer, ""};
                HardSoftSelection selection = UpgradePackageController.userSelectsHardSoftCancel("UP_INSTALL_CONFIRM_TITLE", "UP_INSTALL_CONFIRM_MSG", messageArguments, "UP_SOFT_INSTALL", "UP_HARD_INSTALL", (AbstractController)this);
                if (selection != HardSoftSelection.CANCEL) {
                    this.installUpgradePackage(selection);
                }
            } else {
                Log.logError((String)("Illegal argument to UpgradePackageInstallController: LDNLIST=" + ldn));
            }
        }
        catch (CSException e) {
            this.reportException((Exception)((Object)e), "ERROR_GET", null);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                UpgradePackageInstallController.this.localStopApplication();
            }
        });
    }

    private void localStopApplication() {
        this.getApplication().stopApplicationNoCheck();
    }

    public void installUpgradePackage(HardSoftSelection typeSelection) {
        if (typeSelection == HardSoftSelection.CANCEL) {
            return;
        }
        try {
            if (typeSelection == HardSoftSelection.HARD) {
                this.upgradePackageMo.action("nonBlockingForcedInstall", NO_ARGS, null);
            } else {
                this.upgradePackageMo.action("nonBlockingInstall", NO_ARGS, null);
            }
        }
        catch (CSException e) {
            this.reportException((Exception)((Object)e), "UP_INSTALL_ERROR_MSG", null);
            return;
        }
    }
}

