/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emas.sm.elements;

import java.util.Properties;
import se.ericsson.cello.emas.sm.elements.RPUSlotElementCreator;
import se.ericsson.cello.emas.sm.elements.SlotElementCreator;
import se.ericsson.cello.emas.sm.services.SlotNameFactory;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.mgr.AttributeBuffer;
import se.ericsson.cello.support.mgr.EmasViewElement;
import se.ericsson.cello.support.mgr.EmasViewElementCreator;
import se.ericsson.cello.support.mgr.MOComposite;
import se.ericsson.cello.support.proxy.CSException;
import se.ericsson.cello.support.proxy.MOProxy;

public class SlotElement
extends EmasViewElement {
    private MOProxy slot;
    private MOProxy subrack;
    private String slotName;
    private String slotNumber;
    private String cabinetPos;
    private String subrackPos;
    private String userLabel;

    public SlotElement(MOComposite aMoc, Properties aProperties, SlotElementCreator aCreator) throws CSException {
        super(aMoc, aProperties, (EmasViewElementCreator)aCreator);
        this.slot = aMoc.getMO("Slot");
        this.subrack = this.slot.getParent();
        this.refreshData();
    }

    public SlotElement(MOComposite aMoc, Properties aProperties, RPUSlotElementCreator aCreator) throws CSException {
        super(aMoc, aProperties, (EmasViewElementCreator)aCreator);
        this.slot = aMoc.getMO("Slot");
        this.subrack = this.slot.getParent();
        this.refreshData();
    }

    public String getName() {
        return this.slotName;
    }

    public Object getAttributeValue(String aName) {
        String value = null;
        if (aName.equals("ATTR_CABINET")) {
            value = this.cabinetPos;
        } else if (aName.equals("ATTR_SUBRACK")) {
            value = this.subrackPos;
        } else if (aName.equals("ATTR_SLOT")) {
            value = this.slotNumber;
        } else if (aName.equals("ATTR_TYPE")) {
            value = this.translateKey("SLOT");
        } else if (aName.equals("ATTR_USERLABEL")) {
            value = this.userLabel;
        }
        return value;
    }

    private void refreshData() throws CSException {
        Object moList = null;
        String[] attributes = new String[]{"cabinetPosition", "subrackPosition"};
        try {
            Object[] values = this.subrack.getAttributes(attributes);
            AttributeBuffer buffer = new AttributeBuffer(attributes, values);
            this.cabinetPos = (String)buffer.getAttribute("cabinetPosition");
            this.subrackPos = (String)buffer.getAttribute("subrackPosition");
            this.slotNumber = this.slot.getId();
            this.slotName = SlotNameFactory.getSlotName(this.slot);
            this.userLabel = (String)this.slot.getAttribute("userLabel");
        }
        catch (CSException e) {
            Log.logError((String)"Error determining slot name", (Throwable)e);
            throw e;
        }
    }

    public void refresh() {
        try {
            this.refreshData();
        }
        catch (CSException e) {
            Log.logError((String)"refresh failed", (Throwable)e);
        }
    }

    public String getBoardType(MOProxy slotMo) {
        String boardType = "<empty>";
        try {
            MOProxy[] boardMo = slotMo.getChildren(2, "", "");
            if (boardMo.length > 2) {
                int index;
                String dn = boardMo[2].getDN();
                String board = dn.substring((index = dn.lastIndexOf(",")) + 1);
                if (board.startsWith("Etm1")) {
                    boardType = "ET-M1";
                } else if (board.startsWith("Etm4")) {
                    boardType = "ET-M4";
                } else if (board.startsWith("TimingUnit")) {
                    boardType = "TUB";
                } else if (board.startsWith("Spu")) {
                    boardType = "SPB";
                } else if (board.startsWith("SwitchCoreUnit")) {
                    boardType = "SCB";
                } else if (board.startsWith("SwitchExtensionUnit")) {
                    boardType = "SXB";
                } else if (board.startsWith("GeneralProcessorUnit")) {
                    boardType = "GPB";
                } else if (board.startsWith("TimingUnit")) {
                    boardType = "TUB";
                }
            }
        }
        catch (CSException e) {
            Log.logError((String)"Error with determination of the board", (Throwable)e);
        }
        return boardType;
    }
}

