/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emas.sm.elements;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import se.ericsson.cello.emas.sm.elements.EmasElementCreator;
import se.ericsson.cello.support.gui.AbstractViewElement;
import se.ericsson.cello.support.gui.TopologyModel;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.mgr.EmasViewElement;
import se.ericsson.cello.support.mgr.EmasViewElementInterface;
import se.ericsson.cello.support.mgr.MOComposite;
import se.ericsson.cello.support.proxy.CSException;
import se.ericsson.cello.support.proxy.MOProxy;
import se.ericsson.cello.support.proxy.NameValue;

public class SlotElementCreator
extends EmasElementCreator {
    private MOProxy m_swAllocation = null;
    private Hashtable childElements;

    public SlotElementCreator(Properties p) {
        super(p);
    }

    public void dispose() {
        if (this.m_swAllocation != null) {
            this.m_swAllocation.removeMOListener((MOProxy.MOListener)this);
        }
    }

    public AbstractViewElement[] createInstances(AbstractViewElement parent) {
        MOProxy[] slotList = null;
        Vector<EmasViewElementInterface> newElements = new Vector<EmasViewElementInterface>();
        EmasViewElementInterface parentElement = (EmasViewElementInterface)parent;
        this.m_swAllocation = ((EmasViewElement)parentElement).getMO("SwAllocation");
        String dn = this.m_swAllocation.getDN();
        Log.trace((String)("parent LDN=" + this.m_swAllocation.getDN()));
        if (this.parentElements.containsKey(dn)) {
            Log.trace((String)"already subscribed");
        } else {
            this.parentElements.put(dn, parentElement);
            this.m_swAllocation.addMOListener((MOProxy.MOListener)this);
            Log.trace((String)("addMOListener to LDN=" + this.m_swAllocation.getDN()));
        }
        try {
            slotList = (MOProxy[])this.m_swAllocation.getAttribute("slotList", null);
        }
        catch (CSException e) {
            Log.logError((String)(((Object)((Object)this)).getClass().getName() + "::createInstances failed"), (Throwable)e);
            return newElements.toArray(new AbstractViewElement[0]);
        }
        for (int index = 0; index < slotList.length; ++index) {
            if (!slotList[index].getType().equals("Slot")) continue;
            EmasViewElementInterface newElement = null;
            try {
                newElement = this.createSlotElement(slotList[index]);
                if (newElement == null) continue;
                newElements.add(newElement);
                this.addElement(newElement);
                continue;
            }
            catch (Exception e) {
                Log.logError((String)("Slot Element " + this.getClassName() + " could not be created"), (Throwable)e);
            }
        }
        return newElements.toArray(new AbstractViewElement[0]);
    }

    public void attributesChanged(MOProxy anMO, NameValue[] nameValue) {
        try {
            for (int i = 0; i < nameValue.length; ++i) {
                if (!nameValue[i].name.equals("slotList")) continue;
                AbstractViewElement swa = (AbstractViewElement)this.parentElements.get(anMO.getDN());
                MOProxy[] slotList = Array.getLength(nameValue[i].value) > 0 ? (MOProxy[])nameValue[i].value : new MOProxy[]{};
                this.updateSwAllocation(swa, slotList);
            }
        }
        catch (Exception e) {
            Log.logError((String)"update failed", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSwAllocation(AbstractViewElement swa, MOProxy[] slotList) {
        if (slotList != null) {
            AbstractViewElement abstractViewElement = swa;
            synchronized (abstractViewElement) {
                TopologyModel topologyModel = swa.getModel();
                synchronized (topologyModel) {
                    AbstractViewElement[] children = swa.getChildren();
                    Vector<MOProxy> slots = new Vector<MOProxy>(Arrays.asList(slotList));
                    for (int i = 0; i < children.length; ++i) {
                        EmasViewElement child = (EmasViewElement)children[i];
                        if (child.getMO("Slot") != null) {
                            if (slots.contains(child.getMO("Slot"))) {
                                slots.remove(child.getMO("Slot"));
                                continue;
                            }
                            swa.removeChild((AbstractViewElement)child);
                            this.deleteElement((EmasViewElementInterface)child);
                            continue;
                        }
                        if (!slots.contains(child.getMO("Fan"))) continue;
                        slots.remove(child.getMO("Fan"));
                    }
                    MOProxy[] newSlots = slots.toArray(new MOProxy[0]);
                    for (int i = 0; i < newSlots.length; ++i) {
                        MOProxy slot = newSlots[i];
                        if (!slot.getType().equals("Slot")) continue;
                        EmasViewElementInterface newElement = this.createSlotElement(slot);
                        swa.addChild((AbstractViewElement)newElement);
                        this.addElement(newElement);
                    }
                }
            }
        }
    }

    private EmasViewElementInterface createSlotElement(MOProxy slot) {
        EmasViewElementInterface newElement = null;
        try {
            MOComposite moc = new MOComposite();
            moc.add(slot);
            this.childElements = new Hashtable();
            MOProxy childElement = slot;
            String key = slot.getDN();
            this.childElements.put(key, childElement);
            Object[] args = new Object[]{moc, this.getProperties(), this};
            Class<?> c = Class.forName(this.getClassName());
            Vector v = new Vector();
            for (int i = 0; i < args.length; ++i) {
                v.add(args[i].getClass());
            }
            Constructor<?> constructor = c.getConstructor(v.toArray(new Class[0]));
            newElement = (EmasViewElementInterface)constructor.newInstance(args);
        }
        catch (Exception e) {
            Log.logError((String)("Slot Element " + this.getClassName() + " could not be created"), (Throwable)e);
        }
        return newElement;
    }
}

