/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.sctp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.ConfigurationMismatchException;
import se.ericsson.cello.mao.MaxNumberExceededException;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.ReservableImpl;
import se.ericsson.cello.maofro.framework.FroData;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.SignedIntArrayParameter;
import se.ericsson.cello.maofro.framework.UnsignedIntParameter;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.sctp.SctpAssociationMoImpl;
import se.ericsson.cello.sctp.SctpProfileMo;
import se.ericsson.cello.transaction.Coordinator;

public class SctpProfileMoImpl
extends CelloMao
implements SctpProfileMo {
    private MoData data;
    public static final int MAX_NUMBER_SCTP_PROFILE = 128;
    private static final int MO_DATA_REVISION_9000 = 9000;
    private static final int MO_DATA_REVISION_LATEST = 9000;
    private FroProxy sctpProfileProxy = null;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$String;

    public static synchronized ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator, FroProxy froProxy) throws MoAccessException {
        MoAttributeValidator.checkIdentity((String)"SctpProfile", (String)string);
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoIterator moIterator = MoRepository.instance().lookupType("SctpProfile");
        if (moIterator != null && moIterator.size() >= 128) {
            throw new MaxNumberExceededException("Cardinality exceeded", "SctpProfile");
        }
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)"TransportNetwork");
        ArrayList<UnsignedIntParameter> arrayList = new ArrayList<UnsignedIntParameter>();
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)"", (String)"SctpProfile", (int)128, (int)0);
        int n = MoAttributeValidator.checkAndGetIntegerAttribute((String)"associationMaxRtx", (AttrList)attrList, (boolean)false, (int)8, (int)1, (int)20, (String)"SctpProfile");
        int n2 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"pathMaxRtx", (AttrList)attrList, (boolean)false, (int)4, (int)1, (int)20, (String)"SctpProfile");
        if (n < n2) {
            throw new ValueOutOfRangeException("associationMaxRtx must be greater than or equal to pathMaxRtx", "SctpProfile");
        }
        int n3 = SctpProfileMoImpl.checkandGetPotentiallyFailedMaxRtx("potentiallyFailedMaxRtx", attrList, n2, 0, 0, 20, "SctpProfile");
        MoAttributeValidator.checkOtherAttributes((AttrList)attrList, (String)"SctpProfile");
        UnsignedIntParameter unsignedIntParameter = new UnsignedIntParameter("associationMaxRtx", (long)n);
        arrayList.add(unsignedIntParameter);
        UnsignedIntParameter unsignedIntParameter2 = new UnsignedIntParameter("pathMaxRtx", (long)n2);
        arrayList.add(unsignedIntParameter2);
        if (n3 != -1) {
            UnsignedIntParameter unsignedIntParameter3 = new UnsignedIntParameter("potentiallyFailedMaxRtx", (long)n3);
            arrayList.add(unsignedIntParameter3);
        }
        return new SctpProfileMoImpl(managedObject, string, string2, n, n2, n3, arrayList, coordinator, froProxy);
    }

    private SctpProfileMoImpl(ManagedObject managedObject, String string, String string2, int n, int n2, int n3, ArrayList arrayList, Coordinator coordinator, FroProxy froProxy) throws MoAccessException {
        super(managedObject, "SctpProfile", string, coordinator);
        this.sctpProfileProxy = froProxy;
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        FroData froData = this.sctpProfileProxy.create(coordinator, (Collection)arrayList);
        int n4 = froData.getFroId();
        this.data.registerPersistentAttr((Attribute)new StringAttribute("userLabel", true, string2));
        this.data.registerPersistentAttr((Attribute)new SequenceAttribute("reservedBy", false));
        this.data.registerPersistentAttr((Attribute)new IntegerAttribute("SctpProfileId", false, n4));
        this.data.setRevision(9000);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    public SctpProfileMoImpl(MoData moData, FroProxy froProxy) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName());
        this.data = moData;
        this.sctpProfileProxy = froProxy;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(9000);
        moDataRecoveryHelper.assertAttribute("SctpProfileId");
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute("reservedBy");
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.sctpProfileProxy.delete(coordinator, this.getFroId(coordinator), null);
        super.delete(coordinator);
        this.data.delete(coordinator);
    }

    public void release(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        ReservableImpl.release((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.data, (String)"reservedBy");
    }

    public void reserve(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        ReservableImpl.reserve((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.data, (String)"reservedBy");
    }

    public String getType() {
        return "SctpProfile";
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((IntegerAttribute)this.data.getAttribute("SctpProfileId")).getValue(coordinator);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("userLabel", coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("userLabel", string, coordinator);
    }

    public String getSctpProfileId(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute(this.getType() + "Id", coordinator);
    }

    public void setSctpProfileId(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute(this.getType() + "Id", "SctpProfileId", coordinator);
    }

    public ManagedObject[] getReservedBy(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject[])this.getAttribute("reservedBy", coordinator);
    }

    public ManagedObject[] getSctpAssociationRef(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject[])this.getAttribute("sctpAssociationRef", coordinator);
    }

    public int getAssociationMaxRtx(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("associationMaxRtx", coordinator);
    }

    public void setAssociationMaxRtx(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("associationMaxRtx", new Integer(n), coordinator);
    }

    public int getPathMaxRtx(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pathMaxRtx", coordinator);
    }

    public void setPathMaxRtx(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("pathMaxRtx", new Integer(n), coordinator);
    }

    public int getPotentiallyFailedMaxRtx(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("potentiallyFailedMaxRtx", coordinator);
    }

    public void setPotentiallyFailedMaxRtx(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("potentiallyFailedMaxRtx", new Integer(n), coordinator);
    }

    private Map getFroAttributes(Coordinator coordinator) throws MoAccessException {
        Map map = this.sctpProfileProxy.getAttributes(coordinator, this.getFroId(coordinator));
        return map;
    }

    public Object getAttribute(String string, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = this.getAttributes(stringArray, coordinator);
        return objectArray[0];
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Object[] objectArray = new Object[stringArray.length];
        Map map = null;
        for (int i = 0; i < stringArray.length; ++i) {
            UnsignedIntParameter unsignedIntParameter;
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                objectArray[i] = ((StringAttribute)this.data.getAttribute("userLabel")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("reservedBy")) {
                objectArray[i] = ReservableImpl.retrieveRefArrayFromSequence((SequenceAttribute)((SequenceAttribute)this.data.getAttribute("reservedBy")), (Coordinator)coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase(this.getType() + "Id")) {
                objectArray[i] = super.getNamingAttributeValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("SctpProfileId")) {
                objectArray[i] = super.getNamingAttributeValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pathMaxRtx")) {
                map = this.getAttrFromRes(map, coordinator);
                unsignedIntParameter = (UnsignedIntParameter)map.get("pathMaxRtx");
                objectArray[i] = new Integer((int)unsignedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("associationMaxRtx")) {
                map = this.getAttrFromRes(map, coordinator);
                unsignedIntParameter = (UnsignedIntParameter)map.get("associationMaxRtx");
                objectArray[i] = new Integer((int)unsignedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("potentiallyFailedMaxRtx")) {
                map = this.getAttrFromRes(map, coordinator);
                unsignedIntParameter = (UnsignedIntParameter)map.get("potentiallyFailedMaxRtx");
                objectArray[i] = new Integer((int)unsignedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("sctpAssociationRef")) {
                map = this.getAttrFromRes(map, coordinator);
                objectArray[i] = new ManagedObject[0];
                unsignedIntParameter = (SignedIntArrayParameter)map.get("sctpAssociationRef");
                if (unsignedIntParameter.getValue() == null || unsignedIntParameter.getValue().length <= 0) continue;
                objectArray[i] = this.getSctpAssocArray(unsignedIntParameter.getValue(), coordinator);
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "SctpProfile");
        }
        return objectArray;
    }

    private Map getAttrFromRes(Map map, Coordinator coordinator) throws MoAccessException {
        if (map == null) {
            return this.getFroAttributes(coordinator);
        }
        return map;
    }

    public void setAttribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        this.setAttributes(stringArray, objectArray, coordinator);
    }

    private void sendNotification(String string, Object object, Coordinator coordinator) {
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    public void setAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException {
        int n;
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        int n2 = 0;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        ArrayList<UnsignedIntParameter> arrayList = new ArrayList<UnsignedIntParameter>();
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n].equalsIgnoreCase("associationMaxRtx")) {
                if (objectArray[n].getClass().equals(class$java$lang$Integer == null ? SctpProfileMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    n3 = (Integer)objectArray[n];
                    continue;
                }
                throw new WrongAttributeTypeException("associationMaxRtx", "SctpProfile");
            }
            if (stringArray[n].equalsIgnoreCase("pathMaxRtx")) {
                if (objectArray[n].getClass().equals(class$java$lang$Integer == null ? SctpProfileMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    n4 = (Integer)objectArray[n];
                    continue;
                }
                throw new WrongAttributeTypeException("pathMaxRtx", "SctpProfile");
            }
            if (!stringArray[n].equalsIgnoreCase("potentiallyFailedMaxRtx")) continue;
            if (objectArray[n].getClass().equals(class$java$lang$Integer == null ? SctpProfileMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                n5 = (Integer)objectArray[n];
                continue;
            }
            throw new WrongAttributeTypeException("potentiallyFailedMaxRtx", "SctpProfile");
        }
        for (n = 0; n < stringArray.length; ++n) {
            int n6;
            if (stringArray[n].equalsIgnoreCase("userLabel")) {
                if (!objectArray[n].getClass().equals(class$java$lang$String == null ? SctpProfileMoImpl.class$("java.lang.String") : class$java$lang$String)) {
                    throw new WrongAttributeTypeException("userLabel", "SctpProfile");
                }
                MoAttributeValidator.checkStringWithLength((String)((String)objectArray[n]), (String)"userLabel", (String)"SctpProfile", (int)128, (int)0);
                ((StringAttribute)this.data.getAttribute("userLabel")).setValue((String)objectArray[n]);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("associationMaxRtx")) {
                n2 = (Integer)objectArray[n];
                MoAttributeValidator.checkIntegerAttribute((String)"associationMaxRtx", (int)n2, (int)1, (int)20, (String)"SctpProfile");
                if (n4 != -1) {
                    if (n3 < n4) {
                        throw new ValueOutOfRangeException("associationMaxRtx must be greater than or equal to pathMaxRtx", "SctpProfile");
                    }
                    arrayList.add(new UnsignedIntParameter("associationMaxRtx", (long)n2));
                } else {
                    n6 = (Integer)this.getAttribute("pathMaxRtx", coordinator);
                    if (n2 < n6) {
                        throw new ValueOutOfRangeException("associationMaxRtx must be greater than or equal to pathMaxRtx", "SctpProfile");
                    }
                    arrayList.add(new UnsignedIntParameter("associationMaxRtx", (long)n2));
                }
                this.sendNotification("associationMaxRtx", new Integer(n2), coordinator);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("pathMaxRtx")) {
                n2 = (Integer)objectArray[n];
                MoAttributeValidator.checkIntegerAttribute((String)"pathMaxRtx", (int)n2, (int)1, (int)20, (String)"SctpProfile");
                if (n3 != -1) {
                    if (n3 < n4) {
                        throw new ValueOutOfRangeException("associationMaxRtx must be greater than or equal to pathMaxRtx", "SctpProfile");
                    }
                    arrayList.add(new UnsignedIntParameter("pathMaxRtx", (long)n2));
                } else {
                    n6 = (Integer)this.getAttribute("associationMaxRtx", coordinator);
                    if (n2 > n6) {
                        throw new ValueOutOfRangeException("associationMaxRtx must be greater than or equal to pathMaxRtx", "SctpProfile");
                    }
                }
                if (n5 != -1 ? n5 > n4 : n2 < (n6 = ((Integer)this.getAttribute("potentiallyFailedMaxRtx", coordinator)).intValue())) {
                    throw new ValueOutOfRangeException("pathMaxRtx must be greater than or equal to potentiallyFailedMaxRtx", "SctpProfile");
                }
                arrayList.add(new UnsignedIntParameter("pathMaxRtx", (long)n2));
                this.sendNotification("pathMaxRtx", new Integer(n2), coordinator);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("potentiallyFailedMaxRtx")) {
                n2 = (Integer)objectArray[n];
                MoAttributeValidator.checkIntegerAttribute((String)"potentiallyFailedMaxRtx", (int)n2, (int)0, (int)20, (String)"SctpProfile");
                if (n4 != -1 ? n5 > n4 : n2 > (n6 = ((Integer)this.getAttribute("pathMaxRtx", coordinator)).intValue())) {
                    throw new ValueOutOfRangeException("pathMaxRtx must be greater than or equal to potentiallyFailedMaxRtx", "SctpProfile");
                }
                arrayList.add(new UnsignedIntParameter("potentiallyFailedMaxRtx", (long)n2));
                this.sendNotification("potentiallyFailedMaxRtx", new Integer(n2), coordinator);
                continue;
            }
            throw new NoSuchAttributeException(stringArray[n], "SctpProfile");
        }
        if (arrayList.size() > 0) {
            this.sctpProfileProxy.setAttributes(coordinator, this.getFroId(coordinator), arrayList);
        }
    }

    private ManagedObject[] getSctpAssocArray(int[] nArray, Coordinator coordinator) throws MoAccessException, ConfigurationMismatchException {
        if (nArray != null) {
            ManagedObject[] managedObjectArray = null;
            ArrayList<SctpAssociationMoImpl> arrayList = new ArrayList<SctpAssociationMoImpl>();
            SctpAssociationMoImpl sctpAssociationMoImpl = null;
            for (int i = 0; i < nArray.length; ++i) {
                sctpAssociationMoImpl = SctpAssociationMoImpl.lookupInstance(nArray[i], coordinator);
                arrayList.add(sctpAssociationMoImpl);
            }
            managedObjectArray = new ManagedObject[arrayList.size()];
            arrayList.toArray(managedObjectArray);
            return managedObjectArray;
        }
        return null;
    }

    private static int checkandGetPotentiallyFailedMaxRtx(String string, AttrList attrList, int n, int n2, int n3, int n4, String string2) throws MoAccessException {
        int n5 = attrList.indexOf(string);
        if (n5 == -1 && n == 4) {
            return n2;
        }
        if (n5 == -1 && n != 4) {
            return -1;
        }
        if (!(attrList.getValue(n5) instanceof Integer)) {
            throw new WrongAttributeTypeException(string, string2);
        }
        int n6 = (Integer)attrList.getValue(n5);
        if (n6 < n3 || n6 > n4) {
            throw new ValueOutOfRangeException(string, string2);
        }
        attrList.removeElementAt(n5);
        return n6;
    }
}

