/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.maofro.framework;

import se.ericsson.cello.maofro.framework.IllegalParameterValueException;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.ParameterVisitor;

public class StringParameter
extends Parameter {
    private int length;
    private String value;

    public StringParameter(String string, String string2) throws IllegalParameterValueException {
        super(string);
        if (string2 == null) {
            throw new IllegalParameterValueException("NULL not permitted in StringParameter");
        }
        this.value = string2;
        this.length = string2.length();
    }

    public StringParameter(String string, String string2, int n) throws IllegalParameterValueException {
        this(string, string2);
        if (string2.length() > n) {
            throw new IllegalParameterValueException("String <" + string2 + "> has length " + string2.length() + ", exceeded max length " + n);
        }
        this.length = n;
    }

    public int length() {
        return this.length;
    }

    public String getValue() {
        return this.value;
    }

    public String getValueAsString() {
        return "\"" + this.getValue() + "\"";
    }

    public void accept(ParameterVisitor parameterVisitor) throws Exception {
        parameterVisitor.visitStringParameter(this);
    }
}

