/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.maofro.proxy;

import java.util.Iterator;
import se.ericsson.cello.maofro.framework.AggregateParameter;
import se.ericsson.cello.maofro.framework.ArrayParameter;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.ParameterVisitor;
import se.ericsson.cello.maofro.framework.SignedIntArrayParameter;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.maofro.framework.StringParameter;
import se.ericsson.cello.maofro.framework.StructParameter;
import se.ericsson.cello.maofro.framework.UnsignedIntParameter;

public class ParameterSizeCounter
implements ParameterVisitor {
    private int byteCount = 0;
    private int structCount = 0;
    public static final int ATTRIBUTE_STRUCT_SIZE = 12;
    public static final int S32_SIZE = 4;

    public int size() {
        return this.structCount;
    }

    public int getByteCount() {
        return this.byteCount;
    }

    public int getStructCount() {
        return this.structCount;
    }

    public void reset() {
        this.byteCount = 0;
        this.structCount = 0;
    }

    public void visitStringParameter(StringParameter stringParameter) {
        int n = stringParameter.length();
        this.byteCount += 12 + (n + 4) - n % 4;
        ++this.structCount;
    }

    public void visitSignedIntParameter(SignedIntParameter signedIntParameter) {
        this.byteCount += 12;
        ++this.structCount;
    }

    public void visitUnsignedIntParameter(UnsignedIntParameter unsignedIntParameter) {
        this.byteCount += 12;
        ++this.structCount;
    }

    public void visitArrayParameter(ArrayParameter arrayParameter) throws Exception {
        this.handleAggregateParameter(arrayParameter);
    }

    public void visitStructParameter(StructParameter structParameter) throws Exception {
        this.handleAggregateParameter(structParameter);
    }

    public void visitSignedIntArrayParameter(SignedIntArrayParameter signedIntArrayParameter) throws Exception {
        this.byteCount += 12 + signedIntArrayParameter.getValue().length * 4;
        ++this.structCount;
    }

    private void handleAggregateParameter(AggregateParameter aggregateParameter) throws Exception {
        this.byteCount += 24;
        this.structCount += 2;
        Iterator iterator = aggregateParameter.iterator();
        while (iterator.hasNext()) {
            ((Parameter)iterator.next()).accept(this);
        }
    }
}

