/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.launchpad.toolservice;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Properties;
import se.ericsson.cello.launchpad.LaunchpadLog;
import se.ericsson.cello.launchpad.toolservice.Tool;
import se.ericsson.cello.launchpad.toolservice.ToolHandling;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterHandler
implements ToolHandling {
    static final String TOOL_KEYS = "TOOL_KEYS";
    static final String NAME_SUFFIX = "_NAME";
    static final String FILE_SUFFIX = "_CONFIG";
    static final String KEY_DELIMITER = ";";
    static final String TITLE_KEY = "CUSTOM_APPL_NAME";
    static final String MANAGER_TITLE_KEY = "MANAGER_TITLE";
    static final String DEFAULT_MANAGER_TITLE = "CPP Element Manager";
    static final String DEFAULT_ICON = "se/ericsson/cello/launchpad/view/default.gif";
    static final String DEFAULT_TITLE = "Launchpad";
    static final String HELPSERVICE_CONFIG = "HELPSERVICE_CONFIG";
    private HashMap<String, Tool> tools = new HashMap();
    private String title;
    private String iconPath = null;
    private String iconToPassOn = null;
    public static final String SUPERSEDING_PARAMETER_LIST = "SUPERSEDING_PARAMETER_LIST";
    private Properties myProperties = null;

    public ParameterHandler() {
        LaunchpadLog.logger().finer("Creating parameterhandler");
    }

    public void parse(Properties props) {
        File f;
        LaunchpadLog.logger().finer("Parsing properties");
        this.myProperties = props;
        this.parseTools(props);
        String custom_appl_name = props.getProperty(TITLE_KEY, DEFAULT_TITLE);
        String managTitle = props.getProperty(MANAGER_TITLE_KEY, DEFAULT_MANAGER_TITLE);
        this.title = managTitle + " - " + custom_appl_name;
        this.title = this.title.trim();
        this.iconPath = props.getProperty("TOOL_ICON", DEFAULT_ICON);
        if (null != props.getProperty("TOOL_ICON")) {
            this.iconToPassOn = this.iconPath;
        }
        if (!(f = new File(this.iconPath)).exists()) {
            LaunchpadLog.logger().fine("No path icon supplied. Setting default image");
            this.iconPath = DEFAULT_ICON;
            this.iconToPassOn = null;
        }
    }

    private void parseTools(Properties props) {
        String toolKeys = props.getProperty(TOOL_KEYS);
        if (toolKeys != null) {
            LaunchpadLog.logger().fine("Parsing TOOL_KEYS");
            String[] keys = toolKeys.split(KEY_DELIMITER);
            for (int i = 0; i < keys.length; ++i) {
                Tool tool = new Tool();
                tool.setConfigFile(props.getProperty(keys[i] + FILE_SUFFIX));
                tool.setName(props.getProperty(keys[i] + NAME_SUFFIX));
                this.tools.put(tool.getName(), tool);
                LaunchpadLog.logger().finer("Found " + keys[i] + " " + tool.getConfigFile());
            }
        }
    }

    @Override
    public Tool getTool(String name) {
        return this.tools.get(name);
    }

    @Override
    public Collection<Tool> getTools() {
        return this.tools.values();
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getIconPath() {
        return this.iconPath;
    }

    @Override
    public String getIconToPassOn() {
        return this.iconToPassOn;
    }

    @Override
    public Properties getSupersedingProperties() {
        Properties tempProp = new Properties();
        String strSupersedingList = this.myProperties.getProperty(SUPERSEDING_PARAMETER_LIST);
        if (strSupersedingList != null) {
            tempProp.put(SUPERSEDING_PARAMETER_LIST, strSupersedingList);
            String[] supersedingListArray = strSupersedingList.split(KEY_DELIMITER);
            for (int i = 0; i < supersedingListArray.length; ++i) {
                String supersedingName = supersedingListArray[i];
                String supersedingValue = this.myProperties.getProperty(supersedingName);
                if (null == supersedingValue) continue;
                tempProp.put(supersedingName, supersedingValue);
            }
        }
        return tempProp;
    }
}

