/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.cmaaue.from;

import se.ericsson.cello.aueframework.collector.AttrListImpl;
import se.ericsson.cello.aueframework.collector.CollectorContext;
import se.ericsson.cello.aueframework.collector.DataCollectorAction;
import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.cmaaue.from.Constants;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.transaction.Coordinator;

public class CreateDefaultOspfAreaAction
implements DataCollectorAction,
Constants {
    private static final String AREAID = "areaId";
    private static final String USERLABEL = "userLabel";
    private static final String STUB_AREA_METRIC = "stubAreaMetric";
    private static final String BACKBONE_IP = "0.0.0.0";
    private static final String DEFAULT_1 = "1";
    private static final String DEFAULT_AUE = "backbone_aue";
    private static final String OSPF_AREA_RELATED = "ospfAreaRelated";

    public void perform(CollectorContext collectorContext, Coordinator coordinator, String string) throws AueException {
        collectorContext.getLogger().trace(4, this.getClass(), "Running action");
        ManagedObject managedObject = this.getOspf(collectorContext);
        if (managedObject == null) {
            return;
        }
        ManagedObject managedObject2 = this.findBackbone(collectorContext);
        if (managedObject2 == null) {
            managedObject2 = this.createBackbone(collectorContext, managedObject, coordinator);
        }
        collectorContext.getLogger().trace(4, this.getClass(), "Collecting " + managedObject2.getLocalDistinguishedName());
        collectorContext.getDataWriter().writeData((Attribute)new ReferenceAttribute("defaultOspfArea", managedObject2.getLocalDistinguishedName(), false), collectorContext, coordinator);
        collectorContext.getLogger().trace(4, this.getClass(), "Done.");
    }

    private ManagedObject createBackbone(CollectorContext collectorContext, ManagedObject managedObject, Coordinator coordinator) throws AueException {
        String string = this.getFreeIdentity(collectorContext);
        AttrListImpl attrListImpl = new AttrListImpl(2);
        attrListImpl.addElement(AREAID, (Object)BACKBONE_IP);
        attrListImpl.addElement(USERLABEL, (Object)"defaultOspfArea");
        attrListImpl.addElement(STUB_AREA_METRIC, (Object)new Integer(1));
        MoFactory moFactory = collectorContext.getMoAccessor().lookupMoFactory("OspfArea");
        ManagedObject managedObject2 = null;
        try {
            managedObject2 = moFactory.createMo(managedObject, (AttrList)attrListImpl, string, null, coordinator);
        }
        catch (MoAccessException moAccessException) {
            throw new AueException("Unable to create OspfArea", (Throwable)moAccessException);
        }
        collectorContext.getLogger().trace(4, this.getClass(), "Creating " + managedObject2.getLocalDistinguishedName());
        return managedObject2;
    }

    private ManagedObject findBackbone(CollectorContext collectorContext) throws AueException {
        MoIterator moIterator = collectorContext.getMoAccessor().lookupType("OspfArea");
        ManagedObject managedObject = null;
        if (moIterator != null) {
            while (moIterator.hasMoreElements()) {
                managedObject = moIterator.nextMo();
                String string = null;
                try {
                    string = (String)managedObject.getAttribute(AREAID, null);
                }
                catch (MoAccessException moAccessException) {
                    throw new AueException("Attribute areaId not found", (Throwable)moAccessException);
                }
                if (!string.equals(BACKBONE_IP)) continue;
                return managedObject;
            }
        }
        return null;
    }

    private String getFreeIdentity(CollectorContext collectorContext) throws AueException {
        String string;
        MoIterator moIterator = collectorContext.getMoAccessor().lookupType("OspfArea");
        ManagedObject managedObject = null;
        boolean bl = true;
        boolean bl2 = true;
        if (moIterator != null) {
            while (moIterator.hasMoreElements()) {
                managedObject = moIterator.nextMo();
                string = managedObject.getNamingAttributeValue();
                if (string.equals(DEFAULT_1)) {
                    bl = false;
                    continue;
                }
                if (!string.equals(DEFAULT_AUE)) continue;
                bl2 = false;
            }
        }
        string = "";
        if (bl) {
            string = DEFAULT_1;
        } else if (bl2) {
            string = DEFAULT_AUE;
        } else {
            throw new AueException("OspfArea=backbone_aueoccupied by none backbone OspfArea");
        }
        return string;
    }

    private ManagedObject getOspf(CollectorContext collectorContext) {
        MoIterator moIterator = collectorContext.getMoAccessor().lookupType("Ospf");
        if (moIterator != null) {
            return moIterator.nextMo();
        }
        return null;
    }
}

