/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.login.codec;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import se.ericsson.security.login.codec.BASE64;
import se.ericsson.security.login.codec.CEFormatException;
import se.ericsson.security.login.codec.CEStreamExhausted;
import se.ericsson.security.login.codec.CharacterDecoder;

class BASE64Decoder
extends CharacterDecoder
implements BASE64 {
    private static final byte[] PEM_CONVERT_ARRAY;
    private byte[] decodeBuffer = new byte[4];

    protected int bytesPerAtom() {
        return 4;
    }

    protected int bytesPerLine() {
        return 72;
    }

    protected void decodeAtom(InputStream inputStream, OutputStream outputStream, int n) throws IOException {
        int n2;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        if (n < 2) {
            throw new CEFormatException("BASE64Decoder: Not enough bytes for an atom.");
        }
        do {
            if ((n2 = inputStream.read()) != -1) continue;
            throw new CEStreamExhausted();
        } while (n2 == 10 || n2 == 13);
        this.decodeBuffer[0] = (byte)n2;
        n2 = this.readFully(inputStream, this.decodeBuffer, 1, n - 1);
        if (n2 == -1) {
            throw new CEStreamExhausted();
        }
        if (n > 3 && this.decodeBuffer[3] == 61) {
            n = 3;
        }
        if (n > 2 && this.decodeBuffer[2] == 61) {
            n = 2;
        }
        switch (n) {
            case 4: {
                n6 = PEM_CONVERT_ARRAY[this.decodeBuffer[3] & 0xFF];
            }
            case 3: {
                n5 = PEM_CONVERT_ARRAY[this.decodeBuffer[2] & 0xFF];
            }
            case 2: {
                n4 = PEM_CONVERT_ARRAY[this.decodeBuffer[1] & 0xFF];
                n3 = PEM_CONVERT_ARRAY[this.decodeBuffer[0] & 0xFF];
            }
        }
        switch (n) {
            case 2: {
                outputStream.write((byte)(n3 << 2 & 0xFC | n4 >>> 4 & 3));
                break;
            }
            case 3: {
                outputStream.write((byte)(n3 << 2 & 0xFC | n4 >>> 4 & 3));
                outputStream.write((byte)(n4 << 4 & 0xF0 | n5 >>> 2 & 0xF));
                break;
            }
            case 4: {
                outputStream.write((byte)(n3 << 2 & 0xFC | n4 >>> 4 & 3));
                outputStream.write((byte)(n4 << 4 & 0xF0 | n5 >>> 2 & 0xF));
                outputStream.write((byte)(n5 << 6 & 0xC0 | n6 & 0x3F));
            }
        }
    }

    static {
        int n;
        PEM_CONVERT_ARRAY = new byte[256];
        for (n = 0; n < 255; ++n) {
            BASE64Decoder.PEM_CONVERT_ARRAY[n] = -1;
        }
        for (n = 0; n < BASE64.ARRAY.length; ++n) {
            BASE64Decoder.PEM_CONVERT_ARRAY[BASE64.ARRAY[n]] = (byte)n;
        }
    }
}

