/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.login.creds;

import java.io.InputStream;
import se.ericsson.security.login.creds.Credentials;
import se.ericsson.security.login.creds.CredentialsException;
import se.ericsson.security.login.creds.CredentialsFactorySpi;
import se.ericsson.security.login.creds.CredentialsValidator;
import se.ericsson.security.login.creds.EncryptedXMLCredentialsFactory;
import se.ericsson.security.login.creds.XMLCredentialsFactory;

public class CredentialsFactory {
    private final CredentialsFactorySpi credFacSpi;
    private final String type;

    private CredentialsFactory(CredentialsFactorySpi credentialsFactorySpi, String string) {
        this.type = string;
        this.credFacSpi = credentialsFactorySpi;
    }

    public static final CredentialsFactory getInstance(String string) throws CredentialsException {
        if (string.equals("SAM")) {
            return new CredentialsFactory(new EncryptedXMLCredentialsFactory(), string);
        }
        if (string.equals("SSU") || string.equals("SLS")) {
            return new CredentialsFactory(new XMLCredentialsFactory(), string);
        }
        throw new CredentialsException("No such Credentials type: " + string);
    }

    public final Credentials generateCredentials(InputStream inputStream) throws CredentialsException {
        Credentials credentials = this.credFacSpi.engineGenerateCredentials(inputStream);
        CredentialsValidator.checkValidity(credentials);
        return credentials;
    }

    public final Credentials generateCredentials(InputStream inputStream, char[] cArray) throws CredentialsException {
        Credentials credentials = this.credFacSpi.engineGenerateCredentials(inputStream, cArray);
        CredentialsValidator.checkValidity(credentials);
        return credentials;
    }
}

