/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.equipment;

import java.util.ArrayList;
import java.util.Map;
import se.ericsson.cello.equipment.AppUnitMo;
import se.ericsson.cello.equipment.OperationalProdData;
import se.ericsson.cello.equipment.SlotMoImplInterface;
import se.ericsson.cello.equipment.SubrackMoImpl;
import se.ericsson.cello.equipment.SubrackMoImplInterface;
import se.ericsson.cello.equipment.mom.AppUnit;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationSubscriber;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.ConvertWeekOfYearToDate;
import se.ericsson.cello.mao.IllegalAttributeValueException;
import se.ericsson.cello.mao.InvalidReferenceException;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.MoReservedNotDeletableException;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.mao.ReservableImpl;
import se.ericsson.cello.mao.TraceHelper;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.maofro.framework.FroData;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.maofro.framework.StructParameter;
import se.ericsson.cello.maofro.proxy.MaoFroGenericParameterChdInd;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.mom.commondefinitions.EnumAdmState;
import se.ericsson.cello.productinventory.HardwareProductData;
import se.ericsson.cello.productinventory.ProductRepository;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.util.library.Lib;

public class AppUnitMoImpl
extends CelloMao
implements AppUnitMo,
HardwareProductData {
    protected FroProxy froProxy = null;
    protected MoData data = null;
    private MaoFroIndicationHandler indHandler = null;
    public static final String PRODUCT_NAME = "productName";
    public static final String PRODUCT_NUMBER = "productNumber";
    public static final String PRODUCT_REVISION = "productRevision";
    public static final String SERIAL_NUMBER = "serialNumber";
    public static final String PRODUCTION_DATE = "productionDate";
    public static final String CONNECTEDAPN = "connectedapn";
    protected static final String FROID = "froId";
    protected static final int MO_DATA_REVISION_LATEST = 9000;

    static synchronized ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        return new AppUnitMoImpl(coordinator, managedObject, string, froProxy, attrList, maoFroIndicationHandler);
    }

    protected AppUnitMoImpl(Coordinator coordinator, ManagedObject managedObject, String string, FroProxy froProxy, AttrList attrList, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        super(managedObject, "AppUnit", string, coordinator);
        UpgradeTrace.debug(this.getClass(), (int)70, (String)("AppUnitMoImpl constuctor (\n\tCoordinator c: " + Lib.toString((Coordinator)coordinator) + "\n\tManagedObject: " + managedObject.getLocalDistinguishedName() + "\n\tString identity: " + string + "\n\tFroProxy : " + froProxy.getClass() + "Mo attributes" + this.attributesToString(attrList) + "\n\tIndicationHandler for service: " + maoFroIndicationHandler.getServiceName() + "\n\t)"));
        this.froProxy = froProxy;
        this.indHandler = maoFroIndicationHandler;
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)"", (String)"AppUnit", (int)128, (int)0);
        int n = MoAttributeValidator.checkAndGetIntegerAttribute((String)"administrativeState", (AttrList)attrList, (boolean)false, (int)0, (int)0, (int)2, (String)"AppUnit");
        ManagedObject managedObject2 = this.validateConnectedToScx(attrList, managedObject, coordinator);
        ((Reservable)managedObject2).reserve((ManagedObject)this, coordinator);
        MoAttributeValidator.checkOtherAttributes((AttrList)attrList, (String)"AppUnit");
        ArrayList<SignedIntParameter> arrayList = new ArrayList<SignedIntParameter>();
        int n2 = ((SubrackMoImplInterface)managedObject).getSubrackNumber(coordinator);
        int n3 = ((SlotMoImplInterface)managedObject2).getSlotPosition(coordinator);
        arrayList.add(new SignedIntParameter("subrackNumber", n2));
        arrayList.add(new SignedIntParameter("position", 1));
        arrayList.add(new SignedIntParameter("connectedToScx", n3));
        arrayList.add(new SignedIntParameter("administrativeState", n));
        UpgradeTrace.debug(this.getClass(), (int)70, (String)("AppUnitMoImpl constructor fro parameters \n" + TraceHelper.froParamToString(arrayList)));
        FroData froData = this.froProxy.create(coordinator, arrayList);
        int n4 = froData.getFroId();
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        this.data.registerPersistentAttr((Attribute)new SequenceAttribute("reservedBy", false));
        this.data.registerPersistentAttr((Attribute)new StringAttribute("userLabel", true, string2));
        this.data.registerPersistentAttr((Attribute)new ReferenceAttribute("connectedToScx", false, managedObject2));
        this.data.registerPersistentAttr((Attribute)new IntegerAttribute(FROID, false, n4));
        ProductRepository.instance().registerHw((HardwareProductData)this, coordinator);
        maoFroIndicationHandler.registerForNotifications(coordinator, (MaoFroIndicationSubscriber)this, this.getFroId(coordinator));
        this.data.setRevision(9000);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    public AppUnitMoImpl(MoData moData, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName());
        UpgradeTrace.debug(this.getClass(), (int)70, (String)("AppUnitMoImpl recovery constructor recovered data \n" + TraceHelper.modataToString((MoData)moData)));
        this.froProxy = froProxy;
        this.data = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(9000);
        moDataRecoveryHelper.assertAttribute(FROID);
        moDataRecoveryHelper.assertAttribute("reservedBy");
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute("connectedToScx");
        ProductRepository.instance().registerHw((HardwareProductData)this);
        this.indHandler = maoFroIndicationHandler;
        maoFroIndicationHandler.registerForNotifications(null, (MaoFroIndicationSubscriber)this, ((IntegerAttribute)this.data.getAttribute(FROID)).getValue(null));
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        UpgradeTrace.debug(this.getClass(), (int)70, (String)("delete (Coordinator c)\nCoordinator c: " + Lib.toString((Coordinator)coordinator)));
        if (this.getReservedBy(coordinator).length != 0) {
            throw new MoReservedNotDeletableException((ManagedObject)this);
        }
        this.froProxy.delete(coordinator, this.getFroId(coordinator), null);
        this.indHandler.deregisterForNotifications(coordinator, this.getFroId(coordinator));
        ((Reservable)this.getConnectedToScx(coordinator)).release((ManagedObject)this, coordinator);
        super.delete(coordinator);
        this.data.delete(coordinator);
    }

    public void reserve(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)("reserve (ManagedObject userId, Coordinator c)\nReserving MAnaged Object userId: " + managedObject.getLocalDistinguishedName() + "Coordinator c: " + Lib.toString((Coordinator)coordinator)));
        ReservableImpl.reserve((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.data, (String)"reservedBy");
    }

    public void release(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)("release (ManagedObject userId, Coordinator c)\nReleasing MAnaged Object userId: " + managedObject.getLocalDistinguishedName() + "Coordinator c: " + Lib.toString((Coordinator)coordinator)));
        ReservableImpl.release((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.data, (String)"reservedBy");
    }

    public String getAppUnitId(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("AppUnitId", coordinator);
    }

    public ManagedObject[] getReservedBy(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject[])this.getAttribute("reservedBy", coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("userLabel", string, coordinator);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("userLabel", coordinator);
    }

    public void setAdministrativeState(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("administrativeState", new Integer(n), coordinator);
    }

    public int getAdministrativeState(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("administrativeState", coordinator);
    }

    public ManagedObject getConnectedToScx(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("connectedToScx", coordinator);
    }

    public int getMaintenanceIndicator(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("maintenanceIndicator", coordinator);
    }

    public Struct getOperationalProductData(Coordinator coordinator) throws MoAccessException {
        return (Struct)this.getAttribute("operationalProductData", coordinator);
    }

    public int getOperationalState(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("operationalState", coordinator);
    }

    public String getType() {
        return "AppUnit";
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((IntegerAttribute)this.data.getAttribute(FROID)).getValue(coordinator);
    }

    public Object getAttribute(String string, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = this.getAttributes(stringArray, coordinator);
        return objectArray[0];
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Object[] objectArray = new Object[stringArray.length];
        Map map = null;
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            if (stringArray[i].equalsIgnoreCase(this.getType() + "Id")) {
                objectArray[i] = super.getNamingAttributeValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("reservedBy")) {
                object = (SequenceAttribute)this.data.getAttribute("reservedBy");
                objectArray[i] = ReservableImpl.retrieveRefArrayFromSequence((SequenceAttribute)object, (Coordinator)coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                objectArray[i] = ((StringAttribute)this.data.getAttribute("userLabel")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("administrativeState")) {
                map = this.getFroAttributes(map, coordinator);
                object = (SignedIntParameter)map.get("administrativeState");
                objectArray[i] = new Integer(object.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("connectedToScx")) {
                objectArray[i] = ((ReferenceAttribute)this.data.getAttribute("connectedToScx")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("maintenanceIndicator")) {
                map = this.getFroAttributes(map, coordinator);
                object = (SignedIntParameter)map.get("maintenanceIndicator");
                objectArray[i] = new Integer(object.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("operationalProductData")) {
                map = this.getFroAttributes(map, coordinator);
                object = new OperationalProdData((StructParameter)map.get("operationalProductData"));
                objectArray[i] = ((OperationalProdData)object).toStruct();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("operationalState")) {
                map = this.getFroAttributes(map, coordinator);
                object = (SignedIntParameter)map.get("operationalState");
                objectArray[i] = new Integer(object.getValue());
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "AppUnit");
        }
        return objectArray;
    }

    public void setAttribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        this.setAttributes(stringArray, objectArray, coordinator);
    }

    public void setAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        ArrayList<SignedIntParameter> arrayList = new ArrayList<SignedIntParameter>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                this.validateUserLabel(objectArray[i]);
                ((StringAttribute)this.data.getAttribute("userLabel")).setValue((String)objectArray[i]);
                this.sendNotification("userLabel", (String)objectArray[i], coordinator);
            } else if (stringArray[i].equalsIgnoreCase("administrativeState")) {
                this.validateAdministrativeState(objectArray[i]);
                arrayList.add(new SignedIntParameter("administrativeState", (Integer)objectArray[i]));
                this.sendNotification("administrativeState", (Integer)objectArray[i], coordinator);
            } else {
                throw new NoSuchAttributeException(stringArray[i], "AppUnit");
            }
            if (arrayList.size() <= 0) continue;
            this.froProxy.setAttributes(coordinator, this.getFroId(coordinator), arrayList);
        }
    }

    private Map getFroAttributes(Map map, Coordinator coordinator) throws MoAccessException {
        if (map == null) {
            return this.froProxy.getAttributes(coordinator, this.getFroId(coordinator));
        }
        return map;
    }

    private void sendNotification(String string, Object object, Coordinator coordinator) {
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    public String getProductionDate(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getProductionDate(Coordinator coordinator)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Struct struct = this.getOperationalProductData(coordinator);
        String string = (String)struct.getValue(PRODUCTION_DATE);
        if (string.length() == 8) {
            return string;
        }
        return ConvertWeekOfYearToDate.weekOfYearToDate((String)string);
    }

    public String getProductName(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getProductName(Coordinator coordinator)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Struct struct = this.getOperationalProductData(coordinator);
        String string = (String)struct.getValue(PRODUCT_NAME);
        return string;
    }

    public String getProductNumber(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getProductNumber(Coordinator coordinator)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Struct struct = this.getOperationalProductData(coordinator);
        String string = (String)struct.getValue(PRODUCT_NUMBER);
        return string;
    }

    public String getRState(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getRState(Coordinator coordinator)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Struct struct = this.getOperationalProductData(coordinator);
        String string = (String)struct.getValue(PRODUCT_REVISION);
        return string;
    }

    public String getSerialNumber(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getSerialNumber(Coordinator coordinator)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Struct struct = this.getOperationalProductData(coordinator);
        String string = (String)struct.getValue(SERIAL_NUMBER);
        return string;
    }

    public String getSubrackId(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getSubrackId(Coordinator context)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        SubrackMoImpl subrackMoImpl = (SubrackMoImpl)this.getParent();
        return subrackMoImpl.getSubrackPosition(coordinator);
    }

    public int getSlotPosition(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getSlotPosition(Coordinator context)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        return 0;
    }

    protected String validateUserLabel(Object object) throws MoAccessException {
        if (!(object instanceof String)) {
            throw new WrongAttributeTypeException("AppUnit", "userLabel");
        }
        String string = (String)object;
        MoAttributeValidator.checkStringWithLength((String)string, (String)"userLabel", (String)"AppUnit", (int)128, (int)0);
        return string;
    }

    protected int validateAdministrativeState(Object object) throws MoAccessException {
        if (!(object instanceof Integer)) {
            throw new WrongAttributeTypeException("AppUnit", "administrativeState");
        }
        int n = (Integer)object;
        MoAttributeValidator.checkEnumAttribute((String)"administrativeState", (int)n, (int[])EnumAdmState.VALUES_ARRAY, (String)"AppUnit");
        return n;
    }

    protected ManagedObject validateConnectedToScx(AttrList attrList, ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        ManagedObject managedObject2 = MoAttributeValidator.checkAndGetReferenceAttribute((String)"connectedToScx", (AttrList)attrList, (boolean)true, (Class)SlotMoImplInterface.class, (String)"Slot");
        int n = ((SlotMoImplInterface)managedObject2).getSlotPosition(coordinator);
        if (n != 1 && n != 27) {
            UpgradeTrace.debug(this.getClass(), (int)70, (String)"validateConnectedToScx(AttrList attrs, ManagedObject parent, Coordinator coordinator )", (String)("parent:" + managedObject.getLocalDistinguishedName() + "\n  requested slotPos " + n + "is not 1 or 27 the fixed positions of the SCXB boards" + "coordinator is: " + Lib.toString((Coordinator)coordinator)));
            throw new InvalidReferenceException("Slot", (Object)managedObject2);
        }
        MoIterator moIterator = managedObject.getChildren();
        ManagedObject managedObject3 = null;
        while (moIterator.hasMoreElements()) {
            managedObject3 = (ManagedObject)moIterator.nextElement();
            if (!(managedObject3 instanceof AppUnit) || managedObject3 == this || ((AppUnit)managedObject3).getConnectedToScx(coordinator) != managedObject2) continue;
            throw new IllegalAttributeValueException("AppUnit MO already configured for Slot MO connectedToScx: " + managedObject2.getLocalDistinguishedName(), "connectedToScx", "AppUnit");
        }
        return managedObject2;
    }

    public void parameterChanged(MaoFroGenericParameterChdInd maoFroGenericParameterChdInd) {
    }

    private String attributesToString(AttrList attrList) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\nReceived AppUnit attributes");
        try {
            for (int i = 0; i < attrList.size(); ++i) {
                String string = attrList.getName(i);
                stringBuffer.append("\n" + string);
                String string2 = attrList.getValue(i).toString();
                stringBuffer.append("\t" + string2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringBuffer.toString();
    }
}

