/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.equipment;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import se.ericsson.cello.equipment.InterPiuLinkMo;
import se.ericsson.cello.equipment.SlotMoImpl;
import se.ericsson.cello.equipment.SlotMoInternal;
import se.ericsson.cello.equipment.SubrackMo;
import se.ericsson.cello.equipment.SubrackProdTypeBuildIF;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationSubscriber;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.OperationNotAllowedException;
import se.ericsson.cello.maofro.framework.FroData;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.transaction.Coordinator;

public class InterPiuLinkMoImpl
extends CelloMao
implements InterPiuLinkMo {
    public static final String PRIMARY_SLOT_FRO_ID = "primarySlotFroId";
    public static final String SECONDARY_SLOT_FRO_ID = "secondarySlotFroId";
    public static final int MAX_NO_OF_SIBLINGS = 1;
    private MoData data;
    private FroProxy genericProxyInstance;
    private MaoFroIndicationHandler indicationHandler;
    private static final int MO_DATA_REVISION_7 = 7000;
    private static final int MO_DATA_REVISION_LATEST = 7000;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;

    public static synchronized ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)"Equipment");
        MoAttributeValidator.checkNoOfSiblings((ManagedObject)managedObject, (String)"InterPiuLink", (int)1);
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)"", (String)"InterPiuLink", (int)128, (int)0);
        int n = MoAttributeValidator.checkAndGetIntegerAttribute((String)"administrativeState", (AttrList)attrList, (boolean)false, (int)0, (int)0, (int)2, (String)"InterPiuLink");
        ManagedObject managedObject3 = MoAttributeValidator.checkAndGetReferenceAttribute2((String)"primaryPiuSlot", (AttrList)attrList, (boolean)true, (String[])new String[]{"Slot"}, (String)"InterPiuLink");
        ManagedObject managedObject4 = MoAttributeValidator.checkAndGetReferenceAttribute2((String)"secondaryPiuSlot", (AttrList)attrList, (boolean)true, (String[])new String[]{"Slot"}, (String)"InterPiuLink");
        MoAttributeValidator.checkOtherAttributes((AttrList)attrList, (String)"InterPiuLink");
        InterPiuLinkMoImpl.checkAdditionalRestrictionsOnSlots(managedObject3, managedObject4, coordinator);
        ArrayList<SignedIntParameter> arrayList = new ArrayList<SignedIntParameter>();
        arrayList.add(new SignedIntParameter("administrativeState", n));
        arrayList.add(new SignedIntParameter(PRIMARY_SLOT_FRO_ID, ((SlotMoImpl)managedObject3).getFroId(coordinator)));
        arrayList.add(new SignedIntParameter(SECONDARY_SLOT_FRO_ID, ((SlotMoImpl)managedObject4).getFroId(coordinator)));
        return new InterPiuLinkMoImpl(managedObject, string, string2, managedObject3, managedObject4, arrayList, coordinator, froProxy, maoFroIndicationHandler);
    }

    public Object getAttribute(String string, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        return this.getAttributes(new String[]{string}, coordinator)[0];
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Map map = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("availabilityStatus")) {
                map = this.getFroParameters(map, coordinator);
                arrayList.add(new Integer(((SignedIntParameter)map.get("availabilityStatus")).getValue()));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("operationalState")) {
                map = this.getFroParameters(map, coordinator);
                arrayList.add(new Integer(((SignedIntParameter)map.get("operationalState")).getValue()));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("primaryPiuSlot")) {
                arrayList.add(((ReferenceAttribute)this.data.getAttribute("primaryPiuSlot")).getValue(coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("secondaryPiuSlot")) {
                arrayList.add(((ReferenceAttribute)this.data.getAttribute("secondaryPiuSlot")).getValue(coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                arrayList.add(((StringAttribute)this.data.getAttribute("userLabel")).getValue(coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("administrativeState")) {
                map = this.getFroParameters(map, coordinator);
                arrayList.add(new Integer(((SignedIntParameter)map.get("administrativeState")).getValue()));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("InterPiuLinkId")) {
                arrayList.add(super.getNamingAttributeValue());
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "InterPiuLink");
        }
        return arrayList.toArray();
    }

    public void setAttribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        this.setAttributes(new String[]{string}, new Object[]{object}, coordinator);
    }

    public void setAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        ArrayList<SignedIntParameter> arrayList = new ArrayList<SignedIntParameter>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                if (!objectArray[i].getClass().equals(class$java$lang$String == null ? InterPiuLinkMoImpl.class$("java.lang.String") : class$java$lang$String)) {
                    throw new WrongAttributeTypeException("userLabel", "InterPiuLink");
                }
                MoAttributeValidator.checkStringWithLength((String)((String)objectArray[i]), (String)"userLabel", (String)"InterPiuLink", (int)128, (int)0);
                ((StringAttribute)this.data.getAttribute("userLabel")).setValue((String)objectArray[i]);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("administrativeState")) {
                if (!objectArray[i].getClass().equals(class$java$lang$Integer == null ? InterPiuLinkMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("administrativeState", "InterPiuLink");
                }
                int n = (Integer)objectArray[i];
                MoAttributeValidator.checkIntegerAttribute((String)"administrativeState", (int)n, (int)0, (int)2, (String)"InterPiuLink");
                arrayList.add(new SignedIntParameter("administrativeState", n));
                this.sendNotification("administrativeState", new Integer(n), coordinator);
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "InterPiuLink");
        }
        if (!arrayList.isEmpty()) {
            this.genericProxyInstance.setAttributes(coordinator, this.getFroId(coordinator), arrayList);
        }
    }

    public int getAvailabilityStatus(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("availabilityStatus", coordinator);
    }

    public int getOperationalState(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("operationalState", coordinator);
    }

    public ManagedObject getPrimaryPiuSlot(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("primaryPiuSlot", coordinator);
    }

    public ManagedObject getSecondaryPiuSlot(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("secondaryPiuSlot", coordinator);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("userLabel", coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("userLabel", string, coordinator);
    }

    public int getAdministrativeState(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("administrativeState", coordinator);
    }

    public void setAdministrativeState(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("administrativeState", new Integer(n), coordinator);
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((IntegerAttribute)this.data.getAttribute("froId")).getValue(coordinator);
    }

    public InterPiuLinkMoImpl(MoData moData, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName());
        this.data = moData;
        this.genericProxyInstance = froProxy;
        this.indicationHandler = maoFroIndicationHandler;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(7000);
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute("primaryPiuSlot");
        moDataRecoveryHelper.assertAttribute("secondaryPiuSlot");
        moDataRecoveryHelper.assertAttribute("froId");
        this.indicationHandler.registerForNotifications(null, (MaoFroIndicationSubscriber)this, ((IntegerAttribute)this.data.getAttribute("froId")).getValue(null));
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.checkDeleteAllowed(coordinator);
        SlotMoInternal slotMoInternal = (SlotMoInternal)this.getPrimaryPiuSlot(coordinator);
        slotMoInternal.release(this, coordinator);
        SlotMoInternal slotMoInternal2 = (SlotMoInternal)this.getSecondaryPiuSlot(coordinator);
        slotMoInternal2.release(this, coordinator);
        this.genericProxyInstance.delete(coordinator, this.getFroId(coordinator), null);
        this.indicationHandler.deregisterForNotifications(coordinator, this.getFroId(coordinator));
        super.delete(coordinator);
        this.data.delete(coordinator);
    }

    private InterPiuLinkMoImpl(ManagedObject managedObject, String string, String string2, ManagedObject managedObject2, ManagedObject managedObject3, ArrayList arrayList, Coordinator coordinator, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        super(managedObject, "InterPiuLink", string, coordinator);
        this.genericProxyInstance = froProxy;
        this.indicationHandler = maoFroIndicationHandler;
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        FroData froData = this.genericProxyInstance.create(coordinator, (Collection)arrayList);
        int n = froData.getFroId();
        this.data.registerPersistentAttr((Attribute)new StringAttribute("userLabel", true, string2));
        this.data.registerPersistentAttr((Attribute)new ReferenceAttribute("primaryPiuSlot", false, managedObject2));
        this.data.registerPersistentAttr((Attribute)new ReferenceAttribute("secondaryPiuSlot", false, managedObject3));
        this.data.registerPersistentAttr((Attribute)new IntegerAttribute("froId", false, n));
        ((SlotMoInternal)managedObject2).reserve(this, coordinator);
        ((SlotMoInternal)managedObject3).reserve(this, coordinator);
        this.indicationHandler.registerForNotifications(coordinator, (MaoFroIndicationSubscriber)this, n);
        this.data.setRevision(7000);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    private Map getFroParameters(Map map, Coordinator coordinator) throws MoAccessException {
        if (map == null) {
            map = this.genericProxyInstance.getAttributes(coordinator, this.getFroId(coordinator));
        }
        return map;
    }

    private void sendNotification(String string, Object object, Coordinator coordinator) {
        NotificationSender.instance().pushAVC((ManagedObject)this, new String[]{string}, new Object[]{object}, coordinator);
    }

    private static void checkAdditionalRestrictionsOnSlots(ManagedObject managedObject, ManagedObject managedObject2, Coordinator coordinator) throws OperationNotAllowedException, MoAccessException {
        if (managedObject.equals(managedObject2)) {
            throw new OperationNotAllowedException("PrimaryPiuSlot and SecondaryPiuSlot can not refer to the same Slot, " + managedObject, "InterPiuLink");
        }
        if (((SubrackProdTypeBuildIF)((SubrackMo)managedObject.getParent()).getSubrackProdTypeRef(coordinator)).getTransmissionType(coordinator) != 3 || ((SubrackProdTypeBuildIF)((SubrackMo)managedObject2.getParent()).getSubrackProdTypeRef(coordinator)).getTransmissionType(coordinator) != 3) {
            throw new OperationNotAllowedException("TransmissionType for the subracks of primaryPiuSlot and secondarySlot has to be ETHERNET_CABLE.", "InterPiuLink");
        }
    }

    private void checkDeleteAllowed(Coordinator coordinator) throws OperationNotAllowedException, MoAccessException {
        MoIterator moIterator = this.getSecondaryPiuSlot(coordinator).getChildren();
        if (moIterator != null && moIterator.hasMoreElements()) {
            throw new OperationNotAllowedException("The InterPiuLink can not be deleted when secondaryPiuSlot has a PlugInUnit configured.", "InterPiuLink");
        }
    }

    public String getType() {
        return "InterPiuLink";
    }
}

