/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.equipment;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import se.ericsson.cello.equipment.GenericPiuFroProxyAdapter;
import se.ericsson.cello.equipment.NonGenericPiuFroProxyAdapter;
import se.ericsson.cello.equipment.PlugInUnitMoFactory;
import se.ericsson.cello.equipment.fropxy.OsaPiuMgmntProxy;
import se.ericsson.cello.equipment.fropxy.PiuFroProxy;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.maofro.framework.FroData;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.PmData;
import se.ericsson.cello.maofro.proxy.MaoFroGenericProxy;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.session.PVSession;
import se.ericsson.cello.support.thread.ActionEvent;
import se.ericsson.cello.support.thread.ActionListener;
import se.ericsson.cello.transaction.Coordinator;

public class PiuFroProxyDelegator
implements PiuFroProxy,
ActionListener {
    private static PiuFroProxyDelegator instance = null;
    private static FroProxy genericProxy = null;
    private PVSession session = null;
    private PiuFroProxy proxyAdapter = null;
    private static final int SESSION_CFM = 1;

    public static PiuFroProxyDelegator instance(FroProxy froProxy) {
        UpgradeTrace.debug((Class)PiuFroProxyDelegator.class, (int)70, (String)"instance()");
        if (instance == null) {
            instance = new PiuFroProxyDelegator(froProxy);
        }
        if (genericProxy == null && froProxy != null) {
            genericProxy = froProxy;
        }
        return instance;
    }

    private PiuFroProxyDelegator(FroProxy froProxy) {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"PiuFroProxyDelegator(FroProxy proxy)");
        genericProxy = froProxy;
    }

    public void registerFactory() {
        PlugInUnitMoFactory.instance(this).registerFactory();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"actionPerformed(ActionEvent ae)");
        if (this.session.getSessionState() == 1) {
            this.setProxyAdapter();
        } else {
            this.proxyAdapter = null;
        }
    }

    public void subscribeService() {
        this.session = ((MaoFroGenericProxy)genericProxy).getPVSession();
        this.session.addActionListener((ActionListener)this);
    }

    private void setProxyAdapter() {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setProxyAdapters()");
        int n = Arrays.asList(OsaPiuMgmntProxy.getSupportedPvs()).indexOf(this.session.getProtocolVersion());
        if (n == -1) {
            UpgradeTrace.debug(this.getClass(), (int)72, (String)"setProxyAdapter()", (String)"Generic proxy adapter is ready.");
            this.proxyAdapter = GenericPiuFroProxyAdapter.instance(genericProxy);
        } else {
            UpgradeTrace.debug(this.getClass(), (int)72, (String)"setProxyAdapter()", (String)"Non-Generic proxy adapter is ready.");
            MaoFroIndicationHandler maoFroIndicationHandler = PlugInUnitMoFactory.instance(this).getIndicationHandler();
            this.proxyAdapter = NonGenericPiuFroProxyAdapter.instance(this.session, maoFroIndicationHandler);
        }
    }

    public FroData create(Coordinator coordinator, Collection collection) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"create(Coordinator c, Collection parameters)");
        if (this.proxyAdapter != null) {
            return this.proxyAdapter.create(coordinator, collection);
        }
        UpgradeTrace.debug(this.getClass(), (int)72, (String)"create(Coordinator c, Collection parameters)", (String)"PIU FRO might be down, re-trying to contact FRO.");
        this.session.obtainSession();
        this.setProxyAdapter();
        return this.create(coordinator, collection);
    }

    public void delete(Coordinator coordinator, int n, Collection collection) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"delete(Coordinator c, int froId,Collection parameters)");
        if (this.proxyAdapter != null) {
            this.proxyAdapter.delete(coordinator, n, collection);
        } else {
            UpgradeTrace.debug(this.getClass(), (int)72, (String)"delete(Coordinator c, int froId,Collection parameters)", (String)"PIU FRO might be down, re-trying to contact FRO.");
            this.session.obtainSession();
            this.setProxyAdapter();
            this.delete(coordinator, n, collection);
        }
    }

    public Map getAttributes(Coordinator coordinator, int n) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getAttributes(Coordinator c, int froId)");
        if (this.proxyAdapter != null) {
            return this.proxyAdapter.getAttributes(coordinator, n);
        }
        UpgradeTrace.debug(this.getClass(), (int)72, (String)"getAttributes(Coordinator c, int froId)", (String)"PIU FRO might be down, re-trying to contact FRO.");
        this.session.obtainSession();
        this.setProxyAdapter();
        return this.getAttributes(coordinator, n);
    }

    public Map getAttributes(Coordinator coordinator, int n, Collection collection) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getAttributes(Coordinator c, int froId,Collection requestedAttributes)");
        if (this.proxyAdapter != null) {
            return this.proxyAdapter.getAttributes(coordinator, n, collection);
        }
        UpgradeTrace.debug(this.getClass(), (int)72, (String)"getAttributes(Coordinator c, int froId, Collection requestedAttributes)", (String)"PIU FRO might be down, re-trying to contact FRO.");
        this.session.obtainSession();
        this.setProxyAdapter();
        return this.getAttributes(coordinator, n, collection);
    }

    public Parameter getAttribute(Coordinator coordinator, int n, String string) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getAttributes(Coordinator c, int froId, String parameterName)");
        if (this.proxyAdapter != null) {
            return this.proxyAdapter.getAttribute(coordinator, n, string);
        }
        UpgradeTrace.debug(this.getClass(), (int)72, (String)"getAttributes(Coordinator c, int froId, String parameterName)", (String)"PIU FRO might be down, re-trying to contact FRO.");
        this.session.obtainSession();
        this.setProxyAdapter();
        return this.getAttribute(coordinator, n, string);
    }

    public Map getDiskDataFroAttributes(Coordinator coordinator, int n) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getDiskDataFroAttributes(Coordinator context, int froId)");
        if (this.proxyAdapter != null) {
            return this.proxyAdapter.getDiskDataFroAttributes(coordinator, n);
        }
        UpgradeTrace.debug(this.getClass(), (int)72, (String)"getDiskDataFroAttributes(Coordinator context, int froId)", (String)"PIU FRO might be down, re-trying to contact FRO.");
        this.session.obtainSession();
        this.setProxyAdapter();
        return this.getDiskDataFroAttributes(coordinator, n);
    }

    public Map getHwTestResult(int n, Coordinator coordinator, int n2) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getHwTestResult(int txId, Coordinator context, int froId)");
        if (this.proxyAdapter != null) {
            return this.proxyAdapter.getHwTestResult(n, coordinator, n2);
        }
        UpgradeTrace.debug(this.getClass(), (int)72, (String)"getHwTestResult(int txId, Coordinator context, int froId)", (String)"PIU FRO might be down, re-trying to contact FRO.");
        this.session.obtainSession();
        this.setProxyAdapter();
        return this.getHwTestResult(n, coordinator, n2);
    }

    public void setPiuAttributes(Coordinator coordinator, int n, int n2, String string, String string2, String string3, String string4, String string5, int n3, int n4, int n5) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setPiuAttributes(Coordinator aCoordinator, int forId, int anAdministrativeState, String aProductNumber,String aProductRevision,String aProductName,String aProductionDate, String aSerialNumber, int aPIU_GroupNumber,int anAllowedSeqRestarts, int aPIU_Role)");
        if (this.proxyAdapter != null) {
            this.proxyAdapter.setPiuAttributes(coordinator, n, n2, string, string2, string3, string4, string5, n3, n4, n5);
        } else {
            UpgradeTrace.debug(this.getClass(), (int)72, (String)"setPiuAttributes(Coordinator aCoordinator, int forId, int anAdministrativeState, String aProductNumber,String aProductRevision,String aProductName,String aProductionDate, String aSerialNumber, int aPIU_GroupNumber,int anAllowedSeqRestarts, int aPIU_Role)", (String)"PIU FRO might be down, re-trying to contact FRO.");
            this.session.obtainSession();
            this.setProxyAdapter();
            this.setPiuAttributes(coordinator, n, n2, string, string2, string3, string4, string5, n3, n4, n5);
        }
    }

    public PmData getPmAttributes(Coordinator coordinator, int n) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getPmAttributes(Coordinator c, int froId)");
        if (this.proxyAdapter != null) {
            return this.proxyAdapter.getPmAttributes(coordinator, n);
        }
        UpgradeTrace.debug(this.getClass(), (int)72, (String)"getPmAttributes(Coordinator c, int froId)", (String)"PIU FRO might be down, re-trying to contact FRO.");
        this.session.obtainSession();
        this.setProxyAdapter();
        return this.getPmAttributes(coordinator, n);
    }

    public void setAttributes(Coordinator coordinator, int n, Collection collection) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setAttributes(Coordinator c, int froId,Collection parameters)");
        if (this.proxyAdapter != null) {
            this.proxyAdapter.setAttributes(coordinator, n, collection);
        } else {
            UpgradeTrace.debug(this.getClass(), (int)72, (String)"setAttributes(Coordinator c, int froId,Collection parameters)", (String)"PIU FRO might be down, re-trying to contact FRO.");
            this.session.obtainSession();
            this.setProxyAdapter();
            this.setAttributes(coordinator, n, collection);
        }
    }

    public void setAttribute(Coordinator coordinator, int n, Parameter parameter) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setAttribute(Coordinator c, int froId,Parameter parameter)");
        if (this.proxyAdapter != null) {
            this.proxyAdapter.setAttribute(coordinator, n, parameter);
        } else {
            UpgradeTrace.debug(this.getClass(), (int)72, (String)"setAttribute(Coordinator c, int froId,Parameter parameter)", (String)"PIU FRO might be down, re-trying to contact FRO.");
            this.session.obtainSession();
            this.setProxyAdapter();
            this.setAttribute(coordinator, n, parameter);
        }
    }

    public Map actionWithCfm(Coordinator coordinator, int n, int n2, Collection collection) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"actionWithCfm(Coordinator context, int froId,int actionType, Collection parameters)");
        if (this.proxyAdapter != null) {
            return this.proxyAdapter.actionWithCfm(coordinator, n, n2, collection);
        }
        UpgradeTrace.debug(this.getClass(), (int)72, (String)"actionWithCfm(Coordinator context, int froId,int actionType, Collection parameters)", (String)"PIU FRO might be down, re-trying to contact FRO.");
        this.session.obtainSession();
        this.setProxyAdapter();
        return this.actionWithCfm(coordinator, n, n2, collection);
    }

    public void actionWithoutCfm(Coordinator coordinator, int n, int n2, Collection collection) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"actionWithoutCfm(Coordinator context, int froId,int actionType, Collection parameters)");
        if (this.proxyAdapter != null) {
            this.proxyAdapter.actionWithoutCfm(coordinator, n, n2, collection);
        } else {
            UpgradeTrace.debug(this.getClass(), (int)72, (String)"actionWithoutCfm(Coordinator context, int froId,int actionType, Collection parameters)", (String)"PIU FRO might be down, re-trying to contact FRO.");
            this.session.obtainSession();
            this.setProxyAdapter();
            this.actionWithoutCfm(coordinator, n, n2, collection);
        }
    }
}

