/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.equipment;

import java.util.Map;
import java.util.ResourceBundle;
import se.ericsson.cello.equipment.CaxFanUnitMo;
import se.ericsson.cello.equipment.CaxFanUnitMoExtendFactory;
import se.ericsson.cello.equipment.CaxFanUnitMoImpl;
import se.ericsson.cello.equipment.EquipmentMoImpl;
import se.ericsson.cello.equipment.FanMo;
import se.ericsson.cello.equipment.OperationalProdData;
import se.ericsson.cello.equipment.PfmUnitMo;
import se.ericsson.cello.equipment.PfmUnitMoFactory;
import se.ericsson.cello.equipment.PfmUnitMoImpl;
import se.ericsson.cello.equipment.SlotMo;
import se.ericsson.cello.equipment.SlotMoFactory;
import se.ericsson.cello.equipment.SlotMoImpl;
import se.ericsson.cello.equipment.SubrackMo;
import se.ericsson.cello.equipment.SubrackMoImplInterface;
import se.ericsson.cello.equipment.SubrackMoInternal;
import se.ericsson.cello.equipment.SubrackProdTypeBuildIF;
import se.ericsson.cello.equipment.SubrackProdTypeMo;
import se.ericsson.cello.equipment.SwitchModuleBuildIF;
import se.ericsson.cello.equipment.osa_srmi;
import se.ericsson.cello.equipment.suaccess.SubrackMoSU_Access;
import se.ericsson.cello.equipment.suaccess.SubrackProdTypeMoSU_Access;
import se.ericsson.cello.faultmanagement.Alarm;
import se.ericsson.cello.faultmanagement.AlarmManager;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationSubscriber;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.mao.AttrValueNotUniqueException;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.ConfigurationMismatchException;
import se.ericsson.cello.mao.ConvertWeekOfYearToDate;
import se.ericsson.cello.mao.GetRequestContextImpl;
import se.ericsson.cello.mao.IllegalAttributeValueException;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.MoNotReservedByUserException;
import se.ericsson.cello.mao.MoReservedNotDeletableException;
import se.ericsson.cello.mao.OperationNotAllowedException;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.mao.ReservableImpl;
import se.ericsson.cello.mao.SetRequestContextImpl;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.maofro.framework.FroData;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.maofro.framework.StringParameter;
import se.ericsson.cello.maofro.framework.StructParameter;
import se.ericsson.cello.maofro.framework.UnsignedIntParameter;
import se.ericsson.cello.maofro.proxy.MaoFroGenericParameterChdInd;
import se.ericsson.cello.maofro.proxy.TagNameDictionaries;
import se.ericsson.cello.maofro.proxy.TagNameDictionary;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.AttrMissingAtCreateException;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoFactoryMgr;
import se.ericsson.cello.moframework.MoHasChildrenException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NoSuchFieldException;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.pri.LongSystemParameter;
import se.ericsson.cello.pri.PriJavaProxy;
import se.ericsson.cello.pri.PriJavaProxyFactory;
import se.ericsson.cello.pri.PriProcessNotFoundException;
import se.ericsson.cello.pri.SystemParameterNotFoundException;
import se.ericsson.cello.pri.WrongSystemParameterTypeException;
import se.ericsson.cello.productinventory.HardwareProductData;
import se.ericsson.cello.productinventory.ProductRepository;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.util.library.Lib;

public class SubrackMoImpl
extends CelloMao
implements SubrackMoInternal,
SubrackMoSU_Access,
SubrackMoImplInterface {
    private MoData data;
    private MyHwProdInvImpl myHwProdInvImplRef;
    private static final int SMN_NULL_VALUE = 0;
    private static final int MAX_NO_OF_SUBRACKS = 10;
    private static final String PRODUCT_TYPE_VALUE = "HW";
    protected static final long NODE_MODE_KEY = 73L;
    protected static final int NODE_MASTER_MODE = 0;
    protected static final int NODE_SLAVE_MODE = 1;
    protected static final long RNC_TYPE_KEY = 64L;
    protected static final int RNC_TYPE_EVOC = 2;
    protected static final int RNC_TYPE_NA = 0;
    private static String[] ATTRIBUTES_TO_REQUEST_FROM_FRO = new String[]{"subrackNumber", "operationalProductData", "numberOfDenibDevices", "administrativeProductData", "subrackPosition", "cabinetPosition", "numberOfSlots", "boardPositions", "fanConfiguration", "transmissionType", "maxPowerDissipation", "powerMeasurements"};
    static final String[] SUPPORTED_VERSIONS = new String[]{"SU_1", "SU_2", "SU_3"};
    private static final int MO_DATA_REVISION_70 = 7000;
    private static final int MO_DATA_REVISION_LATEST = 7000;
    private static TagNameDictionary tnd = TagNameDictionaries.create((ResourceBundle)ResourceBundle.getBundle(osa_srmi.class.getName()));
    private FroProxy genericProxyInstance;
    private MaoFroIndicationHandler indicationHandler;
    private static final String RESOURCE_ID = "resourceId";
    private static String[] adminProductDataNames = new String[]{"productNumber", "productRevision", "productName", "productInfo", "productionDate"};
    private SlotMoFactory slotFactory;

    private SubrackMoImpl(ManagedObject managedObject, String string, String string2, SwitchModuleBuildIF switchModuleBuildIF, int n, int n2, SubrackProdTypeBuildIF subrackProdTypeBuildIF, String string3, String string4, int n3, Coordinator coordinator, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler, InitialMaoContext initialMaoContext, SlotMoFactory slotMoFactory) throws MoAccessException {
        super(managedObject, "Subrack", string, coordinator);
        Object object;
        SubrackMo subrackMo;
        MoIterator moIterator;
        MoRepository moRepository;
        this.genericProxyInstance = froProxy;
        this.indicationHandler = maoFroIndicationHandler;
        this.slotFactory = slotMoFactory;
        if (n2 == 0) {
            moRepository = MoRepository.instance();
            moIterator = moRepository.lookupType("Subrack");
            while (moIterator.hasMoreElements()) {
                subrackMo = (SubrackMo)moIterator.nextMo();
                if (subrackMo == this || subrackMo.getSubrackType(coordinator) != 0) continue;
                throw new AttrValueNotUniqueException("Only one Subrack to type Hub allowed " + subrackMo, "Subrack");
            }
            if (switchModuleBuildIF != null && switchModuleBuildIF.getSwitchModuleNumber(coordinator) != 0) {
                throw new ValueOutOfRangeException("switchModuleNumber in referred SwitchModuleMo", "Subrack");
            }
        }
        moRepository = new AttrListImpl();
        moIterator = new SetRequestContextImpl((AttrList)moRepository, coordinator);
        if (switchModuleBuildIF != null) {
            moIterator.addParameter(froProxy, (Parameter)new UnsignedIntParameter("subrackNumber", (long)switchModuleBuildIF.getSwitchModuleNumber(coordinator)));
        } else {
            moIterator.addParameter(froProxy, (Parameter)new UnsignedIntParameter("subrackNumber", (long)n));
        }
        moIterator.addParameter(froProxy, (Parameter)new SignedIntParameter("numberOfDenibDevices", n3));
        subrackMo = new StructParameter("administrativeProductData");
        subrackMo.add((Parameter)new StringParameter("admProductNumber", subrackProdTypeBuildIF.getProductNumber(null)));
        subrackMo.add((Parameter)new StringParameter("admProductRevision", subrackProdTypeBuildIF.getProductRevision(null)));
        subrackMo.add((Parameter)new StringParameter("admProductName", subrackProdTypeBuildIF.getProductName(null)));
        subrackMo.add((Parameter)new StringParameter("admProductionDate", subrackProdTypeBuildIF.getProductDate(null)));
        subrackMo.add((Parameter)new StringParameter("admProductInfo", subrackProdTypeBuildIF.getProductInfo(null)));
        moIterator.addParameter(froProxy, (Parameter)subrackMo);
        StructParameter structParameter = new StructParameter("boardPositions");
        structParameter.add((Parameter)new UnsignedIntParameter("cmxbPositionA", (long)subrackProdTypeBuildIF.getCmxbPositionA(null)));
        structParameter.add((Parameter)new UnsignedIntParameter("cmxbPositionB", (long)subrackProdTypeBuildIF.getCmxbPositionB(null)));
        structParameter.add((Parameter)new UnsignedIntParameter("scuPositionA", (long)subrackProdTypeBuildIF.getScuPositionA(null)));
        structParameter.add((Parameter)new UnsignedIntParameter("scuPositionB", (long)subrackProdTypeBuildIF.getScuPositionB(null)));
        structParameter.add((Parameter)new UnsignedIntParameter("tuPositionA", (long)subrackProdTypeBuildIF.getTubPositionA(null)));
        structParameter.add((Parameter)new UnsignedIntParameter("tuPositionB", (long)subrackProdTypeBuildIF.getTubPositionB(null)));
        moIterator.addParameter(froProxy, (Parameter)structParameter);
        moIterator.addParameter(froProxy, (Parameter)new UnsignedIntParameter("numberOfSlots", (long)subrackProdTypeBuildIF.getDefNumberOfSlots(null)));
        moIterator.addParameter(froProxy, (Parameter)new UnsignedIntParameter("maxPowerDissipation", (long)subrackProdTypeBuildIF.getMaxPowerDissipation(null)));
        moIterator.addParameter(froProxy, (Parameter)new UnsignedIntParameter("transmissionType", (long)subrackProdTypeBuildIF.getTransmissionType(null)));
        moIterator.addParameter(froProxy, (Parameter)new UnsignedIntParameter("fanConfiguration", (long)subrackProdTypeBuildIF.getFanConfiguration(null)));
        FroData froData = moIterator.sendCreateRequest(froProxy);
        int n4 = froData.getFroId();
        this.indicationHandler.registerForNotifications(coordinator, (MaoFroIndicationSubscriber)this, n4);
        this.data = initialMaoContext.createMoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        int n5 = subrackProdTypeBuildIF.getDefNumberOfSlots(null);
        this.initData(switchModuleBuildIF, n4, string2, n2, string3, string4, n5, subrackProdTypeBuildIF, coordinator);
        ((Reservable)subrackProdTypeBuildIF).reserve((ManagedObject)this, coordinator);
        if (switchModuleBuildIF != null) {
            switchModuleBuildIF.reserve(this, coordinator);
        }
        this.createSlots(n5, coordinator);
        if (this.isCaxSubrack(coordinator)) {
            object = (CaxFanUnitMoExtendFactory)MoFactoryMgr.instance().lookup("CaxFanUnit");
            ((CaxFanUnitMoExtendFactory)object).createCaxFanUnits(this, coordinator);
        }
        if (this.isEvoSubrack(coordinator)) {
            object = (PfmUnitMoFactory)MoFactoryMgr.instance().lookup("PfmUnit");
            ((PfmUnitMoFactory)object).createPfmUnits(this, n, coordinator);
        }
        if (!this.isCaxSubrack(coordinator)) {
            this.checkSubrackConfiguration(coordinator);
        }
        this.myHwProdInvImplRef = new MyHwProdInvImpl(this, coordinator);
    }

    public SubrackMoImpl(MoData moData, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler, InitialMaoContext initialMaoContext, SlotMoFactory slotMoFactory) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName(), initialMaoContext);
        this.data = moData;
        this.genericProxyInstance = froProxy;
        this.indicationHandler = maoFroIndicationHandler;
        this.slotFactory = slotMoFactory;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(7000);
        moDataRecoveryHelper.assertAttribute("switchModule");
        moDataRecoveryHelper.assertAttribute(RESOURCE_ID);
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute("subrackType");
        moDataRecoveryHelper.assertAttribute("subrackPosition");
        moDataRecoveryHelper.assertAttribute("cabinetPosition");
        moDataRecoveryHelper.assertAttribute("numberOfSlots");
        moDataRecoveryHelper.assertAttribute("reservedBy");
        moDataRecoveryHelper.assertAttribute("subrackProdTypeRef");
        this.indicationHandler.registerForNotifications(null, (MaoFroIndicationSubscriber)this, ((IntegerAttribute)this.data.getAttribute(RESOURCE_ID)).getValue(null));
        this.myHwProdInvImplRef = new MyHwProdInvImpl(this);
    }

    static SubrackMoImpl create(AttrList attrList, String string, ManagedObject managedObject, Coordinator coordinator, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler, InitialMaoContext initialMaoContext, SlotMoFactory slotMoFactory) throws MoAccessException {
        int n;
        int n2;
        SubrackProdTypeBuildIF subrackProdTypeBuildIF;
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkIdentity((String)"Subrack", (String)string);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)"Equipment");
        MoAttributeValidator.checkNoOfSiblings((ManagedObject)managedObject, (String)"Subrack", (int)10);
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)"", (String)"Subrack", (int)128, (int)0);
        int n3 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"subrackType", (AttrList)attrList, (boolean)true, (int)0, (int)0, (int)1, (String)"Subrack");
        int n4 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"numberOfDenibDevices", (AttrList)attrList, (boolean)false, (int)-1, (int)-1, (int)10, (String)"Subrack");
        if (attrList.contains(new String[]{"subrackProdTypeRef"})) {
            subrackProdTypeBuildIF = SubrackMoImpl.checkAndGetSubrackProdTypeRef(attrList);
            n2 = attrList.indexOf("administrativeProductData");
            if (n2 != -1) {
                attrList.removeElementAt(n2);
            }
        } else if (attrList.contains(new String[]{"administrativeProductData"})) {
            Struct struct = SubrackMoImpl.checkAndGetAdministrativeProductData(attrList);
            subrackProdTypeBuildIF = SubrackMoImpl.findSubrackProdTypeWithProdData(struct);
            if (subrackProdTypeBuildIF == null) {
                throw new OperationNotAllowedException("Could not find a SubrackProdType MO with matching adminProductData.", "Subrack");
            }
        } else {
            throw new AttrMissingAtCreateException("subrackProdTypeRef", "Subrack");
        }
        n2 = subrackProdTypeBuildIF.getTransmissionType(coordinator);
        int n5 = subrackProdTypeBuildIF.getFanConfiguration(coordinator);
        SwitchModuleBuildIF switchModuleBuildIF = null;
        int n6 = 0;
        if (n2 == 1 || n2 == 2) {
            switchModuleBuildIF = (SwitchModuleBuildIF)MoAttributeValidator.checkAndGetReferenceAttribute((String)"switchModule", (AttrList)attrList, (boolean)true, (Class)SwitchModuleBuildIF.class, (String)"Subrack");
            n = attrList.indexOf("subrackNumber");
            if (n != -1) {
                attrList.removeElementAt(n);
            }
            n6 = switchModuleBuildIF.getSwitchModuleNumber(coordinator);
        } else if (n2 == 3 || n2 == 4 || n2 == 5) {
            n6 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"subrackNumber", (AttrList)attrList, (boolean)false, (int)0, (int)0, (int)65535, (String)"Subrack");
            if (n5 == 5 && (n6 < 15 || n6 > 255 || (n6 - 15) % 16 != 0)) {
                throw new IllegalAttributeValueException("In CAX the allowed values for subrackNumber attribute of Subrack are 0F to FF", "subrackNumber", "Subrack");
            }
            n = attrList.indexOf("switchModule");
            if (n != -1) {
                if (attrList.getValue(n) != null) {
                    throw new OperationNotAllowedException("SwitchModule must be null when transmissionType is ETHERNET_CABLE or ETHERNET_1G_10G or ETHERNET_1G_10G_40G ", "Subrack");
                }
                attrList.removeElementAt(n);
            }
        }
        String string3 = SubrackMoImpl.checkAndGetSubrackPosition(attrList);
        String string4 = SubrackMoImpl.checkAndGetCabinetPosition(attrList);
        int n7 = attrList.indexOf("numberOfSlots");
        if (n7 != -1) {
            attrList.removeElementAt(n7);
        }
        SubrackMoImpl.checkDenibDeviceConfiguration(n4, subrackProdTypeBuildIF.getFanConfiguration(coordinator));
        MoAttributeValidator.checkOtherAttributes((AttrList)attrList, (String)"Subrack");
        return new SubrackMoImpl(managedObject, string, string2, switchModuleBuildIF, n6, n3, subrackProdTypeBuildIF, string3, string4, n4, coordinator, froProxy, maoFroIndicationHandler, initialMaoContext, slotMoFactory);
    }

    public void delete(Coordinator coordinator) throws MoAccessException, MoHasChildrenException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (this.getReservedBy(coordinator).length != 0) {
            throw new MoReservedNotDeletableException("Subrack");
        }
        this.deleteSubrackChildren(coordinator);
        this.genericProxyInstance.delete(coordinator, this.getFroId(coordinator), null);
        this.indicationHandler.deregisterForNotifications(coordinator, this.getFroId(coordinator));
        SwitchModuleBuildIF switchModuleBuildIF = (SwitchModuleBuildIF)this.getSwitchModule(coordinator);
        if (switchModuleBuildIF != null) {
            switchModuleBuildIF.release(this, coordinator);
        }
        SubrackProdTypeBuildIF subrackProdTypeBuildIF = (SubrackProdTypeBuildIF)this.getSubrackProdTypeRef(coordinator);
        ((Reservable)subrackProdTypeBuildIF).release((ManagedObject)this, coordinator);
        this.myHwProdInvImplRef.delete(coordinator);
        this.data.delete(coordinator);
        super.delete(coordinator);
    }

    public String getType() {
        return "Subrack";
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("userLabel", coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("userLabel", string, coordinator);
    }

    public ManagedObject getSwitchModule(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("switchModule", coordinator);
    }

    public int getSwitchModuleNumber(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        if (this.getSwitchModule(coordinator) == null) {
            return this.getSubrackNumber(coordinator);
        }
        return ((SwitchModuleBuildIF)this.getSwitchModule(coordinator)).getSwitchModuleNumber(coordinator);
    }

    public int getSubrackType(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("subrackType", coordinator);
    }

    public String[] getSupportedVersions() {
        return SUPPORTED_VERSIONS;
    }

    public String getProductType(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("productType", coordinator);
    }

    public ManagedObject getSubrackProdTypeRef(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("subrackProdTypeRef", coordinator);
    }

    public Struct getOperationalProductData(Coordinator coordinator) throws MoAccessException {
        return (Struct)this.getAttribute("operationalProductData", coordinator);
    }

    public int getSubrackNumber(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("subrackNumber", coordinator);
    }

    public String getOperationalProductNumber(Coordinator coordinator) throws MoAccessException {
        Struct struct = this.getOperationalProductData(coordinator);
        return (String)struct.getValue("productNumber");
    }

    public String getOperationalProductRevision(Coordinator coordinator) throws MoAccessException {
        Struct struct = this.getOperationalProductData(coordinator);
        return (String)struct.getValue("productRevision");
    }

    public Struct getAdministrativeProductData(Coordinator coordinator) throws MoAccessException {
        return (Struct)this.getAttribute("administrativeProductData", coordinator);
    }

    public String getAdministrativeProductNumber(Coordinator coordinator) throws MoAccessException {
        Struct struct = this.getAdministrativeProductData(coordinator);
        return (String)struct.getValue("productNumber");
    }

    public String getAdministrativeProductRevision(Coordinator coordinator) throws MoAccessException {
        Struct struct = this.getAdministrativeProductData(coordinator);
        return (String)struct.getValue("productRevision");
    }

    public int getNumberOfSlots(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("numberOfSlots", coordinator);
    }

    public String getSubrackPosition(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("subrackPosition", coordinator);
    }

    public void setSubrackPosition(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("subrackPosition", string, coordinator);
    }

    public String getCabinetPosition(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("cabinetPosition", coordinator);
    }

    public void setCabinetPosition(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("cabinetPosition", string, coordinator);
    }

    public void setAdministrativeProductData(Struct struct, Coordinator coordinator) throws MoAccessException {
    }

    public void setSubrackProdTypeForSwUpgrade(SubrackProdTypeMoSU_Access subrackProdTypeMoSU_Access, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        ReferenceAttribute referenceAttribute = (ReferenceAttribute)this.data.getAttribute("subrackProdTypeRef");
        SubrackProdTypeMoSU_Access subrackProdTypeMoSU_Access2 = (SubrackProdTypeMoSU_Access)referenceAttribute.getValue(coordinator);
        if (subrackProdTypeMoSU_Access2 != null) {
            subrackProdTypeMoSU_Access2.release(this, coordinator);
        }
        referenceAttribute.setValue((ManagedObject)subrackProdTypeMoSU_Access);
        if (subrackProdTypeMoSU_Access != null) {
            subrackProdTypeMoSU_Access.reserve(this, coordinator);
        }
    }

    public ManagedObject[] getReservedBy(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject[])this.getAttribute("reservedBy", coordinator);
    }

    public Integer getResourceId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return new Integer(((IntegerAttribute)this.data.getAttribute(RESOURCE_ID)).getValue(coordinator));
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((IntegerAttribute)this.data.getAttribute(RESOURCE_ID)).getValue(coordinator);
    }

    public int getNumberOfDenibDevices(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("numberOfDenibDevices", coordinator);
    }

    public void setNumberOfDenibDevices(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("numberOfDenibDevices", new Integer(n), coordinator);
    }

    public String getSubrackId(Coordinator coordinator) throws MoAccessException {
        return this.getNamingAttributeValue();
    }

    public void reserve(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        ReservableImpl.reserve((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.data, (String)"reservedBy");
    }

    public void release(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException, MoNotReservedByUserException {
        ReservableImpl.release((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.data, (String)"reservedBy");
    }

    public void actionRemoveSlots(int n, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (n < 1) {
            throw new ValueOutOfRangeException("numberOfSlots must be equal or greater then 1", "Subrack");
        }
        int n2 = this.getNumberOfSlots(coordinator);
        if (n2 < n) {
            throw new ValueOutOfRangeException("numberOfSlots", "Subrack");
        }
        MoIterator moIterator = this.getChildren();
        while (moIterator.hasMoreElements()) {
            Object object = moIterator.nextElement();
            if (!(object instanceof SlotMo) || ((SlotMoImpl)object).getSlotNumber(coordinator) + n <= n2) continue;
            ((SlotMoImpl)object).deleteTheSlot(coordinator);
        }
        ReferenceAttribute referenceAttribute = (ReferenceAttribute)this.data.getAttribute("subrackProdTypeRef");
        int n3 = this.getNumberOfSlots(coordinator) - n;
        this.setSrFroAttributes((SubrackProdTypeBuildIF)referenceAttribute.getValue(coordinator), new Integer(n3), this.getNumberOfDenibDevices(coordinator), coordinator);
        ((IntegerAttribute)this.data.getAttribute("numberOfSlots")).setValue(n3);
    }

    public void actionAddSlots(int n, Coordinator coordinator) throws MoAccessException {
        int n2;
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"actionaddSlots( long numberOfSlotsToAdd, Coordinator context )", (String)("numberOfSlotsToAdd: " + n + "\n\tcontext: " + coordinator));
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (n < 1) {
            throw new ValueOutOfRangeException("numberOfSlots must be equal or greater than 1", "Subrack");
        }
        ReferenceAttribute referenceAttribute = (ReferenceAttribute)this.data.getAttribute("subrackProdTypeRef");
        SubrackProdTypeBuildIF subrackProdTypeBuildIF = (SubrackProdTypeBuildIF)referenceAttribute.getValue(coordinator);
        int n3 = this.getNumberOfSlots(coordinator);
        if (n > subrackProdTypeBuildIF.getDefNumberOfSlots(null) - n3) {
            throw new ValueOutOfRangeException("numberOfSlots must be equal or less then " + (subrackProdTypeBuildIF.getDefNumberOfSlots(null) - n3) + " as maximum number of defined slots are " + subrackProdTypeBuildIF.getDefNumberOfSlots(null), "Subrack");
        }
        for (n2 = 1; n2 <= n; ++n2) {
            this.slotFactory.createMo(this, n2 + n3, coordinator);
        }
        n2 = n3 + n;
        this.setSrFroAttributes((SubrackProdTypeBuildIF)referenceAttribute.getValue(coordinator), new Integer(n2), this.getNumberOfDenibDevices(coordinator), coordinator);
        ((IntegerAttribute)this.data.getAttribute("numberOfSlots")).setValue(n2);
    }

    public void updateSubrackProdTypeInfoSU(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"updateSubrackProdTypeInfoSU (Coordinator context))", (String)("context: " + coordinator));
        ReferenceAttribute referenceAttribute = (ReferenceAttribute)this.data.getAttribute("subrackProdTypeRef");
        SubrackProdTypeBuildIF subrackProdTypeBuildIF = (SubrackProdTypeBuildIF)referenceAttribute.getValue(coordinator);
        if (subrackProdTypeBuildIF != null) {
            this.setSrFroAttributes(subrackProdTypeBuildIF, null, this.getNumberOfDenibDevices(coordinator), coordinator);
        } else {
            UpgradeTrace.warning(this.getClass(), (String)"updateSubrackProdTypeInfoSU (Coordinator context)", (String)("No SubrackProdType is connected to Subrack. Ignoring setting of SubrackProdType information. \n\tSubrack MO: " + this.getLocalDistinguishedName() + "\n\tSubrack admProductNumber: " + this.getAdmProductNumberFromFro(coordinator) + "\n\tSubrack admProductRevision: " + this.getAdmProductRevisionFromFro(coordinator)));
        }
    }

    public String getAdmProductNumberFromFro(Coordinator coordinator) throws MoAccessException {
        Struct struct = this.getAdministrativeProductData(coordinator);
        return (String)struct.getValue("productNumber");
    }

    public String getAdmProductRevisionFromFro(Coordinator coordinator) throws MoAccessException {
        Struct struct = this.getAdministrativeProductData(coordinator);
        return (String)struct.getValue("productRevision");
    }

    public String getAdmProductNameFromFro(Coordinator coordinator) throws MoAccessException {
        Struct struct = this.getAdministrativeProductData(coordinator);
        return (String)struct.getValue("productName");
    }

    public String getAdmProductDateFromFro(Coordinator coordinator) throws MoAccessException {
        Struct struct = this.getAdministrativeProductData(coordinator);
        return (String)struct.getValue("productionDate");
    }

    public String getAdmProductInfoFromFro(Coordinator coordinator) throws MoAccessException {
        Struct struct = this.getAdministrativeProductData(coordinator);
        return (String)struct.getValue("productInfo");
    }

    public int getNumberOfSlotsFromFro(Coordinator coordinator) throws MoAccessException {
        UnsignedIntParameter unsignedIntParameter = (UnsignedIntParameter)this.getAttributesFromFro(coordinator, "numberOfSlots");
        return (int)unsignedIntParameter.getValue();
    }

    public int getMaxPowerDissipationFromFro(Coordinator coordinator) throws MoAccessException {
        return this.getMaxPowerDissipation(coordinator);
    }

    public int getMaxPowerDissipation(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("maxPowerDissipation", coordinator);
    }

    public Struct getPowerMeasurements(Coordinator coordinator) throws MoAccessException {
        return (Struct)this.getAttribute("powerMeasurements", coordinator);
    }

    public int getTransmissionTypeFromFro(Coordinator coordinator) throws MoAccessException {
        UnsignedIntParameter unsignedIntParameter = (UnsignedIntParameter)this.getAttributesFromFro(coordinator, "transmissionType");
        return (int)unsignedIntParameter.getValue();
    }

    public int getFanConfigurationFromFro(Coordinator coordinator) throws MoAccessException {
        UnsignedIntParameter unsignedIntParameter = (UnsignedIntParameter)this.getAttributesFromFro(coordinator, "fanConfiguration");
        return (int)unsignedIntParameter.getValue();
    }

    public int getCmxbPositionAFromFro(Coordinator coordinator) throws MoAccessException {
        StructParameter structParameter = (StructParameter)this.getAttributesFromFro(coordinator, "boardPositions");
        return (int)((UnsignedIntParameter)structParameter.get("cmxbPositionA")).getValue();
    }

    public int getCmxbPositionBFromFro(Coordinator coordinator) throws MoAccessException {
        StructParameter structParameter = (StructParameter)this.getAttributesFromFro(coordinator, "boardPositions");
        return (int)((UnsignedIntParameter)structParameter.get("cmxbPositionB")).getValue();
    }

    public int getScuPositionAFromFro(Coordinator coordinator) throws MoAccessException {
        StructParameter structParameter = (StructParameter)this.getAttributesFromFro(coordinator, "boardPositions");
        return (int)((UnsignedIntParameter)structParameter.get("scuPositionA")).getValue();
    }

    public int getScuPositionBFromFro(Coordinator coordinator) throws MoAccessException {
        StructParameter structParameter = (StructParameter)this.getAttributesFromFro(coordinator, "boardPositions");
        return (int)((UnsignedIntParameter)structParameter.get("scuPositionB")).getValue();
    }

    public int getTuPositionAFromFro(Coordinator coordinator) throws MoAccessException {
        StructParameter structParameter = (StructParameter)this.getAttributesFromFro(coordinator, "boardPositions");
        return (int)((UnsignedIntParameter)structParameter.get("tuPositionA")).getValue();
    }

    public int getTuPositionBFromFro(Coordinator coordinator) throws MoAccessException {
        StructParameter structParameter = (StructParameter)this.getAttributesFromFro(coordinator, "boardPositions");
        return (int)((UnsignedIntParameter)structParameter.get("tuPositionB")).getValue();
    }

    private void setSrFroAttributes(SubrackProdTypeBuildIF subrackProdTypeBuildIF, Integer n, int n2, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setSrFroAttributes(SubrackProdTypeBuildIF aSubrackProdTypeBuildIF, Integer anActualNumberOfSlots, int aNumberOfDenibDevices Coordinator context", (String)("context: " + Lib.toString((Coordinator)coordinator) + "\n\tanActualNumberOfSlots: " + n + "\n\tSubrackProdTypeBuildIF Info: " + "\n\tcmxbPositionA: " + subrackProdTypeBuildIF.getCmxbPositionA(coordinator) + "\n\tcmxbPositionB: " + subrackProdTypeBuildIF.getCmxbPositionB(coordinator) + "\n\tscuPositionA: " + subrackProdTypeBuildIF.getScuPositionA(coordinator) + "\n\tscuPositionB: " + subrackProdTypeBuildIF.getScuPositionB(coordinator) + "\n\ttuPositionA: " + subrackProdTypeBuildIF.getTubPositionA(coordinator) + "\n\ttuPositionB: " + subrackProdTypeBuildIF.getTubPositionB(coordinator) + "\n\tDefNumberOfSlots: " + subrackProdTypeBuildIF.getDefNumberOfSlots(coordinator) + "\n\tFanConfiguration: " + subrackProdTypeBuildIF.getFanConfiguration(coordinator) + "\n\tMaxPowerDissipation: " + subrackProdTypeBuildIF.getMaxPowerDissipation(coordinator) + "\n\tProductDate(: " + subrackProdTypeBuildIF.getProductDate(coordinator) + "\n\tProductInfo: " + subrackProdTypeBuildIF.getProductInfo(coordinator) + "\n\tProductName: " + subrackProdTypeBuildIF.getProductName(coordinator) + "\n\tProductNumber: " + subrackProdTypeBuildIF.getProductNumber(coordinator) + "\n\tProductRevision: " + subrackProdTypeBuildIF.getProductRevision(coordinator) + "\n\tTransmissionType: " + subrackProdTypeBuildIF.getTransmissionType(coordinator) + "\n\tNumberOfDenibDevices: " + n2));
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        SetRequestContextImpl setRequestContextImpl = new SetRequestContextImpl(null, null, coordinator);
        setRequestContextImpl.addParameter(this.genericProxyInstance, (Parameter)new SignedIntParameter("numberOfDenibDevices", n2));
        StructParameter structParameter = new StructParameter("administrativeProductData");
        structParameter.add((Parameter)new StringParameter("admProductNumber", subrackProdTypeBuildIF.getProductNumber(null)));
        structParameter.add((Parameter)new StringParameter("admProductRevision", subrackProdTypeBuildIF.getProductRevision(null)));
        structParameter.add((Parameter)new StringParameter("admProductName", subrackProdTypeBuildIF.getProductName(null)));
        structParameter.add((Parameter)new StringParameter("admProductionDate", subrackProdTypeBuildIF.getProductDate(null)));
        structParameter.add((Parameter)new StringParameter("admProductInfo", subrackProdTypeBuildIF.getProductInfo(null)));
        setRequestContextImpl.addParameter(this.genericProxyInstance, (Parameter)structParameter);
        StructParameter structParameter2 = new StructParameter("boardPositions");
        structParameter2.add((Parameter)new UnsignedIntParameter("cmxbPositionA", (long)subrackProdTypeBuildIF.getCmxbPositionA(null)));
        structParameter2.add((Parameter)new UnsignedIntParameter("cmxbPositionB", (long)subrackProdTypeBuildIF.getCmxbPositionB(null)));
        structParameter2.add((Parameter)new UnsignedIntParameter("scuPositionA", (long)subrackProdTypeBuildIF.getScuPositionA(null)));
        structParameter2.add((Parameter)new UnsignedIntParameter("scuPositionB", (long)subrackProdTypeBuildIF.getScuPositionB(null)));
        structParameter2.add((Parameter)new UnsignedIntParameter("tuPositionA", (long)subrackProdTypeBuildIF.getTubPositionA(null)));
        structParameter2.add((Parameter)new UnsignedIntParameter("tuPositionB", (long)subrackProdTypeBuildIF.getTubPositionB(null)));
        setRequestContextImpl.addParameter(this.genericProxyInstance, (Parameter)structParameter2);
        if (n == null) {
            setRequestContextImpl.addParameter(this.genericProxyInstance, (Parameter)new UnsignedIntParameter("numberOfSlots", (long)subrackProdTypeBuildIF.getDefNumberOfSlots(null)));
        } else {
            setRequestContextImpl.addParameter(this.genericProxyInstance, (Parameter)new UnsignedIntParameter("numberOfSlots", (long)n.intValue()));
        }
        setRequestContextImpl.addParameter(this.genericProxyInstance, (Parameter)new UnsignedIntParameter("maxPowerDissipation", (long)subrackProdTypeBuildIF.getMaxPowerDissipation(null)));
        setRequestContextImpl.addParameter(this.genericProxyInstance, (Parameter)new UnsignedIntParameter("transmissionType", (long)subrackProdTypeBuildIF.getTransmissionType(null)));
        setRequestContextImpl.addParameter(this.genericProxyInstance, (Parameter)new UnsignedIntParameter("fanConfiguration", (long)subrackProdTypeBuildIF.getFanConfiguration(null)));
        setRequestContextImpl.sendSetRequest(this.genericProxyInstance, this.getFroId(coordinator));
        if (n != null) {
            ((IntegerAttribute)this.data.getAttribute("numberOfSlots")).setValue(n);
        }
    }

    private void createSlots(int n, Coordinator coordinator) throws MoAccessException {
        for (int i = 1; i <= n; ++i) {
            this.slotFactory.createMo(this, i, coordinator);
        }
    }

    private void deleteSubrackChildren(Coordinator coordinator) throws MoAccessException {
        Object object;
        MoIterator moIterator = this.getChildren();
        while (moIterator.hasMoreElements()) {
            object = moIterator.nextElement();
            if (object instanceof PfmUnitMo) {
                ((PfmUnitMoImpl)object).deleteMo(coordinator);
                continue;
            }
            if (!(object instanceof CaxFanUnitMo)) continue;
            ((CaxFanUnitMoImpl)object).deleteMo(coordinator);
        }
        object = null;
        MoIterator moIterator2 = this.getChildren();
        while (moIterator2.hasMoreElements()) {
            object = moIterator2.nextElement();
            if (!(object instanceof SlotMo)) continue;
            ((SlotMoImpl)object).deleteMo(coordinator);
        }
    }

    private static String checkAndGetSubrackPosition(AttrList attrList) throws MoAccessException {
        String string = "";
        int n = attrList.indexOf("subrackPosition");
        if (n == -1) {
            return string;
        }
        if (!(attrList.getValue(n) instanceof String)) {
            throw new WrongAttributeTypeException("subrackPosition", "Subrack");
        }
        string = (String)attrList.getValue(n);
        attrList.removeElementAt(n);
        return string;
    }

    private static String checkAndGetCabinetPosition(AttrList attrList) throws MoAccessException {
        String string = "";
        int n = attrList.indexOf("cabinetPosition");
        if (n == -1) {
            return string;
        }
        if (!(attrList.getValue(n) instanceof String)) {
            throw new WrongAttributeTypeException("cabinetPosition", "Subrack");
        }
        string = (String)attrList.getValue(n);
        attrList.removeElementAt(n);
        return string;
    }

    private static Struct checkAndGetAdministrativeProductData(AttrList attrList) throws MoAccessException {
        int n = attrList.indexOf("administrativeProductData");
        if (n == -1) {
            throw new AttrMissingAtCreateException("administrativeProductData", "Subrack");
        }
        if (!(attrList.getValue(n) instanceof Struct)) {
            throw new WrongAttributeTypeException("administrativeProductData", "Subrack");
        }
        Struct struct = (Struct)attrList.getValue(attrList.indexOf("administrativeProductData"));
        if (struct.size() > 5) {
            throw new NoSuchFieldException("Uknown field in struct");
        }
        String[] stringArray = struct.getNames();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = "";
        String string5 = "";
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equalsIgnoreCase("productInfo")) {
                    try {
                        if (struct.getValue("productInfo") == null) {
                            string4 = "";
                            continue;
                        }
                        if (!struct.getValue("productInfo").getClass().getName().equals("java.lang.String")) {
                            throw new WrongAttributeTypeException("productInfo", "Subrack");
                        }
                        string4 = (String)struct.getValue("productInfo");
                        if (string4.length() >= 0 && string4.length() <= 13) continue;
                        throw new ValueOutOfRangeException("productInfo", "Subrack");
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        string4 = "";
                    }
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("productionDate")) {
                    try {
                        if (struct.getValue("productionDate") == null) {
                            string5 = "";
                            continue;
                        }
                        if (!struct.getValue("productionDate").getClass().getName().equals("java.lang.String")) {
                            throw new WrongAttributeTypeException("productionDate", "Subrack");
                        }
                        string5 = (String)struct.getValue("productionDate");
                        if (string5.length() >= 0 && string5.length() <= 8) continue;
                        throw new ValueOutOfRangeException("productionDate", "Subrack");
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        string4 = "";
                    }
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("productName")) {
                    if (!struct.getValue("productName").getClass().getName().equals("java.lang.String")) {
                        throw new WrongAttributeTypeException("productName", "Subrack");
                    }
                    string3 = (String)struct.getValue("productName");
                    if (string3.length() >= 1 && string3.length() <= 12) continue;
                    throw new ValueOutOfRangeException("productName", "Subrack");
                }
                if (stringArray[i].equalsIgnoreCase("productNumber")) {
                    if (!struct.getValue("productNumber").getClass().getName().equals("java.lang.String")) {
                        throw new WrongAttributeTypeException("productNumber", "Subrack");
                    }
                    string2 = (String)struct.getValue("productNumber");
                    if (string2.length() >= 1 && string2.length() <= 24) continue;
                    throw new ValueOutOfRangeException("productNumber", "Subrack");
                }
                if (stringArray[i].equalsIgnoreCase("productRevision")) {
                    if (!struct.getValue("productRevision").getClass().getName().equals("java.lang.String")) {
                        throw new WrongAttributeTypeException("productRevision", "Subrack");
                    }
                    string = (String)struct.getValue("productRevision");
                    if (string.length() >= 1 && string.length() <= 7) continue;
                    throw new ValueOutOfRangeException("productRevision", "Subrack");
                }
                throw new NoSuchFieldException("Subrack Mo, Unknown field in administrativeProductData " + stringArray[i]);
            }
        }
        if (string == null || string2 == null || string3 == null) {
            throw new AttrMissingAtCreateException("administrativeProductData", "Subrack");
        }
        attrList.removeElementAt(attrList.indexOf("administrativeProductData"));
        Object[] objectArray = new String[]{string2, string, string3, string4, string5};
        struct = new StructImpl(adminProductDataNames, objectArray);
        return struct;
    }

    private static SubrackProdTypeBuildIF checkAndGetSubrackProdTypeRef(AttrList attrList) throws MoAccessException {
        Object object = null;
        int n = attrList.indexOf("subrackProdTypeRef");
        object = attrList.getValue(n);
        if (!(object instanceof SubrackProdTypeBuildIF)) {
            throw new WrongAttributeTypeException("subrackProdTypeRef", "Subrack");
        }
        attrList.removeElementAt(attrList.indexOf("subrackProdTypeRef"));
        return (SubrackProdTypeBuildIF)object;
    }

    private static SubrackProdTypeBuildIF findSubrackProdTypeWithProdData(Struct struct) throws MoAccessException {
        SubrackProdTypeBuildIF subrackProdTypeBuildIF = null;
        MoIterator moIterator = MoRepository.instance().lookupType("SubrackProdType");
        if (moIterator != null) {
            while (moIterator.hasMoreElements()) {
                SubrackProdTypeBuildIF subrackProdTypeBuildIF2 = (SubrackProdTypeBuildIF)moIterator.nextElement();
                if (!SubrackMoImpl.compareProdData(struct, subrackProdTypeBuildIF2)) continue;
                subrackProdTypeBuildIF = subrackProdTypeBuildIF2;
                break;
            }
        }
        return subrackProdTypeBuildIF;
    }

    private static boolean compareProdData(Struct struct, SubrackProdTypeBuildIF subrackProdTypeBuildIF) throws MoAccessException {
        if (!struct.getValue("productName").equals(subrackProdTypeBuildIF.getProductName(null))) {
            return false;
        }
        if (!struct.getValue("productNumber").equals(subrackProdTypeBuildIF.getProductNumber(null))) {
            return false;
        }
        return struct.getValue("productRevision").equals(subrackProdTypeBuildIF.getProductRevision(null));
    }

    private void initData(SwitchModuleBuildIF switchModuleBuildIF, int n, String string, int n2, String string2, String string3, int n3, SubrackProdTypeBuildIF subrackProdTypeBuildIF, Coordinator coordinator) throws MoAccessException {
        this.data.registerPersistentAttr((Attribute)new ReferenceAttribute("switchModule", false, (ManagedObject)switchModuleBuildIF));
        this.data.registerPersistentAttr((Attribute)new IntegerAttribute(RESOURCE_ID, false, n));
        this.data.registerPersistentAttr((Attribute)new StringAttribute("userLabel", true, string));
        this.data.registerPersistentAttr((Attribute)new IntegerAttribute("subrackType", false, n2));
        this.data.registerPersistentAttr((Attribute)new StringAttribute("subrackPosition", true, string2));
        this.data.registerPersistentAttr((Attribute)new StringAttribute("cabinetPosition", true, string3));
        this.data.registerPersistentAttr((Attribute)new IntegerAttribute("numberOfSlots", false, n3));
        this.data.registerPersistentAttr((Attribute)new ReferenceAttribute("subrackProdTypeRef", false, (ManagedObject)subrackProdTypeBuildIF));
        this.data.registerPersistentAttr((Attribute)new SequenceAttribute("reservedBy", true));
        this.data.setRevision(7000);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    private boolean areFansDisconnectedFromThisSr(Coordinator coordinator) {
        MoIterator moIterator = this.getChildren();
        while (moIterator.hasMoreElements()) {
            ManagedObject managedObject = (ManagedObject)moIterator.nextElement();
            if (!(managedObject instanceof FanMo)) continue;
            Alarm alarm = AlarmManager.getReporter().getActiveAlarm(179, managedObject);
            if (alarm == null) {
                MessageLog.trace((int)5, this.getClass(), (String)("Fan: " + managedObject + " alarm: null" + " . No active Fan Contact Fault alarm."));
                return false;
            }
            MessageLog.trace((int)5, this.getClass(), (String)("Fan: " + managedObject + " alarm: Fan Contact Fault is active."));
        }
        return true;
    }

    private static void checkDenibDeviceConfiguration(int n, int n2) throws MoAccessException {
        if (n != -1 && (n2 == 0 || n2 == 1)) {
            throw new IllegalAttributeValueException("numberOfDenibDevices are not allowed to be configured according to the defined fanConfiguration.", "numberOfDenibDevices", "Subrack");
        }
    }

    public void setAttribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        this.setAttributes(stringArray, objectArray, coordinator);
    }

    public void setAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        SetRequestContextImpl setRequestContextImpl = new SetRequestContextImpl(stringArray, objectArray, coordinator);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                this.validateUserLabel(objectArray[i]);
                ((StringAttribute)this.data.getAttribute("userLabel")).setValue((String)objectArray[i]);
                setRequestContextImpl.addAvcNotification("userLabel", (Object)((String)objectArray[i]));
            } else if (stringArray[i].equalsIgnoreCase("cabinetPosition")) {
                if (!(objectArray[i] instanceof String)) {
                    throw new WrongAttributeTypeException("cabinetPosition", "Subrack");
                }
                ((StringAttribute)this.data.getAttribute("cabinetPosition")).setValue((String)objectArray[i]);
            } else if (stringArray[i].equalsIgnoreCase("subrackPosition")) {
                if (!(objectArray[i] instanceof String)) {
                    throw new WrongAttributeTypeException("subrackPosition", "Subrack");
                }
                ((StringAttribute)this.data.getAttribute("subrackPosition")).setValue((String)objectArray[i]);
            } else if (stringArray[i].equalsIgnoreCase("numberOfDenibDevices")) {
                this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
                int n = this.getNumberOfDenibDevices(coordinator);
                MessageLog.trace((int)5, this.getClass(), (String)("numberOfDenibDevices to be set: " + objectArray[i] + " previous value for numberOfDenibDevices: " + n));
                int n2 = this.validateNoOfDenibDevices(objectArray[i]);
                if (n2 != 0 && n != 0 && !this.areFansDisconnectedFromThisSr(coordinator)) {
                    throw new OperationNotAllowedException("Fan units must be disconnected from SCB-DF/SCB-TF board or numberOfDenibDevices first set to 0, to allow configuration of numberOfDenibDevices", "Subrack");
                }
                SubrackProdTypeBuildIF subrackProdTypeBuildIF = (SubrackProdTypeBuildIF)this.getSubrackProdTypeRef(coordinator);
                SubrackMoImpl.checkDenibDeviceConfiguration(n2, subrackProdTypeBuildIF.getFanConfiguration(coordinator));
                setRequestContextImpl.addParameter(this.genericProxyInstance, (Parameter)new SignedIntParameter("numberOfDenibDevices", n2));
                setRequestContextImpl.addAvcNotification("numberOfDenibDevices", (Object)new Integer(n2));
            } else if (!stringArray[i].equalsIgnoreCase("administrativeProductData")) {
                throw new NoSuchAttributeException(stringArray[i], "Subrack");
            }
            setRequestContextImpl.sendSetRequest(this.genericProxyInstance, this.getFroId(coordinator));
            setRequestContextImpl.sendAvcNotifications((ManagedObject)this);
        }
    }

    protected void validateUserLabel(Object object) throws MoAccessException {
        if (!(object instanceof String)) {
            throw new WrongAttributeTypeException("Subrack", "userLabel");
        }
        String string = (String)object;
        MoAttributeValidator.checkStringWithLength((String)string, (String)"userLabel", (String)"Subrack", (int)128, (int)0);
    }

    protected int validateNoOfDenibDevices(Object object) throws MoAccessException {
        if (!(object instanceof Integer)) {
            throw new WrongAttributeTypeException("Subrack", "numberOfDenibDevices");
        }
        Integer n = (Integer)object;
        MoAttributeValidator.checkIntegerAttribute((String)"numberOfDenibDevices", (int)n, (int)-1, (int)10, (String)"Subrack");
        return n;
    }

    public Object getAttribute(String string, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = this.getAttributes(stringArray, coordinator);
        return objectArray[0];
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Object[] objectArray = new Object[stringArray.length];
        GetRequestContextImpl getRequestContextImpl = new GetRequestContextImpl(stringArray, coordinator);
        getRequestContextImpl.readAttributesFromProxy(this.genericProxyInstance, this.getFroId(coordinator), ATTRIBUTES_TO_REQUEST_FROM_FRO);
        for (int i = 0; i < stringArray.length; ++i) {
            Object[] objectArray2;
            Object object;
            Object object2;
            if (stringArray[i].equalsIgnoreCase("reservedBy")) {
                objectArray[i] = ReservableImpl.retrieveRefArrayFromSequence((SequenceAttribute)((SequenceAttribute)this.data.getAttribute("reservedBy")), (Coordinator)coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                objectArray[i] = ((StringAttribute)this.data.getAttribute("userLabel")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase(RESOURCE_ID)) {
                objectArray[i] = new Integer(((IntegerAttribute)this.data.getAttribute(RESOURCE_ID)).getValue(coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase(this.getType() + "Id")) {
                objectArray[i] = super.getNamingAttributeValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("switchModule")) {
                object2 = this.data.getAttribute("switchModule");
                if (null != object2) {
                    objectArray[i] = ((ReferenceAttribute)object2).getValue(coordinator);
                    continue;
                }
                objectArray[i] = null;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("subrackType")) {
                objectArray[i] = new Integer(((IntegerAttribute)this.data.getAttribute("subrackType")).getValue(coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("productType")) {
                objectArray[i] = PRODUCT_TYPE_VALUE;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("subrackPosition")) {
                objectArray[i] = ((StringAttribute)this.data.getAttribute("subrackPosition")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("cabinetPosition")) {
                objectArray[i] = ((StringAttribute)this.data.getAttribute("cabinetPosition")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("numberOfSlots")) {
                objectArray[i] = new Integer(((IntegerAttribute)this.data.getAttribute("numberOfSlots")).getValue(coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("reservedBy")) {
                object2 = (SequenceAttribute)this.data.getAttribute("reservedBy");
                objectArray[i] = ReservableImpl.retrieveRefArrayFromSequence((SequenceAttribute)object2, (Coordinator)coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("subrackProdTypeRef")) {
                objectArray[i] = ((ReferenceAttribute)this.data.getAttribute("subrackProdTypeRef")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("subrackNumber")) {
                object2 = (UnsignedIntParameter)getRequestContextImpl.getParameter("subrackNumber");
                objectArray[i] = new Integer((int)object2.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("administrativeProductData")) {
                object2 = (SubrackProdTypeBuildIF)this.getSubrackProdTypeRef(coordinator);
                object = new Object[5];
                if (object2 != null) {
                    object[0] = object2.getProductNumber(coordinator);
                    object[1] = object2.getProductRevision(coordinator);
                    object[2] = object2.getProductName(coordinator);
                    object[3] = object2.getProductInfo(coordinator);
                    object[4] = object2.getProductDate(coordinator);
                } else {
                    UpgradeTrace.warning(this.getClass(), (String)"getAdministrativeProductData(Coordinator context)", (String)"No reference to subrackProdType found. Getting AdmProdData from resource.");
                    objectArray2 = (Object[])getRequestContextImpl.getParameter("administrativeProductData");
                    object[1] = ((StringParameter)objectArray2.get("admProductNumber")).getValue();
                    object[2] = ((StringParameter)objectArray2.get("admProductRevision")).getValue();
                    object[0] = ((StringParameter)objectArray2.get("admProductName")).getValue();
                    object[3] = ((StringParameter)objectArray2.get("admProductInfo")).getValue();
                    object[4] = ((StringParameter)objectArray2.get("admProductionDate")).getValue();
                }
                objectArray[i] = new StructImpl(adminProductDataNames, (Object[])object);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("operationalProductData")) {
                object2 = (StructParameter)getRequestContextImpl.getParameter("operationalProductData");
                object = new OperationalProdData((StructParameter)object2);
                objectArray[i] = ((OperationalProdData)object).toStruct();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("powerMeasurements")) {
                object2 = (StructParameter)getRequestContextImpl.getParameter("powerMeasurements");
                object = new String[]{"currentLeft", "currentRight", "distributedPower", "voltageLeft", "voltageRight"};
                objectArray2 = new Object[]{new Integer(((SignedIntParameter)object2.get("currentLeft")).getValue()), new Integer(((SignedIntParameter)object2.get("currentRight")).getValue()), new Integer(((SignedIntParameter)object2.get("distributedPower")).getValue()), new Integer(((SignedIntParameter)object2.get("voltageLeft")).getValue()), new Integer(((SignedIntParameter)object2.get("voltageRight")).getValue())};
                objectArray[i] = new StructImpl((String[])object, objectArray2);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("maxPowerDissipation")) {
                object2 = (UnsignedIntParameter)getRequestContextImpl.getParameter("maxPowerDissipation");
                objectArray[i] = new Integer((int)object2.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("numberOfDenibDevices")) {
                object2 = (SignedIntParameter)getRequestContextImpl.getParameter("numberOfDenibDevices");
                objectArray[i] = new Integer(object2.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("switchModuleNumber")) {
                if (this.getSwitchModule(coordinator) == null) {
                    objectArray[i] = new Integer(this.getSubrackNumber(coordinator));
                    continue;
                }
                objectArray[i] = new Integer(((SwitchModuleBuildIF)this.getSwitchModule(coordinator)).getSwitchModuleNumber(coordinator));
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "Subrack");
        }
        return objectArray;
    }

    private Parameter getAttributesFromFro(Coordinator coordinator, String string) throws MoAccessException {
        GetRequestContextImpl getRequestContextImpl = new GetRequestContextImpl(new String[]{string}, coordinator);
        getRequestContextImpl.readAttributesFromProxy(this.genericProxyInstance, this.getFroId(coordinator), ATTRIBUTES_TO_REQUEST_FROM_FRO);
        Parameter parameter = getRequestContextImpl.getParameter(string);
        return parameter;
    }

    public void parameterChanged(MaoFroGenericParameterChdInd maoFroGenericParameterChdInd) {
        UpgradeTrace.debug(this.getClass(), (int)72, (String)"parameterChanged()", (String)("MaoFroGenericParameterChdInd signal received for subrack: " + this));
        StructParameter structParameter = null;
        try {
            Map map = maoFroGenericParameterChdInd.getParameters(tnd);
            structParameter = (StructParameter)map.get("operationalProductData");
        }
        catch (MoAccessException moAccessException) {
            MessageLog.traceError(this.getClass(), (String)"Unable to translate parameters in indication signal", (Throwable)moAccessException);
        }
        if (structParameter != null) {
            try {
                UpgradeTrace.debug(this.getClass(), (int)72, (String)"parameterChanged()", (String)("MaoFroGenericParameterChdInd signal received for subrack: " + this));
                EquipmentMoImpl.instance().actionTriggerLastHwPiChange(null);
            }
            catch (Throwable throwable) {
                MessageLog.info(this.getClass(), (String)"Failed to issue notification for Equipment change");
            }
        } else {
            MessageLog.traceError(this.getClass(), (String)"Unknown attribute in parameterChanged()");
        }
    }

    public boolean isEvoSubrack(Coordinator coordinator) throws MoAccessException {
        SubrackProdTypeMo subrackProdTypeMo = (SubrackProdTypeMo)this.getSubrackProdTypeRef(coordinator);
        return subrackProdTypeMo.getTransmissionType(coordinator) == 4 && this.getSystemParameterValue(73L, 0) != 1;
    }

    public boolean isRncTypeEvoc(Coordinator coordinator) throws MoAccessException {
        return this.getSystemParameterValue(64L, 0) == 2;
    }

    protected int getSystemParameterValue(long l, int n) {
        int n2 = n;
        try {
            PriJavaProxy priJavaProxy = PriJavaProxyFactory.createPriJavaProxy();
            if (priJavaProxy != null) {
                LongSystemParameter longSystemParameter = priJavaProxy.getLongSystemParameter(l);
                if (longSystemParameter != null && longSystemParameter.isValid()) {
                    n2 = (int)longSystemParameter.getValue();
                    MessageLog.info((Class)SubrackMoImpl.class, (String)("Using system parameter " + l + ", System parameter value" + " = " + n2));
                }
            } else {
                MessageLog.info((Class)SubrackMoImpl.class, (String)"No PriJavaProxy available,using default value ");
            }
        }
        catch (WrongSystemParameterTypeException wrongSystemParameterTypeException) {
            MessageLog.info((Class)SubrackMoImpl.class, (String)("Parameter " + l + " has wrong type, using default value"));
        }
        catch (SystemParameterNotFoundException systemParameterNotFoundException) {
            MessageLog.info((Class)SubrackMoImpl.class, (String)("Parameter " + l + " not found, using default value"));
        }
        catch (PriProcessNotFoundException priProcessNotFoundException) {
            MessageLog.info((Class)SubrackMoImpl.class, (String)("Parameter " + l + " not found, using default value"));
        }
        return n2;
    }

    public boolean isCaxSubrack(Coordinator coordinator) throws MoAccessException {
        SubrackProdTypeMo subrackProdTypeMo = (SubrackProdTypeMo)this.getSubrackProdTypeRef(coordinator);
        return subrackProdTypeMo.getFanConfiguration(coordinator) == 5;
    }

    public boolean isMainSubrack(Coordinator coordinator) throws MoAccessException {
        return this.getSubrackType(coordinator) == 0;
    }

    private void checkSubrackConfiguration(Coordinator coordinator) throws MoAccessException {
        MoIterator moIterator = MoRepository.instance().lookupType("Subrack");
        while (moIterator != null && moIterator.hasMoreElements()) {
            SubrackMoImpl subrackMoImpl = (SubrackMoImpl)moIterator.nextMo();
            if (subrackMoImpl == this || subrackMoImpl.isCaxSubrack(coordinator) || subrackMoImpl.isEvoSubrack(coordinator) == this.isEvoSubrack(coordinator)) continue;
            throw new ConfigurationMismatchException("Not allowed to configure a Subrack with transmissionType: " + ((SubrackProdTypeMo)this.getSubrackProdTypeRef(coordinator)).getTransmissionType(coordinator) + " when a Subrack with other transmissionType: " + ((SubrackProdTypeMo)subrackMoImpl.getSubrackProdTypeRef(coordinator)).getTransmissionType(coordinator) + " already exists");
        }
    }

    private static class MyHwProdInvImpl
    implements HardwareProductData {
        private SubrackMoImpl refSubrackMo;

        MyHwProdInvImpl(SubrackMoImpl subrackMoImpl, Coordinator coordinator) throws MoAccessException {
            this.refSubrackMo = subrackMoImpl;
            ProductRepository.instance().registerHw((HardwareProductData)this, coordinator);
            EquipmentMoImpl.instance().actionTriggerLastHwPiChange(coordinator);
        }

        MyHwProdInvImpl(SubrackMoImpl subrackMoImpl) {
            this.refSubrackMo = subrackMoImpl;
            ProductRepository.instance().registerHw((HardwareProductData)this);
        }

        public void delete(Coordinator coordinator) throws MoAccessException {
            ProductRepository.instance().deregisterHw((HardwareProductData)this, coordinator);
            EquipmentMoImpl.instance().actionTriggerLastHwPiChange(coordinator);
        }

        public String getSubrackId(Coordinator coordinator) throws MoAccessException {
            this.refSubrackMo.data.handleTransaction(coordinator, MoData.READ_ACCESS);
            return this.refSubrackMo.getSubrackPosition(coordinator);
        }

        public String getProductionDate(Coordinator coordinator) throws MoAccessException {
            this.refSubrackMo.data.handleTransaction(coordinator, MoData.READ_ACCESS);
            Struct struct = this.refSubrackMo.getOperationalProductData(coordinator);
            String string = (String)struct.getValue("productionDate");
            if (string.length() == 8) {
                return string;
            }
            return ConvertWeekOfYearToDate.weekOfYearToDate((String)string);
        }

        public String getSerialNumber(Coordinator coordinator) throws MoAccessException {
            this.refSubrackMo.data.handleTransaction(coordinator, MoData.READ_ACCESS);
            Struct struct = this.refSubrackMo.getOperationalProductData(coordinator);
            return (String)struct.getValue("serialNumber");
        }

        public int getSlotPosition(Coordinator coordinator) throws MoAccessException {
            return 0;
        }

        public String getProductNumber(Coordinator coordinator) throws MoAccessException {
            this.refSubrackMo.data.handleTransaction(coordinator, MoData.READ_ACCESS);
            Struct struct = this.refSubrackMo.getOperationalProductData(coordinator);
            return (String)struct.getValue("productNumber");
        }

        public String getProductName(Coordinator coordinator) throws MoAccessException {
            this.refSubrackMo.data.handleTransaction(coordinator, MoData.READ_ACCESS);
            Struct struct = this.refSubrackMo.getOperationalProductData(coordinator);
            return (String)struct.getValue("productName");
        }

        public String getRState(Coordinator coordinator) throws MoAccessException {
            this.refSubrackMo.data.handleTransaction(coordinator, MoData.READ_ACCESS);
            Struct struct = this.refSubrackMo.getOperationalProductData(coordinator);
            return (String)struct.getValue("productRevision");
        }
    }
}

