/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.pdhsdhtrans;

import enea.ose.system.Signal;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.AvailConverter;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.FroInfo;
import se.ericsson.cello.mao.MaoFroTypeConverter;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.MoReservedNotDeletableException;
import se.ericsson.cello.mao.ReservableImpl;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoCanNotBeCreatedException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.pdhsdhtrans.AtmPortBuildIF;
import se.ericsson.cello.pdhsdhtrans.Os155SpiTtpMo;
import se.ericsson.cello.pdhsdhtrans.PhysPathTermRepositoryImpl;
import se.ericsson.cello.pdhsdhtrans.TrafficReservable;
import se.ericsson.cello.pdhsdhtrans.Vc12TtpMo;
import se.ericsson.cello.pdhsdhtrans.Vc12TtpMoImpl;
import se.ericsson.cello.pdhsdhtrans.Vc4TtpMo;
import se.ericsson.cello.pdhsdhtrans.fropxy.PhyVc4TtpMiGetAttributeRsp;
import se.ericsson.cello.pdhsdhtrans.fropxy.PhyVc4TtpMiProxy;
import se.ericsson.cello.pdhsdhtrans.fropxy.PhyVc4TtpMiSetAttributeRsp;
import se.ericsson.cello.transaction.Coordinator;

public class Vc4TtpMoImpl
extends CelloMao
implements Vc4TtpMo,
TrafficReservable,
FroInfo {
    private static final String VC4TTP_FRO_ID = "Vc4TtpFroId";
    private static final int PATH_TRACE_FORMAT_TYPE = 21;
    private static final int TRANSMITTED_PATH_TRACE_TYPE = 22;
    private static final int EXPECTED_PATH_TRACE_TYPE = 23;
    private static final int TIM_CONSEQUENT_ACTION_TYPE = 24;
    private static final int VC_DEG_THRESHOLD_TYPE = 25;
    private static final int VC_DEG_M_TYPE = 26;
    private static final int AU_AIS_REPORTING_TYPE = 27;
    private static final int VC_RDI_REPORTING_TYPE = 28;
    private static final int OPERATIONAL_STATE_TYPE = 2;
    private static final int AVAILABILITY_STATUS_TYPE = 3;
    private static final int NO_VC12TTP_CHILDREN = 63;
    private static final int ITU_T_G707 = 16;
    private static final int GR_253_CORE = 64;
    private static final int NO_OF_USER_CHARS_ITU_T_G707 = 15;
    private static final int NO_OF_USER_CHARS_GR_253_CORE = 62;
    private static final int FRO_MULTIPLY_FACTOR = 100;
    private static final int FRO_INCREMENT = 1;
    private static final int VC_DEG_THRESHOLD_MIN = 0;
    private static final int VC_DEG_THRESHOLD_MAX = 100;
    private static final int VC_DEG_M_MIN = 2;
    private static final int VC_DEG_M_MAX = 10;
    private static final int PADDING_INT_VALUE = 99;
    private static final int PHY_VC4TTP_RESULT_OK = 0;
    private static final Class[] reservedClasses = new Class[]{AtmPortBuildIF.class};
    private MoData data;
    private StringAttribute userLabel;
    private ReferenceAttribute reservedBy;
    private IntegerAttribute vc4TtpFroId;
    private static PhyVc4TtpMiProxy froProxy = PhyVc4TtpMiProxy.instance();
    private static NotificationSender notificationSender = NotificationSender.instance();
    private static PhysPathTermRepositoryImpl repository = PhysPathTermRepositoryImpl.instance();
    private static final int MO_DATA_REVISION_35 = 3500;
    private static final int MO_DATA_REVISION_LATEST = 3500;

    public static synchronized void create(ManagedObject managedObject, int n, String string, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkIdentity((String)"Vc4Ttp", (String)string);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)"Os155SpiTtp");
        new Vc4TtpMoImpl(managedObject, n, string, coordinator);
    }

    private Vc4TtpMoImpl(ManagedObject managedObject, int n, String string, Coordinator coordinator) throws MoAccessException {
        super(managedObject, "Vc4Ttp", string, coordinator);
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        this.data.setRevision(3500);
        this.userLabel = new StringAttribute("userLabel", true, "");
        this.data.registerPersistentAttr((Attribute)this.userLabel);
        this.reservedBy = new ReferenceAttribute("reservedBy", false);
        this.reservedBy.setValue(null);
        this.data.registerPersistentAttr((Attribute)this.reservedBy);
        this.vc4TtpFroId = new IntegerAttribute(VC4TTP_FRO_ID, false, n);
        this.data.registerPersistentAttr((Attribute)this.vc4TtpFroId);
        int n2 = ((Os155SpiTtpMo)managedObject).getMuxMode(coordinator);
        if (n2 == 1) {
            int n3 = n * 100;
            String string2 = null;
            for (int i = 0; i < 63; ++i) {
                string2 = "" + (i + 1);
                Vc12TtpMoImpl.create(this, n3, string2, coordinator);
                ++n3;
            }
        } else if (n2 == 2 || n2 == 0) {
            // empty if block
        }
        froProxy.registerForNotifications(coordinator, this, this.vc4TtpFroId.getValue(coordinator));
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        repository.register(n, this, coordinator);
    }

    public static synchronized ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator) throws MoAccessException {
        throw new MoCanNotBeCreatedException("Vc4Ttp");
    }

    public Vc4TtpMoImpl(MoData moData) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName());
        this.data = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(3500);
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute("reservedBy");
        moDataRecoveryHelper.assertAttribute(VC4TTP_FRO_ID);
        this.userLabel = (StringAttribute)moData.getAttribute("userLabel");
        this.reservedBy = (ReferenceAttribute)moData.getAttribute("reservedBy");
        this.vc4TtpFroId = (IntegerAttribute)moData.getAttribute(VC4TTP_FRO_ID);
        froProxy.registerForNotifications(null, this, this.vc4TtpFroId.getValue(null));
        repository.register(this.vc4TtpFroId.getValue(null), this);
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        throw new UndeletableMoException((ManagedObject)this);
    }

    public void deleteMo(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (this.reservedBy.getValue(coordinator) != null) {
            throw new MoReservedNotDeletableException("Vc4Ttp");
        }
        this.deleteVc12TtpMos(coordinator);
        froProxy.deregisterForNotifications(coordinator, this.getFroId(coordinator));
        super.delete(coordinator);
        this.data.delete(coordinator);
        repository.remove(this.getFroId(coordinator), coordinator);
    }

    private void deleteVc12TtpMos(Coordinator coordinator) throws MoAccessException {
        MoIterator moIterator = this.getChildren();
        while (moIterator.hasMoreElements()) {
            Object object = moIterator.nextElement();
            if (!(object instanceof Vc12TtpMo)) continue;
            ((Vc12TtpMoImpl)object).deleteMo(coordinator);
        }
    }

    public int getPathTraceFormat(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        PhyVc4TtpMiGetAttributeRsp phyVc4TtpMiGetAttributeRsp = this.getVc4TtpFroAttr(coordinator, 21);
        return phyVc4TtpMiGetAttributeRsp.getU32Value();
    }

    public void setPathTraceFormat(int n, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (n != 16 && n != 64) {
            throw new ValueOutOfRangeException("pathTraceFormat", "Vc4Ttp");
        }
        this.setVc4TtpFroIntAttr(coordinator, 21, n);
        this.notifyAttrChanged(coordinator, "pathTraceFormat", new Integer(n));
    }

    public String getTransmittedPathTrace(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        PhyVc4TtpMiGetAttributeRsp phyVc4TtpMiGetAttributeRsp = this.getVc4TtpFroAttr(coordinator, 22);
        char[] cArray = phyVc4TtpMiGetAttributeRsp.getStringValue();
        int n = this.getPathTraceFormat(coordinator);
        String string = "invalid TPT";
        if (cArray[0] == '\u0000') {
            string = "";
        } else if (n == 16 || n == 64) {
            string = new String(cArray).trim();
        }
        return string;
    }

    public void setTransmittedPathTrace(String string, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        int n = this.getPathTraceFormat(coordinator);
        if (!(string.equals("") || n == 16 && string.length() <= 15 || n == 64 && string.length() <= 62)) {
            throw new ValueOutOfRangeException("transmittedPathTrace", "Vc4Ttp");
        }
        this.setVc4TtpFroStringAttr(coordinator, 22, string);
        this.notifyAttrChanged(coordinator, "transmittedPathTrace", string);
    }

    public String getExpectedPathTrace(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        PhyVc4TtpMiGetAttributeRsp phyVc4TtpMiGetAttributeRsp = this.getVc4TtpFroAttr(coordinator, 23);
        char[] cArray = phyVc4TtpMiGetAttributeRsp.getStringValue();
        int n = this.getPathTraceFormat(coordinator);
        String string = "invalid EPT";
        if (cArray[0] == '\u0000') {
            string = "";
        } else if (n == 16 || n == 64) {
            string = new String(cArray).trim();
        }
        return string;
    }

    public void setExpectedPathTrace(String string, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (string.equals("")) {
            this.setTimConsequentAction(false, coordinator);
        } else {
            int n = this.getPathTraceFormat(coordinator);
            if (!(n == 16 && string.length() <= 15 || n == 64 && string.length() <= 62)) {
                throw new ValueOutOfRangeException("expectedPathTrace", "Vc4Ttp");
            }
        }
        this.setVc4TtpFroStringAttr(coordinator, 23, string);
        this.notifyAttrChanged(coordinator, "expectedPathTrace", string);
    }

    public boolean getTimConsequentAction(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        PhyVc4TtpMiGetAttributeRsp phyVc4TtpMiGetAttributeRsp = this.getVc4TtpFroAttr(coordinator, 24);
        return MaoFroTypeConverter.int2boolean((int)phyVc4TtpMiGetAttributeRsp.getU32Value());
    }

    public void setTimConsequentAction(boolean bl, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        int n = MaoFroTypeConverter.boolean2int((boolean)bl);
        this.setVc4TtpFroIntAttr(coordinator, 24, n);
        this.notifyAttrChanged(coordinator, "timConsequentAction", bl);
    }

    public int getVcDegThreshold(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        PhyVc4TtpMiGetAttributeRsp phyVc4TtpMiGetAttributeRsp = this.getVc4TtpFroAttr(coordinator, 25);
        return phyVc4TtpMiGetAttributeRsp.getU32Value();
    }

    public void setVcDegThreshold(int n, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (!this.inRange(n, 0, 100)) {
            throw new ValueOutOfRangeException("vcDegThreshold", "Vc4Ttp");
        }
        this.setVc4TtpFroIntAttr(coordinator, 25, n);
        this.notifyAttrChanged(coordinator, "vcDegThreshold", new Integer(n));
    }

    public int getVcDegM(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        PhyVc4TtpMiGetAttributeRsp phyVc4TtpMiGetAttributeRsp = this.getVc4TtpFroAttr(coordinator, 26);
        return phyVc4TtpMiGetAttributeRsp.getU32Value();
    }

    public void setVcDegM(int n, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (!this.inRange(n, 2, 10)) {
            throw new ValueOutOfRangeException("vcDegM", "Vc4Ttp");
        }
        this.setVc4TtpFroIntAttr(coordinator, 26, n);
        this.notifyAttrChanged(coordinator, "vcDegM", new Integer(n));
    }

    public boolean getAuAisReporting(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        PhyVc4TtpMiGetAttributeRsp phyVc4TtpMiGetAttributeRsp = this.getVc4TtpFroAttr(coordinator, 27);
        return MaoFroTypeConverter.int2boolean((int)phyVc4TtpMiGetAttributeRsp.getU32Value());
    }

    public void setAuAisReporting(boolean bl, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        int n = MaoFroTypeConverter.boolean2int((boolean)bl);
        this.setVc4TtpFroIntAttr(coordinator, 27, n);
        this.notifyAttrChanged(coordinator, "auAisReporting", bl);
    }

    public boolean getVcRdiReporting(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        PhyVc4TtpMiGetAttributeRsp phyVc4TtpMiGetAttributeRsp = this.getVc4TtpFroAttr(coordinator, 28);
        return MaoFroTypeConverter.int2boolean((int)phyVc4TtpMiGetAttributeRsp.getU32Value());
    }

    public void setVcRdiReporting(boolean bl, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        int n = MaoFroTypeConverter.boolean2int((boolean)bl);
        this.setVc4TtpFroIntAttr(coordinator, 28, n);
        this.notifyAttrChanged(coordinator, "vcRdiReporting", bl);
    }

    public int getOperationalState(Coordinator coordinator) throws MoAccessException {
        PhyVc4TtpMiGetAttributeRsp phyVc4TtpMiGetAttributeRsp = this.getVc4TtpFroAttr(coordinator, 2);
        return phyVc4TtpMiGetAttributeRsp.getU32Value();
    }

    public int getAvailabilityStatus(Coordinator coordinator) throws MoAccessException {
        PhyVc4TtpMiGetAttributeRsp phyVc4TtpMiGetAttributeRsp = this.getVc4TtpFroAttr(coordinator, 3);
        return AvailConverter.convert((int)phyVc4TtpMiGetAttributeRsp.getU32Value());
    }

    public int getPmVcEs(Coordinator coordinator) throws MoAccessException {
        return super.getPmAttribute("pmVcEs", coordinator);
    }

    public int getPmVcSes(Coordinator coordinator) throws MoAccessException {
        return super.getPmAttribute("pmVcSes", coordinator);
    }

    public int getPmVcUas(Coordinator coordinator) throws MoAccessException {
        return super.getPmAttribute("pmVcUas", coordinator);
    }

    public int getPmVcBbe(Coordinator coordinator) throws MoAccessException {
        return super.getPmAttribute("pmVcBbe", coordinator);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.userLabel.getValue(coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkStringWithLength((String)string, (String)"userLabel", (String)"Vc4Ttp", (int)128, (int)0);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.userLabel.setValue(string);
    }

    public ManagedObject getReservedBy(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.reservedBy.getValue(coordinator);
    }

    public ManagedObject getReservedByTraffic(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.reservedBy.getValue(coordinator);
    }

    public String getType() {
        return "Vc4Ttp";
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.vc4TtpFroId.getValue(coordinator);
    }

    private PhyVc4TtpMiGetAttributeRsp getVc4TtpFroAttr(Coordinator coordinator, int n) throws MoAccessException {
        int n2 = 0;
        if (coordinator != null) {
            n2 = coordinator.getTransactionID();
        }
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        PhyVc4TtpMiGetAttributeRsp phyVc4TtpMiGetAttributeRsp = froProxy.sendPhyVc4TtpMiGetAttributeReq(n2, this.vc4TtpFroId.getValue(coordinator), n);
        this.checkSignal((Signal)phyVc4TtpMiGetAttributeRsp);
        if (phyVc4TtpMiGetAttributeRsp.getResult() != 0) {
            throw new FroRequestFailedException("Vc4Ttp", "Vc4TtpFro", "GetAttrReq: " + froProxy.getResultMsg(phyVc4TtpMiGetAttributeRsp.getResult()), phyVc4TtpMiGetAttributeRsp.getResult());
        }
        return phyVc4TtpMiGetAttributeRsp;
    }

    private void setVc4TtpFroIntAttr(Coordinator coordinator, int n, int n2) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        char[] cArray = this.convertStringToCharArray(coordinator, "");
        PhyVc4TtpMiSetAttributeRsp phyVc4TtpMiSetAttributeRsp = froProxy.sendPhyVc4TtpMiSetAttributeReq(coordinator.getTransactionID(), this.vc4TtpFroId.getValue(coordinator), n, n2, cArray);
        this.checkSignal((Signal)phyVc4TtpMiSetAttributeRsp);
        if (phyVc4TtpMiSetAttributeRsp.getResult() != 0) {
            throw new FroRequestFailedException("Vc4Ttp", "Vc4TtpFro", "SetAttrReq: " + froProxy.getResultMsg(phyVc4TtpMiSetAttributeRsp.getResult()), phyVc4TtpMiSetAttributeRsp.getResult());
        }
    }

    private void setVc4TtpFroStringAttr(Coordinator coordinator, int n, String string) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        int n2 = 99;
        char[] cArray = this.convertStringToCharArray(coordinator, string);
        PhyVc4TtpMiSetAttributeRsp phyVc4TtpMiSetAttributeRsp = froProxy.sendPhyVc4TtpMiSetAttributeReq(coordinator.getTransactionID(), this.vc4TtpFroId.getValue(coordinator), n, n2, cArray);
        this.checkSignal((Signal)phyVc4TtpMiSetAttributeRsp);
        if (phyVc4TtpMiSetAttributeRsp.getResult() != 0) {
            throw new FroRequestFailedException("Vc4Ttp", "Vc4TtpFro", "SetAttrReq: " + froProxy.getResultMsg(phyVc4TtpMiSetAttributeRsp.getResult()), phyVc4TtpMiSetAttributeRsp.getResult());
        }
    }

    private void checkSignal(Signal signal) throws MoAccessException {
        if (signal == null) {
            throw new FroNotAccessibleException("Vc4Ttp", "Vc4TtpFro");
        }
    }

    private void notifyAttrChanged(Coordinator coordinator, String string, Object object) {
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        notificationSender.pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    private boolean inRange(int n, int n2, int n3) {
        return n >= n2 && n <= n3;
    }

    public void trafficReserve(Coordinator coordinator, ManagedObject managedObject) throws MoAccessException {
        this.reservedBy = ReservableImpl.trafficReserve((ManagedObject)managedObject, (Coordinator)coordinator, (String)"Vc4Ttp", (MoData)this.data, (ReferenceAttribute)this.reservedBy, (Class[])reservedClasses);
    }

    public void trafficRelease(Coordinator coordinator, ManagedObject managedObject) throws MoAccessException {
        this.reservedBy = ReservableImpl.trafficRelease((ManagedObject)managedObject, (Coordinator)coordinator, (String)"Vc4Ttp", (MoData)this.data, (ReferenceAttribute)this.reservedBy, (Class[])reservedClasses);
    }

    public char[] convertStringToCharArray(Coordinator coordinator, String string) throws MoAccessException {
        char[] cArray = new char[65];
        if (string.equals("")) {
            return cArray;
        }
        if (string != null) {
            for (int i = 0; i < string.length(); ++i) {
                cArray[i] = string.charAt(i);
            }
            if (this.getPathTraceFormat(coordinator) == 64) {
                cArray[62] = 13;
                cArray[63] = 10;
            }
        }
        return cArray;
    }
}

