/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.managedelement;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import se.ericsson.cello.common.fropxy.PnpSignalPort;
import se.ericsson.cello.common.fropxy.PnpSignalPortManager;
import se.ericsson.cello.mao.ThreadUtil;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.util.library.Lib;

public class AutoConfigurationObserver {
    private static final String[] acThreads = new String[]{"Cma_AutoConfig_Slot_Scan_Thread", "Cma_AutoConfig_Single_Slot_Scan_Thread"};
    public static final Class CLASS = AutoConfigurationObserver.class;

    public static int getAutoConfigurationStatus() {
        int n = 0;
        try {
            PnpSignalPort pnpSignalPort = PnpSignalPortManager.instance();
            if (pnpSignalPort.isIdle()) {
                Collection collection = ThreadUtil.getAllThreadNames();
                List<String> list = Arrays.asList(acThreads);
                collection.retainAll(list);
                if (!collection.isEmpty()) {
                    MessageLog.trace((int)5, (Class)CLASS, (String)(" " + collection.size() + ": AutoConfiguration threads still executing: " + Lib.toString((Object[])collection.toArray())));
                    n = 1;
                }
            } else {
                MessageLog.trace((int)5, (Class)CLASS, (String)"The PnP signalport contains uncompleted signals.");
                n = 1;
            }
        }
        catch (Exception exception) {
            MessageLog.traceError((Class)CLASS, (String)"Failed to obtain autoConfiguration status", (Throwable)exception);
        }
        return n;
    }
}

