/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.managedelement.fropxy;

import enea.ose.system.InSignal;
import enea.ose.system.OseProcess;
import enea.ose.system.Signal;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import se.ericsson.cello.common.fropxy.CmaPortManager;
import se.ericsson.cello.common.fropxy.CmaSignalPort;
import se.ericsson.cello.common.fropxy.FroEmptySignal;
import se.ericsson.cello.common.fropxy.FroProxy;
import se.ericsson.cello.common.fropxy.FroReqU32;
import se.ericsson.cello.managedelement.SU_ME_HealthCheckCoordinator;
import se.ericsson.cello.managedelement.fropxy.FroHealthCheckResultObserver;
import se.ericsson.cello.managedelement.fropxy.FroHealthCheckResultProvider;
import se.ericsson.cello.managedelement.fropxy.OsaMe3RestartReq;
import se.ericsson.cello.managedelement.fropxy.OsaMeFsHealthCheckCfm;
import se.ericsson.cello.managedelement.fropxy.OsaMeFsHealthCheckInd;
import se.ericsson.cello.managedelement.fropxy.OsaMeFsHealthCheckReq;
import se.ericsson.cello.managedelement.fropxy.OsaMeGetDiskDataRsp;
import se.ericsson.cello.managedelement.fropxy.OsaMeGetDiskLimitReq;
import se.ericsson.cello.managedelement.fropxy.OsaMeGetDiskLimitRsp;
import se.ericsson.cello.managedelement.fropxy.OsaMeGetFtcRsp;
import se.ericsson.cello.managedelement.fropxy.OsaMeGetNodeIdRsp;
import se.ericsson.cello.managedelement.fropxy.OsaMeGetPiuGroupEscTypeRsp;
import se.ericsson.cello.managedelement.fropxy.OsaMeGetTopologyVersionRsp;
import se.ericsson.cello.managedelement.fropxy.OsaMePhasedRestartCheckReq;
import se.ericsson.cello.managedelement.fropxy.OsaMePhasedRestartCheckRsp;
import se.ericsson.cello.managedelement.fropxy.OsaMeRestartRsp;
import se.ericsson.cello.managedelement.fropxy.OsaMeSetDiskLimitReq;
import se.ericsson.cello.managedelement.fropxy.OsaMeSetDiskLimitRsp;
import se.ericsson.cello.managedelement.fropxy.OsaMeSetNodeIdReq;
import se.ericsson.cello.managedelement.fropxy.OsaMeSetNodeIdRsp;
import se.ericsson.cello.managedelement.fropxy.OsaMeSetPiuGroupEscTypeReq;
import se.ericsson.cello.managedelement.fropxy.OsaMeSetPiuGroupEscTypeRsp;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.session.NameServerWrapper;
import se.ericsson.cello.session.PVSession;
import se.ericsson.cello.session.ServiceSubscriber;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.services.ServiceProvider;
import se.ericsson.cello.support.services.ServiceStateListener;
import se.ericsson.cello.support.services.ServiceStateManager;
import se.ericsson.cello.support.sigutil.SignalHelper;
import se.ericsson.cello.support.sigutil.SignalObserver;

public class OsaMeMgmntProxy
extends FroProxy
implements FroHealthCheckResultProvider {
    private static final String PROTOCOL_VERSION_CELLO_4300_R1A = "R1A";
    private static final String PROTOCOL_VERSION_CELLO_4300_R2A = "R2A";
    private static final String PROTOCOL_VERSION_CELLO_5100_R3A = "R3A";
    private static final String PROTOCOL_VERSION_ME_FRO_PV6 = "R5B";
    private static final String PROTOCOL_VERSION_LATEST = "R5B";
    public static final int CELLO_ME_OK = 1;
    public static final int CELLO_ME_NODISK = 2;
    public static final int CELLO_ME_GENERAL_ERROR = 3;
    public static final int CELLO_ME_ALREADY_EXISTS = 4;
    public static final int CELLO_ME_SYS_PAR_UNDEF = 5;
    public static final int CELLO_ME_DB_ERROR = 6;
    public static final int CELLO_ME_GET_NOT_ALLOWED = 7;
    public static final int CELLO_ME_SET_NOT_ALLOWED = 8;
    private static String CELLO_ME_CLASS_NAME = "CelloMeResource";
    private CmaSignalPort cmaSignalPort;
    private PVSession session = null;
    private Set observers = new HashSet();
    private static OsaMeMgmntProxy instance = null;

    public static OsaMeMgmntProxy instance() {
        if (instance == null) {
            instance = new OsaMeMgmntProxy();
        }
        return instance;
    }

    public void sendOsaMeRestartReq() throws FroNotAccessibleException {
        FroEmptySignal froEmptySignal = new FroEmptySignal(66090);
        SignalHelper.send((OseProcess)this.session.obtainSession().getFroProcess(), (Signal)froEmptySignal);
    }

    public void sendOsaMe2RestartReq(int n) throws FroNotAccessibleException {
        FroReqU32 froReqU32 = new FroReqU32(67041, n);
        SignalHelper.send((OseProcess)this.session.obtainSession().getFroProcess(), (Signal)froReqU32);
    }

    public void sendOsaMe3RestartReq(int n, int n2, String string) throws FroNotAccessibleException {
        OsaMe3RestartReq osaMe3RestartReq = new OsaMe3RestartReq(n, n2, string);
        SignalHelper.sendAndReceive((OseProcess)this.session.obtainSession().getFroProcess(), (Signal)osaMe3RestartReq, (Class)OsaMeRestartRsp.class);
    }

    private OsaMeMgmntProxy() {
        this.cmaSignalPort = CmaPortManager.instance();
        this.cmaSignalPort.addSignalObserver((SignalObserver)this, OsaMeFsHealthCheckInd.class);
    }

    public OsaMeGetDiskDataRsp sendOsaMeGetDiskDataReq() throws FroNotAccessibleException {
        FroEmptySignal froEmptySignal = new FroEmptySignal(66858);
        OsaMeGetDiskDataRsp osaMeGetDiskDataRsp = (OsaMeGetDiskDataRsp)SignalHelper.sendAndReceive((OseProcess)this.session.obtainSession().getFroProcess(), (Signal)froEmptySignal, (Class)OsaMeGetDiskDataRsp.class);
        return osaMeGetDiskDataRsp;
    }

    public OsaMeGetDiskLimitRsp sendOsaMeGetDiskLimitReq(int n) throws FroNotAccessibleException {
        OsaMeGetDiskLimitReq osaMeGetDiskLimitReq = new OsaMeGetDiskLimitReq(n);
        OsaMeGetDiskLimitRsp osaMeGetDiskLimitRsp = (OsaMeGetDiskLimitRsp)SignalHelper.sendAndReceive((OseProcess)this.session.obtainSession().getFroProcess(), (Signal)osaMeGetDiskLimitReq, (Class)OsaMeGetDiskLimitRsp.class);
        return osaMeGetDiskLimitRsp;
    }

    public OsaMeGetPiuGroupEscTypeRsp sendOsaMeGetPiuGroupEscTypeReq(int n) throws FroNotAccessibleException {
        FroReqU32 froReqU32 = new FroReqU32(67400, n);
        OsaMeGetPiuGroupEscTypeRsp osaMeGetPiuGroupEscTypeRsp = (OsaMeGetPiuGroupEscTypeRsp)SignalHelper.sendAndReceive((OseProcess)this.session.obtainSession().getFroProcess(), (Signal)froReqU32, (Class)OsaMeGetPiuGroupEscTypeRsp.class);
        return osaMeGetPiuGroupEscTypeRsp;
    }

    public OsaMeSetPiuGroupEscTypeRsp sendOsaMeSetPiuGroupEscTypeReq(int n, int n2) throws FroNotAccessibleException {
        OsaMeSetPiuGroupEscTypeReq osaMeSetPiuGroupEscTypeReq = new OsaMeSetPiuGroupEscTypeReq(n, n2);
        OsaMeSetPiuGroupEscTypeRsp osaMeSetPiuGroupEscTypeRsp = (OsaMeSetPiuGroupEscTypeRsp)SignalHelper.sendAndReceive((OseProcess)this.session.obtainSession().getFroProcess(), (Signal)osaMeSetPiuGroupEscTypeReq, (Class)OsaMeSetPiuGroupEscTypeRsp.class);
        return osaMeSetPiuGroupEscTypeRsp;
    }

    public OsaMeSetDiskLimitRsp sendOsaMeSetDiskLimitReq(int n, int n2) throws FroNotAccessibleException {
        OsaMeSetDiskLimitReq osaMeSetDiskLimitReq = new OsaMeSetDiskLimitReq(n, n2);
        OsaMeSetDiskLimitRsp osaMeSetDiskLimitRsp = (OsaMeSetDiskLimitRsp)SignalHelper.sendAndReceive((OseProcess)this.session.obtainSession().getFroProcess(), (Signal)osaMeSetDiskLimitReq, (Class)OsaMeSetDiskLimitRsp.class);
        return osaMeSetDiskLimitRsp;
    }

    public OsaMeGetNodeIdRsp sendOsaMeGetNodeIdReq(int n) throws FroNotAccessibleException {
        FroReqU32 froReqU32 = new FroReqU32(67408, n);
        OsaMeGetNodeIdRsp osaMeGetNodeIdRsp = (OsaMeGetNodeIdRsp)SignalHelper.sendAndReceive((OseProcess)this.session.obtainSession().getFroProcess(), (Signal)froReqU32, (Class)OsaMeGetNodeIdRsp.class);
        return osaMeGetNodeIdRsp;
    }

    public OsaMeSetNodeIdRsp sendOsaMeSetNodeIdReq(int n, String string, String string2, String string3, String string4, String string5) throws FroNotAccessibleException {
        OsaMeSetNodeIdReq osaMeSetNodeIdReq = new OsaMeSetNodeIdReq(n, string, string2, string3, string4, string5);
        OsaMeSetNodeIdRsp osaMeSetNodeIdRsp = (OsaMeSetNodeIdRsp)SignalHelper.sendAndReceive((OseProcess)this.session.obtainSession().getFroProcess(), (Signal)osaMeSetNodeIdReq, (Class)OsaMeSetNodeIdRsp.class);
        return osaMeSetNodeIdRsp;
    }

    public OsaMeGetFtcRsp sendOsaMeGetFtcStateReq(int n) throws FroNotAccessibleException {
        FroEmptySignal froEmptySignal = new FroEmptySignal(67646);
        OsaMeGetFtcRsp osaMeGetFtcRsp = (OsaMeGetFtcRsp)SignalHelper.sendAndReceive((OseProcess)this.session.obtainSession().getFroProcess(), (Signal)froEmptySignal, (Class)OsaMeGetFtcRsp.class);
        return osaMeGetFtcRsp;
    }

    public void addFroHealthCheckResultObserver(FroHealthCheckResultObserver froHealthCheckResultObserver) {
        this.observers.add(froHealthCheckResultObserver);
    }

    public void removeFroHealthCheckResultObserver(FroHealthCheckResultObserver froHealthCheckResultObserver) {
        this.observers.remove(froHealthCheckResultObserver);
    }

    public int sendOsaMeFsHealthCheckReq(long l) throws FroNotAccessibleException {
        OsaMeFsHealthCheckReq osaMeFsHealthCheckReq = new OsaMeFsHealthCheckReq(l);
        OsaMeFsHealthCheckCfm osaMeFsHealthCheckCfm = (OsaMeFsHealthCheckCfm)SignalHelper.sendAndReceive((OseProcess)this.session.obtainSession().getFroProcess(), (Signal)osaMeFsHealthCheckReq, (Class)OsaMeFsHealthCheckCfm.class);
        return osaMeFsHealthCheckCfm.getResult();
    }

    public OsaMePhasedRestartCheckRsp sendOsaMePhasedRestartCheckReq() throws FroNotAccessibleException {
        OsaMePhasedRestartCheckReq osaMePhasedRestartCheckReq = new OsaMePhasedRestartCheckReq();
        MessageLog.info(this.getClass(), (String)"Waiting for Phased Restart response from FRO");
        OsaMePhasedRestartCheckRsp osaMePhasedRestartCheckRsp = (OsaMePhasedRestartCheckRsp)SignalHelper.sendAndReceive((OseProcess)this.session.obtainSession().getFroProcess(), (Signal)osaMePhasedRestartCheckReq, (Class)OsaMePhasedRestartCheckRsp.class, (int)3600000);
        return osaMePhasedRestartCheckRsp;
    }

    public OsaMeGetTopologyVersionRsp sendOsaMeGetTopologyVersionReq(int n) throws FroNotAccessibleException {
        FroEmptySignal froEmptySignal = new FroEmptySignal(68810);
        OsaMeGetTopologyVersionRsp osaMeGetTopologyVersionRsp = (OsaMeGetTopologyVersionRsp)SignalHelper.sendAndReceive((OseProcess)this.session.obtainSession().getFroProcess(), (Signal)froEmptySignal, (Class)OsaMeGetTopologyVersionRsp.class);
        return osaMeGetTopologyVersionRsp;
    }

    public void subscribeService() {
        if (this.session == null) {
            this.session = new PVSession(CELLO_ME_CLASS_NAME, "R5B", "R5B", "R5B", "ManagedElement", 1537);
            new NameServerWrapper(CELLO_ME_CLASS_NAME, (ServiceSubscriber)this);
        }
    }

    public void signalReceived(InSignal inSignal) {
        if (inSignal instanceof OsaMeFsHealthCheckInd) {
            OsaMeFsHealthCheckInd osaMeFsHealthCheckInd = (OsaMeFsHealthCheckInd)inSignal;
            long l = osaMeFsHealthCheckInd.getRequestId();
            int n = osaMeFsHealthCheckInd.getResultCode();
            String string = osaMeFsHealthCheckInd.getMessage();
            if (this.observers.isEmpty()) {
                MessageLog.traceError(this.getClass(), (String)("Received health check result for request id " + l + " (Result code is " + n + "), but noone subscribed to it."));
            }
            HashSet hashSet = new HashSet(this.observers);
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                FroHealthCheckResultObserver froHealthCheckResultObserver = (FroHealthCheckResultObserver)iterator.next();
                froHealthCheckResultObserver.froHealthCheckResultUpdated(l, n, string);
                if (!(froHealthCheckResultObserver instanceof SU_ME_HealthCheckCoordinator)) continue;
                this.removeFroHealthCheckResultObserver(froHealthCheckResultObserver);
            }
        } else {
            MessageLog.info(this.getClass(), (String)("Unknown Signal recieved ,signal no:" + inSignal.getSigNo()));
        }
    }

    public void sendOmsInitializedToFro() {
        if (System.getProperty("is.using.nat", "false").equalsIgnoreCase("false")) {
            String[] stringArray = new String[]{"CPP.OAM.SERVICES"};
            ServiceStateListener serviceStateListener = new ServiceStateListener(){

                public void serviceNotAvailable(ServiceProvider serviceProvider) {
                }

                public void serviceAvailable(ServiceProvider serviceProvider) {
                    if (serviceProvider.getServiceName().equalsIgnoreCase("CPP.OAM.SERVICES")) {
                        FroReqU32 froReqU32 = new FroReqU32(69068, 1);
                        try {
                            MessageLog.info(this.getClass(), (String)"OMS Initialized Indication sent to FRO");
                            SignalHelper.send((OseProcess)OsaMeMgmntProxy.this.session.obtainSession().getFroProcess(), (Signal)froReqU32);
                        }
                        catch (FroNotAccessibleException froNotAccessibleException) {
                            MessageLog.traceError(this.getClass(), (String)"Unable to send OMS Initilaized indication to FRO", (Throwable)froNotAccessibleException);
                        }
                    }
                }
            };
            ServiceStateManager.getInstance().registerServiceStateListener(serviceStateListener, stringArray);
        }
    }

    public void serviceAdded() {
    }

    public void serviceRemoved() {
        super.serviceRemoved(CELLO_ME_CLASS_NAME);
    }

    public String getResultMsg(int n) {
        String string = "";
        switch (n) {
            case 1: {
                string = "CELLO_ME_OK";
                break;
            }
            case 2: {
                string = "CELLO_ME_NODISK";
                break;
            }
            case 3: {
                string = "CELLO_ME_GENERAL_ERROR";
                break;
            }
            case 4: {
                string = "CELLO_ME_ALREADY_EXISTS";
                break;
            }
            case 5: {
                string = "CELLO_ME_SYS_PAR_UNDEF";
                break;
            }
            case 6: {
                string = "CELLO_ME_DB_ERROR";
                break;
            }
            case 7: {
                string = "CELLO_ME_GET_NOT_ALLOWED";
                break;
            }
            case 8: {
                string = "CELLO_ME_SET_NOT_ALLOWED";
                break;
            }
            default: {
                string = "UNKNOWN RESULT CODE: " + n;
            }
        }
        return string;
    }
}

