/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9.bluez.crypto;

import com.ibm.j9.bluez.crypto.CL3;
import com.ibm.j9.bluez.crypto.CL3Exception;
import com.ibm.j9.bluez.crypto.CL3Key;

public class AESCipher {
    static final int[] AES_S = new int[256];
    static final int[] AES_Si = new int[256];
    static final byte[] AES_RCON = new byte[30];
    static final int[] AES_T1234 = new int[1024];
    static final int[] AES_D1234 = new int[1024];

    static {
        int[] ALOG = new int[256];
        int[] LOG = new int[256];
        int c = 0;
        int A = 0;
        int i = 0;
        ALOG[0] = 1;
        int a = 1;
        while (++i < 256) {
            if ((a ^= a << 1) >= 256) {
                a ^= 0x11B;
            }
            ALOG[i] = a;
            LOG[ALOG[i]] = i;
        }
        LOG[1] = 0;
        i = 0;
        while (i < 256) {
            c = 99;
            A = 248;
            int m = 128;
            int t = 0;
            while (t < 8) {
                int x = A & (i <= 1 ? i : ALOG[255 - LOG[i]]);
                while (x > 0) {
                    c ^= (x & 1) * m;
                    x >>>= 1;
                }
                A = A >>> 1 | (A & 1) << 7;
                m >>>= 1;
                ++t;
            }
            AESCipher.AES_S[i] = (short)c;
            AESCipher.AES_Si[c] = (short)i;
            ++i;
        }
        i = 0;
        while (i < 256) {
            int j = 0;
            while (j < 8) {
                if (j % 4 == 0) {
                    if (j == 0) {
                        a = AES_S[i];
                        c = 33620227;
                    } else {
                        a = AES_Si[i];
                        c = 235474187;
                    }
                    A = LOG[a];
                }
                (j <= 3 ? AESCipher.AES_T1234 : AESCipher.AES_D1234)[(j & 3) * 256 + i] = a == 0 ? 0 : ALOG[(A + LOG[c >>> 24]) % 255] << 24 | ALOG[(A + LOG[c >>> 16 & 0xFF]) % 255] << 16 | ALOG[(A + LOG[c >>> 8 & 0xFF]) % 255] << 8 | ALOG[(A + LOG[c & 0xFF]) % 255];
                c = c >>> 8 | c << 24;
                ++j;
            }
            ++i;
        }
        AESCipher.AES_RCON[0] = 1;
        a = 1;
        i = 1;
        while (i < 30) {
            AESCipher.AES_RCON[i++] = (byte)((a <<= 1) >= 256 ? (a = a ^ 0x11B) : a);
        }
    }

    public static CL3Key aesKey(byte[] rawKey, int off, int len, int blockSize) {
        int Nb;
        if (blockSize != 16 && blockSize != 24 && blockSize != 32 || len != 16 && len != 24 && len != 32) {
            throw new CL3Exception(-2147483645);
        }
        int Nk = len / 4;
        int k = Nb * (((Nb = blockSize / 4) > Nk ? Nb : Nk) + 7);
        int[] W = new int[2 * k + 1];
        W[W.length - 1] = blockSize;
        int i = 0;
        while (i < Nk) {
            W[i] = CL3.msbf4(rawKey, off + i * 4);
            ++i;
        }
        int j = W[i - 1];
        i = Nk;
        while (i < k) {
            if (i % Nk == 0) {
                j = AES_S[j >>> 16 & 0xFF] << 24 ^ AES_S[j >>> 8 & 0xFF] << 16 ^ AES_S[j & 0xFF] << 8 ^ AES_S[j >>> 24] ^ AES_RCON[(i - Nk) / Nk] << 24;
            } else if (Nk > 6 && i % Nk == 4) {
                j = AES_S[j >>> 24] << 24 ^ AES_S[j >>> 16 & 0xFF] << 16 ^ AES_S[j >>> 8 & 0xFF] << 8 ^ AES_S[j & 0xFF];
            }
            W[i] = j ^= W[i - Nk];
            ++i;
        }
        j = 0;
        while (--i >= 0) {
            int a = W[i];
            W[k + j] = j < Nb || i < Nb ? a : AES_D1234[AES_S[a >>> 24]] ^ AES_D1234[256 + AES_S[a >>> 16 & 0xFF]] ^ AES_D1234[512 + AES_S[a >>> 8 & 0xFF]] ^ AES_D1234[768 + AES_S[a & 0xFF]];
            ++j;
        }
        return new CL3Key(W, 33);
    }

    public static void aes(CL3Key key, int mode, byte[] iv, int ivOff, byte[] data, int off, byte[] to, int pos, int len) {
        int ke;
        int w7;
        int w6;
        int w5;
        int w4;
        int w3;
        int w2;
        int w1;
        int w0;
        int[] X;
        int[] S;
        int kE;
        int kb;
        int[] K = (int[])key.obj;
        int ki = K.length - 1;
        int b = K[ki];
        if (len % b != 0) {
            throw new CL3Exception(-2147483645);
        }
        if (mode == 0) {
            kb = 0;
            kE = ki / 2 - b;
            S = AES_S;
            X = AES_T1234;
            w0 = ivOff;
            w1 = 4;
            w2 = 8;
            w3 = 12;
            w4 = 16;
            w5 = 20;
            w6 = 24;
            w7 = 28;
            ke = ki / 2 - b / 4;
        } else {
            kb = ki / 2;
            kE = ki - b;
            S = AES_Si;
            X = AES_D1234;
            w0 = b - 4;
            off += w0;
            pos += w0;
            w0 += ivOff;
            w1 = -4;
            w2 = -8;
            w3 = -12;
            w4 = -16;
            w5 = -20;
            w6 = -24;
            w7 = -28;
            ke = ki - b / 4;
        }
        int jv3 = 0;
        int jv2 = 0;
        int jv1 = 0;
        int jv0 = 0;
        int iv3 = 0;
        int iv2 = 0;
        int iv1 = 0;
        int iv0 = 0;
        int jv7 = 0;
        int jv6 = 0;
        int jv5 = 0;
        int jv4 = 0;
        int iv7 = 0;
        int iv6 = 0;
        int iv5 = 0;
        int iv4 = 0;
        if (iv != null) {
            iv0 = CL3.msbf4(iv, w0);
            iv1 = CL3.msbf4(iv, w0 + w1);
            iv2 = CL3.msbf4(iv, w0 + w2);
            iv3 = CL3.msbf4(iv, w0 + w3);
            if (b > 16) {
                iv4 = CL3.msbf4(iv, w0 + w4);
                iv5 = CL3.msbf4(iv, w0 + w5);
                if (b > 24) {
                    iv6 = CL3.msbf4(iv, w0 + w6);
                    iv7 = CL3.msbf4(iv, w0 + w7);
                }
            }
        }
        int t7 = 0;
        int t6 = 0;
        int t5 = 0;
        int t4 = 0;
        int a7 = 0;
        int a6 = 0;
        int a5 = 0;
        int a4 = 0;
        len += off;
        while (off < len) {
            int t0;
            int t3;
            int t2;
            int t1;
            int a0 = CL3.msbf4(data, off);
            int a1 = CL3.msbf4(data, off + w1);
            int a2 = CL3.msbf4(data, off + w2);
            int a3 = CL3.msbf4(data, off + w3);
            if (b > 16) {
                a4 = CL3.msbf4(data, off + w4);
                a5 = CL3.msbf4(data, off + w5);
                if (b > 24) {
                    a6 = CL3.msbf4(data, off + w6);
                    a7 = CL3.msbf4(data, off + w7);
                }
            }
            off += b;
            if (iv != null) {
                if (mode == 0) {
                    a0 ^= iv0;
                    a1 ^= iv1;
                    a2 ^= iv2;
                    a3 ^= iv3;
                    if (b > 16) {
                        a4 ^= iv4;
                        a5 ^= iv5;
                        a6 ^= iv6;
                        a7 ^= iv7;
                    }
                } else {
                    jv0 = iv0;
                    jv1 = iv1;
                    jv2 = iv2;
                    jv3 = iv3;
                    iv0 = a0;
                    iv1 = a1;
                    iv2 = a2;
                    iv3 = a3;
                    if (b > 16) {
                        jv4 = iv4;
                        jv5 = iv5;
                        jv6 = iv6;
                        jv7 = iv7;
                        iv4 = a4;
                        iv5 = a5;
                        iv6 = a6;
                        iv7 = a7;
                    }
                }
            }
            ki = kb;
            if (b == 16) {
                a0 ^= K[ki];
                a1 ^= K[ki + 1];
                a2 ^= K[ki + 2];
                a3 ^= K[ki + 3];
                do {
                    t1 = K[ki + 5];
                    t2 = K[ki + 6];
                    t3 = K[ki + 7];
                    t0 = K[ki + 4];
                    t1 ^= X[768 + (a0 & 0xFF)];
                    t2 ^= X[512 + (a0 >>> 8 & 0xFF)];
                    t3 ^= X[256 + (a0 >>> 16 & 0xFF)];
                    t0 ^= X[a0 >>> 24];
                    t2 ^= X[768 + (a1 & 0xFF)];
                    t3 ^= X[512 + (a1 >>> 8 & 0xFF)];
                    t0 ^= X[256 + (a1 >>> 16 & 0xFF)];
                    t1 ^= X[a1 >>> 24];
                    t3 ^= X[768 + (a2 & 0xFF)];
                    t0 ^= X[512 + (a2 >>> 8 & 0xFF)];
                    t1 ^= X[256 + (a2 >>> 16 & 0xFF)];
                    t2 ^= X[a2 >>> 24];
                    t0 ^= X[768 + (a3 & 0xFF)];
                    t1 ^= X[512 + (a3 >>> 8 & 0xFF)];
                    t2 ^= X[256 + (a3 >>> 16 & 0xFF)];
                    t3 ^= X[a3 >>> 24];
                    a1 = K[ki + 9];
                    a2 = K[ki + 10];
                    a3 = K[ki + 11];
                    a0 = K[ki + 8];
                    a1 ^= X[768 + (t0 & 0xFF)];
                    a2 ^= X[512 + (t0 >>> 8 & 0xFF)];
                    a3 ^= X[256 + (t0 >>> 16 & 0xFF)];
                    a0 ^= X[t0 >>> 24];
                    a2 ^= X[768 + (t1 & 0xFF)];
                    a3 ^= X[512 + (t1 >>> 8 & 0xFF)];
                    a0 ^= X[256 + (t1 >>> 16 & 0xFF)];
                    a1 ^= X[t1 >>> 24];
                    a3 ^= X[768 + (t2 & 0xFF)];
                    a0 ^= X[512 + (t2 >>> 8 & 0xFF)];
                    a1 ^= X[256 + (t2 >>> 16 & 0xFF)];
                    a2 ^= X[t2 >>> 24];
                    a0 ^= X[768 + (t3 & 0xFF)];
                    a1 ^= X[512 + (t3 >>> 8 & 0xFF)];
                    a2 ^= X[256 + (t3 >>> 16 & 0xFF)];
                    a3 ^= X[t3 >>> 24];
                } while ((ki += 8) < kE);
                t1 = K[ki + 5];
                t2 = K[ki + 6];
                t3 = K[ki + 7];
                t0 = K[ki + 4];
                t1 ^= X[768 + (a0 & 0xFF)];
                t2 ^= X[512 + (a0 >>> 8 & 0xFF)];
                t3 ^= X[256 + (a0 >>> 16 & 0xFF)];
                t0 ^= X[a0 >>> 24];
                t2 ^= X[768 + (a1 & 0xFF)];
                t3 ^= X[512 + (a1 >>> 8 & 0xFF)];
                t0 ^= X[256 + (a1 >>> 16 & 0xFF)];
                t1 ^= X[a1 >>> 24];
                t3 ^= X[768 + (a2 & 0xFF)];
                t0 ^= X[512 + (a2 >>> 8 & 0xFF)];
                t1 ^= X[256 + (a2 >>> 16 & 0xFF)];
                t2 ^= X[a2 >>> 24];
                a0 = S[(t0 ^= X[768 + (a3 & 0xFF)]) >>> 24] << 24 ^ S[(t1 ^= X[512 + (a3 >>> 8 & 0xFF)]) >>> 16 & 0xFF] << 16 ^ S[(t2 ^= X[256 + (a3 >>> 16 & 0xFF)]) >>> 8 & 0xFF] << 8 ^ S[(t3 ^= X[a3 >>> 24]) & 0xFF] ^ K[ki + 8];
                a1 = S[t1 >>> 24] << 24 ^ S[t2 >>> 16 & 0xFF] << 16 ^ S[t3 >>> 8 & 0xFF] << 8 ^ S[t0 & 0xFF] ^ K[ki + 9];
                a2 = S[t2 >>> 24] << 24 ^ S[t3 >>> 16 & 0xFF] << 16 ^ S[t0 >>> 8 & 0xFF] << 8 ^ S[t1 & 0xFF] ^ K[ki + 10];
                a3 = S[t3 >>> 24] << 24 ^ S[t0 >>> 16 & 0xFF] << 16 ^ S[t1 >>> 8 & 0xFF] << 8 ^ S[t2 & 0xFF] ^ K[ki + 11];
            } else if (b == 24) {
                while (true) {
                    t0 = a0 ^ K[ki];
                    t1 = a1 ^ K[ki + 1];
                    t2 = a2 ^ K[ki + 2];
                    t3 = a3 ^ K[ki + 3];
                    t4 = a4 ^ K[ki + 4];
                    t5 = a5 ^ K[(ki += 6) - 1];
                    if (ki == ke) break;
                    a0 = X[t0 >>> 24] ^ X[256 + (t1 >>> 16 & 0xFF)] ^ X[512 + (t2 >>> 8 & 0xFF)] ^ X[768 + (t3 & 0xFF)];
                    a1 = X[t1 >>> 24] ^ X[256 + (t2 >>> 16 & 0xFF)] ^ X[512 + (t3 >>> 8 & 0xFF)] ^ X[768 + (t4 & 0xFF)];
                    a2 = X[t2 >>> 24] ^ X[256 + (t3 >>> 16 & 0xFF)] ^ X[512 + (t4 >>> 8 & 0xFF)] ^ X[768 + (t5 & 0xFF)];
                    a3 = X[t3 >>> 24] ^ X[256 + (t4 >>> 16 & 0xFF)] ^ X[512 + (t5 >>> 8 & 0xFF)] ^ X[768 + (t0 & 0xFF)];
                    a4 = X[t4 >>> 24] ^ X[256 + (t5 >>> 16 & 0xFF)] ^ X[512 + (t0 >>> 8 & 0xFF)] ^ X[768 + (t1 & 0xFF)];
                    a5 = X[t5 >>> 24] ^ X[256 + (t0 >>> 16 & 0xFF)] ^ X[512 + (t1 >>> 8 & 0xFF)] ^ X[768 + (t2 & 0xFF)];
                }
                a0 = S[t0 >>> 24] << 24 ^ S[t1 >>> 16 & 0xFF] << 16 ^ S[t2 >>> 8 & 0xFF] << 8 ^ S[t3 & 0xFF] ^ K[ki];
                a1 = S[t1 >>> 24] << 24 ^ S[t2 >>> 16 & 0xFF] << 16 ^ S[t3 >>> 8 & 0xFF] << 8 ^ S[t4 & 0xFF] ^ K[ki + 1];
                a2 = S[t2 >>> 24] << 24 ^ S[t3 >>> 16 & 0xFF] << 16 ^ S[t4 >>> 8 & 0xFF] << 8 ^ S[t5 & 0xFF] ^ K[ki + 2];
                a3 = S[t3 >>> 24] << 24 ^ S[t4 >>> 16 & 0xFF] << 16 ^ S[t5 >>> 8 & 0xFF] << 8 ^ S[t0 & 0xFF] ^ K[ki + 3];
                a4 = S[t4 >>> 24] << 24 ^ S[t5 >>> 16 & 0xFF] << 16 ^ S[t0 >>> 8 & 0xFF] << 8 ^ S[t1 & 0xFF] ^ K[ki + 4];
                a5 = S[t5 >>> 24] << 24 ^ S[t0 >>> 16 & 0xFF] << 16 ^ S[t1 >>> 8 & 0xFF] << 8 ^ S[t2 & 0xFF] ^ K[ki + 5];
            } else {
                while (true) {
                    t0 = a0 ^ K[ki];
                    t1 = a1 ^ K[ki + 1];
                    t2 = a2 ^ K[ki + 2];
                    t3 = a3 ^ K[ki + 3];
                    t4 = a4 ^ K[ki + 4];
                    t5 = a5 ^ K[ki + 5];
                    t6 = a6 ^ K[ki + 6];
                    t7 = a7 ^ K[(ki += 8) - 1];
                    if (ki == ke) break;
                    a0 = X[t0 >>> 24] ^ X[256 + (t1 >>> 16 & 0xFF)] ^ X[512 + (t3 >>> 8 & 0xFF)] ^ X[768 + (t4 & 0xFF)];
                    a1 = X[t1 >>> 24] ^ X[256 + (t2 >>> 16 & 0xFF)] ^ X[512 + (t4 >>> 8 & 0xFF)] ^ X[768 + (t5 & 0xFF)];
                    a2 = X[t2 >>> 24] ^ X[256 + (t3 >>> 16 & 0xFF)] ^ X[512 + (t5 >>> 8 & 0xFF)] ^ X[768 + (t6 & 0xFF)];
                    a3 = X[t3 >>> 24] ^ X[256 + (t4 >>> 16 & 0xFF)] ^ X[512 + (t6 >>> 8 & 0xFF)] ^ X[768 + (t7 & 0xFF)];
                    a4 = X[t4 >>> 24] ^ X[256 + (t5 >>> 16 & 0xFF)] ^ X[512 + (t7 >>> 8 & 0xFF)] ^ X[768 + (t0 & 0xFF)];
                    a5 = X[t5 >>> 24] ^ X[256 + (t6 >>> 16 & 0xFF)] ^ X[512 + (t0 >>> 8 & 0xFF)] ^ X[768 + (t1 & 0xFF)];
                    a6 = X[t6 >>> 24] ^ X[256 + (t7 >>> 16 & 0xFF)] ^ X[512 + (t1 >>> 8 & 0xFF)] ^ X[768 + (t2 & 0xFF)];
                    a7 = X[t7 >>> 24] ^ X[256 + (t0 >>> 16 & 0xFF)] ^ X[512 + (t2 >>> 8 & 0xFF)] ^ X[768 + (t3 & 0xFF)];
                }
                a0 = S[t0 >>> 24] << 24 ^ S[t1 >>> 16 & 0xFF] << 16 ^ S[t3 >>> 8 & 0xFF] << 8 ^ S[t4 & 0xFF] ^ K[ki];
                a1 = S[t1 >>> 24] << 24 ^ S[t2 >>> 16 & 0xFF] << 16 ^ S[t4 >>> 8 & 0xFF] << 8 ^ S[t5 & 0xFF] ^ K[ki + 1];
                a2 = S[t2 >>> 24] << 24 ^ S[t3 >>> 16 & 0xFF] << 16 ^ S[t5 >>> 8 & 0xFF] << 8 ^ S[t6 & 0xFF] ^ K[ki + 2];
                a3 = S[t3 >>> 24] << 24 ^ S[t4 >>> 16 & 0xFF] << 16 ^ S[t6 >>> 8 & 0xFF] << 8 ^ S[t7 & 0xFF] ^ K[ki + 3];
                a4 = S[t4 >>> 24] << 24 ^ S[t5 >>> 16 & 0xFF] << 16 ^ S[t7 >>> 8 & 0xFF] << 8 ^ S[t0 & 0xFF] ^ K[ki + 4];
                a5 = S[t5 >>> 24] << 24 ^ S[t6 >>> 16 & 0xFF] << 16 ^ S[t0 >>> 8 & 0xFF] << 8 ^ S[t1 & 0xFF] ^ K[ki + 5];
                a6 = S[t6 >>> 24] << 24 ^ S[t7 >>> 16 & 0xFF] << 16 ^ S[t1 >>> 8 & 0xFF] << 8 ^ S[t2 & 0xFF] ^ K[ki + 6];
                a7 = S[t7 >>> 24] << 24 ^ S[t0 >>> 16 & 0xFF] << 16 ^ S[t2 >>> 8 & 0xFF] << 8 ^ S[t3 & 0xFF] ^ K[ki + 7];
            }
            if (iv != null) {
                if (mode == 0) {
                    iv0 = a0;
                    iv1 = a1;
                    iv2 = a2;
                    iv3 = a3;
                    if (b > 16) {
                        iv4 = a4;
                        iv5 = a5;
                        iv6 = a6;
                        iv7 = a7;
                    }
                } else {
                    a0 ^= jv0;
                    a1 ^= jv1;
                    a2 ^= jv2;
                    a3 ^= jv3;
                    if (b > 16) {
                        a4 ^= jv4;
                        a5 ^= jv5;
                        a6 ^= jv6;
                        a7 ^= jv7;
                    }
                }
            }
            if (to == null) continue;
            CL3.msbf4(a0, to, pos);
            CL3.msbf4(a1, to, pos + w1);
            CL3.msbf4(a2, to, pos + w2);
            CL3.msbf4(a3, to, pos + w3);
            if (b > 16) {
                CL3.msbf4(a4, to, pos + w4);
                CL3.msbf4(a5, to, pos + w5);
                if (b > 24) {
                    CL3.msbf4(a6, to, pos + w6);
                    CL3.msbf4(a7, to, pos + w7);
                }
            }
            pos += b;
        }
        if (iv != null) {
            CL3.msbf4(iv0, iv, w0);
            CL3.msbf4(iv1, iv, w0 + w1);
            CL3.msbf4(iv2, iv, w0 + w2);
            CL3.msbf4(iv3, iv, w0 + w3);
            if (b > 16) {
                CL3.msbf4(iv4, iv, w0 + w4);
                CL3.msbf4(iv5, iv, w0 + w5);
                if (b > 24) {
                    CL3.msbf4(iv6, iv, w0 + w6);
                    CL3.msbf4(iv7, iv, w0 + w7);
                }
            }
        }
    }
}

