/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9.bluez.crypto;

final class BigInteger {
    private static BigInteger ZERO = new BigInteger(0, new int[0]);
    private static BigInteger ONE = BigInteger.valueOf(1);
    private static int POS = 0;
    private static int NEG = Integer.MIN_VALUE;
    private static int MSDMASK = ~NEG;
    private int signNmsd;
    private int[] digits;

    private BigInteger(int signNmsd, int[] digits) {
        this.signNmsd = signNmsd == NEG ? POS : signNmsd;
        this.digits = digits;
    }

    private BigInteger(int signNmsd, int n, int[] digits) {
        while (n >= 0 && digits[n] == 0) {
            --n;
        }
        this.digits = n < 0 ? BigInteger.ZERO.digits : digits;
        this.signNmsd = n < 0 ? 0 : signNmsd | n + 1;
    }

    private static int multByDigit(int[] dest, int[] src, int msd, int factor, int carry) {
        long a = carry;
        long f = factor;
        int i = 0;
        while (i <= msd) {
            a = (long)src[i] * f + a;
            dest[i++] = (int)(a & Integer.MAX_VALUE);
            a >>>= 31;
        }
        if (a != 0L) {
            dest[i++] = (int)a;
        }
        return i - 1;
    }

    BigInteger(byte[] data) {
        this(0, data);
    }

    /*
     * Unable to fully structure code
     */
    BigInteger(int signum, byte[] data) {
        super();
        beg = 0;
        len = data.length;
        accu = 0L;
        totalBits = 8 * len;
        if (totalBits == 0) {
            this.signNmsd = BigInteger.POS;
            this.digits = BigInteger.ZERO.digits;
            return;
        }
        this.digits = new int[(totalBits + 31 - 1) / 31];
        x = totalBits % 31;
        bitsInAccu = x == 0 ? 0 : 31 - x;
        digitIndex = this.digits.length - 1;
        ** GOTO lbl22
        {
            accu = accu << 8 | (len > 0 ? (long)data[beg++] & 255L : 0L);
            bitsInAccu += 8;
            --len;
            do {
                if (bitsInAccu < 31) continue block0;
                this.digits[digitIndex--] = (int)(accu >>> bitsInAccu - 31) & 0x7FFFFFFF;
                bitsInAccu -= 31;
lbl22:
                // 2 sources

            } while (digitIndex >= 0);
        }
        lastBit = (totalBits - 1) % 31;
        msb = this.digits[(totalBits - 1) / 31] >> lastBit;
        if (signum < 0 || signum == 0 && (msb & 1) != 0) {
            i = this.digits.length;
            v0 = --i;
            this.digits[v0] = this.digits[v0] ^ (2 << lastBit) - 1;
            while (--i >= 0) {
                v1 = i;
                this.digits[v1] = this.digits[v1] ^ 0x7FFFFFFF;
            }
            this.signNmsd = BigInteger.POS | this.digits.length;
            t = this.add(BigInteger.ONE);
            this.signNmsd = BigInteger.NEG | t.signNmsd;
            this.digits = t.digits;
            return;
        }
        i = this.digits.length;
        while (--i >= 0 && this.digits[i] == 0) {
        }
        this.signNmsd = BigInteger.POS | i + 1;
    }

    final int signum() {
        return this.signNmsd == 0 ? 0 : (this.signNmsd > 0 ? 1 : -1);
    }

    static BigInteger valueOf(int n) {
        if (n == 0) {
            return ZERO;
        }
        if (n == 1 && ONE != null) {
            return ONE;
        }
        int[] d = new int[]{n < 0 ? -n : n};
        return new BigInteger(n < 0 ? NEG | 1 : 1, d);
    }

    private boolean isOne() {
        return (this.signNmsd & MSDMASK) == 1 && this.digits[0] == 1 && this.signNmsd >= 0;
    }

    final int bitLength() {
        int k = 0;
        int n = this.signNmsd & MSDMASK;
        if (n != 0) {
            int d = this.digits[--n];
            k = n * 31;
            while (d != 0) {
                if (d >= 256) {
                    d >>>= 8;
                    k += 8;
                    continue;
                }
                d >>>= 1;
                ++k;
            }
        }
        return k;
    }

    public boolean equals(Object obj) {
        return obj instanceof BigInteger && this.compareTo((BigInteger)obj) == 0;
    }

    final int compareTo(BigInteger b) {
        int i = this.signNmsd < 0 ? -1 : 1;
        if (i < 0 ^ b.signNmsd < 0) {
            return i;
        }
        return i * this.compareDigits(b);
    }

    private int compareDigits(BigInteger b) {
        int i = this.signNmsd & MSDMASK;
        int d = i - (b.signNmsd & MSDMASK);
        if (d == 0) {
            while (--i >= 0 && (d = this.digits[i] - b.digits[i]) == 0) {
            }
            if (d == 0) {
                return 0;
            }
        }
        return d < 0 ? -1 : 1;
    }

    final BigInteger add(BigInteger b) {
        return (this.signNmsd ^ b.signNmsd) < 0 ? (this.signNmsd < 0 ? BigInteger.subtract(NEG, this, b) : BigInteger.subtract(POS, this, b)) : BigInteger.add(this.signNmsd & NEG, this, b);
    }

    private static BigInteger add(int sign, BigInteger a, BigInteger b) {
        int Cn;
        int[] L;
        int stop;
        int[] A = a.digits;
        int[] B = b.digits;
        int An = (a.signNmsd & MSDMASK) - 1;
        int Bn = (b.signNmsd & MSDMASK) - 1;
        if (An < 0) {
            return new BigInteger(sign, Bn, b.digits);
        }
        if (Bn < 0) {
            return new BigInteger(sign, An, a.digits);
        }
        if (An == Bn) {
            stop = An;
            L = A;
            Cn = An + 1;
        } else if (An < Bn) {
            stop = An;
            L = B;
            Cn = Bn + 1;
        } else {
            stop = Bn;
            L = A;
            Cn = An + 1;
        }
        int Ln = Cn - 1;
        int[] C = new int[Cn + 1];
        int accu = 0;
        int i = 0;
        while (i <= stop) {
            accu = A[i] + B[i] + accu;
            C[i] = accu & Integer.MAX_VALUE;
            accu >>>= 31;
            ++i;
        }
        while (accu != 0 && i <= Ln) {
            accu = L[i] + accu;
            C[i] = accu & Integer.MAX_VALUE;
            accu >>>= 31;
            ++i;
        }
        if (i <= Cn && accu != 0) {
            C[i++] = accu;
            accu = 0;
        }
        if (i <= Cn && i <= Ln) {
            System.arraycopy((Object)L, i, (Object)C, i, Ln - i + 1);
        }
        return new BigInteger(sign, Cn, C);
    }

    final BigInteger subtract(BigInteger b) {
        return (this.signNmsd ^ b.signNmsd) < 0 ? (this.signNmsd < 0 ? BigInteger.add(NEG, this, b) : BigInteger.add(POS, this, b)) : BigInteger.subtract(this.signNmsd & NEG, this, b);
    }

    private static BigInteger subtract(int sign, BigInteger a, BigInteger b) {
        int Cn;
        int j;
        int[] C;
        int i;
        int[] A = a.digits;
        int[] B = b.digits;
        int An = (a.signNmsd & MSDMASK) - 1;
        int Bn = (b.signNmsd & MSDMASK) - 1;
        int cmp = 0;
        if (An < 0) {
            return new BigInteger(NEG ^ sign, Bn, b.digits);
        }
        if (Bn < 0) {
            return new BigInteger(sign, An, a.digits);
        }
        cmp = An - Bn;
        if (cmp == 0) {
            i = An;
            while (i >= 0) {
                cmp = A[i] - B[i];
                if (cmp != 0) {
                    if (cmp >= 0) break;
                    C = B;
                    B = A;
                    A = C;
                    j = Bn;
                    Bn = An;
                    An = j;
                    break;
                }
                --i;
            }
            if (i < 0) {
                return ZERO;
            }
            Cn = i;
        } else {
            if (cmp < 0) {
                C = B;
                B = A;
                A = C;
                i = Bn;
                Bn = An;
                An = i;
            }
            Cn = An;
        }
        j = Bn < Cn ? Bn : Cn;
        C = new int[Cn + 1];
        int accu = 0;
        i = 0;
        while (i <= j) {
            accu = A[i] - B[i] - accu;
            C[i] = accu & Integer.MAX_VALUE;
            accu >>>= 31;
            ++i;
        }
        while (accu != 0 && i <= Cn) {
            accu = A[i] - accu;
            C[i] = accu & Integer.MAX_VALUE;
            accu >>>= 31;
            ++i;
        }
        if (i <= Cn) {
            System.arraycopy((Object)A, i, (Object)C, i, Cn - i + 1);
        }
        return new BigInteger(cmp & NEG ^ sign, Cn, C);
    }

    final BigInteger shiftRight(int n) {
        int An;
        if (n > 0 && (An = this.signNmsd & MSDMASK) != 0) {
            int ndigits = n / 31;
            if (ndigits > --An) {
                return ZERO;
            }
            int dnshift = n % 31;
            int Bn = An - ndigits - (this.digits[An] >>> dnshift == 0 ? 1 : 0);
            int[] B = new int[Bn + 1];
            int last = this.digits[ndigits++] >>> dnshift;
            int i = 0;
            while (ndigits <= An) {
                int d = this.digits[ndigits];
                B[i] = last | d << 31 - dnshift & Integer.MAX_VALUE;
                last = d >>> dnshift;
                ++i;
                ++ndigits;
            }
            if (last != 0) {
                B[i++] = last;
            }
            return new BigInteger(this.signNmsd & NEG | i, B);
        }
        return this;
    }

    final BigInteger shiftLeft(int n) {
        int An;
        if (n <= 0 || (An = (this.signNmsd & MSDMASK) - 1) < 0) {
            return this;
        }
        int ndigits = n / 31;
        int[] A = this.digits;
        int upshift = n % 31;
        int dnshift = 31 - upshift;
        int Bn = An + ndigits + (A[An] >>> dnshift == 0 ? 0 : 1);
        int[] B = new int[Bn + 1];
        int last = 0;
        int i = 0;
        while (i <= An) {
            int d = A[i];
            B[ndigits + i] = d << upshift & Integer.MAX_VALUE | last;
            last = d >>> dnshift;
            ++i;
        }
        if (last != 0) {
            B[ndigits + i++] = last;
        }
        return new BigInteger(this.signNmsd & NEG | ndigits + i, B);
    }

    final BigInteger multiply(BigInteger b) {
        return BigInteger.multiply(this, b, null);
    }

    private static BigInteger multiply(BigInteger a, BigInteger b, BigInteger c) {
        int[] C;
        int Bn;
        int[] A = a.digits;
        int[] B = b.digits;
        int An = (a.signNmsd & MSDMASK) - 1;
        if (An < 0 || (Bn = (b.signNmsd & MSDMASK) - 1) < 0) {
            if (c != null) {
                c.signNmsd = POS;
                return c;
            }
            return ZERO;
        }
        if (An < Bn) {
            int Xn = An;
            An = Bn;
            Bn = Xn;
            int[] X = A;
            A = B;
            B = X;
        }
        int Cn = An + Bn + 1;
        if (c != null) {
            C = c.digits;
            if (C.length <= Cn) {
                Cn = C.length - 1;
            }
        } else {
            C = new int[Cn + 1];
        }
        long accu = 0L;
        long over = 0L;
        int ai = 0;
        int bi = 0;
        int ci = 0;
        while (ci <= Cn) {
            int be;
            if (ci <= Bn) {
                ai = ci;
                bi = 0;
                be = ci;
            } else if (ci <= An) {
                ai = ci;
                bi = 0;
                be = Bn;
            } else {
                ai = An;
                bi = ci - An;
                be = Bn;
            }
            while (bi <= be) {
                if ((accu += (long)A[ai] * (long)B[bi]) < 0L) {
                    ++over;
                    accu &= Long.MAX_VALUE;
                }
                --ai;
                ++bi;
            }
            C[ci++] = (int)accu & Integer.MAX_VALUE;
            accu = (accu >>> 31) + (over << 32);
            over = 0L;
        }
        if (c != null) {
            while (Cn >= 0 && c.digits[Cn] == 0) {
                --Cn;
            }
            c.signNmsd = (a.signNmsd ^ b.signNmsd) & NEG | Cn + 1;
            return c;
        }
        return new BigInteger((a.signNmsd ^ b.signNmsd) & NEG, Cn, C);
    }

    final BigInteger divide(BigInteger b) {
        return (BigInteger)BigInteger.divide(this, b, 1);
    }

    final BigInteger remainder(BigInteger b) {
        return (BigInteger)BigInteger.divide(this, b, 2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Object divide(BigInteger a, BigInteger b, int mode) {
        BigInteger quotient;
        BigInteger remainder;
        if ((b.signNmsd & MSDMASK) == 0) {
            throw new ArithmeticException("BigInteger divide by zero");
        }
        if ((a.signNmsd & MSDMASK) == 0) {
            quotient = remainder = ZERO;
            return BigInteger.resultDivMod(quotient, remainder, mode);
        } else {
            remainder = null;
            quotient = null;
            int sign_r = a.signNmsd & NEG;
            int sign_q = b.signNmsd < 0 ? sign_r ^ NEG : sign_r;
            int i = a.compareDigits(b);
            if (i == 0) {
                quotient = sign_q < 0 ? BigInteger.valueOf(-1) : ONE;
                remainder = ZERO;
                return BigInteger.resultDivMod(quotient, remainder, mode);
            } else if (i < 0) {
                quotient = ZERO;
                remainder = a;
                return BigInteger.resultDivMod(quotient, remainder, mode);
            } else {
                if ((b.signNmsd & MSDMASK) != 1) return BigInteger.divBig(a, b, mode, sign_q, sign_r, false);
                if (b.digits[0] != 1) return mode == 2 ? BigInteger.modSmall(a, b.digits[0], sign_r) : BigInteger.divSmall(a, b.digits[0], mode, sign_q, sign_r, false);
                quotient = new BigInteger(sign_q, (a.signNmsd & MSDMASK) - 1, a.digits);
                remainder = ZERO;
            }
        }
        return BigInteger.resultDivMod(quotient, remainder, mode);
    }

    private static Object resultDivMod(BigInteger quotient, BigInteger remainder, int mode) {
        if (mode == 1) {
            return quotient;
        }
        if (mode == 2) {
            return remainder;
        }
        BigInteger[] qr = new BigInteger[]{quotient, remainder};
        return qr;
    }

    private static Object divSmall(BigInteger a, int denominator, int mode, int sign_q, int sign_r, boolean destructive) {
        int An;
        int[] A = a.digits;
        int Qn = An + (A[An = (a.signNmsd & MSDMASK) - 1] / denominator > 0 ? 0 : -1);
        int[] Q = destructive ? a.digits : new int[Qn + 1];
        int r = BigInteger.divideByDigit(Q, A, An, denominator);
        BigInteger quotient = null;
        BigInteger remainder = null;
        if ((mode & 1) != 0) {
            quotient = new BigInteger(sign_q, Qn, Q);
        }
        if ((mode & 2) != 0) {
            if (destructive) {
                a.signNmsd = sign_r | (r > 0 ? 1 : 0);
                a.digits[0] = r;
                remainder = a;
            } else if (r != 0) {
                int[] R = new int[]{r};
                remainder = new BigInteger(sign_r | R.length, R);
            } else {
                remainder = ZERO;
            }
        }
        return BigInteger.resultDivMod(quotient, remainder, mode);
    }

    private static BigInteger modSmall(BigInteger a, int denominator, int sign_r) {
        int[] A = a.digits;
        int An = (a.signNmsd & MSDMASK) - 1;
        int r = BigInteger.modulusByDigit(A, An, denominator);
        if (r == 0) {
            return ZERO;
        }
        int[] R = new int[]{r};
        return new BigInteger(sign_r | R.length, R);
    }

    private static int[] normalize(int[] digits, int last, int shift, boolean destructive) {
        int[] newdgts = destructive && last + 1 < digits.length ? digits : new int[last + 2];
        long accu = 0L;
        int i = 0;
        while (i <= last) {
            newdgts[i] = (int)(accu |= (long)digits[i] << shift) & Integer.MAX_VALUE;
            accu >>>= 31;
            ++i;
        }
        newdgts[i] = (int)accu;
        return newdgts;
    }

    private static Object divBig(BigInteger a, BigInteger b, int mode, int sign_q, int sign_r, boolean destructive) {
        int[] A = a.digits;
        int[] B = b.digits;
        int An = (a.signNmsd & MSDMASK) - 1;
        if (An < 0) {
            if (destructive) {
                a.signNmsd = POS;
                return null;
            }
            return BigInteger.resultDivMod(ZERO, ZERO, mode);
        }
        int Bn = (b.signNmsd & MSDMASK) - 1;
        if (Bn == 0) {
            return BigInteger.divSmall(a, B[0], mode, sign_q, sign_r, destructive);
        }
        int[] Q = null;
        int shift = 0;
        long msdb = B[Bn];
        int qi = An - Bn;
        int ai = 0;
        boolean quot = (mode & 1) != 0;
        while (msdb < 0x40000000L) {
            ++shift;
            msdb <<= 1;
        }
        A = BigInteger.normalize(A, An, shift, destructive);
        ++An;
        if (shift != 0) {
            B = BigInteger.normalize(B, Bn, shift, false);
        }
        long Bmsd1 = B[Bn];
        long Bmsd2 = B[Bn - 1];
        ai = An;
        while (ai > Bn) {
            long Amsd1 = A[ai];
            long Amsd12 = (Amsd1 << 31) + (long)A[ai - 1];
            long guess = Amsd1 == Bmsd1 ? Integer.MAX_VALUE : Amsd12 / Bmsd1;
            long comparand = (Amsd12 - guess * Bmsd1 << 31) + (long)A[ai - 2];
            long product = Bmsd2 * guess;
            while (product > comparand) {
                product -= Bmsd2;
                comparand += Bmsd1 << 31;
                --guess;
            }
            int Qi = BigInteger.divSub(A, ai - Bn - 1, B, Bn, guess);
            if (quot && Qi != 0) {
                if (Q == null) {
                    Q = new int[qi + 1];
                }
                Q[qi] = Qi;
            }
            --qi;
            --ai;
        }
        BigInteger quotient = null;
        BigInteger remainder = null;
        if ((mode & 1) != 0) {
            BigInteger bigInteger = quotient = Q == null ? ZERO : new BigInteger(sign_q | Q.length, Q);
        }
        if ((mode & 2) != 0) {
            An = ai;
            long accu = 0L;
            while (ai >= 0) {
                accu = accu << 31 | (long)A[ai];
                A[ai] = (int)(accu >> shift & Integer.MAX_VALUE);
                --ai;
            }
            while (An >= 0 && A[An] == 0) {
                --An;
            }
            if (destructive) {
                a.signNmsd = sign_r | An + 1;
                a.digits = A;
                remainder = a;
            } else {
                remainder = new BigInteger(sign_r, An, A);
            }
        }
        return BigInteger.resultDivMod(quotient, remainder, mode);
    }

    private static int divSub(int[] A, int ax, int[] B, int Bn, long factor) {
        int bi;
        long accu;
        int ai;
        block9: {
            block8: {
                if (factor == 0L) {
                    return 0;
                }
                ai = ax;
                accu = 0L;
                bi = 0;
                while (bi <= Bn) {
                    int n = ai;
                    A[n] = A[n] - ((int)(accu += (long)B[bi] * factor) & Integer.MAX_VALUE);
                    if (A[n] < 0) {
                        int n2 = ai;
                        A[n2] = A[n2] & Integer.MAX_VALUE;
                        accu += 0x80000000L;
                    }
                    accu >>>= 31;
                    ++ai;
                    ++bi;
                }
                if (accu == 0L) break block8;
                int n = ai;
                A[n] = A[n] - (int)accu;
                if (A[n] < 0) break block9;
            }
            return (int)factor;
        }
        int n = ai;
        A[n] = (int)((long)A[n] + 0x80000000L);
        accu = 0L;
        ai = ax;
        bi = 0;
        while (bi <= Bn) {
            A[ai] = (int)(accu += (long)A[ai] + (long)B[bi]) & Integer.MAX_VALUE;
            accu >>>= 31;
            ++ai;
            ++bi;
        }
        if (accu != 0L) {
            A[ai] = A[ai] + (int)accu & Integer.MAX_VALUE;
        }
        return (int)(factor - 1L);
    }

    private static int divideByDigit(int[] dest, int[] src, int msd, int denominator) {
        long rest = 0L;
        while (msd >= 0) {
            rest = (long)src[msd] + (rest << 31);
            if (msd < dest.length) {
                dest[msd] = (int)(rest / (long)denominator);
            }
            rest %= (long)denominator;
            --msd;
        }
        return (int)rest;
    }

    private static int modulusByDigit(int[] src, int msd, int denominator) {
        long rest = 0L;
        while (msd >= 0) {
            rest = ((long)src[msd] + (rest << 31)) % (long)denominator;
            --msd;
        }
        return (int)rest;
    }

    final BigInteger modPow(BigInteger exp, BigInteger mod) {
        int cn;
        if (exp.signNmsd < 0) {
            throw new ArithmeticException("Negative exponent");
        }
        if ((this.signNmsd & MSDMASK) == 0 || this.isOne() || exp.isOne()) {
            return this;
        }
        if ((exp.signNmsd & MSDMASK) == 0) {
            return ONE;
        }
        int n = this.signNmsd & MSDMASK;
        int expBits = exp.bitLength();
        if (mod != null) {
            int mn = mod.signNmsd & MSDMASK;
            long nn = (long)(n > mn ? n : mn) * 2L + (long)mn + 2L;
            cn = (int)nn + 1;
            if (nn > Integer.MAX_VALUE) {
                throw new ArithmeticException("Overflow in power");
            }
        } else {
            long nn = (long)n << expBits;
            cn = (int)nn + 1;
            if (expBits >= 31 || nn > Integer.MAX_VALUE) {
                throw new ArithmeticException("Overflow in power");
            }
        }
        BigInteger c1st = new BigInteger(POS | 1, new int[cn]);
        BigInteger c2nd = new BigInteger(POS | cn - 1, new int[cn]);
        BigInteger a1st = new BigInteger(this.signNmsd, new int[cn]);
        BigInteger a2nd = new BigInteger(POS | cn - 1, new int[cn]);
        System.arraycopy((Object)this.digits, 0, (Object)a1st.digits, 0, n);
        c1st.digits[0] = 1;
        int nthBit = 0;
        while (true) {
            BigInteger x;
            if ((exp.digits[nthBit / 31] >> nthBit % 31 & 1) != 0) {
                x = BigInteger.multiply(a1st, c1st, c2nd);
                if (mod != null) {
                    BigInteger.divBig(x, mod, 2, POS, x.signNmsd & NEG, true);
                    if ((x.signNmsd & MSDMASK) == 0) {
                        return ZERO;
                    }
                }
                c2nd = c1st;
                c1st = x;
            }
            if (++nthBit >= expBits) break;
            x = BigInteger.multiply(a1st, a1st, a2nd);
            if (mod != null && (x.signNmsd & MSDMASK) != 0) {
                BigInteger.divBig(x, mod, 2, POS, x.signNmsd & NEG, true);
            }
            a2nd = a1st;
            a1st = x;
        }
        return c1st;
    }

    final BigInteger modInverse(BigInteger mod) {
        BigInteger inv = (BigInteger)BigInteger.extendedEuclid(this, mod, 1);
        if (inv.signNmsd < 0) {
            inv = mod.add(inv);
        }
        return inv.remainder(mod);
    }

    final BigInteger gcd(BigInteger b) {
        return (BigInteger)BigInteger.extendedEuclid(this, b, 0);
    }

    private static Object extendedEuclid(BigInteger u, BigInteger v, int mode) {
        BigInteger u1 = ONE;
        BigInteger u3 = u;
        BigInteger v1 = ZERO;
        BigInteger v3 = v;
        while ((v3.signNmsd & MSDMASK) != 0) {
            BigInteger q = u3.divide(v3);
            BigInteger t1 = u1.subtract(q.multiply(v1));
            BigInteger t3 = u3.subtract(q.multiply(v3));
            u1 = v1;
            u3 = v3;
            v1 = t1;
            v3 = t3;
        }
        if (mode == 0) {
            return u3;
        }
        if (mode == 1) {
            if (!u3.isOne()) {
                throw new ArithmeticException("Multiplicative inverse does not exist");
            }
            return u1;
        }
        BigInteger[] r = new BigInteger[]{u1, u3.subtract(u.multiply(u1)).divide(v), u3};
        return r;
    }

    final byte[] toByteArray() {
        int nBits = this.bitLength();
        if (nBits == 0) {
            return new byte[1];
        }
        BigInteger src = this;
        long mask = 0L;
        if (this.signNmsd < 0) {
            src = src.add(ONE);
            mask = -1L;
        }
        nBits = src.bitLength() + 1;
        int nUnits = (nBits + 8 - 1) / 8;
        int index = 0;
        byte[] data = new byte[nUnits];
        long accu = 0L;
        int nDigits = src.signNmsd & MSDMASK;
        int digitIndex = (nUnits * 8 - 1) / 31;
        int bitsInAccu = nUnits * 8 - (digitIndex + 1) * 31;
        while (nUnits > 0) {
            accu <<= 31;
            if (digitIndex >= 0 && digitIndex < nDigits) {
                accu |= (long)src.digits[digitIndex];
            }
            --digitIndex;
            bitsInAccu += 31;
            while (bitsInAccu >= 8) {
                data[index++] = (byte)(accu >> bitsInAccu - 8 ^ mask);
                bitsInAccu -= 8;
                --nUnits;
            }
        }
        return data;
    }

    public long longValue() {
        int n = this.signNmsd & MSDMASK;
        if (n == 0) {
            return 0L;
        }
        long v = 0L;
        int i = n - 1;
        while (i >= 0) {
            v = v << 31 | (long)this.digits[i];
            --i;
        }
        return this.signNmsd < 0 ? -v : v;
    }

    public int intValue() {
        return (int)this.longValue();
    }

    final int getLowestSetBit() {
        if ((this.signNmsd & MSDMASK) == 0) {
            return -1;
        }
        int n = this.signNmsd & MSDMASK;
        int i = 0;
        int d = this.digits[i];
        while (i < n && (d = this.digits[i]) == 0) {
            ++i;
        }
        i *= 31;
        while ((d & 1) == 0) {
            d >>= 1;
            ++i;
        }
        return i;
    }
}

