/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9.ssl;

import com.ibm.j9.ssl.CipherAlgorithm;
import com.ibm.j9.ssl.HashingAlgorithm;
import com.ibm.j9.ssl.SSLProtocol;
import com.ibm.j9.ssl.Util;
import com.ibm.oti.crypto.Provider;
import com.ibm.oti.util.PriviAction;
import java.io.IOException;
import java.security.AccessController;

public class CipherSpec {
    private byte[] id;
    private String idString;
    int cipherAlg;
    int keyLength;
    boolean isExportable;
    private int hashingAlgorithm;
    public static final byte[] NULL_PROTOCOL_VERSION = new byte[2];
    public static final String NULL_PROTOCOL_NAME = "";
    public static final CipherSpec NULL_SPEC = new CipherSpec(new byte[2], "SSL_NULL_WITH_NULL_NULL", -1, 0, false, 0);
    public static final CipherSpec[] SUPPORTED_SPECS;
    public static final String[] SUPPORTED_PROTOCOLS;
    public static boolean enableSSL;
    public static final String[] SUPPORTED_SPEC_IDS;

    static {
        CipherSpec[] cipherSpecArray = new CipherSpec[7];
        byte[] byArray = new byte[2];
        byArray[1] = 10;
        cipherSpecArray[0] = new CipherSpec(byArray, "SSL_RSA_WITH_3DES_EDE_CBC_SHA", 2, 24, false, 1);
        byte[] byArray2 = new byte[2];
        byArray2[1] = 9;
        cipherSpecArray[1] = new CipherSpec(byArray2, "SSL_RSA_WITH_DES_CBC_SHA", 1, 8, false, 1);
        byte[] byArray3 = new byte[2];
        byArray3[1] = 2;
        cipherSpecArray[2] = new CipherSpec(byArray3, "SSL_RSA_WITH_NULL_SHA", 6, 0, false, 1);
        byte[] byArray4 = new byte[2];
        byArray4[1] = 1;
        cipherSpecArray[3] = new CipherSpec(byArray4, "SSL_RSA_WITH_NULL_MD5", 6, 0, false, 2);
        byte[] byArray5 = new byte[2];
        byArray5[1] = 47;
        cipherSpecArray[4] = new CipherSpec(byArray5, "TLS_RSA_WITH_AES_128_CBC_SHA", 5, 16, false, 1);
        byte[] byArray6 = new byte[2];
        byArray6[1] = 5;
        cipherSpecArray[5] = new CipherSpec(byArray6, "SSL_RSA_WITH_RC4_128_SHA", 4, 16, false, 1);
        byte[] byArray7 = new byte[2];
        byArray7[1] = 4;
        cipherSpecArray[6] = new CipherSpec(byArray7, "SSL_RSA_WITH_RC4_128_MD5", 4, 16, false, 2);
        SUPPORTED_SPECS = cipherSpecArray;
        enableSSL = false;
        enableSSL = "true".equalsIgnoreCase((String)AccessController.doPrivileged(new PriviAction("com.ibm.oti.ssl.enableSSL")));
        SUPPORTED_PROTOCOLS = enableSSL ? new String[]{"SSLv3", "TLSv1"} : new String[]{"TLSv1"};
        SUPPORTED_SPEC_IDS = CipherSpec.getSupportedCipherSuiteIDs();
    }

    public static final String[] getSupportedCipherSuiteIDs() {
        CipherSpec[] specs = SUPPORTED_SPECS;
        String[] result = new String[specs.length];
        int i = 0;
        while (i < specs.length) {
            result[i] = specs[i].getIdString();
            ++i;
        }
        return result;
    }

    public static CipherSpec[] getCipherSpecs(String[] ids) {
        CipherSpec[] result = new CipherSpec[ids.length];
        int i = 0;
        while (i < ids.length) {
            result[i] = CipherSpec.getCipherSpec(ids[i]);
            ++i;
        }
        return result;
    }

    public static CipherSpec getCipherSpec(String id) {
        int i = 0;
        while (i < SUPPORTED_SPECS.length) {
            if (SUPPORTED_SPECS[i].getIdString().equals(id)) {
                return SUPPORTED_SPECS[i];
            }
            ++i;
        }
        return NULL_SPEC;
    }

    public static CipherSpec getCipherSpec(byte[] id) {
        int i = 0;
        while (i < SUPPORTED_SPECS.length) {
            if (id[0] == SUPPORTED_SPECS[i].getId()[0] && id[1] == SUPPORTED_SPECS[i].getId()[1]) {
                return SUPPORTED_SPECS[i];
            }
            ++i;
        }
        return null;
    }

    public static byte[] getProtocolVersion(String id) {
        if (id.equals("SSLv3")) {
            return SSLProtocol.SSL_PROTOCOL_VERSION;
        }
        if (id.equals("TLSv1")) {
            return SSLProtocol.TLS_PROTOCOL_VERSION;
        }
        return NULL_PROTOCOL_VERSION;
    }

    private CipherSpec(byte[] id, String idString, int cipherAlg, int keyLength, boolean isExportable, int hashingAlgorithm) {
        this.id = id;
        this.idString = idString;
        this.cipherAlg = cipherAlg;
        this.keyLength = keyLength;
        this.isExportable = isExportable;
        this.hashingAlgorithm = hashingAlgorithm;
    }

    public byte[] getId() {
        return this.id;
    }

    public String getIdString() {
        return this.idString;
    }

    public String toString() {
        return this.idString != null ? this.idString : "0x" + Integer.toHexString(this.id[0]) + ",0x" + Integer.toHexString(this.id[1]);
    }

    public CipherAlgorithm newCipherAlgorithm() throws IOException {
        if (this.cipherAlg == -1) {
            return null;
        }
        return new CipherAlgorithm(Provider.getProvider(this.cipherAlg, this.keyLength));
    }

    public String getKeyAlgorithmName() {
        return "RSA";
    }

    public HashingAlgorithm getHashingAlgorithm() {
        return HashingAlgorithm.getInstance(this.hashingAlgorithm);
    }

    public static String getProtocolName(byte[] version) {
        if (Util.equals(version, SSLProtocol.SSL_PROTOCOL_VERSION)) {
            return "SSLv3";
        }
        if (Util.equals(version, SSLProtocol.TLS_PROTOCOL_VERSION)) {
            return "TLSv1";
        }
        return NULL_PROTOCOL_NAME;
    }
}

