/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9.ssl;

import com.ibm.j9.ssl.CipherAlgorithm;
import com.ibm.j9.ssl.HashingAlgorithm;
import com.ibm.j9.ssl.HashingAlgorithmMD5;
import com.ibm.j9.ssl.HashingAlgorithmSHA1;
import com.ibm.j9.ssl.SSLProtocol;
import com.ibm.j9.ssl.SessionState;
import com.ibm.j9.ssl.Util;
import java.io.IOException;

public class ConnectionState {
    private SessionState sessionState;
    boolean readEncrypted;
    boolean writeEncrypted;
    private boolean shouldGenerateKeys = true;
    public byte[] serverRandom;
    public byte[] clientRandom;
    public byte[] clientWriteMACSecret;
    public byte[] serverWriteMACSecret;
    public byte[] clientWriteKey;
    public byte[] serverWriteKey;
    public byte[] clientWriteIV;
    public byte[] serverWriteIV;
    public int receiveSequenceNumber = 0;
    public int transmitSequenceNumber = 0;
    private CipherAlgorithm readCipherAlgorithm;
    private CipherAlgorithm writeCipherAlgorithm;
    private HashingAlgorithm hashingAlgorithm;

    public SessionState getSessionState() {
        return this.sessionState;
    }

    public void resetKeys() {
        this.shouldGenerateKeys = true;
    }

    public void setWriteEncrypted(boolean value) {
        this.writeEncrypted = value;
    }

    public void setReadEncrypted(boolean value) {
        this.readEncrypted = value;
    }

    public void setSessionState(SessionState session) {
        this.sessionState = session;
    }

    public CipherAlgorithm getReadCipherAlgorithm() throws IOException {
        if (this.sessionState == null) {
            return null;
        }
        if (this.readCipherAlgorithm == null) {
            this.readCipherAlgorithm = this.sessionState.getCipherSpec().newCipherAlgorithm();
            if (this.readCipherAlgorithm != null) {
                this.readCipherAlgorithm.setConnectionState(this);
            }
        }
        return this.readCipherAlgorithm;
    }

    public CipherAlgorithm getWriteCipherAlgorithm() throws IOException {
        if (this.sessionState == null) {
            return null;
        }
        if (this.writeCipherAlgorithm == null) {
            this.writeCipherAlgorithm = this.sessionState.getCipherSpec().newCipherAlgorithm();
            if (this.writeCipherAlgorithm != null) {
                this.writeCipherAlgorithm.setConnectionState(this);
            }
        }
        return this.writeCipherAlgorithm;
    }

    public HashingAlgorithm getHashingAlgorithm() {
        if (this.sessionState == null) {
            return null;
        }
        if (this.hashingAlgorithm == null) {
            this.hashingAlgorithm = this.sessionState.getCipherSpec().getHashingAlgorithm();
        }
        return this.hashingAlgorithm;
    }

    public void generateConnectionKeys() throws IOException {
        if (!this.shouldGenerateKeys) {
            return;
        }
        this.shouldGenerateKeys = false;
        byte[] keyMaterial = this.generateKeyBlock(this.sessionState.getMasterSecret());
        int i = 0;
        this.clientWriteMACSecret = new byte[this.getHashingAlgorithm().getHashSize()];
        System.arraycopy((Object)keyMaterial, i, (Object)this.clientWriteMACSecret, 0, this.clientWriteMACSecret.length);
        this.serverWriteMACSecret = new byte[this.getHashingAlgorithm().getHashSize()];
        System.arraycopy((Object)keyMaterial, i += this.clientWriteMACSecret.length, (Object)this.serverWriteMACSecret, 0, this.serverWriteMACSecret.length);
        this.clientWriteKey = new byte[this.sessionState.getCipherSpec().keyLength];
        System.arraycopy((Object)keyMaterial, i += this.serverWriteMACSecret.length, (Object)this.clientWriteKey, 0, this.clientWriteKey.length);
        this.serverWriteKey = new byte[this.sessionState.getCipherSpec().keyLength];
        System.arraycopy((Object)keyMaterial, i += this.clientWriteKey.length, (Object)this.serverWriteKey, 0, this.serverWriteKey.length);
        i += this.serverWriteKey.length;
        this.clientWriteIV = new byte[this.getWriteCipherAlgorithm().getIVSize()];
        this.serverWriteIV = new byte[this.getWriteCipherAlgorithm().getIVSize()];
        if (this.sessionState.getCipherSpec().isExportable) {
            this.applyExportControl();
        } else {
            System.arraycopy((Object)keyMaterial, i, (Object)this.clientWriteIV, 0, this.clientWriteIV.length);
            System.arraycopy((Object)keyMaterial, i += this.clientWriteIV.length, (Object)this.serverWriteIV, 0, this.serverWriteIV.length);
            i += this.serverWriteIV.length;
        }
    }

    private void applyExportControl() throws IOException {
        if (this.isTLS()) {
            this.applyTLSExportControl();
        } else {
            this.applySSLExportControl();
        }
    }

    private void applySSLExportControl() throws IOException {
        byte[] finalClientWriteKey = HashingAlgorithmMD5.hashMD5(Util.concatenate(this.clientWriteKey, this.clientRandom, this.serverRandom));
        this.clientWriteKey = new byte[this.getWriteCipherAlgorithm().getKeyMaterialSize()];
        System.arraycopy((Object)finalClientWriteKey, 0, (Object)this.clientWriteKey, 0, this.clientWriteKey.length);
        byte[] finalServerWriteKey = HashingAlgorithmMD5.hashMD5(Util.concatenate(this.serverWriteKey, this.serverRandom, this.clientRandom));
        this.serverWriteKey = new byte[this.getWriteCipherAlgorithm().getKeyMaterialSize()];
        System.arraycopy((Object)finalServerWriteKey, 0, (Object)this.serverWriteKey, 0, this.serverWriteKey.length);
        byte[] finalClientWriteIV = HashingAlgorithmMD5.hashMD5(Util.concatenate(this.clientRandom, this.serverRandom));
        System.arraycopy((Object)finalClientWriteIV, 0, (Object)this.clientWriteIV, 0, this.clientWriteIV.length);
        byte[] finalServerWriteIV = HashingAlgorithmMD5.hashMD5(Util.concatenate(this.serverRandom, this.clientRandom));
        System.arraycopy((Object)finalServerWriteIV, 0, (Object)this.serverWriteIV, 0, this.serverWriteIV.length);
    }

    private void applyTLSExportControl() throws IOException {
        byte[] fullRandom = Util.concatenate(this.clientRandom, this.serverRandom);
        byte[] finalClientWriteKey = this.getHashingAlgorithm().PRF(this.clientWriteKey, "client write key", fullRandom, this.getWriteCipherAlgorithm().getKeyMaterialSize());
        this.clientWriteKey = new byte[this.getWriteCipherAlgorithm().getKeyMaterialSize()];
        System.arraycopy((Object)finalClientWriteKey, 0, (Object)this.clientWriteKey, 0, this.clientWriteKey.length);
        byte[] finalServerWriteKey = this.getHashingAlgorithm().PRF(this.serverWriteKey, "server write key", fullRandom, this.getWriteCipherAlgorithm().getKeyMaterialSize());
        this.serverWriteKey = new byte[this.getWriteCipherAlgorithm().getKeyMaterialSize()];
        System.arraycopy((Object)finalServerWriteKey, 0, (Object)this.serverWriteKey, 0, this.serverWriteKey.length);
        byte[] ivBlock = this.getHashingAlgorithm().PRF(new byte[0], "IV block", fullRandom, this.clientWriteIV.length + this.serverWriteIV.length);
        System.arraycopy((Object)ivBlock, 0, (Object)this.clientWriteIV, 0, this.clientWriteIV.length);
        System.arraycopy((Object)ivBlock, this.clientWriteIV.length, (Object)this.serverWriteIV, 0, this.serverWriteIV.length);
    }

    private byte[] generateKeyBlock(byte[] master_secret) throws IOException {
        int length = 2 * this.getHashingAlgorithm().getHashSize() + 2 * this.sessionState.getCipherSpec().keyLength;
        if (!this.sessionState.getCipherSpec().isExportable && this.getWriteCipherAlgorithm().getIVSize() > 0) {
            length += 2 * this.getWriteCipherAlgorithm().getIVSize();
        }
        if (this.isTLS()) {
            return this.generateTLSKeyBlock(master_secret, length);
        }
        return this.generateSSLKeyBlock(master_secret, length);
    }

    private byte[] generateSSLKeyBlock(byte[] master_secret, int bytesRequired) {
        byte[] block = new byte[]{};
        int iteration = 1;
        while (block.length < bytesRequired) {
            block = Util.concatenate(block, this.generateKeyBlockSegment(master_secret, iteration++));
        }
        return block;
    }

    private byte[] generateTLSKeyBlock(byte[] master_secret, int bytesRequired) {
        byte[] newSeed = Util.concatenate(this.serverRandom, this.clientRandom);
        return this.getHashingAlgorithm().PRF(master_secret, "key expansion", newSeed, bytesRequired);
    }

    public boolean isTLS() {
        return Util.equals(SSLProtocol.TLS_PROTOCOL_VERSION, this.getSessionState().getProtocolVersion());
    }

    public int getPadType() {
        if (this.isTLS()) {
            return 4;
        }
        return 3;
    }

    private byte[] generateKeyBlockSegment(byte[] master_secret, int iteration) {
        byte[] randomBytes = new byte[iteration];
        int i = 0;
        while (i < iteration) {
            randomBytes[i] = (byte)(65 + (iteration - 1));
            ++i;
        }
        return HashingAlgorithmMD5.hashMD5(Util.concatenate(master_secret, HashingAlgorithmSHA1.hashSHA1(Util.concatenate(randomBytes, master_secret, this.serverRandom, this.clientRandom))));
    }

    public byte[] decipher(byte contentType, boolean useClientMode, byte[] data) throws IOException {
        if (this.readEncrypted) {
            return this.getReadCipherAlgorithm().decipher(contentType, useClientMode, data);
        }
        return data;
    }

    public byte[] encipher(byte contentType, boolean useClientMode, byte[] data) throws IOException {
        if (this.writeEncrypted) {
            return this.getWriteCipherAlgorithm().encipher(contentType, useClientMode, data);
        }
        return data;
    }

    public byte[] getProtocolVersion() {
        if (this.sessionState == null) {
            return SessionState.DEFAULT_PROTOCOL_VERSION;
        }
        return this.sessionState.getProtocolVersion();
    }

    public boolean hasPeerCertificates() {
        return this.sessionState != null && this.sessionState.getPeerCertificates() != null && this.sessionState.getPeerCertificates().length != 0;
    }
}

