/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9.ssl;

import com.ibm.j9.bluez.crypto.CL3State;
import com.ibm.j9.bluez.crypto.HMAC;
import com.ibm.j9.ssl.HashingAlgorithm;
import com.ibm.j9.ssl.Util;
import com.ibm.oti.crypto.SHAOutputStream;
import java.io.IOException;

public class HashingAlgorithmSHA1
extends HashingAlgorithm {
    public static final byte[] PAD_1 = Util.repeat((byte)54, 40);
    public static final byte[] PAD_2 = Util.repeat((byte)92, 40);
    private static final SHAOutputStream hash = new SHAOutputStream();

    public static synchronized byte[] hashSHA1(byte[] bytes) {
        try {
            hash.write(bytes);
        }
        catch (IOException iOException) {}
        return hash.getHashAsBytes();
    }

    public int getHashSize() {
        return 20;
    }

    public byte[] hashSSL(byte[] bytes) {
        return HashingAlgorithmSHA1.hashSHA1(bytes);
    }

    public byte[] getPad1() {
        return PAD_1;
    }

    public byte[] getPad2() {
        return PAD_2;
    }

    public synchronized byte[] hashTLS(byte[] key, byte[] data) {
        byte[] result = new byte[20];
        CL3State hmac = HMAC.hmacInit(null, 3, key, 0, key.length);
        HMAC.hmac(hmac, data, 0, data.length, result, 0);
        return result;
    }
}

