/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9.ssl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class StreamQueue {
    byte[] buffer = new byte[1024];
    int posRead = 0;
    int posWrite = 0;
    private InputStream queueRead = new InputStream(){
        private int mark = -1;

        public void mark(int readLimit) {
            this.mark = StreamQueue.this.posRead;
        }

        public void reset() {
            if (this.mark != -1) {
                StreamQueue.this.posRead = this.mark;
                this.mark = -1;
            }
        }

        public int available() throws IOException {
            return StreamQueue.this.getSize();
        }

        public int read() throws IOException {
            byte[] value = new byte[1];
            this.read(value, 0, 1);
            return value[0] & 0xFF;
        }

        public int read(byte[] b, int offset, int length) throws IOException {
            if (length > this.available()) {
                length = this.available();
            }
            int readlen = length > StreamQueue.this.buffer.length - StreamQueue.this.posRead ? StreamQueue.this.buffer.length - StreamQueue.this.posRead : length;
            System.arraycopy((Object)StreamQueue.this.buffer, StreamQueue.this.posRead, (Object)b, offset, readlen);
            if (readlen < length) {
                System.arraycopy((Object)StreamQueue.this.buffer, 0, (Object)b, offset + readlen, length - readlen);
                StreamQueue.this.posRead = length - readlen;
            } else {
                StreamQueue.this.posRead += length;
            }
            return length;
        }

        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }
    };
    private OutputStream queueWrite = new OutputStream(){

        public void write(byte[] b, int offset, int length) throws IOException {
            if (StreamQueue.this.getUnusedCapacity() < length) {
                StreamQueue.this.grow(length - StreamQueue.this.getUnusedCapacity());
            }
            int writelen = length > StreamQueue.this.buffer.length - StreamQueue.this.posWrite ? StreamQueue.this.buffer.length - StreamQueue.this.posWrite : length;
            System.arraycopy((Object)b, offset, (Object)StreamQueue.this.buffer, StreamQueue.this.posWrite, writelen);
            if (writelen < length) {
                System.arraycopy((Object)b, offset + writelen, (Object)StreamQueue.this.buffer, 0, length - writelen);
                StreamQueue.this.posWrite = length - writelen;
            } else {
                StreamQueue.this.posWrite += length;
            }
        }

        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        public void write(int oneByte) throws IOException {
            byte[] value = new byte[]{(byte)oneByte};
            this.write(value, 0, 1);
        }
    };

    public InputStream getReadStream() {
        return this.queueRead;
    }

    public OutputStream getWriteStream() {
        return this.queueWrite;
    }

    public int getCapacity() {
        return this.buffer.length - 1;
    }

    public int getSize() {
        if (this.posRead == this.posWrite) {
            return 0;
        }
        if (this.posRead < this.posWrite) {
            return this.posWrite - this.posRead;
        }
        return this.buffer.length - this.posRead + this.posWrite;
    }

    public int getUnusedCapacity() {
        return this.getCapacity() - this.getSize();
    }

    int grow(int growsize) throws IOException {
        growsize = growsize < this.buffer.length / 8 ? this.buffer.length / 8 : growsize;
        byte[] newBuffer = new byte[this.buffer.length + growsize];
        int size = this.getSize();
        this.queueRead.read(newBuffer, 0, size);
        this.posRead = 0;
        this.posWrite = size;
        this.buffer = newBuffer;
        return growsize;
    }
}

