/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.connection.datagram;

import com.ibm.oti.connection.ConnectionUtil;
import com.ibm.oti.connection.CreateConnection;
import com.ibm.oti.connection.datagram.DatagramPacket;
import com.ibm.oti.connection.socket.SocketHelper;
import com.ibm.oti.util.Msg;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import javax.microedition.io.Datagram;
import javax.microedition.io.UDPDatagramConnection;

public class Connection
implements CreateConnection,
UDPDatagramConnection {
    static final int DEFAULT_TIMEOUT = 8000;
    private String server;
    private boolean closed = false;
    private int access;
    private int port;
    private int timeout = 0;
    private DatagramSocket socket;

    public void close() throws IOException {
        this.closed = true;
        this.socket.close();
    }

    private static native int netMaxDatagramImpl(DatagramSocket var0);

    private static native int netNominalDatagramImpl(DatagramSocket var0);

    public int getMaximumLength() throws IOException {
        if (this.closed) {
            throw new IOException(Msg.getString("K00ac"));
        }
        return Connection.netMaxDatagramImpl(this.socket);
    }

    public int getNominalLength() throws IOException {
        if (this.closed) {
            throw new IOException(Msg.getString("K00ac"));
        }
        return Connection.netNominalDatagramImpl(this.socket);
    }

    public Datagram newDatagram(byte[] data, int length) throws IOException {
        if (this.closed) {
            throw new IOException(Msg.getString("K00ac"));
        }
        if (length < 0 || this.isOverMaxLength(length)) {
            throw new IllegalArgumentException();
        }
        DatagramPacket datagram = new DatagramPacket();
        datagram.setData(data, 0, length);
        StringBuffer address = new StringBuffer("datagram://");
        if (this.server != null) {
            address.append(this.server);
        }
        address.append(':');
        address.append(this.port);
        datagram.setAddress(address.toString());
        return datagram;
    }

    public Datagram newDatagram(byte[] data, int length, String address) throws IOException {
        if (this.closed) {
            throw new IOException(Msg.getString("K00ac"));
        }
        if (length < 0 || this.isOverMaxLength(length)) {
            throw new IllegalArgumentException();
        }
        DatagramPacket datagram = new DatagramPacket();
        datagram.setData(data, 0, length);
        datagram.setAddress(address);
        return datagram;
    }

    public Datagram newDatagram(int length) throws IOException {
        if (this.closed) {
            throw new IOException(Msg.getString("K00ac"));
        }
        if (length < 0 || this.isOverMaxLength(length)) {
            throw new IllegalArgumentException();
        }
        return this.newDatagram(new byte[length], length);
    }

    public Datagram newDatagram(int length, String address) throws IOException {
        if (this.closed) {
            throw new IOException(Msg.getString("K00ac"));
        }
        if (length < 0 || this.isOverMaxLength(length)) {
            throw new IllegalArgumentException();
        }
        DatagramPacket datagram = new DatagramPacket();
        datagram.setData(new byte[length], 0, length);
        datagram.setAddress(address);
        return datagram;
    }

    private boolean isOverMaxLength(int length) {
        try {
            if (this.getMaximumLength() < length) {
                return true;
            }
        }
        catch (IOException iOException) {}
        return false;
    }

    public void receive(Datagram datagram) throws IOException {
        DatagramPacket data;
        if (this.closed) {
            throw new IOException(Msg.getString("K00ac"));
        }
        if (this.access != 1 && this.access != 3) {
            throw new IOException(Msg.getString("K00a9"));
        }
        if (datagram instanceof DatagramPacket) {
            data = (DatagramPacket)datagram;
        } else {
            data = new DatagramPacket();
            data.setData(datagram.getData(), datagram.getOffset(), datagram.getLength());
            data.setAddress(datagram.getAddress());
        }
        try {
            this.socket.receive(data.getNetPacket());
            data.setData(data.getData(), data.getOffset(), data.getLength());
            if (data != datagram) {
                datagram.setAddress(data.getAddress());
            }
        }
        catch (SocketException e) {
            throw new IOException(e.getMessage());
        }
    }

    public void send(Datagram datagram) throws IOException {
        DatagramPacket data;
        if (this.closed) {
            throw new IOException(Msg.getString("K00ac"));
        }
        if (this.access != 2 && this.access != 3) {
            throw new IOException(Msg.getString("K00aa"));
        }
        if (datagram instanceof DatagramPacket) {
            data = (DatagramPacket)datagram;
        } else {
            data = new DatagramPacket();
            data.setData(datagram.getData(), datagram.getOffset(), datagram.getLength());
            data.setAddress(datagram.getAddress());
        }
        String serverAddress = data.getAddress();
        if (serverAddress == null) {
            if (this.server == null) {
                return;
            }
            if (data == datagram) {
                data = new DatagramPacket();
                data.setData(datagram.getData(), datagram.getOffset(), datagram.getLength());
            }
            data.setAddress("datagram://" + this.server + ":" + this.port);
        }
        try {
            this.socket.send(data.getNetPacket());
        }
        catch (SocketException e) {
            throw new IOException(e.getMessage());
        }
    }

    public javax.microedition.io.Connection setParameters2(String spec, int access, boolean timeout) throws IOException {
        String[][] equates = ConnectionUtil.NO_PARAMETERS;
        int index = spec.indexOf(59);
        if (index != -1) {
            equates = ConnectionUtil.getParameters(spec.substring(index + 1));
            spec = spec.substring(0, index);
        }
        this.setParameters(spec, equates, access, timeout);
        return this;
    }

    private void setParameters(String spec, String[][] equates, int access, boolean throwTimeout) throws IOException {
        this.access = access;
        int rcvbuf = 0;
        int sndbuf = 0;
        int[] result = new int[1];
        int i = 0;
        while (i < equates.length) {
            String key = equates[i][0];
            equates[i][0] = equates[i][0].toLowerCase();
            if (ConnectionUtil.intParam("so_timeout", equates[i], 1, result)) {
                this.timeout = result[0];
            } else if (ConnectionUtil.intParam("so_rcvbuf", equates[i], 2, result)) {
                rcvbuf = result[0];
            } else if (ConnectionUtil.intParam("so_sndbuf", equates[i], 2, result)) {
                sndbuf = result[0];
            } else {
                throw new IllegalArgumentException(Msg.getString("K00a5", key));
            }
            ++i;
        }
        if (throwTimeout && this.timeout == 0) {
            this.timeout = 8000;
        }
        if (!spec.startsWith("//")) {
            throw new IllegalArgumentException(Msg.getString("K00a1"));
        }
        String host = SocketHelper.parseURL(spec, result, true, true);
        if (host.length() != 0) {
            this.server = host;
        }
        this.port = result[0];
        try {
            this.socket = new DatagramSocket(this.server == null ? this.port : 0);
            if (rcvbuf != 0) {
                this.socket.setReceiveBufferSize(rcvbuf);
            }
            if (sndbuf != 0) {
                this.socket.setSendBufferSize(sndbuf);
            }
            if (this.timeout != 0) {
                this.socket.setSoTimeout(this.timeout);
            }
        }
        catch (SocketException e) {
            if (this.socket != null) {
                this.socket.close();
            }
            throw new IOException(e.getMessage());
        }
    }

    private boolean addressZero(byte[] address) {
        boolean addressZero = true;
        int i = 0;
        while (i < address.length) {
            if (address[i] != 0) {
                addressZero = false;
                break;
            }
            ++i;
        }
        return addressZero;
    }

    public String getLocalAddress() throws IOException {
        if (this.closed) {
            throw new IOException(Msg.getString("K00ac"));
        }
        InetAddress inet = this.socket.getLocalAddress();
        if (!this.addressZero(inet.getAddress())) {
            return inet.getHostAddress();
        }
        inet = InetAddress.getLocalHost();
        if (!this.addressZero(inet.getAddress())) {
            return inet.getHostAddress();
        }
        return "127.0.0.1";
    }

    public int getLocalPort() throws IOException {
        if (this.closed) {
            throw new IOException(Msg.getString("K00ac"));
        }
        return this.socket.getLocalPort();
    }
}

