/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.io;

import com.ibm.oti.io.CharacterConverter;

public class CharacterConverter_UNICODELITTLE
extends CharacterConverter {
    boolean readTag = true;
    boolean writeTag = true;
    boolean isModal = true;

    public CharacterConverter getModeless() {
        this.isModal = false;
        return this;
    }

    public int countChars(byte[] value, int offset, int count, int countLimit) {
        if (count < 0) {
            throw new StringIndexOutOfBoundsException();
        }
        if (count < 2) {
            return 0;
        }
        count /= 2;
        if (this.readTag) {
            int tag = ((value[offset + 1] & 0xFF) << 8) + (value[offset] & 0xFF);
            if (tag == 65279) {
                --count;
                if (countLimit < 0) {
                    return count;
                }
                return countLimit < count ? countLimit : count;
            }
            if (tag == 65534) {
                return -1;
            }
            if (this.isModal) {
                this.readTag = false;
            }
        }
        if (countLimit < 0) {
            return count;
        }
        return countLimit < count ? countLimit : count;
    }

    public int convert(byte[] value, int offset, char[] result, int charOffset, int total) {
        if (total == 0) {
            return offset;
        }
        if (this.readTag) {
            offset += 2;
            if (this.isModal) {
                this.readTag = false;
            }
        }
        int end = offset + (total << 1);
        int i = offset;
        while (i < end) {
            result[charOffset++] = (char)(((value[i + 1] & 0xFF) << 8) + (value[i] & 0xFF));
            i += 2;
        }
        return end;
    }

    public byte[] convert(char[] value, int offset, int count) {
        int total = (count << 1) + (this.writeTag ? 2 : 0);
        byte[] result = new byte[total];
        int index = 0;
        if (this.writeTag) {
            result[index++] = -1;
            result[index++] = -2;
            if (this.isModal) {
                this.writeTag = false;
            }
        }
        int end = offset + count;
        int i = offset;
        while (i < end) {
            result[index++] = (byte)value[i];
            result[index++] = (byte)(value[i] >> 8);
            ++i;
        }
        return result;
    }
}

