/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.net.www.protocol.jar;

import com.ibm.oti.util.Msg;
import com.ibm.oti.util.Util;
import com.ibm.oti.vm.VM;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;

public class JarURLConnection
extends java.net.JarURLConnection {
    static Hashtable jarCache = new Hashtable();
    private static final String encoding = "UTF8";
    InputStream jarInput;
    private JarFile jarFile;
    private JarEntry jarEntry;
    ReferenceQueue cacheQueue = new ReferenceQueue();
    static TreeSet lru = new TreeSet(new LRUComparitor());
    static int Limit = (Integer)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return Integer.getInteger("jar.cacheSize", 500);
        }
    });

    static {
        VM.closeJars();
    }

    public JarURLConnection(URL url) throws MalformedURLException {
        super(url);
    }

    public void connect() throws IOException {
        this.jarFileURLConnection = this.getJarFileURL().openConnection();
        this.findJarFile();
        this.findJarEntry();
        this.connected = true;
    }

    public JarFile getJarFile() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return this.jarFile;
    }

    private void findJarFile() throws IOException {
        URL jarFileURL = this.getJarFileURL();
        if (jarFileURL.getProtocol().equals("file")) {
            String fileName = jarFileURL.getFile();
            String host = jarFileURL.getHost();
            if (host != null && host.length() > 0) {
                fileName = "//" + host + fileName;
            }
            fileName = Util.decode(fileName, false, encoding);
            this.jarFile = this.getUseCaches() ? this.openJarFile(fileName, fileName, false) : new JarFile(fileName);
            return;
        }
        final String externalForm = this.jarFileURLConnection.getURL().toExternalForm();
        if (this.getUseCaches()) {
            this.jarFile = (JarFile)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return JarURLConnection.this.openJarFile(null, externalForm, false);
                    }
                    catch (IOException iOException) {
                        return null;
                    }
                }
            });
            if (this.jarFile != null) {
                return;
            }
        }
        final InputStream is = this.jarFileURLConnection.getInputStream();
        try {
            this.jarFile = (JarFile)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        File tempJar = File.createTempFile("j9jar_", ".tmp", null);
                        FileOutputStream fos = new FileOutputStream(tempJar);
                        byte[] buf = new byte[4096];
                        int nbytes = 0;
                        while ((nbytes = is.read(buf)) > -1) {
                            fos.write(buf, 0, nbytes);
                        }
                        fos.close();
                        String path = tempJar.getPath();
                        if (JarURLConnection.this.getUseCaches()) {
                            return JarURLConnection.this.openJarFile(path, externalForm, true);
                        }
                        return JarURLConnection.this.openJarFile(path, path, true);
                    }
                    catch (IOException iOException) {
                        return null;
                    }
                }
            });
        }
        finally {
            is.close();
        }
        if (this.jarFile == null) {
            throw new IOException();
        }
    }

    JarFile openJarFile(String fileString, String key, boolean temp) throws IOException {
        CacheEntry entry;
        while ((entry = (CacheEntry)this.cacheQueue.poll()) != null) {
            jarCache.remove(entry.key);
        }
        entry = (CacheEntry)jarCache.get(key);
        JarFile jar = null;
        if (entry != null) {
            jar = (JarFile)entry.get();
        }
        if (jar == null && fileString != null) {
            int flags = 1 + (temp ? 4 : 0);
            jar = new JarFile(new File(fileString), true, flags);
            jarCache.put(key, new CacheEntry(jar, key, this.cacheQueue));
        } else {
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkPermission(this.getPermission());
            }
            if (temp) {
                lru.remove(new LRUKey(jar, 0L));
            }
        }
        if (temp) {
            lru.add(new LRUKey(jar, new Date().getTime()));
            if (lru.size() > Limit) {
                lru.remove(lru.first());
            }
        }
        return jar;
    }

    public JarEntry getJarEntry() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return this.jarEntry;
    }

    private void findJarEntry() throws IOException {
        if (this.getEntryName() == null) {
            return;
        }
        this.jarEntry = this.jarFile.getJarEntry(this.getEntryName());
        if (this.jarEntry == null) {
            throw new FileNotFoundException(this.getEntryName());
        }
    }

    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        if (this.jarInput != null) {
            return this.jarInput;
        }
        if (this.jarEntry == null) {
            throw new IOException(Msg.getString("K00fc"));
        }
        this.jarInput = this.jarFile.getInputStream(this.jarEntry);
        return this.jarInput;
    }

    public String getContentType() {
        try {
            if (this.url.getFile().endsWith("!/")) {
                return this.getJarFileURL().openConnection().getContentType();
            }
        }
        catch (IOException iOException) {}
        return JarURLConnection.guessContentTypeFromName(this.url.getFile());
    }

    public int getContentLength() {
        try {
            if (this.url.getFile().endsWith("!/")) {
                return this.getJarFileURL().openConnection().getContentLength();
            }
        }
        catch (IOException iOException) {}
        return -1;
    }

    public Object getContent() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        if (this.jarEntry == null) {
            return this.jarFile;
        }
        return super.getContent();
    }

    public Permission getPermission() throws IOException {
        if (this.jarFileURLConnection != null) {
            return this.jarFileURLConnection.getPermission();
        }
        return this.getJarFileURL().openConnection().getPermission();
    }

    public static void closeCachedFiles() {
        Enumeration elemEnum = jarCache.elements();
        while (elemEnum.hasMoreElements()) {
            try {
                ZipFile zip = (ZipFile)((CacheEntry)elemEnum.nextElement()).get();
                if (zip == null) continue;
                zip.close();
            }
            catch (IOException iOException) {}
        }
    }

    static final class CacheEntry
    extends WeakReference {
        Object key;

        CacheEntry(Object jar, String key, ReferenceQueue queue) {
            super(jar, queue);
            this.key = key;
        }
    }

    static final class LRUKey {
        JarFile jar;
        long ts;

        LRUKey(JarFile file, long time) {
            this.jar = file;
            this.ts = time;
        }

        public boolean equals(Object obj) {
            return this.jar == ((LRUKey)obj).jar;
        }
    }

    static final class LRUComparitor
    implements Comparator {
        LRUComparitor() {
        }

        public int compare(Object o1, Object o2) {
            if (((LRUKey)o1).ts > ((LRUKey)o2).ts) {
                return 1;
            }
            return ((LRUKey)o1).ts == ((LRUKey)o2).ts ? 0 : -1;
        }

        public boolean equals(Object o1, Object o2) {
            return o1.equals(o2);
        }
    }
}

