/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.security.provider;

import com.ibm.oti.util.Msg;
import com.ibm.oti.util.PasswordProtectedInputStream;
import com.ibm.oti.util.SHAOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public class KeyStore
extends KeyStoreSpi {
    static final int RANDOM_BYTES = 32;
    protected Hashtable database = new Hashtable();

    protected int getKeyStoreMagic() {
        return 77;
    }

    protected int getKeyStoreVersion() {
        return 2;
    }

    protected int getKeyStoreOldVeresion() {
        return 1;
    }

    private static byte[] digestPassword(char[] passw) {
        SHAOutputStream sha = new SHAOutputStream();
        DataOutputStream out = new DataOutputStream(sha);
        try {
            int i = 0;
            while (i < passw.length) {
                out.write(passw[i]);
                ++i;
            }
            out.flush();
            out.close();
        }
        catch (IOException iOException) {}
        return sha.getHashAsBytes();
    }

    protected static void writeCertificate(Certificate cert, ObjectOutputStream out) throws IOException, CertificateEncodingException {
        byte[] encoded = cert.getEncoded();
        String type = cert.getType();
        out.writeObject(type);
        out.writeObject(encoded);
    }

    protected static Certificate readCertificate(ObjectInputStream in) throws ClassNotFoundException, IOException, CertificateException {
        String type = (String)in.readObject();
        byte[] encoded = (byte[])in.readObject();
        CertificateFactory factory = CertificateFactory.getInstance(type);
        return factory.generateCertificate(new ByteArrayInputStream(encoded));
    }

    private static byte[] digestHeader(long time, byte[] random, char[] passw) {
        SHAOutputStream sha = new SHAOutputStream();
        DataOutputStream out = new DataOutputStream(sha);
        try {
            out.writeLong(time);
            out.write(random);
            int i = 0;
            while (i < passw.length) {
                out.write(passw[i]);
                ++i;
            }
            out.flush();
            out.close();
        }
        catch (IOException iOException) {}
        return sha.getHashAsBytes();
    }

    public Enumeration engineAliases() {
        return this.database.keys();
    }

    public boolean engineContainsAlias(String alias) {
        return this.database.containsKey(alias);
    }

    public void engineDeleteEntry(String alias) throws KeyStoreException {
        this.database.remove(alias);
    }

    public Certificate engineGetCertificate(String alias) {
        KeyStoreEntry entry = (KeyStoreEntry)this.database.get(alias);
        if (entry != null) {
            Certificate[] chain;
            if (entry instanceof KeyStoreCertificate) {
                return ((KeyStoreCertificate)entry).cert;
            }
            if (entry instanceof KeyStoreKey && (chain = ((KeyStoreKey)entry).chain) != null && chain.length > 0) {
                return chain[0];
            }
        }
        return null;
    }

    public String engineGetCertificateAlias(Certificate cert) {
        Enumeration keys = this.database.keys();
        while (keys.hasMoreElements()) {
            Certificate[] chain;
            String alias = (String)keys.nextElement();
            KeyStoreEntry entry = (KeyStoreEntry)this.database.get(alias);
            Certificate value = null;
            if (entry == null) continue;
            if (entry instanceof KeyStoreCertificate) {
                value = ((KeyStoreCertificate)entry).cert;
            } else if (entry instanceof KeyStoreKey && (chain = ((KeyStoreKey)entry).chain) != null && chain.length > 0) {
                value = chain[0];
            }
            if (value == null || !value.equals(cert)) continue;
            return alias;
        }
        return null;
    }

    public Certificate[] engineGetCertificateChain(String alias) {
        KeyStoreEntry entry = (KeyStoreEntry)this.database.get(alias);
        if (entry != null && entry instanceof KeyStoreKey) {
            return ((KeyStoreKey)entry).chain;
        }
        return null;
    }

    public Date engineGetCreationDate(String alias) {
        KeyStoreEntry entry = (KeyStoreEntry)this.database.get(alias);
        if (entry != null) {
            return entry.creationDate;
        }
        return null;
    }

    public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        KeyStoreEntry entry = (KeyStoreEntry)this.database.get(alias);
        if (entry != null && entry instanceof KeyStoreKey) {
            byte[] digest = KeyStore.digestPassword(password);
            KeyStoreKey convertedEntry = (KeyStoreKey)entry;
            if (convertedEntry.key instanceof Key) {
                if (Arrays.equals(digest, convertedEntry.digest)) {
                    return (Key)convertedEntry.key;
                }
                throw new UnrecoverableKeyException();
            }
        }
        return null;
    }

    public boolean engineIsCertificateEntry(String alias) {
        KeyStoreEntry entry = (KeyStoreEntry)this.database.get(alias);
        if (entry == null) {
            return false;
        }
        return entry instanceof KeyStoreCertificate;
    }

    public boolean engineIsKeyEntry(String alias) {
        KeyStoreEntry entry = (KeyStoreEntry)this.database.get(alias);
        if (entry == null) {
            return false;
        }
        return entry instanceof KeyStoreKey;
    }

    public void engineLoad(InputStream input, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        ObjectInputStream ois;
        byte[] computedDigest;
        if (input == null) {
            return;
        }
        DataInputStream in = new DataInputStream(input);
        int magic = in.readInt();
        if (magic != this.getKeyStoreMagic()) {
            throw new IOException(Msg.getString("K00fd"));
        }
        int version = in.readInt();
        if (version != this.getKeyStoreVersion() && version != this.getKeyStoreOldVeresion()) {
            throw new IOException(Msg.getString("K00fd"));
        }
        long time = in.readLong();
        byte[] random = new byte[32];
        in.readFully(random);
        byte[] savedDigest = new byte[20];
        in.readFully(savedDigest);
        if (password != null && !Arrays.equals(savedDigest, computedDigest = KeyStore.digestHeader(time, random, password))) {
            throw new IOException(Msg.getString("K00fe"));
        }
        if (version == this.getKeyStoreOldVeresion()) {
            byte[] passwordBytes = new String(password).getBytes();
            ois = new ObjectInputStream(new PasswordProtectedInputStream(input, passwordBytes));
        } else {
            ois = new ObjectInputStream(input);
        }
        try {
            final ObjectInputStream stream = ois;
            this.database = (Hashtable)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return stream.readObject();
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
            });
            if (this.database == null) {
                throw new IOException("Error reading keystore");
            }
        }
        finally {
            ois.close();
        }
    }

    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        KeyStoreEntry entry = (KeyStoreEntry)this.database.get(alias);
        if (entry != null && entry instanceof KeyStoreKey) {
            throw new KeyStoreException(Msg.getString("K0185"));
        }
        this.database.put(alias, new KeyStoreCertificate(cert));
    }

    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
        this.database.put(alias, new KeyStoreKey(key, chain));
    }

    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        KeyStoreKey entry = new KeyStoreKey(key, chain);
        entry.digest = KeyStore.digestPassword(password);
        this.database.put(alias, entry);
    }

    public int engineSize() {
        return this.database.size();
    }

    public void engineStore(OutputStream output, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        DataOutputStream out = new DataOutputStream(output);
        long time = System.currentTimeMillis();
        byte[] random = new byte[32];
        new SecureRandom().nextBytes(random);
        byte[] digest = KeyStore.digestHeader(time, random, password);
        out.writeInt(this.getKeyStoreMagic());
        out.writeInt(this.getKeyStoreVersion());
        out.writeLong(time);
        out.write(random);
        out.write(digest);
        out.flush();
        ObjectOutputStream oos = new ObjectOutputStream(output);
        oos.writeObject(this.database);
        oos.close();
    }

    protected static class KeyStoreEntry
    implements Serializable {
        static final long serialVersionUID = -6740993172540267582L;
        Date creationDate = new Date();

        protected KeyStoreEntry() {
        }
    }

    protected static class KeyStoreKey
    extends KeyStoreEntry {
        static final long serialVersionUID = -3264292225350417776L;
        protected Object key;
        protected Certificate[] chain;
        byte[] digest;

        protected KeyStoreKey() {
        }

        protected KeyStoreKey(byte[] key) {
            this(key, null);
        }

        protected KeyStoreKey(Key key) {
            this(key, null);
        }

        protected KeyStoreKey(Object key, Certificate[] chain) {
            this.key = key;
            this.chain = chain;
        }

        public Object getKey() {
            return this.key;
        }

        private void writeObject(ObjectOutputStream out) throws IOException, CertificateEncodingException {
            out.writeObject(this.key);
            out.writeObject(this.digest);
            if (this.chain == null) {
                out.writeObject(this.chain);
            } else {
                out.writeObject(new Integer(this.chain.length));
                int i = 0;
                while (i < this.chain.length) {
                    KeyStore.writeCertificate(this.chain[i], out);
                    ++i;
                }
            }
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, CertificateException {
            this.key = in.readObject();
            this.digest = (byte[])in.readObject();
            Object nullOrLength = in.readObject();
            if (nullOrLength != null) {
                Integer len = (Integer)nullOrLength;
                this.chain = new Certificate[len.intValue()];
                int i = 0;
                while (i < len) {
                    this.chain[i] = KeyStore.readCertificate(in);
                    ++i;
                }
            }
        }
    }

    protected static class KeyStoreCertificate
    extends KeyStoreEntry {
        static final long serialVersionUID = 253492815225434760L;
        Certificate cert;

        public KeyStoreCertificate(Certificate cert) {
            this.cert = cert;
        }

        private void writeObject(ObjectOutputStream out) throws IOException, CertificateEncodingException {
            KeyStore.writeCertificate(this.cert, out);
        }

        private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException, CertificateException {
            this.cert = KeyStore.readCertificate(in);
        }
    }
}

