/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.security.provider;

import com.ibm.oti.util.SHAOutputStream;
import java.security.MessageDigest;

public class MessageDigestSHA
extends MessageDigest
implements Cloneable {
    private SHAOutputStream shaStream = new SHAOutputStream();

    public MessageDigestSHA() {
        super("SHA-1");
    }

    public Object clone() throws CloneNotSupportedException {
        MessageDigestSHA result = (MessageDigestSHA)super.clone();
        result.shaStream = (SHAOutputStream)this.shaStream.clone();
        return result;
    }

    protected byte[] engineDigest() {
        return this.shaStream.getHashAsBytes();
    }

    protected int engineGetDigestLength() {
        return 20;
    }

    protected void engineReset() {
        this.shaStream.reset();
    }

    protected void engineUpdate(byte[] bytesToHash, int offset, int count) {
        this.shaStream.write(bytesToHash, offset, count);
    }

    protected void engineUpdate(byte byteToHash) {
        this.shaStream.write(byteToHash);
    }
}

