/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.security.provider;

import com.ibm.oti.security.provider.X509Extension;
import com.ibm.oti.util.ASN1Decoder;
import com.ibm.oti.util.ASN1Encoder;
import java.math.BigInteger;
import java.security.cert.CRLException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;

public class X509CRLEntry
extends java.security.cert.X509CRLEntry {
    private byte[] encoded;
    private BigInteger serialNumber;
    private Date revocationDate;
    private Hashtable extensions;
    private static final String[] SUPPORTED_CRITICAL_EXTENSIONS = new String[0];

    public byte[] getEncoded() throws CRLException {
        return this.encoded;
    }

    public BigInteger getSerialNumber() {
        return this.serialNumber;
    }

    public Date getRevocationDate() {
        return this.revocationDate;
    }

    public boolean hasExtensions() {
        if (this.extensions == null) {
            return false;
        }
        return this.extensions.size() > 0;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("X.509 CRL Entry S/N=");
        result.append(this.getSerialNumber());
        result.append(" , Extensions: ");
        result.append(this.extensions == null ? 0 : this.extensions.size());
        result.append(" , Revocation: ");
        result.append(this.getRevocationDate());
        return result.toString();
    }

    public boolean hasUnsupportedCriticalExtension() {
        Set critical = this.getCriticalExtensionOIDs();
        if (critical == null) {
            return false;
        }
        if (critical.size() > SUPPORTED_CRITICAL_EXTENSIONS.length) {
            return true;
        }
        int i = 0;
        while (i < SUPPORTED_CRITICAL_EXTENSIONS.length) {
            critical.remove(SUPPORTED_CRITICAL_EXTENSIONS[i]);
            ++i;
        }
        return critical.size() != 0;
    }

    private Set getExtensionOIDs(boolean isCritical) {
        if (this.extensions == null) {
            return null;
        }
        HashSet result = new HashSet();
        Enumeration elements = this.extensions.elements();
        while (elements.hasMoreElements()) {
            X509Extension extension = (X509Extension)elements.nextElement();
            if (extension.isCritical() != isCritical) continue;
            result.add(extension.name());
        }
        return result;
    }

    public Set getCriticalExtensionOIDs() {
        return this.getExtensionOIDs(true);
    }

    public Set getNonCriticalExtensionOIDs() {
        return this.getExtensionOIDs(false);
    }

    public byte[] getExtensionValue(String oid) {
        if (this.extensions == null) {
            return null;
        }
        X509Extension extn = (X509Extension)this.extensions.get(oid);
        if (extn == null) {
            return null;
        }
        byte[] extnValue = extn.value();
        if (extnValue == null) {
            extnValue = new byte[]{};
        }
        ASN1Decoder.Node node = new ASN1Decoder.Node();
        node.type = 4;
        node.data = extn.value();
        return ASN1Encoder.encodeNode(node);
    }

    static X509CRLEntry X509CRLEntryFromASN1Object(ASN1Decoder.Node node, byte[] rawBytes) throws CRLException {
        try {
            X509CRLEntry result = new X509CRLEntry();
            int start = node.startPosition;
            int end = node.endPosition;
            if (start == 0 && end == rawBytes.length - 1) {
                result.encoded = rawBytes;
            } else {
                result.encoded = new byte[end - start + 1];
                System.arraycopy((Object)rawBytes, start, (Object)result.encoded, 0, result.encoded.length);
            }
            ASN1Decoder.Node[] contents = (ASN1Decoder.Node[])node.data;
            result.serialNumber = (BigInteger)contents[0].data;
            result.revocationDate = (Date)contents[1].data;
            if (contents.length > 2) {
                result.extensions = new Hashtable();
                ASN1Decoder.Node[] extensions = (ASN1Decoder.Node[])contents[2].data;
                int i = 0;
                while (i < extensions.length) {
                    ASN1Decoder.Node extension = extensions[i];
                    ASN1Decoder.Node[] extensionFields = (ASN1Decoder.Node[])extension.data;
                    result.extensions.put(extensionFields[0], extensionFields[1]);
                    ++i;
                }
            }
            return result;
        }
        catch (ClassCastException classCastException) {
            throw new CRLException();
        }
    }
}

