/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.util;

import com.ibm.oti.util.ASN1Exception;
import com.ibm.oti.util.Msg;
import com.ibm.oti.util.PositionedInputStream;
import com.ibm.oti.util.PriviAction;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.AccessController;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.Vector;

public class ASN1Decoder {
    private PositionedInputStream input;
    private int nesting = 0;
    private int sequenceItem = 0;
    private TypeMapper[] tagConfiguration;
    private boolean collectBytes;
    private ByteArrayOutputStream bytesCollected;
    public static final int END_OF_BER_CONTENTS = 0;
    public static final int BOOLEAN = 1;
    public static final int INTEGER = 2;
    public static final int BIT_STRING = 3;
    public static final int OCTET_STRING = 4;
    public static final int NULL = 5;
    public static final int OBJECT_IDENTIFIER = 6;
    public static final int SEQUENCE = 16;
    public static final int SET = 17;
    public static final int BMP_STRING = 30;
    public static final int NUMERIC_STRING = 18;
    public static final int PRINTABLE_STRING = 19;
    public static final int T61_STRING = 20;
    public static final int VIDEOTEXT_STRING = 21;
    public static final int IA5_STRING = 22;
    public static final int UTF_STRING = 12;
    public static final int UTC_TIME = 23;
    public static final int GENERALIZED_TIME = 24;
    public static final int CLASS_UNIVERSAL = 0;
    public static final int EXPLICIT = 160;
    public static final int LENGTH_UNKNOWN = -1;

    public ASN1Decoder(InputStream input) {
        this.input = new PositionedInputStream(input);
    }

    public ASN1Decoder(InputStream input, boolean set2) {
        this.input = new PositionedInputStream(input);
    }

    private int readByte() throws ASN1Exception {
        try {
            int octet = this.input.read();
            if (octet < 0) {
                throw new ASN1Exception();
            }
            if (this.collectBytes) {
                this.bytesCollected.write(octet);
            }
            return octet & 0xFF;
        }
        catch (IOException ioe) {
            throw new ASN1Exception(ioe.toString());
        }
    }

    private Date parseUTCDate(String dateString) {
        int[] date = this.parseYMD(dateString, 2);
        date[0] = date[0] <= 49 ? date[0] + 2000 : date[0] + 1900;
        return this.dateFromArray(dateString, date);
    }

    private Date parseGeneralizedDate(String dateString) {
        int[] date = this.parseYMD(dateString, 4);
        return this.dateFromArray(dateString, date);
    }

    private Date dateFromArray(String dateString, int[] date) {
        String timeZoneName = this.getTZ(dateString);
        TimeZone tz = TimeZone.getTimeZone(timeZoneName);
        Calendar cal = Calendar.getInstance(tz);
        cal.set(date[0], date[1] - 1, date[2], date[3], date[4], date[5]);
        cal.set(14, 0);
        return cal.getTime();
    }

    private int[] parseYMD(String dateString, int yearDigits) {
        int index = 0;
        int digitLength = yearDigits;
        int[] date = new int[6];
        int i = 0;
        while (i < date.length) {
            char next;
            if (i == 5 && ((next = dateString.charAt(index)) < '0' || next > '9')) break;
            date[i] = Integer.parseInt(dateString.substring(index, index + digitLength));
            index += digitLength;
            digitLength = 2;
            ++i;
        }
        return date;
    }

    private String getTZ(String dateString) {
        String timeZoneName = "GMT";
        char offsetIndicator = dateString.charAt(dateString.length() - 1);
        if (offsetIndicator != 'Z') {
            timeZoneName = String.valueOf(timeZoneName) + dateString.substring(dateString.length() - 5, dateString.length());
        }
        return timeZoneName;
    }

    public void collectBytes(boolean collectBytes) {
        this.collectBytes = collectBytes;
        this.bytesCollected = collectBytes ? new ByteArrayOutputStream(1024) : null;
    }

    public byte[] collectedBytes() {
        if (this.collectBytes) {
            return this.bytesCollected.toByteArray();
        }
        return null;
    }

    public Node readContents() throws ASN1Exception {
        Node node = new Node();
        node.startPosition = this.input.currentPosition();
        this.readTag(node);
        this.computeTypeRedirection(node);
        switch (node.type) {
            case 16: {
                node.data = this.readSequence();
                break;
            }
            case 17: {
                node.data = this.readSet();
                break;
            }
            case 1: {
                node.data = this.readBoolean();
                break;
            }
            case 2: {
                node.data = this.readInteger();
                break;
            }
            case 5: {
                if (this.readByte() == 0) break;
                this.throwASN1Exception();
                break;
            }
            case 6: {
                node.data = this.readObjectIdentifier();
                break;
            }
            case 4: {
                node.data = this.readOctetString();
                break;
            }
            case 18: {
                node.data = this.readNumericString();
                break;
            }
            case 19: {
                node.data = this.readPrintableString();
                break;
            }
            case 30: {
                node.data = this.readBMPString();
                break;
            }
            case 22: {
                node.data = this.readIA5String();
                break;
            }
            case 12: {
                node.data = this.readUTFString();
                break;
            }
            case 20: {
                node.data = this.readT61String();
                break;
            }
            case 21: {
                node.data = this.readVideotextString();
                break;
            }
            case 3: {
                node.data = this.readBitString();
                break;
            }
            case 23: {
                node.data = this.readUTCTime();
                break;
            }
            case 24: {
                node.data = this.readGeneralizedTime();
                break;
            }
            case 0: {
                int len = this.readLength();
                if (len != 0) {
                    throw new ASN1Exception(Msg.getString("K0088"));
                }
                return null;
            }
            default: {
                throw new ASN1Exception(Msg.getString("K0089", node.type));
            }
        }
        node.endPosition = this.input.currentPosition() - 1;
        return node;
    }

    public Object readContentsToObject() throws ASN1Exception {
        Node node = new Node();
        node.startPosition = this.input.currentPosition();
        this.readTag(node);
        this.computeTypeRedirection(node);
        switch (node.type) {
            case 16: {
                node.data = this.readSequenceToObject();
                break;
            }
            case 17: {
                node.data = this.readSetToObject();
                break;
            }
            case 1: {
                node.data = this.readBoolean();
                break;
            }
            case 2: {
                node.data = this.readInteger();
                break;
            }
            case 5: {
                if (this.readByte() == 0) break;
                this.throwASN1Exception();
                break;
            }
            case 6: {
                node.data = this.readObjectIdentifier();
                break;
            }
            case 4: {
                node.data = this.readOctetString();
                break;
            }
            case 18: {
                node.data = this.readNumericString();
                break;
            }
            case 19: {
                node.data = this.readPrintableString();
                break;
            }
            case 30: {
                node.data = this.readBMPString();
                break;
            }
            case 22: {
                node.data = this.readIA5String();
                break;
            }
            case 12: {
                node.data = this.readUTFString();
                break;
            }
            case 20: {
                node.data = this.readT61String();
                break;
            }
            case 21: {
                node.data = this.readVideotextString();
                break;
            }
            case 3: {
                node.data = this.readBitString();
                break;
            }
            case 23: {
                node.data = this.readUTCTimeToObject();
                break;
            }
            case 24: {
                node.data = this.readGeneralizedTimeToObject();
                break;
            }
            case 0: {
                int len = this.readLength();
                if (len != 0) {
                    throw new ASN1Exception(Msg.getString("K0088"));
                }
                return null;
            }
            default: {
                throw new ASN1Exception(Msg.getString("K0089", node.type));
            }
        }
        node.endPosition = this.input.currentPosition() - 1;
        return node.data;
    }

    private void readFully(InputStream source, byte[] buffer) throws ASN1Exception {
        try {
            this.readFully(source, buffer, 0, buffer.length);
        }
        catch (IOException ioe) {
            throw new ASN1Exception(ioe.toString());
        }
    }

    private void readFully(InputStream source, byte[] buffer, int offset, int count) throws IOException {
        int totalRead = 0;
        int toRead = count;
        while (totalRead < count) {
            int readNow = source.read(buffer, offset + totalRead, toRead);
            if (readNow <= 0) {
                throw new IOException(Msg.getString("K008a", new Object[]{Integer.toString(readNow), Integer.toString(toRead), source}));
            }
            if (this.collectBytes) {
                this.bytesCollected.write(buffer, offset + totalRead, readNow);
            }
            totalRead += readNow;
            toRead -= readNow;
        }
    }

    protected Date readUTCTime() throws ASN1Exception {
        String UTCASCII = ASN1Decoder.convertToString(this.readOctetString());
        return this.parseUTCDate(UTCASCII);
    }

    protected UTCTime readUTCTimeToObject() throws ASN1Exception {
        String UTCASCII = ASN1Decoder.convertToString(this.readOctetString());
        return new UTCTime(this.parseUTCDate(UTCASCII));
    }

    protected Date readGeneralizedTime() throws ASN1Exception {
        String generalizedASCII = ASN1Decoder.convertToString(this.readOctetString());
        return this.parseGeneralizedDate(generalizedASCII);
    }

    protected GeneralizedTime readGeneralizedTimeToObject() throws ASN1Exception {
        String generalizedASCII = ASN1Decoder.convertToString(this.readOctetString());
        return new GeneralizedTime(this.parseGeneralizedDate(generalizedASCII));
    }

    protected BigInteger readInteger() throws ASN1Exception {
        int length = this.readLength();
        byte[] integer = new byte[length];
        this.readFully(this.input, integer);
        return new BigInteger(1, integer);
    }

    protected Boolean readBoolean() throws ASN1Exception {
        int bool;
        int length = this.readLength();
        if (length != 1) {
            this.throwASN1Exception();
        }
        if ((bool = this.readByte()) == 0) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    protected int readLength() throws ASN1Exception {
        int len = this.readByte();
        if (len < 128) {
            return len;
        }
        if (len == 128) {
            return -1;
        }
        int lenOctets = len & 0x7F;
        len = 0;
        int i = 0;
        while (i < lenOctets) {
            len = len * 256 + this.readByte();
            ++i;
        }
        if (len < 0) {
            this.throwASN1Exception();
        }
        return len;
    }

    protected int[] readObjectIdentifier() throws ASN1Exception {
        int length = this.readLength();
        int[] oid = new int[length];
        int i = 0;
        while (i < oid.length) {
            oid[i] = this.readByte();
            ++i;
        }
        int size = oid.length + 1;
        int i2 = 1;
        while (i2 < oid.length) {
            if (oid[i2] >= 128) {
                --size;
            }
            ++i2;
        }
        int[] result = new int[size];
        result[0] = oid[0] / 40;
        result[1] = oid[0] % 40;
        int indexOID = 1;
        int indexResult = 2;
        while (indexOID < oid.length) {
            int n = indexResult;
            result[n] = result[n] * 128;
            if (oid[indexOID] < 128) {
                int n2 = indexResult++;
                result[n2] = result[n2] + oid[indexOID];
            } else {
                int n3 = indexResult;
                result[n3] = result[n3] + (oid[indexOID] - 128);
            }
            ++indexOID;
        }
        return result;
    }

    protected byte[] readOctetString() throws ASN1Exception {
        int length = this.readLength();
        byte[] bytes = new byte[length];
        this.readFully(this.input, bytes);
        return bytes;
    }

    protected String readNumericString() throws ASN1Exception {
        return ASN1Decoder.convertToString(this.readOctetString());
    }

    protected String readPrintableString() throws ASN1Exception {
        return ASN1Decoder.convertToString(this.readOctetString());
    }

    protected String readIA5String() throws ASN1Exception {
        return ASN1Decoder.convertToString(this.readOctetString());
    }

    protected String readUTFString() throws ASN1Exception {
        String result = null;
        try {
            result = new String(this.readOctetString(), "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new ASN1Exception(Msg.getString("K0220", e));
        }
        return result;
    }

    protected String readT61String() throws ASN1Exception {
        return ASN1Decoder.convertToString(this.readOctetString());
    }

    protected String readVideotextString() throws ASN1Exception {
        return ASN1Decoder.convertToString(this.readOctetString());
    }

    protected BitString readBitString() throws ASN1Exception {
        int length = this.readLength();
        int unusedBits = this.readByte();
        byte[] bytes = new byte[length - 1];
        this.readFully(this.input, bytes);
        return new BitString(unusedBits, bytes);
    }

    protected Node[] readSequence() throws ASN1Exception {
        int length = this.readLength();
        int totalRead = 0;
        Vector elements = new Vector();
        ++this.nesting;
        int sequenceItem = 1;
        while (totalRead < length || length == -1) {
            int posBefore = this.input.currentPosition();
            this.sequenceItem = sequenceItem;
            Node contents = this.readContents();
            if (length == -1 && contents == null) break;
            elements.addElement(contents);
            int posAfter = this.input.currentPosition();
            int read = posAfter - posBefore;
            totalRead += read;
            ++sequenceItem;
        }
        --this.nesting;
        if (length != -1 && totalRead != length) {
            this.throwASN1Exception();
        }
        Object[] result = new Node[elements.size()];
        elements.copyInto(result);
        return result;
    }

    protected Object[] readSequenceToObject() throws ASN1Exception {
        int length = this.readLength();
        int totalRead = 0;
        Vector elements = new Vector();
        ++this.nesting;
        int sequenceItem = 1;
        while (totalRead < length || length == -1) {
            int posBefore = this.input.currentPosition();
            this.sequenceItem = sequenceItem;
            Object contents = this.readContentsToObject();
            if (length == -1 && contents == null) break;
            elements.addElement(contents);
            int posAfter = this.input.currentPosition();
            int read = posAfter - posBefore;
            totalRead += read;
            ++sequenceItem;
        }
        --this.nesting;
        if (length != -1 && totalRead != length) {
            this.throwASN1Exception();
        }
        Object[] result = new Object[elements.size()];
        elements.copyInto(result);
        return result;
    }

    protected Node[] readSet() throws ASN1Exception {
        return this.readSequence();
    }

    protected Set readSetToObject() throws ASN1Exception {
        return new Set(this.readSequenceToObject());
    }

    protected BMPString readBMPString() throws ASN1Exception {
        int length = this.readLength();
        byte[] bytes = new byte[length];
        this.readFully(this.input, bytes);
        String value = null;
        try {
            value = new String(bytes, "UnicodeBigUnmarked");
        }
        catch (UnsupportedEncodingException uee) {
            throw new ASN1Exception(Msg.getString("K018f", uee));
        }
        return new BMPString(value);
    }

    protected Node[] readConstructed() throws ASN1Exception {
        return this.readSequence();
    }

    protected void readTag(Node node) throws ASN1Exception {
        int octet = this.readByte();
        node.elementClass = octet >> 6;
        node.isPrimitive = (octet & 0x20) == 0;
        int type = octet & 0x1F;
        if (type == 31) {
            int next;
            type = 0;
            do {
                next = this.readByte();
                type = type * 128 + (next & 0x7F);
            } while ((next & 0x80) != 0);
        }
        node.originalType = type;
        node.type = type;
    }

    public void configureTypeRedirection(int nesting, TypeMapper mapper) {
        if (this.tagConfiguration == null) {
            this.tagConfiguration = new TypeMapper[nesting + 5];
        }
        if (this.tagConfiguration.length <= nesting) {
            TypeMapper[] old = this.tagConfiguration;
            this.tagConfiguration = new TypeMapper[nesting + 5];
            int i = 0;
            while (i < old.length) {
                this.tagConfiguration[i] = old[i];
                ++i;
            }
        }
        this.tagConfiguration[nesting] = mapper;
    }

    private void computeTypeRedirection(Node node) {
        if (node.elementClass == 0 && this.nesting == 0) {
            return;
        }
        if (this.tagConfiguration == null) {
            if (node.type == 0) {
                try {
                    this.readLength();
                    this.readTag(node);
                }
                catch (ASN1Exception aSN1Exception) {}
            }
            return;
        }
        if (this.nesting >= this.tagConfiguration.length) {
            return;
        }
        TypeMapper mapper = this.tagConfiguration[this.nesting];
        if (mapper == null) {
            return;
        }
        node.type = mapper.map(node.originalType, this.nesting, this.sequenceItem);
    }

    private void throwASN1Exception() throws ASN1Exception {
        throw new ASN1Exception(Msg.getString("K008b", this.input.currentPosition()));
    }

    public static Object getDecoded(byte[] bytes) throws ASN1Exception {
        if (bytes == null) {
            throw new ASN1Exception(Msg.getString("K0190"));
        }
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        ASN1Decoder dec = new ASN1Decoder(in);
        return dec.readContentsToObject();
    }

    private static String convertToString(byte[] bytes) {
        try {
            return new String(bytes, "ISO8859_1");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.toString());
        }
    }

    public static class BitString {
        public int unusedBits;
        public byte[] data;

        public BitString(int unusedBits, byte[] bytes) {
            this.unusedBits = unusedBits;
            this.data = bytes;
        }

        public int bitLength() {
            return this.data.length * 8 - this.unusedBits;
        }

        public boolean bitAt(int bitPosition) {
            int whichOctet = bitPosition / 8;
            int octet = this.data[whichOctet] & 0xFF;
            int octetBit = bitPosition % 8;
            return (octet >>> 7 - octetBit & 1) == 1;
        }
    }

    public static class Node {
        public static final int TAG_IMPLICIT = 1;
        public static final int TAG_EXPLICIT = 2;
        public static final int LAST = Integer.MAX_VALUE;
        public Object data;
        public int originalType = -1;
        public int tagtype = 1;
        public int type;
        public boolean isPrimitive;
        int elementClass;
        public int startPosition;
        public int endPosition;
        private static String lineTerminator = null;

        static {
            lineTerminator = (String)AccessController.doPrivileged(new PriviAction("line.separator"));
        }

        public boolean isUniversal() {
            return this.elementClass == 0;
        }

        public boolean isApplication() {
            return this.elementClass == 1;
        }

        public boolean isContextSpecific() {
            return this.elementClass == 2;
        }

        public boolean isPrivate() {
            return this.elementClass == 3;
        }

        public Node subnode(int position) {
            try {
                int len = ((Node[])this.data).length;
                if (position >= len) {
                    position = len - 1 - (Integer.MAX_VALUE - position);
                }
                return ((Node[])this.data)[position];
            }
            catch (Exception exception) {
                return null;
            }
        }

        public Node subnodeWithOriginalType(int originalType) {
            try {
                Node[] subnodes = (Node[])this.data;
                int i = 0;
                while (i < subnodes.length) {
                    Node subnode = subnodes[i];
                    if (subnode.originalType == originalType) {
                        return subnode;
                    }
                    ++i;
                }
            }
            catch (Exception exception) {}
            return null;
        }

        public Object subnode(int[] positionIndices) {
            try {
                Node result = ((Node[])this.data)[positionIndices[0]];
                int i = 1;
                while (i < positionIndices.length) {
                    result = ((Node[])result.data)[positionIndices[i]];
                    ++i;
                }
                return result;
            }
            catch (Exception exception) {
                return null;
            }
        }

        public String toString() {
            return this.toString(0);
        }

        private String toString(int indent) {
            if (this.type == 16 || this.type == 17) {
                StringBuffer sb = new StringBuffer();
                Node[] subNodes = (Node[])this.data;
                if (this.type == 16) {
                    sb.append("[SEQUENCE]");
                } else {
                    sb.append("[SET]");
                }
                sb.append("(" + subNodes.length + ") ... " + (this.endPosition - this.startPosition + 1));
                int i = 0;
                while (i < subNodes.length) {
                    sb.append(lineTerminator);
                    int j = 0;
                    while (j < indent + 2) {
                        sb.append(" ");
                        ++j;
                    }
                    sb.append(subNodes[i].toString(indent + 2));
                    ++i;
                }
                return sb.toString();
            }
            if (this.data == null) {
                return "NULL";
            }
            if (this.data instanceof BitString) {
                return "[BIT_STRING] " + Node.getStringForByteArray(((BitString)this.data).data);
            }
            if (this.data instanceof byte[]) {
                return "[BIT_STRING] " + Node.getStringForByteArray((byte[])this.data);
            }
            if (this.data instanceof int[]) {
                StringBuffer result = new StringBuffer();
                result.append("OID ");
                int[] ints = (int[])this.data;
                result.append(ints[0]);
                int i = 1;
                while (i < ints.length) {
                    result.append("." + ints[i]);
                    ++i;
                }
                return result.toString();
            }
            return this.data.toString();
        }

        private static String getStringForByteArray(byte[] data) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < data.length) {
                sb.append(Integer.toHexString(data[i] >> 4 & 0xF));
                sb.append(Integer.toHexString(data[i] & 0xF));
                sb.append(" ");
                ++i;
            }
            return sb.toString().toUpperCase();
        }
    }

    public static class Set {
        public Object[] sequence = null;

        public Set(Object[] s) {
            this.sequence = s;
        }
    }

    public static class Set2 {
        public Object[] sequence = null;

        public Set2(Object[] s) {
            this.sequence = s;
        }
    }

    public static class ImplicitSet {
        public Set2 set = null;
        public int tag = 0;

        public ImplicitSet(Set2 s, int tag) {
            this.set = s;
            this.tag = tag;
        }
    }

    public static class CertificateSet {
        public Object[] sequence = null;

        public CertificateSet(Object[] s) {
            this.sequence = s;
        }
    }

    public static class Explicit {
        public Object type = null;

        public Explicit(Object obj) {
            this.type = obj;
        }
    }

    public static class BMPString {
        public String bmpString = null;

        public BMPString(String value) {
            this.bmpString = value;
        }
    }

    public static class UTCTime {
        public Date utcTime = null;

        public UTCTime(Date date) {
            this.utcTime = date;
        }
    }

    public static class GeneralizedTime {
        public Date generalizedTime = null;

        public GeneralizedTime(Date date) {
            this.generalizedTime = date;
        }
    }

    public static class Data {
        public byte[] data = null;

        public Data(byte[] d) {
            this.data = d;
        }
    }

    public static interface TypeMapper {
        public int map(int var1, int var2, int var3);
    }
}

