/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class PositionedInputStream
extends FilterInputStream {
    int currentPosition = 0;

    public PositionedInputStream(InputStream in) {
        super(in);
    }

    public int currentPosition() {
        return this.currentPosition;
    }

    public int read() throws IOException {
        int read = this.in.read();
        if (read >= 0) {
            ++this.currentPosition;
        }
        return read;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int read = this.in.read(b, off, len);
        if (read >= 0) {
            this.currentPosition += read;
        }
        return read;
    }

    public void resetCurrentPosition() {
        this.currentPosition = 0;
    }

    public long skip(long n) throws IOException {
        long skip = this.in.skip(n);
        this.currentPosition = (int)((long)this.currentPosition + skip);
        return skip;
    }
}

