/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.vm;

import com.ibm.oti.util.Msg;
import com.ibm.oti.util.Util;
import com.ibm.oti.vm.JxeResource;
import com.ibm.oti.vm.MemInputStream;
import com.ibm.oti.vm.VM;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;

class JxeResourceTable {
    private static final boolean useNative = VM.useNatives();
    private Hashtable pointerTable;
    private InputStream iStream;
    private JxeResource osmEntry;
    private int offset;
    private long pointer;
    private byte[] header = new byte[30];
    private byte[] nameBytes = new byte[16];
    private char[] nameChars = new char[0];
    private static final int LOCHDR = 30;
    private static final int SIG_LOCAL = 67324752;
    private static final int SIG_CEN = 33639248;
    private static final int SIG_ENDCEN = 101010256;

    JxeResourceTable(InputStream stream) throws IOException {
        this.iStream = stream;
    }

    JxeResourceTable(MemInputStream stream) throws IOException {
        this.iStream = stream;
        this.pointer = stream.getPointer();
        this.readEntries();
    }

    private void readEntries() throws IOException {
        String fileName;
        this.offset = 0;
        this.pointerTable = new Hashtable(15);
        while ((fileName = this.getNext()) != null) {
            int size = this.osmEntry.getSize();
            long lrc = this.iStream.skip(size);
            this.offset += size;
            if (lrc != (long)size) {
                throw new IOException(Msg.getString("K01a0"));
            }
            if (fileName.equals("rom.classes")) continue;
            this.pointerTable.put(fileName, this.osmEntry);
        }
    }

    JxeResource getResource() {
        return this.osmEntry;
    }

    Hashtable getTable() {
        return this.pointerTable;
    }

    String getNext() throws IOException {
        String fileName;
        this.osmEntry = null;
        int rc = this.iStream.read(this.header, 0, this.header.length);
        long sig = this.getInt(this.header, 0);
        if (33639248L == sig || 101010256L == sig) {
            return null;
        }
        if (67324752L != sig) {
            throw new IOException(Msg.getString("K019c"));
        }
        if (rc != 30) {
            throw new IOException(Msg.getString("K01a0"));
        }
        this.offset += rc;
        int gpBits = this.getShort(this.header, 6);
        int method = this.getShort(this.header, 8);
        long compressedSize = this.getInt(this.header, 18);
        int fileNameLength = this.getShort(this.header, 26);
        int extraLength = this.getShort(this.header, 28);
        if (method != 0 && 8 != method) {
            throw new IOException(Msg.getString("K019d"));
        }
        if ((1 & gpBits) != 0) {
            throw new IOException(Msg.getString("K019e"));
        }
        if ((0x80 & gpBits) != 0) {
            throw new IOException(Msg.getString("K019f"));
        }
        if (fileNameLength > this.nameBytes.length) {
            this.nameBytes = new byte[fileNameLength + 32];
        }
        if ((rc = this.iStream.read(this.nameBytes, 0, fileNameLength)) != fileNameLength) {
            throw new IOException(Msg.getString("K01a0"));
        }
        this.offset += fileNameLength;
        if (useNative) {
            fileName = Util.convertFromUTF8(this.nameBytes, 0, fileNameLength);
        } else {
            if (this.nameChars.length < this.nameBytes.length) {
                this.nameChars = new char[this.nameBytes.length];
            }
            fileName = Util.convertUTF8WithBuf(this.nameBytes, this.nameChars, 0, fileNameLength);
        }
        rc = (int)this.iStream.skip(extraLength);
        if (rc != extraLength) {
            throw new IOException(Msg.getString("K01a0"));
        }
        this.offset += extraLength;
        this.osmEntry = new JxeResource(this.pointer + (long)this.offset, (int)compressedSize, method);
        return fileName;
    }

    private long getInt(byte[] bytes, int offset) {
        return (long)(((bytes[offset + 2] & 0xFF) << 16) + ((bytes[offset + 1] & 0xFF) << 8) + (bytes[offset] & 0xFF)) + ((long)(bytes[offset + 3] & 0xFF) << 24);
    }

    private int getShort(byte[] bytes, int offset) {
        return ((bytes[offset + 1] & 0xFF) << 8) + (bytes[offset] & 0xFF);
    }
}

