/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.vm;

import com.ibm.oti.util.Msg;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.zip.ZipFile;

public class ZipStream
extends InputStream {
    private long streamHandle;
    private long uncompressedSize;
    private long pos;
    private long markPos = 0L;
    private Object lock;
    private ZipFile zipFile;
    private static Field descriptorField;
    private static Field lockField;
    static /* synthetic */ Class class$0;

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Class clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.util.zip.ZipFile");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Class zipFileClass = clazz;
                try {
                    descriptorField = zipFileClass.getDeclaredField("descriptor");
                    descriptorField.setAccessible(true);
                    lockField = zipFileClass.getDeclaredField("lock");
                    lockField.setAccessible(true);
                    return null;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    throw new Error();
                }
            }
        });
    }

    ZipStream(long handle) throws IOException {
        this.streamHandle = handle;
        this.uncompressedSize = this.streamSizeImpl(this.streamHandle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream getZipStream(ZipFile zipFile, String entryName) throws IOException {
        Object lock;
        try {
            lock = lockField.get(zipFile);
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        Object object = lock;
        synchronized (object) {
            long descriptor = ZipStream.checkDescriptor(zipFile);
            long streamHandle = ZipStream.openZipFileImpl(descriptor, entryName);
            if (streamHandle == 0L) {
                return null;
            }
            ZipStream stream = new ZipStream(streamHandle);
            stream.setInternals(zipFile, lock);
            return stream;
        }
    }

    private void setInternals(ZipFile zipFile, Object lock) {
        this.lock = lock;
        this.zipFile = zipFile;
    }

    private static long checkDescriptor(ZipFile zipFile) {
        long value = -1L;
        try {
            value = descriptorField.getLong(zipFile);
        }
        catch (IllegalAccessException illegalAccessException) {}
        if (value == -1L) {
            throw new IllegalStateException(Msg.getString("K00b7"));
        }
        return value;
    }

    protected void finalize() {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (this.streamHandle != 0L) {
                this.closeStreamImpl(this.streamHandle);
                this.streamHandle = 0L;
            }
        }
    }

    public int available() throws IOException {
        return (int)(this.uncompressedSize - this.pos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] buffer, int offset, int length) throws IOException {
        if (offset <= buffer.length && offset >= 0 && length >= 0 && length <= buffer.length - offset) {
            Object object = this.lock;
            synchronized (object) {
                block7: {
                    ZipStream.checkDescriptor(this.zipFile);
                    if (this.streamHandle == 0L) {
                        throw new IOException(Msg.getString("K0059"));
                    }
                    if (this.pos != this.uncompressedSize) break block7;
                    return -1;
                }
                long remaining = this.uncompressedSize - this.pos;
                if ((long)length > remaining) {
                    length = (int)remaining;
                }
                this.readStreamImpl(this.streamHandle, buffer, offset, length);
                this.pos += (long)length;
                return length;
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public int read() throws IOException {
        byte[] buf = new byte[1];
        if (this.read(buf, 0, 1) == -1) {
            return -1;
        }
        return buf[0] & 0xFF;
    }

    public boolean markSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mark(int readLimit) {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.streamHandle != 0L) {
                    this.markStreamImpl(this.streamHandle);
                }
                this.markPos = this.pos;
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            ZipStream.checkDescriptor(this.zipFile);
            if (this.streamHandle == 0L) {
                throw new IOException(Msg.getString("K0059"));
            }
            this.resetStreamImpl(this.streamHandle);
            this.pos = this.markPos;
        }
    }

    private static native long openZipFileImpl(long var0, String var2) throws IOException;

    private native long streamSizeImpl(long var1);

    private native void readStreamImpl(long var1, byte[] var3, int var4, int var5) throws IOException;

    private native void markStreamImpl(long var1) throws IOException;

    private native void resetStreamImpl(long var1) throws IOException;

    private native void closeStreamImpl(long var1);
}

