/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import com.ibm.oti.util.Msg;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BufferedInputStream
extends FilterInputStream {
    protected byte[] buf;
    protected int count;
    protected int marklimit;
    protected int markpos = -1;
    protected int pos;

    public BufferedInputStream(InputStream in) {
        super(in);
        this.buf = new byte[2048];
    }

    public BufferedInputStream(InputStream in, int size) {
        super(in);
        if (size <= 0) {
            throw new IllegalArgumentException(Msg.getString("K0058"));
        }
        this.buf = new byte[size];
    }

    public synchronized int available() throws IOException {
        if (this.buf == null) {
            throw new IOException(Msg.getString("K0059"));
        }
        return this.count - this.pos + this.in.available();
    }

    public synchronized void close() throws IOException {
        super.close();
        this.buf = null;
    }

    private int fillbuf() throws IOException {
        if (this.markpos == -1 || this.pos - this.markpos >= this.marklimit) {
            int result = this.in.read(this.buf);
            if (result > 0) {
                this.markpos = -1;
                this.pos = 0;
                this.count = result == -1 ? 0 : result;
            }
            return result;
        }
        if (this.markpos == 0 && this.marklimit > this.buf.length) {
            int newLength = this.buf.length * 2;
            if (newLength > this.marklimit) {
                newLength = this.marklimit;
            }
            byte[] newbuf = new byte[newLength];
            System.arraycopy((Object)this.buf, 0, (Object)newbuf, 0, this.buf.length);
            this.buf = newbuf;
        } else if (this.markpos > 0) {
            System.arraycopy((Object)this.buf, this.markpos, (Object)this.buf, 0, this.buf.length - this.markpos);
        }
        this.pos -= this.markpos;
        this.markpos = 0;
        this.count = 0;
        int bytesread = this.in.read(this.buf, this.pos, this.buf.length - this.pos);
        this.count = bytesread <= 0 ? this.pos : this.pos + bytesread;
        return bytesread;
    }

    public synchronized void mark(int readlimit) {
        this.marklimit = readlimit;
        this.markpos = this.pos;
    }

    public boolean markSupported() {
        return true;
    }

    public synchronized int read() throws IOException {
        if (this.buf != null) {
            if (this.pos >= this.count && this.fillbuf() == -1) {
                return -1;
            }
            if (this.count - this.pos > 0) {
                return this.buf[this.pos++] & 0xFF;
            }
            return -1;
        }
        throw new IOException(Msg.getString("K0059"));
    }

    public synchronized int read(byte[] buffer, int offset, int length) throws IOException {
        if (this.buf != null && buffer != null) {
            if (offset >= 0 && offset <= buffer.length && length >= 0 && length <= buffer.length - offset) {
                int required;
                if (length == 0) {
                    return 0;
                }
                if (this.pos < this.count) {
                    int copylength = this.count - this.pos >= length ? length : this.count - this.pos;
                    System.arraycopy((Object)this.buf, this.pos, (Object)buffer, offset, copylength);
                    this.pos += copylength;
                    if (copylength == length || this.in.available() == 0) {
                        return copylength;
                    }
                    offset += copylength;
                    required = length - copylength;
                } else {
                    required = length;
                }
                while (true) {
                    int read;
                    if (this.markpos == -1 && required >= this.buf.length) {
                        read = this.in.read(buffer, offset, required);
                        if (read == -1) {
                            return required == length ? -1 : length - required;
                        }
                    } else {
                        if (this.fillbuf() == -1) {
                            return required == length ? -1 : length - required;
                        }
                        read = this.count - this.pos >= required ? required : this.count - this.pos;
                        System.arraycopy((Object)this.buf, this.pos, (Object)buffer, offset, read);
                        this.pos += read;
                    }
                    if ((required -= read) == 0) {
                        return length;
                    }
                    if (this.in.available() == 0) {
                        return length - required;
                    }
                    offset += read;
                }
            }
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this.buf == null) {
            throw new IOException(Msg.getString("K0059"));
        }
        throw new NullPointerException(Msg.getString("K0047"));
    }

    public synchronized void reset() throws IOException {
        if (this.markpos != -1) {
            if (this.buf == null) {
                throw new IOException(Msg.getString("K0059"));
            }
        } else {
            throw new IOException(Msg.getString("K005a"));
        }
        this.pos = this.markpos;
    }

    public synchronized long skip(long amount) throws IOException {
        if (amount < 1L) {
            return 0L;
        }
        if ((long)(this.count - this.pos) >= amount) {
            this.pos = (int)((long)this.pos + amount);
            return amount;
        }
        long read = this.count - this.pos;
        this.pos = this.count;
        if (this.markpos != -1) {
            if (amount <= (long)this.marklimit) {
                if (this.fillbuf() == -1) {
                    return read;
                }
                if ((long)(this.count - this.pos) >= amount - read) {
                    this.pos = (int)((long)this.pos + (amount - read));
                    return amount;
                }
                this.pos = this.count;
                return read += (long)(this.count - this.pos);
            }
            this.markpos = -1;
        }
        return read + this.in.skip(amount - read);
    }
}

