/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import com.ibm.oti.util.Msg;
import java.io.IOException;
import java.io.Reader;

public class CharArrayReader
extends Reader {
    protected char[] buf;
    protected int pos = 0;
    protected int markedPos = -1;
    protected int count = 0;

    public CharArrayReader(char[] buf) {
        super(buf);
        this.buf = buf;
        this.count = buf.length;
    }

    public CharArrayReader(char[] buf, int offset, int length) {
        super(buf);
        if (offset < 0 || offset > buf.length || length < 0) {
            throw new IllegalArgumentException();
        }
        this.buf = buf;
        this.pos = offset;
        this.count = this.pos + length < buf.length ? length : buf.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isOpen()) {
                this.buf = null;
            }
        }
    }

    private boolean isOpen() {
        return this.buf != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mark(int readLimit) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new IOException(Msg.getString("K0060"));
            }
            this.markedPos = this.pos;
        }
    }

    public boolean markSupported() {
        return true;
    }

    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            block5: {
                if (!this.isOpen()) break block5;
                if (this.pos != this.count) {
                    return this.buf[this.pos++];
                }
                return -1;
            }
            throw new IOException(Msg.getString("K0060"));
        }
    }

    public int read(char[] buf, int offset, int count) throws IOException {
        if (offset >= 0 && offset <= buf.length && count >= 0 && count <= buf.length - offset) {
            Object object = this.lock;
            synchronized (object) {
                block6: {
                    if (!this.isOpen()) break block6;
                    if (this.pos != this.count) {
                        int bytesRead = this.pos + count > this.count ? this.count - this.pos : count;
                        System.arraycopy((Object)this.buf, this.pos, (Object)buf, offset, bytesRead);
                        this.pos += bytesRead;
                        return bytesRead;
                    }
                    return -1;
                }
                throw new IOException(Msg.getString("K0060"));
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isOpen()) {
                return this.pos != this.count;
            }
            throw new IOException(Msg.getString("K0060"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new IOException(Msg.getString("K0060"));
            }
            this.pos = this.markedPos != -1 ? this.markedPos : 0;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long skip(long count) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            block5: {
                if (!this.isOpen()) throw new IOException(Msg.getString("K0060"));
                if (count > 0L) break block5;
                return 0L;
            }
            long skipped = 0L;
            if (count < (long)(this.count - this.pos)) {
                this.pos += (int)count;
                return count;
            }
            skipped = this.count - this.pos;
            this.pos = this.count;
            return skipped;
        }
    }
}

