/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import com.ibm.oti.util.Msg;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;

public class PipedOutputStream
extends OutputStream {
    private PipedInputStream dest;

    public PipedOutputStream() {
    }

    public PipedOutputStream(PipedInputStream dest) throws IOException {
        this.connect(dest);
    }

    public void close() throws IOException {
        if (this.dest != null) {
            this.dest.done();
            this.dest = null;
        }
    }

    public void connect(PipedInputStream dest) throws IOException {
        if (this.dest == null) {
            if (dest.isConnected) {
                throw new IOException(Msg.getString("K007a"));
            }
        } else {
            throw new IOException(Msg.getString("K0079"));
        }
        dest.buffer = new byte[1024];
        dest.isConnected = true;
        this.dest = dest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        if (this.dest != null) {
            PipedInputStream pipedInputStream = this.dest;
            synchronized (pipedInputStream) {
                this.dest.notifyAll();
            }
        }
    }

    public void write(byte[] buffer, int offset, int count) throws IOException {
        super.write(buffer, offset, count);
    }

    public void write(int oneByte) throws IOException {
        if (this.dest == null) {
            throw new IOException();
        }
        this.dest.receive(oneByte);
    }
}

