/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import com.ibm.oti.util.Msg;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class PushbackInputStream
extends FilterInputStream {
    protected byte[] buf;
    protected int pos;

    public PushbackInputStream(InputStream in) {
        super(in);
        this.buf = new byte[1];
        this.pos = 1;
    }

    public PushbackInputStream(InputStream in, int size) {
        super(in);
        if (size <= 0) {
            throw new IllegalArgumentException(Msg.getString("K0058"));
        }
        this.buf = new byte[size];
        this.pos = size;
    }

    public int available() throws IOException {
        if (this.buf != null) {
            return this.buf.length - this.pos + this.in.available();
        }
        throw new IOException();
    }

    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
            this.in = null;
            this.buf = null;
        }
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        if (this.buf != null) {
            if (this.pos < this.buf.length) {
                return this.buf[this.pos++] & 0xFF;
            }
            return this.in.read();
        }
        throw new IOException();
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        if (this.buf != null && buffer != null) {
            if (offset >= 0 && offset <= buffer.length && length >= 0 && length <= buffer.length - offset) {
                int copiedBytes = 0;
                int copyLength = 0;
                int newOffset = offset;
                if (this.pos < this.buf.length) {
                    copyLength = this.buf.length - this.pos >= length ? length : this.buf.length - this.pos;
                    System.arraycopy((Object)this.buf, this.pos, (Object)buffer, newOffset, copyLength);
                    newOffset += copyLength;
                    copiedBytes += copyLength;
                    this.pos += copyLength;
                }
                if (copyLength == length) {
                    return length;
                }
                int inCopied = this.in.read(buffer, newOffset, length - copiedBytes);
                if (inCopied > 0) {
                    return inCopied + copiedBytes;
                }
                if (copiedBytes == 0) {
                    return inCopied;
                }
                return copiedBytes;
            }
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this.buf == null) {
            throw new IOException();
        }
        throw new NullPointerException();
    }

    public long skip(long count) throws IOException {
        if (this.in != null) {
            if (count <= 0L) {
                return 0L;
            }
            int numSkipped = 0;
            if (this.pos < this.buf.length) {
                numSkipped = (int)((long)numSkipped + (count < (long)(this.buf.length - this.pos) ? count : (long)(this.buf.length - this.pos)));
                this.pos += numSkipped;
            }
            if ((long)numSkipped < count) {
                numSkipped = (int)((long)numSkipped + this.in.skip(count - (long)numSkipped));
            }
            return numSkipped;
        }
        throw new IOException(Msg.getString("K0059"));
    }

    public void unread(byte[] buffer) throws IOException {
        this.unread(buffer, 0, buffer.length);
    }

    public void unread(byte[] buffer, int offset, int length) throws IOException {
        if (length > this.pos) {
            throw new IOException(Msg.getString("K007e"));
        }
        if (offset >= 0 && offset <= buffer.length && length >= 0 && length <= buffer.length - offset) {
            int i = offset + length - 1;
            while (i >= offset) {
                this.unread(buffer[i]);
                --i;
            }
        } else {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public void unread(int oneByte) throws IOException {
        if (this.buf != null) {
            if (this.pos == 0) {
                throw new IOException(Msg.getString("K007e"));
            }
        } else {
            throw new IOException();
        }
        this.buf[--this.pos] = (byte)oneByte;
    }
}

