/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import com.ibm.oti.util.Msg;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;

public class SequenceInputStream
extends InputStream {
    Enumeration e;
    InputStream in;

    public SequenceInputStream(InputStream s1, InputStream s2) {
        if (s1 == null || s2 == null) {
            throw new NullPointerException();
        }
        Vector inVector = new Vector(1);
        inVector.addElement(s2);
        this.e = inVector.elements();
        this.in = s1;
    }

    public SequenceInputStream(Enumeration e) {
        this.e = e;
        if (e.hasMoreElements()) {
            this.in = (InputStream)e.nextElement();
            if (this.in == null) {
                throw new NullPointerException();
            }
        }
    }

    public int available() throws IOException {
        if (this.e != null && this.in != null) {
            return this.in.available();
        }
        return 0;
    }

    public void close() throws IOException {
        if (this.e != null) {
            while (this.in != null) {
                this.nextStream();
            }
        } else {
            throw new IOException(Msg.getString("K00b7"));
        }
        this.e = null;
    }

    private void nextStream() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
        if (this.e.hasMoreElements()) {
            this.in = (InputStream)this.e.nextElement();
            if (this.in == null) {
                throw new NullPointerException();
            }
        } else {
            this.in = null;
        }
    }

    public int read() throws IOException {
        while (this.in != null) {
            int result = this.in.read();
            if (result >= 0) {
                return result;
            }
            this.nextStream();
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int read(byte[] buffer, int offset, int count) throws IOException {
        if (buffer == null) {
            if (offset < 0 || count < 0) throw new ArrayIndexOutOfBoundsException();
            while (this.in != null) {
                long result = this.in.skip(count);
                if (result >= 0L) {
                    return (int)result;
                }
                this.nextStream();
            }
            return -1;
        } else {
            if (offset < 0 || offset > buffer.length || count < 0 || count > buffer.length - offset) throw new ArrayIndexOutOfBoundsException();
            while (this.in != null) {
                int result = this.in.read(buffer, offset, count);
                if (result >= 0) {
                    return result;
                }
                this.nextStream();
            }
        }
        return -1;
    }
}

