/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;

final class GenericIPMreq {
    private InetAddress multiaddr;
    private InetAddress interfaceAddr;
    private boolean isIPV6Address;
    private int interfaceIdx;

    GenericIPMreq(InetAddress addr) {
        this.multiaddr = addr;
        this.interfaceAddr = null;
        this.interfaceIdx = 0;
        this.init();
    }

    GenericIPMreq(InetAddress addr, NetworkInterface netInterface) {
        this.multiaddr = addr;
        if (netInterface != null) {
            this.interfaceIdx = netInterface.getIndex();
            this.interfaceAddr = null;
            Enumeration theAddresses = netInterface.getInetAddresses();
            if (addr instanceof Inet4Address && theAddresses != null) {
                boolean found = false;
                while (theAddresses.hasMoreElements() && !found) {
                    InetAddress theAddress = (InetAddress)theAddresses.nextElement();
                    if (!(theAddress instanceof Inet4Address)) continue;
                    this.interfaceAddr = theAddress;
                    found = true;
                }
            }
        } else {
            this.interfaceIdx = 0;
            this.interfaceAddr = null;
        }
        this.init();
    }

    private void init() {
        this.isIPV6Address = false;
        if (this.multiaddr != null && this.multiaddr instanceof Inet6Address) {
            this.isIPV6Address = true;
        }
    }
}

