/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import com.ibm.oti.util.Msg;
import com.ibm.oti.util.PriviAction;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.BindException;
import java.net.DatagramPacket;
import java.net.DatagramSocketImpl;
import java.net.GenericIPMreq;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.util.Hashtable;

class PlainDatagramSocketImpl
extends DatagramSocketImpl {
    private static final int SO_BROADCAST = 32;
    static final int IP_MULTICAST_ADD = 19;
    static final int IP_MULTICAST_DROP = 20;
    static final int IP_MULTICAST_TTL = 17;
    private boolean bindToDevice;
    private byte[] ipaddress = new byte[4];
    private int ttl = 1;
    private volatile boolean isNativeConnected = false;
    static final int REUSEADDR_AND_REUSEPORT = 10001;
    private InetAddress connectedAddress = null;
    private int connectedPort = -1;
    private int trafficClass = 0;
    private static boolean fixBind = false;
    private static Hashtable checkBind;
    boolean reuseAddr = false;

    static {
        PlainDatagramSocketImpl.oneTimeInitialization(true);
        String prop = (String)AccessController.doPrivileged(new PriviAction("uniqueBindFix"));
        boolean bl = fixBind = prop != null && prop.toLowerCase().equals("true");
        if (fixBind) {
            checkBind = new Hashtable();
        }
    }

    PlainDatagramSocketImpl() {
    }

    private static native void oneTimeInitialization(boolean var0);

    protected void bind(int port, InetAddress addr) throws SocketException {
        boolean useBindToDevice;
        String prop = (String)AccessController.doPrivileged(new PriviAction("bindToDevice"));
        boolean bl = useBindToDevice = prop != null && prop.toLowerCase().equals("true");
        if (fixBind && !this.reuseAddr && port != 0 && checkBind.get(new Integer(port)) != null) {
            throw new BindException(Msg.getString("K03ba", port));
        }
        try {
            this.bindToDevice = PlainDatagramSocketImpl.socketBindImpl2(this.fd, port, useBindToDevice, addr);
        }
        catch (BindException e) {
            throw new BindException(addr + ":" + port + " - " + e.getMessage());
        }
        this.localPort = port != 0 ? port : Socket.getSocketLocalPortImpl(this.fd, InetAddress.preferIPv6Addresses());
        if (fixBind) {
            Integer portObj = new Integer(this.localPort);
            checkBind.put(portObj, portObj);
        }
        try {
            this.setOption(32, Boolean.TRUE);
        }
        catch (IOException iOException) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close() {
        FileDescriptor fileDescriptor = this.fd;
        synchronized (fileDescriptor) {
            if (this.fd.valid()) {
                Socket.socketCloseImpl(this.fd);
                if (fixBind) {
                    checkBind.remove(new Integer(this.localPort));
                }
                this.initializeSocket();
            }
        }
    }

    protected void create() throws SocketException {
        PlainDatagramSocketImpl.createDatagramSocketImpl(this.fd, Socket.preferIPv4Stack());
    }

    protected void finalize() {
        this.close();
    }

    InetAddress getLocalAddress() {
        return Socket.getSocketLocalAddressImpl(this.fd, InetAddress.preferIPv6Addresses());
    }

    public Object getOption(int optID) throws SocketException {
        if (optID == 4102) {
            return new Integer(this.receiveTimeout);
        }
        if (optID == 3) {
            return new Integer(this.trafficClass);
        }
        Object result = Socket.getSocketOptionImpl(this.fd, optID);
        if (optID == 16 && (Socket.getSocketFlags() & 1) != 0) {
            return new Inet4Address(this.ipaddress);
        }
        return result;
    }

    protected int getTimeToLive() throws IOException {
        int result = (Byte)this.getOption(17) & 0xFF;
        if ((Socket.getSocketFlags() & 2) != 0) {
            return this.ttl;
        }
        return result;
    }

    protected byte getTTL() throws IOException {
        byte result = (Byte)this.getOption(17);
        if ((Socket.getSocketFlags() & 2) != 0) {
            return (byte)this.ttl;
        }
        return result;
    }

    protected void join(InetAddress addr) throws IOException {
        this.setOption(19, new GenericIPMreq(addr));
    }

    protected void joinGroup(SocketAddress addr, NetworkInterface netInterface) throws IOException {
        if (addr instanceof InetSocketAddress) {
            InetAddress groupAddr = ((InetSocketAddress)addr).getAddress();
            this.setOption(19, new GenericIPMreq(groupAddr, netInterface));
        }
    }

    protected void leave(InetAddress addr) throws IOException {
        this.setOption(20, new GenericIPMreq(addr));
    }

    protected void leaveGroup(SocketAddress addr, NetworkInterface netInterface) throws IOException {
        if (addr instanceof InetSocketAddress) {
            InetAddress groupAddr = ((InetSocketAddress)addr).getAddress();
            this.setOption(20, new GenericIPMreq(groupAddr, netInterface));
        }
    }

    protected static native void connectDatagramImpl2(FileDescriptor var0, int var1, int var2, InetAddress var3) throws SocketException;

    protected static native void disconnectDatagramImpl(FileDescriptor var0) throws SocketException;

    protected static native void createDatagramSocketImpl(FileDescriptor var0, boolean var1) throws SocketException;

    protected static native boolean socketBindImpl2(FileDescriptor var0, int var1, boolean var2, InetAddress var3) throws SocketException;

    protected static native int peekDatagramImpl(FileDescriptor var0, InetAddress var1, int var2) throws IOException;

    protected static native int receiveDatagramImpl2(FileDescriptor var0, DatagramPacket var1, byte[] var2, int var3, int var4, int var5, boolean var6) throws IOException;

    protected static native int recvConnectedDatagramImpl(FileDescriptor var0, DatagramPacket var1, byte[] var2, int var3, int var4, int var5, boolean var6) throws IOException;

    protected static native int sendDatagramImpl2(FileDescriptor var0, byte[] var1, int var2, int var3, int var4, boolean var5, int var6, InetAddress var7) throws IOException;

    protected static native int sendConnectedDatagramImpl(FileDescriptor var0, byte[] var1, int var2, int var3, boolean var4) throws IOException;

    protected int peek(InetAddress sender) throws IOException {
        if (this.isNativeConnected) {
            byte[] storageArray = new byte[10];
            DatagramPacket pack = new DatagramPacket(storageArray, storageArray.length);
            PlainDatagramSocketImpl.recvConnectedDatagramImpl(this.fd, pack, pack.getData(), pack.getOffset(), pack.getLength(), this.receiveTimeout, true);
            sender.ipaddress = this.connectedAddress.getAddress();
            return this.connectedPort;
        }
        return PlainDatagramSocketImpl.peekDatagramImpl(this.fd, sender, this.receiveTimeout);
    }

    protected void receive(DatagramPacket pack) throws IOException {
        boolean isLoopback;
        try {
            if (this.isNativeConnected) {
                PlainDatagramSocketImpl.recvConnectedDatagramImpl(this.fd, pack, pack.getData(), pack.getOffset(), pack.getLength(), this.receiveTimeout, false);
                this.updatePacketRecvAddress(pack);
            } else {
                PlainDatagramSocketImpl.receiveDatagramImpl2(this.fd, pack, pack.getData(), pack.getOffset(), pack.getLength(), this.receiveTimeout, false);
            }
        }
        catch (InterruptedIOException e) {
            throw new SocketTimeoutException(e.getMessage());
        }
        byte[] addr = InetAddress.LOOPBACK.ipaddress;
        boolean bl = isLoopback = addr.length == this.ipaddress.length;
        if (isLoopback) {
            int i = 0;
            while (i < addr.length) {
                if (addr[i] != this.ipaddress[i]) {
                    isLoopback = false;
                    break;
                }
                ++i;
            }
        }
        if (isLoopback) {
            try {
                if (pack.getAddress().equals(InetAddress.getLocalHost())) {
                    pack.setAddress(InetAddress.LOOPBACK);
                }
            }
            catch (UnknownHostException unknownHostException) {}
        }
    }

    protected void send(DatagramPacket packet) throws IOException {
        if (this.isNativeConnected) {
            PlainDatagramSocketImpl.sendConnectedDatagramImpl(this.fd, packet.getData(), packet.getOffset(), packet.getLength(), this.bindToDevice);
        } else {
            PlainDatagramSocketImpl.sendDatagramImpl2(this.fd, packet.getData(), packet.getOffset(), packet.getLength(), packet.getPort(), this.bindToDevice, this.trafficClass, packet.getAddress());
        }
    }

    public void setOption(int optID, Object val) throws SocketException {
        if (optID == 512) {
            this.reuseAddr = (Boolean)val;
        } else if (optID == 4) {
            optID = 10001;
            this.reuseAddr = (Boolean)val;
        }
        if (optID == 4102) {
            this.receiveTimeout = (Integer)val;
        } else {
            int flags;
            block15: {
                flags = Socket.getSocketFlags();
                try {
                    Socket.setSocketOptionImpl(this.fd, optID | flags << 16, val);
                }
                catch (SocketException e) {
                    if (optID == 3) break block15;
                    throw e;
                }
            }
            if (optID == 16 && (flags & 1) != 0) {
                InetAddress inet = (InetAddress)val;
                if (inet.ipaddress.length == 4 && InetAddress.bytesToInt(inet.ipaddress, 0) == 0 || inet.equals(InetAddress.LOOPBACK)) {
                    this.ipaddress = ((InetAddress)val).getAddress();
                } else {
                    InetAddress local = null;
                    try {
                        local = InetAddress.getLocalHost();
                    }
                    catch (UnknownHostException e) {
                        throw new SocketException("getLocalHost(): " + e.toString());
                    }
                    if (inet.equals(local)) {
                        this.ipaddress = ((InetAddress)val).getAddress();
                    } else {
                        throw new SocketException(val + " != getLocalHost(): " + local);
                    }
                }
            }
            if (optID == 3) {
                this.trafficClass = (Integer)val;
            }
        }
    }

    protected void setTimeToLive(int ttl) throws IOException {
        this.setOption(17, new Byte((byte)(ttl & 0xFF)));
        if ((Socket.getSocketFlags() & 2) != 0) {
            this.ttl = ttl;
        }
    }

    protected void setTTL(byte ttl) throws IOException {
        this.setOption(17, new Byte(ttl));
        if ((Socket.getSocketFlags() & 2) != 0) {
            this.ttl = ttl;
        }
    }

    protected void connect(InetAddress inetAddr, int port) throws SocketException {
        PlainDatagramSocketImpl.connectDatagramImpl2(this.fd, port, this.trafficClass, inetAddr);
        try {
            this.connectedAddress = InetAddress.getByAddress(inetAddr.getAddress());
        }
        catch (UnknownHostException unknownHostException) {
            throw new SocketException(Msg.getString("K0317", inetAddr.getHostName()));
        }
        this.connectedPort = port;
        this.isNativeConnected = true;
    }

    protected void disconnect() {
        try {
            PlainDatagramSocketImpl.disconnectDatagramImpl(this.fd);
        }
        catch (Exception exception) {}
        this.connectedPort = -1;
        this.connectedAddress = null;
        this.isNativeConnected = false;
    }

    protected int peekData(DatagramPacket pack) throws IOException {
        try {
            if (this.isNativeConnected) {
                PlainDatagramSocketImpl.recvConnectedDatagramImpl(this.fd, pack, pack.getData(), pack.getOffset(), pack.getLength(), this.receiveTimeout, true);
                this.updatePacketRecvAddress(pack);
            } else {
                PlainDatagramSocketImpl.receiveDatagramImpl2(this.fd, pack, pack.getData(), pack.getOffset(), pack.getLength(), this.receiveTimeout, true);
            }
        }
        catch (InterruptedIOException e) {
            throw new SocketTimeoutException(e.getMessage());
        }
        return pack.getPort();
    }

    private void updatePacketRecvAddress(DatagramPacket packet) {
        packet.setAddress(this.connectedAddress);
        packet.port = this.connectedPort;
    }
}

