/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import com.ibm.oti.util.Msg;

public class URISyntaxException
extends Exception {
    private String input;
    private int index;

    public URISyntaxException(String input, String reason, int index) {
        super(reason);
        if (input == null || reason == null) {
            throw new NullPointerException();
        }
        if (index < -1) {
            throw new IllegalArgumentException();
        }
        this.input = input;
        this.index = index;
    }

    public URISyntaxException(String input, String reason) {
        super(reason);
        if (input == null || reason == null) {
            throw new NullPointerException();
        }
        this.input = input;
        this.index = -1;
    }

    public int getIndex() {
        return this.index;
    }

    public String getReason() {
        return super.getMessage();
    }

    public String getInput() {
        return this.input;
    }

    public String getMessage() {
        String reason = super.getMessage();
        if (this.index != -1) {
            return Msg.getString("K0326", new String[]{reason, Integer.toString(this.index), this.input});
        }
        return Msg.getString("K0327", new String[]{reason, this.input});
    }
}

