/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.IOException;
import java.security.AlgorithmParametersSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public class AlgorithmParameters {
    private static final String KEY_PREFIX = "AlgorithmParameters.";
    private String algorithmName;
    private Provider provider;
    private AlgorithmParametersSpi algorithmParametersSpi;
    private boolean initialized = false;

    protected AlgorithmParameters(AlgorithmParametersSpi paramSpi, Provider provider, String algName) {
        this.setProvider(provider);
        this.setAlgorithm(algName);
        this.algorithmParametersSpi = paramSpi;
    }

    private static AlgorithmParameters createAlgorithmParameters(Provider provider, Class algorithmClass, String algName) throws NoSuchAlgorithmException {
        try {
            AlgorithmParametersSpi providedDigest = (AlgorithmParametersSpi)algorithmClass.newInstance();
            AlgorithmParameters result = new AlgorithmParameters(providedDigest, provider, algName);
            return result;
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {}
        throw new NoSuchAlgorithmException(algName);
    }

    public final String getAlgorithm() {
        return this.algorithmName;
    }

    public final byte[] getEncoded() throws IOException {
        return this.algorithmParametersSpi.engineGetEncoded();
    }

    public final byte[] getEncoded(String format) throws IOException {
        if (format == null) {
            return this.getEncoded();
        }
        return this.algorithmParametersSpi.engineGetEncoded(format);
    }

    public static AlgorithmParameters getInstance(String algorithmName) throws NoSuchAlgorithmException {
        if (algorithmName != null) {
            return AlgorithmParameters.toAlgorithmParametersImplementation(algorithmName);
        }
        throw new IllegalArgumentException();
    }

    public static AlgorithmParameters getInstance(String algorithmName, String providerName) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (providerName == null || algorithmName == null) {
            throw new IllegalArgumentException();
        }
        Provider provider = Security.getProvider(providerName);
        if (provider != null) {
            return AlgorithmParameters.toAlgorithmParametersImplementation(algorithmName, provider);
        }
        throw new NoSuchProviderException(providerName);
    }

    public static AlgorithmParameters getInstance(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        if (algorithm == null || provider == null) {
            throw new IllegalArgumentException();
        }
        return AlgorithmParameters.toAlgorithmParametersImplementation(algorithm, provider);
    }

    public final AlgorithmParameterSpec getParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
        if (this.initialized) {
            return this.algorithmParametersSpi.engineGetParameterSpec(paramSpec);
        }
        throw new InvalidParameterSpecException();
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final void init(byte[] params) throws IOException {
        if (this.initialized) {
            throw new IOException();
        }
        this.algorithmParametersSpi.engineInit(params);
        this.initialized = true;
    }

    public final void init(byte[] params, String format) throws IOException {
        if (this.initialized) {
            throw new IOException();
        }
        this.algorithmParametersSpi.engineInit(params, format);
        this.initialized = true;
    }

    public final void init(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
        if (this.initialized) {
            throw new InvalidParameterSpecException();
        }
        this.algorithmParametersSpi.engineInit(paramSpec);
        this.initialized = true;
    }

    void setAlgorithm(String algorithmName) {
        this.algorithmName = algorithmName;
    }

    void setProvider(Provider provider) {
        this.provider = provider;
    }

    private static AlgorithmParameters toAlgorithmParametersImplementation(String algorithmName) throws NoSuchAlgorithmException {
        Provider[] providers = Security.getProviders();
        int i = 0;
        while (i < providers.length) {
            Provider provider = providers[i];
            try {
                return AlgorithmParameters.toAlgorithmParametersImplementation(algorithmName, provider);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                ++i;
            }
        }
        throw new NoSuchAlgorithmException(algorithmName);
    }

    private static AlgorithmParameters toAlgorithmParametersImplementation(String algorithmName, Provider provider) throws NoSuchAlgorithmException {
        String algorithmParametersClassName;
        try {
            algorithmParametersClassName = provider.getProperty(KEY_PREFIX + algorithmName);
        }
        catch (ClassCastException classCastException) {
            throw new NoSuchAlgorithmException(algorithmName);
        }
        if (algorithmParametersClassName == null) {
            throw new NoSuchAlgorithmException(algorithmName);
        }
        try {
            Class algorithmParametersClass = Class.forName(algorithmParametersClassName, true, provider.getClass().getClassLoader());
            return AlgorithmParameters.createAlgorithmParameters(provider, algorithmParametersClass, algorithmName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoSuchAlgorithmException(algorithmName);
        }
    }

    public final String toString() {
        if (this.initialized) {
            return this.algorithmParametersSpi.engineToString();
        }
        return null;
    }
}

