/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;

public final class SignedObject
implements Serializable {
    private static final long serialVersionUID = 720502720485447167L;
    private byte[] content;
    private byte[] signature;
    private String thealgorithm;

    public SignedObject(Serializable object, PrivateKey key, Signature signatureAlgorithm) throws IOException, InvalidKeyException, SignatureException {
        this.thealgorithm = signatureAlgorithm.getAlgorithm();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(object);
        oos.close();
        this.content = baos.toByteArray();
        signatureAlgorithm.initSign(key);
        signatureAlgorithm.update(this.content);
        this.signature = signatureAlgorithm.sign();
    }

    public String getAlgorithm() {
        return this.thealgorithm;
    }

    public byte[] getSignature() {
        return (byte[])this.signature.clone();
    }

    public boolean verify(PublicKey key, Signature signatureAlgorithm) throws InvalidKeyException, SignatureException {
        signatureAlgorithm.initVerify(key);
        signatureAlgorithm.update(this.content);
        return signatureAlgorithm.verify(this.getSignature());
    }

    public Object getObject() throws IOException, ClassNotFoundException {
        ByteArrayInputStream bais = new ByteArrayInputStream(this.content);
        ObjectInputStream ois = new ObjectInputStream(bais);
        return ois.readObject();
    }
}

