/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import com.ibm.oti.text.CompactByteArray;
import com.ibm.oti.util.Msg;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.MissingResourceException;

class BreakDictionary {
    private char[] reverseColumnMap = null;
    private static int supportedVersion = 0;
    private int version;
    private CompactByteArray columnMap = null;
    private int numCols;
    private int numColGroups;
    private short[] table = null;
    private short[] rowIndex = null;
    private int[] rowIndexFlags = null;
    private short[] rowIndexFlagsIndex = null;
    private byte[] rowIndexShifts = null;

    public BreakDictionary(InputStream dictionaryStream) throws IOException {
        this.readDictionaryFile(new DataInputStream(dictionaryStream));
    }

    public void readDictionaryFile(DataInputStream in) throws IOException {
        this.version = in.readInt();
        if (this.version != supportedVersion) {
            throw new MissingResourceException(Msg.getString("K000f", this.version), in.toString(), "");
        }
        int l = in.readInt();
        short[] temp = new short[l];
        int i = 0;
        while (i < temp.length) {
            temp[i] = in.readShort();
            ++i;
        }
        l = in.readInt();
        byte[] temp2 = new byte[l];
        int i2 = 0;
        while (i2 < temp2.length) {
            temp2[i2] = in.readByte();
            ++i2;
        }
        this.columnMap = new CompactByteArray(temp, temp2);
        this.numCols = in.readInt();
        this.numColGroups = in.readInt();
        l = in.readInt();
        this.rowIndex = new short[1];
        i2 = 0;
        while (i2 < this.rowIndex.length) {
            this.rowIndex[i2] = in.readShort();
            ++i2;
        }
        l = in.readInt();
        this.rowIndexFlagsIndex = new short[l];
        i2 = 0;
        while (i2 < this.rowIndexFlagsIndex.length) {
            this.rowIndexFlagsIndex[i2] = in.readShort();
            ++i2;
        }
        l = in.readInt();
        this.rowIndexFlags = new int[1];
        i2 = 0;
        while (i2 < this.rowIndexFlags.length) {
            this.rowIndexFlags[i2] = in.readInt();
            ++i2;
        }
        l = in.readInt();
        this.rowIndexShifts = new byte[1];
        i2 = 0;
        while (i2 < this.rowIndexShifts.length) {
            this.rowIndexShifts[i2] = in.readByte();
            ++i2;
        }
        l = in.readInt();
        this.table = new short[l];
        i2 = 0;
        while (i2 < this.table.length) {
            this.table[i2] = in.readShort();
            ++i2;
        }
        this.reverseColumnMap = new char[this.numCols];
        char c = '\u0000';
        while (c < '\uffff') {
            byte col = this.columnMap.elementAt(c);
            if (col != 0) {
                this.reverseColumnMap[col] = c;
            }
            c = (char)(c + '\u0001');
        }
        in.close();
    }

    public final short at(int row, char ch) {
        byte col = this.columnMap.elementAt(ch);
        return this.at(row, col);
    }

    public final short at(int row, int col) {
        if (this.cellIsPopulated(row, col)) {
            return this.internalAt(this.rowIndex[row], col + this.rowIndexShifts[row]);
        }
        return 0;
    }

    private final boolean cellIsPopulated(int row, int col) {
        if (this.rowIndexFlagsIndex[row] < 0) {
            return col == -this.rowIndexFlagsIndex[row];
        }
        int flags = this.rowIndexFlags[this.rowIndexFlagsIndex[row] + (col >> 5)];
        return (flags & 1 << (col & 0x1F)) != 0;
    }

    private final short internalAt(int row, int col) {
        return this.table[row * this.numCols + col];
    }
}

