/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import com.ibm.oti.locale.Locale;
import com.ibm.oti.util.Msg;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Currency;
import java.util.Vector;

public class DecimalFormat
extends NumberFormat {
    private static final long serialVersionUID = 864413376551465018L;
    private static final String patternChars = "0#.,;%\u2030E";
    private static final char CURRENCY_SYMBOL = '\u00a4';
    private static final int DOUBLE_INTEGER_DIGITS = 309;
    private static final int DOUBLE_FRACTION_DIGITS = 340;
    private byte groupingSize = (byte)3;
    private int multiplier = 1;
    private String positivePrefix = "";
    private String positiveSuffix = "";
    private String negativePrefix = "-";
    private String negativeSuffix = "";
    private String posPrefixPattern;
    private String posSuffixPattern;
    private String negPrefixPattern;
    private String negSuffixPattern;
    private boolean decimalSeparatorAlwaysShown = false;
    private transient boolean posPrefixMonetary = false;
    private transient boolean posSuffixMonetary = false;
    private transient boolean negPrefixMonetary = false;
    private transient boolean negSuffixMonetary = false;
    private DecimalFormatSymbols symbols;
    private boolean useExponentialNotation = false;
    private byte minExponentDigits;
    private int serialVersionOnStream = 2;
    private transient char zero;
    private static final double log10 = Math.log(10.0);

    public DecimalFormat() {
        this(DecimalFormat.getPattern(java.util.Locale.getDefault(), Locale.NUMBER));
    }

    public DecimalFormat(String pattern) {
        this.symbols = new DecimalFormatSymbols();
        this.zero = this.symbols.getZeroDigit();
        this.applyPattern(pattern);
    }

    public DecimalFormat(String pattern, DecimalFormatSymbols value) {
        this.symbols = (DecimalFormatSymbols)value.clone();
        this.zero = this.symbols.getZeroDigit();
        this.applyPattern(pattern);
    }

    public void applyLocalizedPattern(String pattern) {
        this.applyPattern(this.convertPattern(pattern, this.symbols.getLocalPatternChars(), patternChars, false));
    }

    public void applyPattern(String pattern) {
        if (pattern.length() == 0) {
            return;
        }
        int grouping = 0;
        int intCount = 0;
        int minInt = 0;
        int minFraction = 0;
        int maxFraction = 0;
        int multiplier = 1;
        int minExponent = 0;
        boolean inPrefix = true;
        boolean countGrouping = false;
        boolean exponent = false;
        boolean fraction = false;
        boolean negative = false;
        boolean inSuffix = false;
        StringBuffer buffer = new StringBuffer();
        String prefix = "";
        String suffix = "";
        String negPrefix = "";
        String negSuffix = "";
        String format = null;
        boolean quote = false;
        boolean lastQuote = false;
        int patternLength = pattern.length();
        int i = 0;
        while (i < patternLength) {
            char next = pattern.charAt(i);
            if (!(quote || "0#,.".indexOf(next) == -1 && (exponent || inPrefix || inSuffix || next != 'E'))) {
                if (inPrefix) {
                    if (negative) {
                        negPrefix = buffer.toString();
                    } else {
                        prefix = buffer.toString();
                    }
                    buffer.setLength(0);
                    inPrefix = false;
                }
                if (inSuffix) {
                    throw new IllegalArgumentException(Msg.getString("K0014", String.valueOf(next), pattern));
                }
                buffer.append(next);
                if (next == 'E') {
                    exponent = true;
                }
                if (!negative) {
                    switch (next) {
                        case '0': {
                            if (countGrouping) {
                                ++grouping;
                            }
                            if (exponent) {
                                ++minExponent;
                                break;
                            }
                            if (maxFraction > 0) {
                                throw new IllegalArgumentException(Msg.getString("K0015", String.valueOf(next), pattern));
                            }
                            if (fraction) {
                                ++minFraction;
                                break;
                            }
                            ++minInt;
                            break;
                        }
                        case '#': {
                            if (!fraction && minInt > 0 || exponent) {
                                throw new IllegalArgumentException(Msg.getString("K0016", String.valueOf(next), pattern));
                            }
                            if (countGrouping) {
                                ++grouping;
                            }
                            if (fraction) {
                                ++maxFraction;
                                break;
                            }
                            ++intCount;
                            break;
                        }
                        case ',': {
                            if (fraction || exponent) {
                                throw new IllegalArgumentException(Msg.getString("K0016", String.valueOf(next), pattern));
                            }
                            grouping = 0;
                            countGrouping = true;
                            break;
                        }
                        case '.': {
                            if (fraction || exponent) {
                                throw new IllegalArgumentException(Msg.getString("K0016", String.valueOf(next), pattern));
                            }
                            countGrouping = false;
                            fraction = true;
                            break;
                        }
                        case 'E': {
                            countGrouping = false;
                        }
                        default: {
                            break;
                        }
                    }
                }
            } else {
                if (!inPrefix && !inSuffix) {
                    if (!negative) {
                        format = buffer.toString();
                    }
                    buffer.setLength(0);
                }
                if (!inPrefix) {
                    inSuffix = true;
                }
                if (next == '\'') {
                    if (lastQuote) {
                        buffer.append('\'');
                    }
                    quote = !quote;
                    lastQuote = true;
                } else {
                    lastQuote = false;
                    if (next == ';' && !quote) {
                        if (format == null || format.length() == 0) {
                            throw new IllegalArgumentException(Msg.getString("K0017", String.valueOf(next), pattern));
                        }
                        if (exponent && minExponent == 0) {
                            throw new IllegalArgumentException(Msg.getString("K0018", pattern));
                        }
                        suffix = buffer.toString();
                        buffer.setLength(0);
                        inPrefix = true;
                        negative = true;
                        exponent = false;
                        inSuffix = false;
                    } else {
                        if (!(negative || next != '%' && next != '\u2030' || quote)) {
                            if (multiplier != 1) {
                                throw new IllegalArgumentException(Msg.getString("K0016", String.valueOf(next), pattern));
                            }
                            multiplier = next == '%' ? 100 : 1000;
                        }
                        buffer.append(next);
                    }
                }
            }
            ++i;
        }
        if (quote) {
            throw new IllegalArgumentException(Msg.getString("K0019", pattern));
        }
        if (countGrouping && grouping == 0) {
            throw new IllegalArgumentException(Msg.getString("K001a", pattern));
        }
        if (!negative && exponent && minExponent == 0) {
            throw new IllegalArgumentException(Msg.getString("K0018", pattern));
        }
        if (minExponent > 0 && intCount + minInt + minFraction + maxFraction == 0) {
            throw new IllegalArgumentException(Msg.getString("K001b", pattern));
        }
        if (inPrefix) {
            if (negative) {
                negPrefix = buffer.toString();
            } else {
                prefix = buffer.toString();
            }
        }
        if (inSuffix) {
            if (negative) {
                negSuffix = buffer.toString();
            } else {
                suffix = buffer.toString();
            }
        }
        maxFraction += minFraction;
        if (fraction && minFraction == 0 && minInt == 0 && intCount > 0) {
            minInt = 1;
            --intCount;
        } else if (maxFraction > 0 && minInt + intCount == 0 && minFraction == 0) {
            minFraction = 1;
        }
        boolean bl = this.useExponentialNotation = minExponent > 0;
        if (this.useExponentialNotation) {
            this.setMaximumIntegerDigits(intCount + minInt);
        } else {
            this.setMaximumIntegerDigits(Integer.MAX_VALUE);
        }
        this.setMinimumIntegerDigits(minInt);
        this.setMaximumFractionDigits(maxFraction);
        this.setMinimumFractionDigits(minFraction);
        this.setGroupingSize(grouping);
        this.setGroupingUsed(grouping > 0);
        this.setPositivePrefix(prefix.toString());
        this.setPositiveSuffix(suffix.toString());
        this.posPrefixMonetary = this.positivePrefix.indexOf(164) > -1;
        this.posPrefixPattern = this.expandAffix(this.positivePrefix);
        this.posSuffixMonetary = this.positiveSuffix.indexOf(164) > -1;
        this.posSuffixPattern = this.expandAffix(this.positiveSuffix);
        byte by = this.minExponentDigits = (byte)(minExponent > 127 ? 127 : (byte)minExponent);
        if (!negative) {
            negPrefix = String.valueOf(this.symbols.getMinusSign()) + prefix;
            negSuffix = suffix;
        }
        this.setNegativePrefix(negPrefix);
        this.setNegativeSuffix(negSuffix);
        this.negPrefixMonetary = negPrefix.indexOf(164) > -1;
        this.negPrefixPattern = this.expandAffix(negPrefix);
        this.negSuffixMonetary = negSuffix.indexOf(164) > -1;
        this.negSuffixPattern = this.expandAffix(negSuffix);
        this.setDecimalSeparatorAlwaysShown(fraction && (minInt + intCount == 0 || minFraction + maxFraction == 0));
        this.setMultiplier(multiplier);
    }

    public Object clone() {
        DecimalFormat clone = (DecimalFormat)super.clone();
        clone.symbols = (DecimalFormatSymbols)this.symbols.clone();
        return clone;
    }

    private String convertCurrencySymbols(String value) {
        StringBuffer output = null;
        int i = 0;
        while (i < value.length()) {
            char next = value.charAt(i);
            if (next == '\u00a4') {
                if (output == null) {
                    output = new StringBuffer(value.substring(0, i));
                }
                if (i + 1 < value.length() && value.charAt(i + 1) == '\u00a4') {
                    ++i;
                    output.append(this.symbols.getInternationalCurrencySymbol());
                } else {
                    output.append(this.symbols.getCurrencySymbol());
                }
            } else if (output != null) {
                output.append(next);
            }
            ++i;
        }
        if (output == null) {
            return value;
        }
        return output.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DecimalFormat)) {
            return false;
        }
        DecimalFormat format = (DecimalFormat)object;
        return super.equals(object) && this.symbols.equals(format.symbols) && this.groupingSize == format.groupingSize && this.multiplier == format.multiplier && this.positivePrefix.equals(format.positivePrefix) && this.positiveSuffix.equals(format.positiveSuffix) && this.negativePrefix.equals(format.negativePrefix) && this.negativeSuffix.equals(format.negativeSuffix) && this.decimalSeparatorAlwaysShown == format.decimalSeparatorAlwaysShown && this.isCurrency() == format.isCurrency();
    }

    private Number error(ParsePosition position, int offset) {
        position.setErrorIndex(offset);
        return null;
    }

    public AttributedCharacterIterator formatToCharacterIterator(Object object) {
        long lv;
        if (!(object instanceof Number)) {
            throw new IllegalArgumentException();
        }
        StringBuffer buffer = new StringBuffer();
        Vector fields = new Vector();
        double dv = ((Number)object).doubleValue();
        if (dv == (double)(lv = ((Number)object).longValue())) {
            this.formatImpl(lv, buffer, new FieldPosition(0), fields);
        } else {
            this.formatImpl(dv, buffer, new FieldPosition(0), fields);
        }
        AttributedString as = new AttributedString(buffer.toString());
        int i = 0;
        while (i < fields.size()) {
            FieldPosition pos = (FieldPosition)fields.elementAt(i);
            Format.Field attribute = pos.getFieldAttribute();
            as.addAttribute(attribute, attribute, pos.getBeginIndex(), pos.getEndIndex());
            ++i;
        }
        return as.getIterator();
    }

    public StringBuffer format(double value, StringBuffer buffer, FieldPosition position) {
        return this.formatImpl(value, buffer, position, null);
    }

    private StringBuffer formatImpl(double value, StringBuffer buffer, FieldPosition position, Vector fields) {
        if (this.multiplier != 1) {
            value *= (double)this.multiplier;
        }
        position.clear();
        if (Double.isNaN(value)) {
            return buffer.append(this.symbols.getNaN());
        }
        long bits = Double.doubleToLongBits(value);
        String prefix = bits < 0L ? this.getNegativePrefix() : this.getPositivePrefix();
        this.formatPrefixSuffix(prefix, buffer, position, fields);
        FieldPosition positionInteger = null;
        positionInteger = new FieldPosition(NumberFormat.Field.INTEGER);
        this.handleIntegerBegin(buffer.length(), position, fields, positionInteger);
        if (Double.isInfinite(value)) {
            buffer.append(this.symbols.getInfinity());
            this.handleIntegerEnd(buffer.length(), position, fields, positionInteger);
        } else {
            long pow;
            int checkScale;
            double abs = value == 0.0 ? 0.0 : (value < 0.0 ? -value : value);
            boolean fixed = false;
            int scale = 0;
            int exponent = 0;
            int minFract = 0;
            int maxFract = 0;
            if (this.useExponentialNotation) {
                exponent = this.scale(abs);
                minFract = this.getMinimumIntegerDigits() + this.getMinimumFractionDigits();
                boolean bl = fixed = this.getMinimumIntegerDigits() == this.getMaximumIntegerDigits();
                if (fixed) {
                    minFract -= this.getMinimumIntegerDigits();
                    scale = this.getMinimumIntegerDigits() - 1;
                    if (value != 0.0) {
                        exponent -= scale;
                    }
                } else {
                    scale = exponent % this.getMaximumIntegerDigits();
                    if (exponent < -1 && scale + this.getMaximumIntegerDigits() < this.getMaximumIntegerDigits()) {
                        scale += this.getMaximumIntegerDigits();
                    }
                    if (this.getMinimumIntegerDigits() == 0) {
                        --scale;
                    }
                    if (value != 0.0) {
                        exponent -= scale;
                    }
                    if (scale >= 0) {
                        minFract -= scale + 1;
                    }
                }
                if (exponent != 0) {
                    abs /= Math.pow(10.0, exponent);
                }
                maxFract = this.getMaximumIntegerDigits() + this.getMaximumFractionDigits();
                if (scale >= 0) {
                    maxFract -= scale + 1;
                }
            } else {
                scale = this.scale(abs);
                minFract = this.getMinimumFractionDigits();
                maxFract = this.getMaximumFractionDigits();
            }
            if (-maxFract - 1 >= scale - 16) {
                abs += Math.pow(10.0, -maxFract - 1) * 5.0;
            }
            if ((checkScale = this.scale(abs)) > scale) {
                if (this.useExponentialNotation) {
                    if (fixed || this.getMinimumIntegerDigits() == 0) {
                        abs /= 10.0;
                        ++exponent;
                    } else if (scale + 1 == this.getMaximumIntegerDigits() || exponent + this.getMaximumIntegerDigits() == 0 && scale + 2 == this.getMaximumIntegerDigits()) {
                        abs /= Math.pow(10.0, this.getMaximumIntegerDigits());
                        int adjust = (exponent += this.getMaximumIntegerDigits()) == 0 ? -1 : 0;
                        minFract += scale - adjust;
                        maxFract += scale - adjust;
                        scale = adjust;
                    } else {
                        ++scale;
                        --minFract;
                        --maxFract;
                    }
                } else {
                    scale = checkScale;
                }
            }
            int shift = 0;
            String sValue = Double.toString(abs);
            int dLength = sValue.lastIndexOf(69);
            if (dLength > -1) {
                shift = Integer.parseInt(sValue.substring(dLength + 1));
            } else {
                dLength = sValue.length();
            }
            int index = sValue.indexOf(46);
            if (index > -1) {
                String fValue = sValue.substring(index + 1, dLength);
                String iValue = sValue.substring(0, index);
                if (fValue.equals("0")) {
                    sValue = iValue;
                    dLength -= 2;
                } else {
                    shift -= fValue.length();
                    if (iValue.equals("0")) {
                        int i = 0;
                        while (fValue.charAt(i) == '0') {
                            ++i;
                        }
                        sValue = fValue.substring(i);
                        dLength -= i + 2;
                    } else {
                        sValue = String.valueOf(iValue) + fValue;
                        --dLength;
                    }
                }
            } else {
                sValue = sValue.substring(0, dLength);
            }
            long digits = Long.parseLong(sValue);
            int iLength = dLength;
            long number = digits;
            if (shift < 0) {
                if (-shift < dLength) {
                    iLength = dLength + shift;
                    pow = this.intPow(-shift);
                    digits -= (number /= pow) * pow;
                    dLength = -shift;
                } else {
                    number = 0L;
                    iLength = 1;
                }
            } else {
                iLength += shift;
                digits = 0L;
                dLength = 0;
            }
            if (maxFract != 0 && maxFract < dLength) {
                pow = this.intPow(dLength - maxFract);
                digits /= pow;
                shift += dLength - maxFract;
                dLength = maxFract;
            }
            int length = buffer.length();
            StringBuffer output = new StringBuffer();
            if (scale < 0 && !this.useExponentialNotation) {
                this.formatInteger("0", buffer, position, fields);
            } else {
                output.append(Long.toString(number));
                int i = output.length();
                while (i < iLength) {
                    output.append('0');
                    ++i;
                }
                if (this.useExponentialNotation) {
                    i = 0;
                    while (i <= scale) {
                        if (i >= output.length()) {
                            buffer.append(this.zero);
                        } else {
                            buffer.append((char)(this.zero + (output.charAt(i) - 48)));
                        }
                        ++i;
                    }
                } else {
                    this.formatInteger(output.toString(), buffer, position, fields);
                }
            }
            if (maxFract == 0) {
                if (length == buffer.length()) {
                    buffer.append(this.zero);
                }
                this.handleIntegerEnd(buffer.length(), position, fields, positionInteger);
                this.formatFraction(new StringBuffer(), buffer, position, fields);
            } else {
                output.setLength(0);
                int lastDigit = 0;
                int leading = -shift - dLength;
                if (digits > 0L && maxFract > leading) {
                    String print = Long.toString(digits);
                    if (dLength > print.length()) {
                        leading += dLength - print.length();
                    }
                    int i = 0;
                    while (i < leading) {
                        output.append(this.zero);
                        ++i;
                    }
                    i = leading;
                    while (i < maxFract) {
                        int digit = i - leading >= print.length() ? 0 : print.charAt(i - leading) - 48;
                        output.append((char)(this.zero + digit));
                        if (digit > 0) {
                            lastDigit = output.length();
                        }
                        ++i;
                    }
                }
                if (output.length() < minFract) {
                    int i = output.length();
                    while (i < minFract) {
                        output.append(this.zero);
                        ++i;
                    }
                } else {
                    output.setLength(lastDigit < minFract ? minFract : lastDigit);
                }
                if (output.length() == 0 && length == buffer.length()) {
                    buffer.append(this.zero);
                }
                this.handleIntegerEnd(buffer.length(), position, fields, positionInteger);
                this.formatFraction(output, buffer, position, fields);
            }
            if (this.useExponentialNotation) {
                this.formatExponent(exponent, buffer, position, fields);
            }
        }
        String suffix = bits < 0L ? this.getNegativeSuffix() : this.getPositiveSuffix();
        this.formatPrefixSuffix(suffix, buffer, position, fields);
        return buffer;
    }

    public StringBuffer format(long value, StringBuffer buffer, FieldPosition position) {
        return this.formatImpl(value, buffer, position, (Vector)null);
    }

    private StringBuffer formatImpl(long value, StringBuffer buffer, FieldPosition position, Vector fields) {
        StringBuffer output;
        int i;
        if (this.multiplier != 1) {
            int sign = 1;
            if (value < 0L) {
                sign *= -1;
            }
            if (this.multiplier < 0) {
                sign *= -1;
            }
            long oldValue = value;
            if (sign > 0 && oldValue >= (value *= (long)this.multiplier) || sign < 0 && oldValue <= value) {
                return this.formatImpl((double)oldValue, buffer, position, fields);
            }
            double result = (double)value * (double)this.multiplier;
            if (result > 9.223372036854776E18 || result < -9.223372036854776E18) {
                return this.formatImpl((double)value, buffer, position, fields);
            }
        }
        String prefix = value < 0L ? this.getNegativePrefix() : this.getPositivePrefix();
        this.formatPrefixSuffix(prefix, buffer, position, fields);
        FieldPosition positionInteger = null;
        positionInteger = new FieldPosition(NumberFormat.Field.INTEGER);
        this.handleIntegerBegin(buffer.length(), position, fields, positionInteger);
        int outLength = buffer.length();
        String digits = Long.toString(value);
        int exponent = 0;
        int scale = 0;
        int minFract = 0;
        if (this.useExponentialNotation) {
            boolean fixed;
            if (value < 0L) {
                digits = digits.substring(1, digits.length());
            }
            int length = digits.length();
            minFract = this.getMinimumIntegerDigits() + this.getMinimumFractionDigits();
            exponent = length - 1;
            boolean bl = fixed = this.getMinimumIntegerDigits() == this.getMaximumIntegerDigits();
            if (fixed) {
                minFract -= this.getMinimumIntegerDigits();
                scale = this.getMinimumIntegerDigits() - 1;
                if (value != 0L) {
                    exponent -= scale;
                }
                ++scale;
            } else {
                scale = exponent % this.getMaximumIntegerDigits();
                if (value != 0L) {
                    exponent -= scale;
                }
                if (this.getMinimumIntegerDigits() > 0) {
                    ++scale;
                } else if (value != 0L) {
                    ++exponent;
                }
                minFract -= scale;
            }
            if (this.getMaximumIntegerDigits() + this.getMaximumFractionDigits() < length) {
                int chop;
                int i2 = chop = length - (this.getMaximumIntegerDigits() + this.getMaximumFractionDigits()) - 1;
                while (--i2 >= 0) {
                    value /= 10L;
                }
                value = value < 0L ? (value -= 5L) : (value += 5L);
                digits = Long.toString(value);
                if (value < 0L) {
                    digits = digits.substring(1, digits.length());
                }
                int remove = 1;
                if (digits.length() > length - chop) {
                    if (fixed || this.getMinimumIntegerDigits() == 0) {
                        ++remove;
                        ++exponent;
                    } else if (scale == this.getMaximumIntegerDigits()) {
                        exponent += this.getMaximumIntegerDigits();
                        remove += this.getMaximumIntegerDigits();
                        minFract += scale - 1;
                        scale = 1;
                    } else {
                        ++scale;
                        --minFract;
                    }
                }
                digits = digits.substring(0, digits.length() - remove);
            }
            i = 0;
            while (i < scale) {
                if (i >= digits.length()) {
                    buffer.append(this.zero);
                } else {
                    buffer.append((char)(this.zero + (digits.charAt(i) - 48)));
                }
                ++i;
            }
        } else {
            this.formatInteger(digits, buffer, position, fields);
        }
        if (!this.useExponentialNotation && outLength == buffer.length()) {
            buffer.append(this.zero);
        }
        this.handleIntegerEnd(buffer.length(), position, fields, positionInteger);
        if (this.useExponentialNotation) {
            output = new StringBuffer();
            int lastDigit = 0;
            i = 0;
            while (i < digits.length() - scale) {
                int digit = digits.charAt(scale + i) - 48;
                if (digit > 0) {
                    lastDigit = i + 1;
                }
                output.append((char)(this.zero + digit));
                ++i;
            }
            i = output.length();
            while (i < minFract) {
                output.append(this.zero);
                ++i;
            }
            output.setLength(lastDigit < minFract ? minFract : lastDigit);
            this.formatFraction(output, buffer, position, fields);
        } else {
            output = new StringBuffer();
            int i3 = 0;
            while (i3 < this.getMinimumFractionDigits()) {
                output.append(this.zero);
                ++i3;
            }
            this.formatFraction(output, buffer, position, fields);
        }
        if (this.useExponentialNotation) {
            this.formatExponent(exponent, buffer, position, fields);
        }
        String suffix = value < 0L ? this.getNegativeSuffix() : this.getPositiveSuffix();
        this.formatPrefixSuffix(suffix, buffer, position, fields);
        return buffer;
    }

    private void formatPrefixSuffix(String fix, StringBuffer buffer, FieldPosition position, Vector fields) {
        int beginIndex = buffer.length();
        buffer.append(fix);
        if (fix.length() > 0) {
            DecimalFormatSymbols symbols = this.getDecimalFormatSymbols();
            String curSymbol = symbols.getCurrencySymbol();
            int index = fix.indexOf(curSymbol);
            if (index > -1) {
                this.handleField(NumberFormat.Field.CURRENCY, beginIndex + index, beginIndex + index + curSymbol.length(), position, fields);
            }
            if ((index = fix.indexOf(symbols.getMinusSign())) > -1) {
                this.handleField(NumberFormat.Field.SIGN, beginIndex + index, beginIndex + index + 1, position, fields);
            }
            if ((index = fix.indexOf(symbols.getPercent())) > -1) {
                this.handleField(NumberFormat.Field.PERCENT, beginIndex + index, beginIndex + index + 1, position, fields);
            }
            if ((index = fix.indexOf(symbols.getPerMill())) > -1) {
                this.handleField(NumberFormat.Field.PERMILLE, beginIndex + index, beginIndex + index + 1, position, fields);
            }
        }
    }

    private void formatInteger(String output, StringBuffer buffer, FieldPosition position, Vector fields) {
        int offset = 0;
        int total = output.length();
        if (output.charAt(0) == '-') {
            offset = 1;
            --total;
        }
        boolean firstOccurrenceFound = false;
        int groupingSize = this.getGroupingSize();
        if (!this.isGroupingUsed()) {
            groupingSize = 0;
        }
        if (this.getMinimumIntegerDigits() > total) {
            int extra = this.getMinimumIntegerDigits() - total;
            total = this.getMinimumIntegerDigits();
            int i = 0;
            while (i < extra) {
                buffer.append(this.zero);
                if (groupingSize > 0 && --total > 0 && total % groupingSize == 0) {
                    buffer.append(this.symbols.getGroupingSeparator());
                    int index = buffer.length();
                    if (fields != null) {
                        this.addToFields(fields, NumberFormat.Field.GROUPING_SEPARATOR, index - 1, index);
                    } else if (!firstOccurrenceFound && position.getFieldAttribute() == NumberFormat.Field.GROUPING_SEPARATOR) {
                        position.setBeginIndex(index - 1);
                        position.setEndIndex(index);
                        firstOccurrenceFound = true;
                    }
                }
                ++i;
            }
        }
        if (total > this.getMaximumIntegerDigits()) {
            offset += total - this.getMaximumIntegerDigits();
            total = this.getMaximumIntegerDigits();
        }
        if (this.getMinimumIntegerDigits() == 0 && total == 1 && output.charAt(offset) == '0') {
            return;
        }
        int i = offset;
        while (i < output.length()) {
            buffer.append((char)(this.zero + (output.charAt(i) - 48)));
            if (groupingSize > 0 && --total > 0 && total % groupingSize == 0) {
                buffer.append(this.symbols.getGroupingSeparator());
                int index = buffer.length();
                if (fields != null) {
                    this.addToFields(fields, NumberFormat.Field.GROUPING_SEPARATOR, index - 1, index);
                } else if (!firstOccurrenceFound && position.getFieldAttribute() == NumberFormat.Field.GROUPING_SEPARATOR) {
                    position.setBeginIndex(index - 1);
                    position.setEndIndex(index);
                    firstOccurrenceFound = true;
                }
            }
            ++i;
        }
    }

    private void formatFraction(StringBuffer fraction, StringBuffer buffer, FieldPosition position, Vector fields) {
        int index;
        int len = fraction.length();
        if (this.isDecimalSeparatorAlwaysShown() || len > 0) {
            buffer.append(this.getDecimalSeparator());
            index = buffer.length();
            this.handleField(NumberFormat.Field.DECIMAL_SEPARATOR, index - 1, index, position, fields);
        }
        if (len > 0) {
            buffer.append(fraction);
            index = buffer.length();
            if (fields != null) {
                this.addToFields(fields, NumberFormat.Field.FRACTION, index - len, index);
            } else if (position.getFieldAttribute() == NumberFormat.Field.FRACTION || position.getFieldAttribute() == null && position.getField() == 1) {
                position.setBeginIndex(index - len);
                position.setEndIndex(index);
            }
        }
    }

    private void formatExponent(int exponent, StringBuffer buffer, FieldPosition position, Vector fields) {
        int suffixLen;
        int i;
        int prefixLen;
        String output = Integer.toString(exponent);
        int offset = 0;
        int total = output.length();
        buffer.append(this.symbols.getExponential());
        int currentIndex = buffer.length();
        this.handleField(NumberFormat.Field.EXPONENT_SYMBOL, currentIndex - 1, currentIndex, position, fields);
        if (exponent < 0) {
            buffer.append(this.getNegativePrefix());
            offset = 1;
            --total;
        } else {
            buffer.append(this.getPositivePrefix());
        }
        int n = prefixLen = exponent < 0 ? this.getNegativePrefix().length() : this.getPositivePrefix().length();
        if (prefixLen > 0) {
            currentIndex = buffer.length();
            this.handleField(NumberFormat.Field.EXPONENT_SIGN, currentIndex - prefixLen, currentIndex, position, fields);
        }
        if (this.minExponentDigits > total) {
            i = this.minExponentDigits - total;
            while (--i >= 0) {
                buffer.append(this.zero);
            }
        }
        i = offset;
        while (i < output.length()) {
            buffer.append((char)(this.zero + (output.charAt(i) - 48)));
            ++i;
        }
        this.handleField(NumberFormat.Field.EXPONENT, currentIndex, buffer.length(), position, fields);
        if (exponent < 0) {
            buffer.append(this.getNegativeSuffix());
        } else {
            buffer.append(this.getPositiveSuffix());
        }
        int n2 = suffixLen = exponent < 0 ? this.getNegativeSuffix().length() : this.getPositiveSuffix().length();
        if (suffixLen > 0) {
            currentIndex = buffer.length();
            this.handleField(NumberFormat.Field.EXPONENT_SIGN, currentIndex - suffixLen, currentIndex, position, fields);
        }
    }

    private void handleField(NumberFormat.Field field, int begin, int end, FieldPosition position, Vector fields) {
        if (fields != null) {
            this.addToFields(fields, field, begin, end);
        } else if (position.getFieldAttribute() == field) {
            position.setBeginIndex(begin);
            position.setEndIndex(end);
        }
    }

    private void addToFields(Vector fields, NumberFormat.Field field, int begin, int end) {
        FieldPosition pos = new FieldPosition(field);
        pos.setBeginIndex(begin);
        pos.setEndIndex(end);
        fields.add(pos);
    }

    private void handleIntegerBegin(int index, FieldPosition position, Vector fields, FieldPosition positionInteger) {
        if (fields != null) {
            positionInteger.setBeginIndex(index);
        } else if (position.getFieldAttribute() == NumberFormat.Field.INTEGER || position.getFieldAttribute() == null && position.getField() == 0) {
            position.setBeginIndex(index);
        }
    }

    private void handleIntegerEnd(int index, FieldPosition position, Vector fields, FieldPosition positionInteger) {
        if (fields != null) {
            positionInteger.setEndIndex(index);
            fields.add(positionInteger);
        } else if (position.getFieldAttribute() == NumberFormat.Field.INTEGER || position.getFieldAttribute() == null && position.getField() == 0) {
            position.setEndIndex(index);
        }
    }

    public DecimalFormatSymbols getDecimalFormatSymbols() {
        return (DecimalFormatSymbols)this.symbols.clone();
    }

    private char getDecimalSeparator() {
        if (this.isCurrency()) {
            return this.symbols.getMonetaryDecimalSeparator();
        }
        return this.symbols.getDecimalSeparator();
    }

    public Currency getCurrency() {
        return this.symbols.getCurrency();
    }

    public int getGroupingSize() {
        return this.groupingSize;
    }

    public int getMultiplier() {
        return this.multiplier;
    }

    public String getNegativePrefix() {
        return this.negPrefixPattern == null ? this.negativePrefix : this.negPrefixPattern;
    }

    public String getNegativeSuffix() {
        return this.negSuffixPattern == null ? this.negativeSuffix : this.negSuffixPattern;
    }

    public String getPositivePrefix() {
        return this.posPrefixPattern == null ? this.positivePrefix : this.posPrefixPattern;
    }

    public String getPositiveSuffix() {
        return this.posSuffixPattern == null ? this.positiveSuffix : this.posSuffixPattern;
    }

    public int hashCode() {
        return super.hashCode() + this.symbols.hashCode() + this.groupingSize + this.multiplier + this.positivePrefix.hashCode() + this.positiveSuffix.hashCode() + this.negativePrefix.hashCode() + this.negativeSuffix.hashCode() + (this.decimalSeparatorAlwaysShown ? 1231 : 1237) + (this.isCurrency() ? 1231 : 1237);
    }

    private boolean isCurrency() {
        return this.posPrefixMonetary || this.posSuffixMonetary || this.negPrefixMonetary || this.negSuffixMonetary;
    }

    public boolean isDecimalSeparatorAlwaysShown() {
        return this.decimalSeparatorAlwaysShown;
    }

    private int parseExponent(String string, ParsePosition position) {
        String negSuffix;
        String negPrefix;
        int sign = 0;
        int offset = position.getIndex();
        position.setIndex(-1);
        String posPrefix = this.posPrefixPattern != null ? this.posPrefixPattern : this.positivePrefix;
        String string2 = negPrefix = this.negPrefixPattern != null ? this.negPrefixPattern : this.negativePrefix;
        if (posPrefix.length() != 0 && string.startsWith(posPrefix, offset)) {
            sign = 1;
            offset += posPrefix.length();
        } else if (negPrefix.length() != 0 && string.startsWith(negPrefix, offset)) {
            sign = -1;
            offset += negPrefix.length();
        } else if (posPrefix.length() != 0 && negPrefix.length() != 0) {
            return 0;
        }
        boolean overflow = false;
        int number = 0;
        int lastOffset = offset;
        int length = string.length();
        while (offset < length) {
            char ch = string.charAt(offset);
            int value = this.getDigit(ch);
            if (value == -1) break;
            int next = number * 10 - value;
            if (next > number) {
                overflow = true;
            }
            number = next;
            ++offset;
        }
        if (offset == lastOffset) {
            return 0;
        }
        String posSuffix = this.posSuffixPattern != null ? this.posSuffixPattern : this.positiveSuffix;
        String string3 = negSuffix = this.negSuffixPattern != null ? this.negSuffixPattern : this.negativeSuffix;
        if (sign >= 0) {
            if (posSuffix.length() == 0) {
                position.setIndex(offset);
                sign = 1;
            } else if (string.startsWith(posSuffix, offset)) {
                position.setIndex(offset + posSuffix.length());
                sign = 1;
            } else if (sign == 1) {
                return 0;
            }
        }
        if (sign <= 0) {
            if (negSuffix.length() == 0) {
                position.setIndex(offset);
                sign = -1;
            } else if (string.startsWith(negSuffix, offset)) {
                position.setIndex(offset + negSuffix.length());
                sign = -1;
            } else {
                return 0;
            }
        }
        if (sign != -1 && (number = -number) < 0) {
            overflow = true;
        }
        if (overflow) {
            return 1024;
        }
        return number;
    }

    public Number parse(String string, ParsePosition position) {
        String negSuffix;
        int offset = position.getIndex();
        if (offset < 0) {
            return this.error(position, offset);
        }
        if (string.startsWith(this.symbols.getNaN(), offset)) {
            position.setIndex(offset + this.symbols.getNaN().length());
            return new Double(Double.NaN);
        }
        int sign = 0;
        String posPrefix = this.posPrefixPattern != null ? this.posPrefixPattern : this.positivePrefix;
        String negPrefix = this.negPrefixPattern != null ? this.negPrefixPattern : this.negativePrefix;
        boolean posPre = string.startsWith(posPrefix, offset);
        if (posPrefix.equals(negPrefix)) {
            if (!posPre) {
                return this.error(position, offset);
            }
            offset += posPrefix.length();
        } else {
            boolean negPre = string.startsWith(negPrefix, offset);
            if (posPre || negPre) {
                if (posPre && negPre) {
                    if (negPrefix.length() > posPrefix.length()) {
                        posPre = false;
                    } else {
                        negPre = false;
                    }
                }
                if (posPre) {
                    sign = 1;
                    offset += posPrefix.length();
                } else if (negPre) {
                    sign = -1;
                    offset += negPrefix.length();
                }
            } else {
                return this.error(position, offset);
            }
        }
        double dnumber = 0.0;
        long max = -922337203685477580L;
        boolean overflow = false;
        boolean useFloat = false;
        long number = 0L;
        long fraction = 0L;
        int length = string.length();
        int lastValid = -1;
        int decimalDigits = 0;
        int fractionDigits = 0;
        int exponent = 0;
        if (string.startsWith(this.symbols.getInfinity(), offset)) {
            lastValid = offset += this.symbols.getInfinity().length();
            dnumber = Double.POSITIVE_INFINITY;
        } else {
            boolean digits = false;
            while (offset < length) {
                char ch = string.charAt(offset);
                if (ch == this.getDecimalSeparator()) {
                    if (this.isParseIntegerOnly()) break;
                    lastValid = ++offset;
                    StringBuffer fractDigits = new StringBuffer();
                    while (offset < length) {
                        ch = string.charAt(offset);
                        if (this.getDigit(ch) == -1) break;
                        fractDigits.append(ch);
                        lastValid = ++offset;
                    }
                    int len = fractDigits.length() - 1;
                    while (len >= 0 && this.getDigit(fractDigits.charAt(len)) == 0) {
                        digits = true;
                        --len;
                    }
                    int i = 0;
                    while (i <= len) {
                        digits = true;
                        int value = this.getDigit(fractDigits.charAt(i));
                        if (!overflow) {
                            if (max > fraction) {
                                overflow = true;
                                break;
                            }
                            long next = fraction * 10L - (long)value;
                            if (next <= fraction) {
                                fraction = next;
                                ++fractionDigits;
                            } else {
                                overflow = true;
                                break;
                            }
                        }
                        ++i;
                    }
                    if (ch != this.symbols.getExponential()) break;
                    ParsePosition pos = new ParsePosition(offset + 1);
                    exponent = this.parseExponent(string, pos);
                    if (pos.getIndex() == -1) break;
                    lastValid = pos.getIndex();
                    break;
                }
                int value = this.getDigit(ch);
                if (value != -1) {
                    digits = true;
                    if (number != 0L || value > 0) {
                        ++decimalDigits;
                        if (useFloat) {
                            dnumber = dnumber * 10.0 - (double)value;
                        } else if (max <= number) {
                            long next = number * 10L - (long)value;
                            if (next > number) {
                                dnumber = (double)number * 10.0 - (double)value;
                                useFloat = true;
                            } else {
                                number = next;
                            }
                        } else {
                            dnumber = (double)number * 10.0 - (double)value;
                            useFloat = true;
                        }
                    }
                    lastValid = offset + 1;
                } else {
                    if (ch == this.symbols.getExponential()) {
                        ParsePosition pos = new ParsePosition(offset + 1);
                        exponent = this.parseExponent(string, pos);
                        if (pos.getIndex() == -1) break;
                        lastValid = pos.getIndex();
                        break;
                    }
                    if (ch != this.symbols.getGroupingSeparator() || !this.isGroupingUsed()) break;
                }
                ++offset;
            }
            if (!digits) {
                return this.error(position, position.getIndex());
            }
        }
        String posSuffix = this.posSuffixPattern != null ? this.posSuffixPattern : this.positiveSuffix;
        String string2 = negSuffix = this.negSuffixPattern != null ? this.negSuffixPattern : this.negativeSuffix;
        if (sign == 0) {
            boolean negSuf;
            boolean posSuf = posSuffix.length() > 0 && string.startsWith(posSuffix, offset);
            boolean bl = negSuf = negSuffix.length() > 0 && string.startsWith(negSuffix, offset);
            if (posSuf != negSuf) {
                sign = posSuf ? 1 : -1;
            } else if (posSuffix.equals(negSuffix)) {
                return this.error(position, lastValid);
            }
        }
        if (sign >= 0) {
            if (posSuffix.length() == 0) {
                position.setIndex(lastValid);
                sign = 1;
            } else if (offset == lastValid && string.startsWith(posSuffix, offset)) {
                position.setIndex(offset + posSuffix.length());
                sign = 1;
            } else if (sign == 1) {
                return this.error(position, lastValid);
            }
        }
        if (sign <= 0) {
            if (negSuffix.length() == 0) {
                position.setIndex(lastValid);
                sign = -1;
            } else if (offset == lastValid && string.startsWith(negSuffix, offset)) {
                position.setIndex(offset + negSuffix.length());
                sign = -1;
            } else {
                return this.error(position, lastValid);
            }
        }
        if (!useFloat && (fraction != 0L && exponent == 0 || exponent < 0 || exponent + decimalDigits - 1 > 19 || exponent < fractionDigits || overflow)) {
            dnumber = number;
            useFloat = true;
        }
        if (!useFloat && number != 0L) {
            long next = number;
            int i = exponent;
            while (--i >= 0) {
                if (max > next) {
                    dnumber = number;
                    useFloat = true;
                    break;
                }
                next *= 10L;
            }
            number = next;
        }
        if (fraction != 0L && !useFloat) {
            long next = fraction;
            int i = exponent - fractionDigits;
            while (--i >= 0) {
                next *= 10L;
            }
            long result = number + next;
            if (next < number) {
                number = result;
            } else {
                dnumber = number;
                exponent = 0;
                fraction = next;
                fractionDigits = 0;
                useFloat = true;
            }
        }
        if (useFloat) {
            if (fraction != 0L) {
                dnumber += (double)fraction / Math.pow(10.0, fractionDigits);
            }
            if (exponent != 0) {
                dnumber *= Math.pow(10.0, exponent);
            }
        }
        if (!useFloat && number == 0L && sign == -1 && !this.isParseIntegerOnly()) {
            dnumber = -0.0;
            useFloat = true;
        }
        if (this.multiplier != 1) {
            if (dnumber != 0.0) {
                dnumber /= (double)this.multiplier;
            } else {
                double dResult = (double)number / (double)this.multiplier;
                long remainder = number % (long)this.multiplier;
                long lResult = number / (long)this.multiplier + Math.round((double)remainder / (double)this.multiplier);
                if (dResult == (double)lResult) {
                    number = lResult;
                } else {
                    dnumber = dResult;
                    useFloat = true;
                }
            }
        }
        if (number == Long.MIN_VALUE && sign == 1) {
            dnumber = number;
            useFloat = true;
        }
        if (useFloat) {
            return new Double(sign < 0 ? dnumber : -dnumber);
        }
        return new Long(sign < 0 ? number : -number);
    }

    private String quote(String string, String special) {
        int i = 0;
        while (i < special.length()) {
            char ch = special.charAt(i);
            if (string.indexOf(ch) != -1 && (i < 5 || ch != patternChars.charAt(i))) {
                return String.valueOf('\'') + string + '\'';
            }
            ++i;
        }
        return string;
    }

    private int scale(double value) {
        if (value == 0.0) {
            return 0;
        }
        int scale = (int)Math.floor(Math.log(value) / log10);
        return Math.pow(10.0, scale) > value ? scale - 1 : scale;
    }

    private String expandAffix(String affix) {
        String newAffix = this.convertPattern(affix, patternChars, new String(this.symbols.patternChars), false);
        return this.convertCurrencySymbols(newAffix);
    }

    public void setDecimalFormatSymbols(DecimalFormatSymbols value) {
        if (value != null) {
            this.symbols = (DecimalFormatSymbols)value.clone();
            this.zero = this.symbols.getZeroDigit();
            if (this.posPrefixPattern != null) {
                this.posPrefixPattern = this.expandAffix(this.positivePrefix);
            }
            if (this.posSuffixPattern != null) {
                this.posSuffixPattern = this.expandAffix(this.positiveSuffix);
            }
            if (this.negPrefixPattern != null) {
                this.negPrefixPattern = this.expandAffix(this.negativePrefix);
            }
            if (this.negSuffixPattern != null) {
                this.negSuffixPattern = this.expandAffix(this.negativeSuffix);
            }
        }
    }

    public void setCurrency(Currency currency) {
        this.symbols.setCurrency(currency);
    }

    public void setDecimalSeparatorAlwaysShown(boolean value) {
        this.decimalSeparatorAlwaysShown = value;
    }

    public void setGroupingSize(int value) {
        this.groupingSize = (byte)value;
    }

    public void setMaximumFractionDigits(int value) {
        super.setMaximumFractionDigits(value > 340 ? 340 : value);
    }

    public void setMaximumIntegerDigits(int value) {
        super.setMaximumIntegerDigits(value > 309 ? 309 : value);
    }

    public void setMinimumFractionDigits(int value) {
        super.setMinimumFractionDigits(value > 340 ? 340 : value);
    }

    public void setMinimumIntegerDigits(int value) {
        super.setMinimumIntegerDigits(value > 309 ? 309 : value);
    }

    public void setMultiplier(int value) {
        this.multiplier = value;
    }

    public void setNegativePrefix(String value) {
        this.negativePrefix = value;
        this.negPrefixMonetary = false;
        this.negPrefixPattern = null;
    }

    public void setNegativeSuffix(String value) {
        this.negativeSuffix = value;
        this.negSuffixMonetary = false;
        this.negSuffixPattern = null;
    }

    public void setPositivePrefix(String value) {
        this.positivePrefix = value;
        this.posPrefixMonetary = false;
        this.posPrefixPattern = null;
    }

    public void setPositiveSuffix(String value) {
        this.positiveSuffix = value;
        this.posSuffixMonetary = false;
        this.posSuffixPattern = null;
    }

    public String toLocalizedPattern() {
        return this.toPatternString(this.symbols.getLocalPatternChars());
    }

    public String toPattern() {
        return this.toPatternString(patternChars);
    }

    private String toPatternString(String localPatternChars) {
        int i;
        boolean groupingUsed;
        StringBuffer pattern = new StringBuffer();
        boolean bl = groupingUsed = this.isGroupingUsed() && this.getGroupingSize() > 0;
        if (!groupingUsed || this.groupingSize > this.getMinimumIntegerDigits()) {
            if (groupingUsed) {
                if (this.useExponentialNotation) {
                    i = 0;
                    while (i < this.getMaximumIntegerDigits() - this.groupingSize - 1) {
                        pattern.append('#');
                        ++i;
                    }
                }
                pattern.append("#,");
                i = 0;
                while (i < this.groupingSize - this.getMinimumIntegerDigits()) {
                    pattern.append('#');
                    ++i;
                }
            } else if (this.useExponentialNotation) {
                i = 0;
                while (i < this.getMaximumIntegerDigits() - this.getMinimumIntegerDigits()) {
                    pattern.append('#');
                    ++i;
                }
            } else {
                pattern.append('#');
            }
            i = 0;
            while (i < this.getMinimumIntegerDigits()) {
                pattern.append('0');
                ++i;
            }
        } else {
            if (this.useExponentialNotation) {
                i = 0;
                while (i < this.getMaximumIntegerDigits() - this.getMinimumIntegerDigits()) {
                    pattern.append('#');
                    ++i;
                }
            } else {
                pattern.append('#');
            }
            i = 0;
            while (i < this.getMinimumIntegerDigits() - this.groupingSize) {
                pattern.append('0');
                ++i;
            }
            pattern.append(',');
            i = 0;
            while (i < this.groupingSize) {
                pattern.append('0');
                ++i;
            }
        }
        if (this.getMaximumFractionDigits() > 0 || this.isDecimalSeparatorAlwaysShown()) {
            pattern.append('.');
            i = 0;
            while (i < this.getMinimumFractionDigits()) {
                pattern.append('0');
                ++i;
            }
            i = 0;
            while (i < this.getMaximumFractionDigits() - this.getMinimumFractionDigits()) {
                pattern.append('#');
                ++i;
            }
        }
        if (this.useExponentialNotation) {
            pattern.append('E');
            i = 0;
            while (i < this.minExponentDigits) {
                pattern.append('0');
                ++i;
            }
        }
        String localPattern = pattern.toString();
        String result = String.valueOf(this.quote(this.positivePrefix, localPatternChars)) + localPattern + this.quote(this.positiveSuffix, localPatternChars);
        if (!this.negativePrefix.equals(String.valueOf(this.symbols.getMinusSign()) + this.positivePrefix) || !this.negativeSuffix.equals(this.positiveSuffix)) {
            result = String.valueOf(result) + ';' + this.quote(this.negativePrefix, localPatternChars) + localPattern + this.quote(this.negativeSuffix, localPatternChars);
        }
        if (localPatternChars != patternChars) {
            result = this.convertPattern(result, patternChars, localPatternChars, false);
        }
        return result;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this.serialVersionOnStream == 0) {
            this.useExponentialNotation = false;
        }
        this.zero = this.symbols.getZeroDigit();
        this.serialVersionOnStream = 2;
        if (this.posPrefixPattern != null) {
            boolean bl = this.posPrefixMonetary = this.positivePrefix.indexOf(164) > -1;
        }
        if (this.posSuffixPattern != null) {
            boolean bl = this.posSuffixMonetary = this.positiveSuffix.indexOf(164) > -1;
        }
        if (this.negPrefixPattern != null) {
            boolean bl = this.negPrefixMonetary = this.negativePrefix.indexOf(164) > -1;
        }
        if (this.negSuffixPattern != null) {
            boolean bl = this.negSuffixMonetary = this.negativeSuffix.indexOf(164) > -1;
        }
        if (this.getMinimumIntegerDigits() > 309 || this.getMaximumIntegerDigits() > 309 || this.getMinimumFractionDigits() > 340 || this.getMaximumFractionDigits() > 340) {
            throw new InvalidObjectException(Msg.getString("K00f9"));
        }
    }

    long intPow(int exp) {
        long result = 1L;
        int i = 0;
        while (i < exp) {
            result *= 10L;
            ++i;
        }
        return result;
    }

    int getDigit(char ch) {
        int diff = ch - this.zero;
        if (diff >= 0 && diff <= 9) {
            return diff;
        }
        return Character.digit(ch, 10);
    }
}

