/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Comparator;
import java.util.List;
import java.util.RandomAccess;

public class Arrays {
    private Arrays() {
    }

    public static List asList(Object[] array) {
        return new ArrayList(array);
    }

    public static int binarySearch(byte[] array, byte value) {
        int low = 0;
        int mid = -1;
        int high = array.length - 1;
        while (low <= high) {
            mid = low + high >> 1;
            if (value > array[mid]) {
                low = mid + 1;
                continue;
            }
            if (value == array[mid]) {
                return mid;
            }
            high = mid - 1;
        }
        if (mid < 0) {
            return -1;
        }
        return -mid - (value < array[mid] ? 1 : 2);
    }

    public static int binarySearch(char[] array, char value) {
        int low = 0;
        int mid = -1;
        int high = array.length - 1;
        while (low <= high) {
            mid = low + high >> 1;
            if (value > array[mid]) {
                low = mid + 1;
                continue;
            }
            if (value == array[mid]) {
                return mid;
            }
            high = mid - 1;
        }
        if (mid < 0) {
            return -1;
        }
        return -mid - (value < array[mid] ? 1 : 2);
    }

    public static int binarySearch(double[] array, double value) {
        long longBits = Double.doubleToLongBits(value);
        int low = 0;
        int mid = -1;
        int high = array.length - 1;
        while (low <= high) {
            mid = low + high >> 1;
            if (Arrays.lessThan(array[mid], value)) {
                low = mid + 1;
                continue;
            }
            if (longBits == Double.doubleToLongBits(array[mid])) {
                return mid;
            }
            high = mid - 1;
        }
        if (mid < 0) {
            return -1;
        }
        return -mid - (Arrays.lessThan(value, array[mid]) ? 1 : 2);
    }

    public static int binarySearch(float[] array, float value) {
        int intBits = Float.floatToIntBits(value);
        int low = 0;
        int mid = -1;
        int high = array.length - 1;
        while (low <= high) {
            mid = low + high >> 1;
            if (Arrays.lessThan(array[mid], value)) {
                low = mid + 1;
                continue;
            }
            if (intBits == Float.floatToIntBits(array[mid])) {
                return mid;
            }
            high = mid - 1;
        }
        if (mid < 0) {
            return -1;
        }
        return -mid - (Arrays.lessThan(value, array[mid]) ? 1 : 2);
    }

    public static int binarySearch(int[] array, int value) {
        int low = 0;
        int mid = -1;
        int high = array.length - 1;
        while (low <= high) {
            mid = low + high >> 1;
            if (value > array[mid]) {
                low = mid + 1;
                continue;
            }
            if (value == array[mid]) {
                return mid;
            }
            high = mid - 1;
        }
        if (mid < 0) {
            return -1;
        }
        return -mid - (value < array[mid] ? 1 : 2);
    }

    public static int binarySearch(long[] array, long value) {
        int low = 0;
        int mid = -1;
        int high = array.length - 1;
        while (low <= high) {
            mid = low + high >> 1;
            if (value > array[mid]) {
                low = mid + 1;
                continue;
            }
            if (value == array[mid]) {
                return mid;
            }
            high = mid - 1;
        }
        if (mid < 0) {
            return -1;
        }
        return -mid - (value < array[mid] ? 1 : 2);
    }

    public static int binarySearch(Object[] array, Object object) {
        Comparable key = (Comparable)object;
        int low = 0;
        int mid = 0;
        int high = array.length - 1;
        int result = 0;
        while (low <= high) {
            mid = low + high >> 1;
            result = key.compareTo(array[mid]);
            if (result > 0) {
                low = mid + 1;
                continue;
            }
            if (result == 0) {
                return mid;
            }
            high = mid - 1;
        }
        return -mid - (result <= 0 ? 1 : 2);
    }

    public static int binarySearch(Object[] array, Object object, Comparator comparator) {
        int low = 0;
        int mid = 0;
        int high = array.length - 1;
        int result = 0;
        while (low <= high) {
            mid = low + high >> 1;
            result = comparator.compare(array[mid], object);
            if (result < 0) {
                low = mid + 1;
                continue;
            }
            if (result == 0) {
                return mid;
            }
            high = mid - 1;
        }
        return -mid - (result >= 0 ? 1 : 2);
    }

    public static int binarySearch(short[] array, short value) {
        int low = 0;
        int mid = -1;
        int high = array.length - 1;
        while (low <= high) {
            mid = low + high >> 1;
            if (value > array[mid]) {
                low = mid + 1;
                continue;
            }
            if (value == array[mid]) {
                return mid;
            }
            high = mid - 1;
        }
        if (mid < 0) {
            return -1;
        }
        return -mid - (value < array[mid] ? 1 : 2);
    }

    public static void fill(byte[] array, byte value) {
        Arrays.fillImpl(array, 0, array.length, value);
    }

    public static void fill(byte[] array, int start, int end, byte value) {
        Arrays.fillImpl(array, start, end, value);
    }

    private static native void fillImpl(byte[] var0, int var1, int var2, byte var3);

    public static void fill(short[] array, short value) {
        Arrays.fillImpl(array, 0, array.length, value);
    }

    public static void fill(short[] array, int start, int end, short value) {
        Arrays.fillImpl(array, start, end, value);
    }

    private static native void fillImpl(short[] var0, int var1, int var2, short var3);

    public static void fill(char[] array, char value) {
        Arrays.fillImpl(array, 0, array.length, value);
    }

    public static void fill(char[] array, int start, int end, char value) {
        Arrays.fillImpl(array, start, end, value);
    }

    private static native void fillImpl(char[] var0, int var1, int var2, char var3);

    public static void fill(int[] array, int value) {
        Arrays.fillImpl(array, 0, array.length, value);
    }

    public static void fill(int[] array, int start, int end, int value) {
        Arrays.fillImpl(array, start, end, value);
    }

    private static native void fillImpl(int[] var0, int var1, int var2, int var3);

    public static void fill(long[] array, long value) {
        Arrays.fillImpl(array, 0, array.length, value);
    }

    public static void fill(long[] array, int start, int end, long value) {
        Arrays.fillImpl(array, start, end, value);
    }

    private static native void fillImpl(long[] var0, int var1, int var2, long var3);

    public static void fill(float[] array, float value) {
        Arrays.fillImpl(array, 0, array.length, value);
    }

    public static void fill(float[] array, int start, int end, float value) {
        Arrays.fillImpl(array, start, end, value);
    }

    private static native void fillImpl(float[] var0, int var1, int var2, float var3);

    public static void fill(double[] array, double value) {
        Arrays.fillImpl(array, 0, array.length, value);
    }

    public static void fill(double[] array, int start, int end, double value) {
        Arrays.fillImpl(array, start, end, value);
    }

    private static native void fillImpl(double[] var0, int var1, int var2, double var3);

    public static void fill(boolean[] array, boolean value) {
        Arrays.fillImpl(array, 0, array.length, value);
    }

    public static void fill(boolean[] array, int start, int end, boolean value) {
        Arrays.fillImpl(array, start, end, value);
    }

    private static native void fillImpl(boolean[] var0, int var1, int var2, boolean var3);

    public static void fill(Object[] array, Object value) {
        Arrays.fillImpl(array, 0, array.length, value);
    }

    public static void fill(Object[] array, int start, int end, Object value) {
        Arrays.fillImpl(array, start, end, value);
    }

    private static native void fillImpl(Object[] var0, int var1, int var2, Object var3);

    public static boolean equals(byte[] array1, byte[] array2) {
        return Arrays.equalsImpl(array1, array2);
    }

    private static native boolean equalsImpl(byte[] var0, byte[] var1);

    public static boolean equals(short[] array1, short[] array2) {
        return Arrays.equalsImpl(array1, array2);
    }

    private static native boolean equalsImpl(short[] var0, short[] var1);

    public static boolean equals(char[] array1, char[] array2) {
        return Arrays.equalsImpl(array1, array2);
    }

    private static native boolean equalsImpl(char[] var0, char[] var1);

    public static boolean equals(int[] array1, int[] array2) {
        return Arrays.equalsImpl(array1, array2);
    }

    private static native boolean equalsImpl(int[] var0, int[] var1);

    public static boolean equals(long[] array1, long[] array2) {
        return Arrays.equalsImpl(array1, array2);
    }

    private static native boolean equalsImpl(long[] var0, long[] var1);

    public static boolean equals(float[] array1, float[] array2) {
        if (array1 == array2) {
            return true;
        }
        if (array1 == null || array2 == null || array1.length != array2.length) {
            return false;
        }
        int i = 0;
        while (i < array1.length) {
            if (Float.floatToIntBits(array1[i]) != Float.floatToIntBits(array2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equals(double[] array1, double[] array2) {
        if (array1 == array2) {
            return true;
        }
        if (array1 == null || array2 == null || array1.length != array2.length) {
            return false;
        }
        int i = 0;
        while (i < array1.length) {
            if (Double.doubleToLongBits(array1[i]) != Double.doubleToLongBits(array2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equals(boolean[] array1, boolean[] array2) {
        return Arrays.equalsImpl(array1, array2);
    }

    private static native boolean equalsImpl(boolean[] var0, boolean[] var1);

    public static boolean equals(Object[] array1, Object[] array2) {
        if (array1 == array2) {
            return true;
        }
        if (array1 == null || array2 == null || array1.length != array2.length) {
            return false;
        }
        int i = 0;
        while (i < array1.length) {
            Object e1 = array1[i];
            Object e2 = array2[i];
            if (e1 == null ? e2 != null : !e1.equals(e2)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static int med3(byte[] array, int a, int b, int c) {
        byte x = array[a];
        byte y = array[b];
        byte z = array[c];
        return x < y ? (y < z ? b : (x < z ? c : a)) : (y > z ? b : (x > z ? c : a));
    }

    private static int med3(char[] array, int a, int b, int c) {
        char x = array[a];
        char y = array[b];
        char z = array[c];
        return x < y ? (y < z ? b : (x < z ? c : a)) : (y > z ? b : (x > z ? c : a));
    }

    private static boolean lessThan(double double1, double double2) {
        long NaNbits = Double.doubleToLongBits(Double.NaN);
        long d1 = Double.doubleToLongBits(double1);
        if (d1 == NaNbits) {
            return false;
        }
        long d2 = Double.doubleToLongBits(double2);
        if (d2 == NaNbits) {
            return true;
        }
        if (double1 == double2) {
            if (d1 == d2) {
                return false;
            }
            return d1 < d2;
        }
        return double1 < double2;
    }

    private static int med3(double[] array, int a, int b, int c) {
        double x = array[a];
        double y = array[b];
        double z = array[c];
        return Arrays.lessThan(x, y) ? (Arrays.lessThan(y, z) ? b : (Arrays.lessThan(x, z) ? c : a)) : (Arrays.lessThan(z, y) ? b : (Arrays.lessThan(z, x) ? c : a));
    }

    private static boolean lessThan(float float1, float float2) {
        int NaNbits = Float.floatToIntBits(Float.NaN);
        int f1 = Float.floatToIntBits(float1);
        if (f1 == NaNbits) {
            return false;
        }
        int f2 = Float.floatToIntBits(float2);
        if (f2 == NaNbits) {
            return true;
        }
        if (float1 == float2) {
            if (f1 == f2) {
                return false;
            }
            return f1 < f2;
        }
        return float1 < float2;
    }

    private static int med3(float[] array, int a, int b, int c) {
        float x = array[a];
        float y = array[b];
        float z = array[c];
        return Arrays.lessThan(x, y) ? (Arrays.lessThan(y, z) ? b : (Arrays.lessThan(x, z) ? c : a)) : (Arrays.lessThan(z, y) ? b : (Arrays.lessThan(z, x) ? c : a));
    }

    private static int med3(int[] array, int a, int b, int c) {
        int x = array[a];
        int y = array[b];
        int z = array[c];
        return x < y ? (y < z ? b : (x < z ? c : a)) : (y > z ? b : (x > z ? c : a));
    }

    private static int med3(long[] array, int a, int b, int c) {
        long x = array[a];
        long y = array[b];
        long z = array[c];
        return x < y ? (y < z ? b : (x < z ? c : a)) : (y > z ? b : (x > z ? c : a));
    }

    private static int med3(short[] array, int a, int b, int c) {
        short x = array[a];
        short y = array[b];
        short z = array[c];
        return x < y ? (y < z ? b : (x < z ? c : a)) : (y > z ? b : (x > z ? c : a));
    }

    public static void sort(byte[] array) {
        Arrays.sort(0, array.length, array);
    }

    public static void sort(byte[] array, int start, int end) {
        if (start >= 0 && end <= array.length) {
            if (start > end) {
                throw new IllegalArgumentException();
            }
        } else {
            throw new ArrayIndexOutOfBoundsException();
        }
        Arrays.sort(start, end, array);
    }

    private static void sort(int start, int end, byte[] array) {
        byte temp;
        int d;
        int b;
        int length = end - start;
        if (length < 7) {
            int i = start + 1;
            while (i < end) {
                int j = i;
                while (j > start && array[j - 1] > array[j]) {
                    byte temp2 = array[j];
                    array[j] = array[j - 1];
                    array[j - 1] = temp2;
                    --j;
                }
                ++i;
            }
            return;
        }
        int middle = (start + end) / 2;
        if (length > 7) {
            int bottom = start;
            int top = end - 1;
            if (length > 40) {
                bottom = Arrays.med3(array, bottom, bottom + (length /= 8), bottom + 2 * length);
                middle = Arrays.med3(array, middle - length, middle, middle + length);
                top = Arrays.med3(array, top - 2 * length, top - length, top);
            }
            middle = Arrays.med3(array, bottom, middle, top);
        }
        byte partionValue = array[middle];
        int a = b = start;
        int c = d = end - 1;
        while (true) {
            if (b <= c && array[b] <= partionValue) {
                if (array[b] == partionValue) {
                    temp = array[a];
                    array[a++] = array[b];
                    array[b] = temp;
                }
                ++b;
                continue;
            }
            while (c >= b && array[c] >= partionValue) {
                if (array[c] == partionValue) {
                    temp = array[c];
                    array[c] = array[d];
                    array[d--] = temp;
                }
                --c;
            }
            if (b > c) break;
            temp = array[b];
            array[b++] = array[c];
            array[c--] = temp;
        }
        length = a - start < b - a ? a - start : b - a;
        int l = start;
        int h = b - length;
        while (length-- > 0) {
            temp = array[l];
            array[l++] = array[h];
            array[h++] = temp;
        }
        length = d - c < end - 1 - d ? d - c : end - 1 - d;
        l = b;
        h = end - length;
        while (length-- > 0) {
            temp = array[l];
            array[l++] = array[h];
            array[h++] = temp;
        }
        length = b - a;
        if (length > 0) {
            Arrays.sort(start, start + length, array);
        }
        if ((length = d - c) > 0) {
            Arrays.sort(end - length, end, array);
        }
    }

    public static void sort(char[] array) {
        Arrays.sort(0, array.length, array);
    }

    public static void sort(char[] array, int start, int end) {
        if (start >= 0 && end <= array.length) {
            if (start > end) {
                throw new IllegalArgumentException();
            }
        } else {
            throw new ArrayIndexOutOfBoundsException();
        }
        Arrays.sort(start, end, array);
    }

    private static void sort(int start, int end, char[] array) {
        char temp;
        int d;
        int b;
        int length = end - start;
        if (length < 7) {
            int i = start + 1;
            while (i < end) {
                int j = i;
                while (j > start && array[j - 1] > array[j]) {
                    char temp2 = array[j];
                    array[j] = array[j - 1];
                    array[j - 1] = temp2;
                    --j;
                }
                ++i;
            }
            return;
        }
        int middle = (start + end) / 2;
        if (length > 7) {
            int bottom = start;
            int top = end - 1;
            if (length > 40) {
                bottom = Arrays.med3(array, bottom, bottom + (length /= 8), bottom + 2 * length);
                middle = Arrays.med3(array, middle - length, middle, middle + length);
                top = Arrays.med3(array, top - 2 * length, top - length, top);
            }
            middle = Arrays.med3(array, bottom, middle, top);
        }
        char partionValue = array[middle];
        int a = b = start;
        int c = d = end - 1;
        while (true) {
            if (b <= c && array[b] <= partionValue) {
                if (array[b] == partionValue) {
                    temp = array[a];
                    array[a++] = array[b];
                    array[b] = temp;
                }
                ++b;
                continue;
            }
            while (c >= b && array[c] >= partionValue) {
                if (array[c] == partionValue) {
                    temp = array[c];
                    array[c] = array[d];
                    array[d--] = temp;
                }
                --c;
            }
            if (b > c) break;
            temp = array[b];
            array[b++] = array[c];
            array[c--] = temp;
        }
        length = a - start < b - a ? a - start : b - a;
        int l = start;
        int h = b - length;
        while (length-- > 0) {
            temp = array[l];
            array[l++] = array[h];
            array[h++] = temp;
        }
        length = d - c < end - 1 - d ? d - c : end - 1 - d;
        l = b;
        h = end - length;
        while (length-- > 0) {
            temp = array[l];
            array[l++] = array[h];
            array[h++] = temp;
        }
        length = b - a;
        if (length > 0) {
            Arrays.sort(start, start + length, array);
        }
        if ((length = d - c) > 0) {
            Arrays.sort(end - length, end, array);
        }
    }

    public static void sort(double[] array) {
        Arrays.sort(0, array.length, array);
    }

    public static void sort(double[] array, int start, int end) {
        if (start >= 0 && end <= array.length) {
            if (start > end) {
                throw new IllegalArgumentException();
            }
        } else {
            throw new ArrayIndexOutOfBoundsException();
        }
        Arrays.sort(start, end, array);
    }

    private static void sort(int start, int end, double[] array) {
        double temp;
        int d;
        int b;
        int length = end - start;
        if (length < 7) {
            int i = start + 1;
            while (i < end) {
                int j = i;
                while (j > start && Arrays.lessThan(array[j], array[j - 1])) {
                    double temp2 = array[j];
                    array[j] = array[j - 1];
                    array[j - 1] = temp2;
                    --j;
                }
                ++i;
            }
            return;
        }
        int middle = (start + end) / 2;
        if (length > 7) {
            int bottom = start;
            int top = end - 1;
            if (length > 40) {
                bottom = Arrays.med3(array, bottom, bottom + (length /= 8), bottom + 2 * length);
                middle = Arrays.med3(array, middle - length, middle, middle + length);
                top = Arrays.med3(array, top - 2 * length, top - length, top);
            }
            middle = Arrays.med3(array, bottom, middle, top);
        }
        double partionValue = array[middle];
        int a = b = start;
        int c = d = end - 1;
        while (true) {
            if (b <= c && !Arrays.lessThan(partionValue, array[b])) {
                if (array[b] == partionValue) {
                    temp = array[a];
                    array[a++] = array[b];
                    array[b] = temp;
                }
                ++b;
                continue;
            }
            while (c >= b && !Arrays.lessThan(array[c], partionValue)) {
                if (array[c] == partionValue) {
                    temp = array[c];
                    array[c] = array[d];
                    array[d--] = temp;
                }
                --c;
            }
            if (b > c) break;
            temp = array[b];
            array[b++] = array[c];
            array[c--] = temp;
        }
        length = a - start < b - a ? a - start : b - a;
        int l = start;
        int h = b - length;
        while (length-- > 0) {
            temp = array[l];
            array[l++] = array[h];
            array[h++] = temp;
        }
        length = d - c < end - 1 - d ? d - c : end - 1 - d;
        l = b;
        h = end - length;
        while (length-- > 0) {
            temp = array[l];
            array[l++] = array[h];
            array[h++] = temp;
        }
        length = b - a;
        if (length > 0) {
            Arrays.sort(start, start + length, array);
        }
        if ((length = d - c) > 0) {
            Arrays.sort(end - length, end, array);
        }
    }

    public static void sort(float[] array) {
        Arrays.sort(0, array.length, array);
    }

    public static void sort(float[] array, int start, int end) {
        if (start >= 0 && end <= array.length) {
            if (start > end) {
                throw new IllegalArgumentException();
            }
        } else {
            throw new ArrayIndexOutOfBoundsException();
        }
        Arrays.sort(start, end, array);
    }

    private static void sort(int start, int end, float[] array) {
        float temp;
        int d;
        int b;
        int length = end - start;
        if (length < 7) {
            int i = start + 1;
            while (i < end) {
                int j = i;
                while (j > start && Arrays.lessThan(array[j], array[j - 1])) {
                    float temp2 = array[j];
                    array[j] = array[j - 1];
                    array[j - 1] = temp2;
                    --j;
                }
                ++i;
            }
            return;
        }
        int middle = (start + end) / 2;
        if (length > 7) {
            int bottom = start;
            int top = end - 1;
            if (length > 40) {
                bottom = Arrays.med3(array, bottom, bottom + (length /= 8), bottom + 2 * length);
                middle = Arrays.med3(array, middle - length, middle, middle + length);
                top = Arrays.med3(array, top - 2 * length, top - length, top);
            }
            middle = Arrays.med3(array, bottom, middle, top);
        }
        float partionValue = array[middle];
        int a = b = start;
        int c = d = end - 1;
        while (true) {
            if (b <= c && !Arrays.lessThan(partionValue, array[b])) {
                if (array[b] == partionValue) {
                    temp = array[a];
                    array[a++] = array[b];
                    array[b] = temp;
                }
                ++b;
                continue;
            }
            while (c >= b && !Arrays.lessThan(array[c], partionValue)) {
                if (array[c] == partionValue) {
                    temp = array[c];
                    array[c] = array[d];
                    array[d--] = temp;
                }
                --c;
            }
            if (b > c) break;
            temp = array[b];
            array[b++] = array[c];
            array[c--] = temp;
        }
        length = a - start < b - a ? a - start : b - a;
        int l = start;
        int h = b - length;
        while (length-- > 0) {
            temp = array[l];
            array[l++] = array[h];
            array[h++] = temp;
        }
        length = d - c < end - 1 - d ? d - c : end - 1 - d;
        l = b;
        h = end - length;
        while (length-- > 0) {
            temp = array[l];
            array[l++] = array[h];
            array[h++] = temp;
        }
        length = b - a;
        if (length > 0) {
            Arrays.sort(start, start + length, array);
        }
        if ((length = d - c) > 0) {
            Arrays.sort(end - length, end, array);
        }
    }

    public static void sort(int[] array) {
        Arrays.sort(0, array.length, array);
    }

    public static void sort(int[] array, int start, int end) {
        if (start >= 0 && end <= array.length) {
            if (start > end) {
                throw new IllegalArgumentException();
            }
        } else {
            throw new ArrayIndexOutOfBoundsException();
        }
        Arrays.sort(start, end, array);
    }

    private static void sort(int start, int end, int[] array) {
        int temp;
        int d;
        int b;
        int length = end - start;
        if (length < 7) {
            int i = start + 1;
            while (i < end) {
                int j = i;
                while (j > start && array[j - 1] > array[j]) {
                    int temp2 = array[j];
                    array[j] = array[j - 1];
                    array[j - 1] = temp2;
                    --j;
                }
                ++i;
            }
            return;
        }
        int middle = (start + end) / 2;
        if (length > 7) {
            int bottom = start;
            int top = end - 1;
            if (length > 40) {
                bottom = Arrays.med3(array, bottom, bottom + (length /= 8), bottom + 2 * length);
                middle = Arrays.med3(array, middle - length, middle, middle + length);
                top = Arrays.med3(array, top - 2 * length, top - length, top);
            }
            middle = Arrays.med3(array, bottom, middle, top);
        }
        int partionValue = array[middle];
        int a = b = start;
        int c = d = end - 1;
        while (true) {
            if (b <= c && array[b] <= partionValue) {
                if (array[b] == partionValue) {
                    temp = array[a];
                    array[a++] = array[b];
                    array[b] = temp;
                }
                ++b;
                continue;
            }
            while (c >= b && array[c] >= partionValue) {
                if (array[c] == partionValue) {
                    temp = array[c];
                    array[c] = array[d];
                    array[d--] = temp;
                }
                --c;
            }
            if (b > c) break;
            temp = array[b];
            array[b++] = array[c];
            array[c--] = temp;
        }
        length = a - start < b - a ? a - start : b - a;
        int l = start;
        int h = b - length;
        while (length-- > 0) {
            temp = array[l];
            array[l++] = array[h];
            array[h++] = temp;
        }
        length = d - c < end - 1 - d ? d - c : end - 1 - d;
        l = b;
        h = end - length;
        while (length-- > 0) {
            temp = array[l];
            array[l++] = array[h];
            array[h++] = temp;
        }
        length = b - a;
        if (length > 0) {
            Arrays.sort(start, start + length, array);
        }
        if ((length = d - c) > 0) {
            Arrays.sort(end - length, end, array);
        }
    }

    public static void sort(long[] array) {
        Arrays.sort(0, array.length, array);
    }

    public static void sort(long[] array, int start, int end) {
        if (start >= 0 && end <= array.length) {
            if (start > end) {
                throw new IllegalArgumentException();
            }
        } else {
            throw new ArrayIndexOutOfBoundsException();
        }
        Arrays.sort(start, end, array);
    }

    private static void sort(int start, int end, long[] array) {
        long temp;
        int d;
        int b;
        int length = end - start;
        if (length < 7) {
            int i = start + 1;
            while (i < end) {
                int j = i;
                while (j > start && array[j - 1] > array[j]) {
                    long temp2 = array[j];
                    array[j] = array[j - 1];
                    array[j - 1] = temp2;
                    --j;
                }
                ++i;
            }
            return;
        }
        int middle = (start + end) / 2;
        if (length > 7) {
            int bottom = start;
            int top = end - 1;
            if (length > 40) {
                bottom = Arrays.med3(array, bottom, bottom + (length /= 8), bottom + 2 * length);
                middle = Arrays.med3(array, middle - length, middle, middle + length);
                top = Arrays.med3(array, top - 2 * length, top - length, top);
            }
            middle = Arrays.med3(array, bottom, middle, top);
        }
        long partionValue = array[middle];
        int a = b = start;
        int c = d = end - 1;
        while (true) {
            if (b <= c && array[b] <= partionValue) {
                if (array[b] == partionValue) {
                    temp = array[a];
                    array[a++] = array[b];
                    array[b] = temp;
                }
                ++b;
                continue;
            }
            while (c >= b && array[c] >= partionValue) {
                if (array[c] == partionValue) {
                    temp = array[c];
                    array[c] = array[d];
                    array[d--] = temp;
                }
                --c;
            }
            if (b > c) break;
            temp = array[b];
            array[b++] = array[c];
            array[c--] = temp;
        }
        length = a - start < b - a ? a - start : b - a;
        int l = start;
        int h = b - length;
        while (length-- > 0) {
            temp = array[l];
            array[l++] = array[h];
            array[h++] = temp;
        }
        length = d - c < end - 1 - d ? d - c : end - 1 - d;
        l = b;
        h = end - length;
        while (length-- > 0) {
            temp = array[l];
            array[l++] = array[h];
            array[h++] = temp;
        }
        length = b - a;
        if (length > 0) {
            Arrays.sort(start, start + length, array);
        }
        if ((length = d - c) > 0) {
            Arrays.sort(end - length, end, array);
        }
    }

    public static void sort(Object[] array) {
        Arrays.sort(0, array.length, array);
    }

    public static void sort(Object[] array, int start, int end) {
        if (start >= 0 && end <= array.length) {
            if (start > end) {
                throw new IllegalArgumentException();
            }
        } else {
            throw new ArrayIndexOutOfBoundsException();
        }
        Arrays.sort(start, end, array);
    }

    private static void sort(int start, int end, Object[] array) {
        int middle = (start + end) / 2;
        if (start + 1 < middle) {
            Arrays.sort(start, middle, array);
        }
        if (middle + 1 < end) {
            Arrays.sort(middle, end, array);
        }
        if (start + 1 >= end) {
            return;
        }
        if (((Comparable)array[middle - 1]).compareTo(array[middle]) <= 0) {
            return;
        }
        if (start + 2 == end) {
            Object temp = array[start];
            array[start] = array[middle];
            array[middle] = temp;
            return;
        }
        int i1 = start;
        int i2 = middle;
        int i3 = 0;
        Object[] merge = new Object[end - start];
        while (i1 < middle && i2 < end) {
            Object object = merge[i3++] = ((Comparable)array[i1]).compareTo(array[i2]) <= 0 ? array[i1++] : array[i2++];
        }
        if (i1 < middle) {
            System.arraycopy((Object)array, i1, (Object)merge, i3, middle - i1);
        }
        System.arraycopy((Object)merge, 0, (Object)array, start, i2 - start);
    }

    public static void sort(Object[] array, int start, int end, Comparator comparator) {
        if (start >= 0 && end <= array.length) {
            if (start > end) {
                throw new IllegalArgumentException();
            }
        } else {
            throw new ArrayIndexOutOfBoundsException();
        }
        Arrays.sort(start, end, array, comparator);
    }

    private static void sort(int start, int end, Object[] array, Comparator comparator) {
        int middle = (start + end) / 2;
        if (start + 1 < middle) {
            Arrays.sort(start, middle, array, comparator);
        }
        if (middle + 1 < end) {
            Arrays.sort(middle, end, array, comparator);
        }
        if (start + 1 >= end) {
            return;
        }
        if (comparator.compare(array[middle - 1], array[middle]) <= 0) {
            return;
        }
        if (start + 2 == end) {
            Object temp = array[start];
            array[start] = array[middle];
            array[middle] = temp;
            return;
        }
        int i1 = start;
        int i2 = middle;
        int i3 = 0;
        Object[] merge = new Object[end - start];
        while (i1 < middle && i2 < end) {
            Object object = merge[i3++] = comparator.compare(array[i1], array[i2]) <= 0 ? array[i1++] : array[i2++];
        }
        if (i1 < middle) {
            System.arraycopy((Object)array, i1, (Object)merge, i3, middle - i1);
        }
        System.arraycopy((Object)merge, 0, (Object)array, start, i2 - start);
    }

    public static void sort(Object[] array, Comparator comparator) {
        Arrays.sort(0, array.length, array, comparator);
    }

    public static void sort(short[] array) {
        Arrays.sort(0, array.length, array);
    }

    public static void sort(short[] array, int start, int end) {
        if (start >= 0 && end <= array.length) {
            if (start > end) {
                throw new IllegalArgumentException();
            }
        } else {
            throw new ArrayIndexOutOfBoundsException();
        }
        Arrays.sort(start, end, array);
    }

    private static void sort(int start, int end, short[] array) {
        short temp;
        int d;
        int b;
        int length = end - start;
        if (length < 7) {
            int i = start + 1;
            while (i < end) {
                int j = i;
                while (j > start && array[j - 1] > array[j]) {
                    short temp2 = array[j];
                    array[j] = array[j - 1];
                    array[j - 1] = temp2;
                    --j;
                }
                ++i;
            }
            return;
        }
        int middle = (start + end) / 2;
        if (length > 7) {
            int bottom = start;
            int top = end - 1;
            if (length > 40) {
                bottom = Arrays.med3(array, bottom, bottom + (length /= 8), bottom + 2 * length);
                middle = Arrays.med3(array, middle - length, middle, middle + length);
                top = Arrays.med3(array, top - 2 * length, top - length, top);
            }
            middle = Arrays.med3(array, bottom, middle, top);
        }
        short partionValue = array[middle];
        int a = b = start;
        int c = d = end - 1;
        while (true) {
            if (b <= c && array[b] <= partionValue) {
                if (array[b] == partionValue) {
                    temp = array[a];
                    array[a++] = array[b];
                    array[b] = temp;
                }
                ++b;
                continue;
            }
            while (c >= b && array[c] >= partionValue) {
                if (array[c] == partionValue) {
                    temp = array[c];
                    array[c] = array[d];
                    array[d--] = temp;
                }
                --c;
            }
            if (b > c) break;
            temp = array[b];
            array[b++] = array[c];
            array[c--] = temp;
        }
        length = a - start < b - a ? a - start : b - a;
        int l = start;
        int h = b - length;
        while (length-- > 0) {
            temp = array[l];
            array[l++] = array[h];
            array[h++] = temp;
        }
        length = d - c < end - 1 - d ? d - c : end - 1 - d;
        l = b;
        h = end - length;
        while (length-- > 0) {
            temp = array[l];
            array[l++] = array[h];
            array[h++] = temp;
        }
        length = b - a;
        if (length > 0) {
            Arrays.sort(start, start + length, array);
        }
        if ((length = d - c) > 0) {
            Arrays.sort(end - length, end, array);
        }
    }

    private static class ArrayList
    extends AbstractList
    implements List,
    Serializable,
    RandomAccess {
        private static final long serialVersionUID = -2764017481108945198L;
        private final Object[] a;

        ArrayList(Object[] storage) {
            if (storage == null) {
                throw new NullPointerException();
            }
            this.a = storage;
        }

        public boolean contains(Object object) {
            if (object != null) {
                int i = 0;
                while (i < this.a.length) {
                    if (object.equals(this.a[i])) {
                        return true;
                    }
                    ++i;
                }
            } else {
                int i = 0;
                while (i < this.a.length) {
                    if (this.a[i] == null) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }

        public Object get(int location) {
            try {
                return this.a[location];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new IndexOutOfBoundsException();
            }
        }

        public int indexOf(Object object) {
            if (object != null) {
                int i = 0;
                while (i < this.a.length) {
                    if (object.equals(this.a[i])) {
                        return i;
                    }
                    ++i;
                }
            } else {
                int i = 0;
                while (i < this.a.length) {
                    if (this.a[i] == null) {
                        return i;
                    }
                    ++i;
                }
            }
            return -1;
        }

        public int lastIndexOf(Object object) {
            if (object != null) {
                int i = this.a.length - 1;
                while (i >= 0) {
                    if (object.equals(this.a[i])) {
                        return i;
                    }
                    --i;
                }
            } else {
                int i = this.a.length - 1;
                while (i >= 0) {
                    if (this.a[i] == null) {
                        return i;
                    }
                    --i;
                }
            }
            return -1;
        }

        public Object set(int location, Object object) {
            try {
                Object result = this.a[location];
                this.a[location] = object;
                return result;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new IndexOutOfBoundsException();
            }
            catch (ArrayStoreException arrayStoreException) {
                throw new ClassCastException();
            }
        }

        public int size() {
            return this.a.length;
        }

        public Object[] toArray() {
            return (Object[])this.a.clone();
        }

        public Object[] toArray(Object[] contents) {
            int size = this.size();
            if (size > contents.length) {
                contents = (Object[])Array.newInstance(contents.getClass().getComponentType(), size);
            }
            System.arraycopy((Object)this.a, 0, (Object)contents, 0, size);
            if (size < contents.length) {
                contents[size] = null;
            }
            return contents;
        }
    }
}

