/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import com.ibm.oti.util.ExtendedResourceBundle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public abstract class Calendar
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -1807547505821590642L;
    protected boolean areFieldsSet = false;
    protected int[] fields = new int[17];
    protected boolean[] isSet = new boolean[17];
    protected boolean isTimeSet = false;
    protected long time;
    transient int lastTimeFieldSet;
    transient int lastDateFieldSet;
    private boolean lenient;
    private int firstDayOfWeek;
    private int minimalDaysInFirstWeek;
    private TimeZone zone;
    public static final int JANUARY = 0;
    public static final int FEBRUARY = 1;
    public static final int MARCH = 2;
    public static final int APRIL = 3;
    public static final int MAY = 4;
    public static final int JUNE = 5;
    public static final int JULY = 6;
    public static final int AUGUST = 7;
    public static final int SEPTEMBER = 8;
    public static final int OCTOBER = 9;
    public static final int NOVEMBER = 10;
    public static final int DECEMBER = 11;
    public static final int UNDECIMBER = 12;
    public static final int SUNDAY = 1;
    public static final int MONDAY = 2;
    public static final int TUESDAY = 3;
    public static final int WEDNESDAY = 4;
    public static final int THURSDAY = 5;
    public static final int FRIDAY = 6;
    public static final int SATURDAY = 7;
    public static final int ERA = 0;
    public static final int YEAR = 1;
    public static final int MONTH = 2;
    public static final int WEEK_OF_YEAR = 3;
    public static final int WEEK_OF_MONTH = 4;
    public static final int DATE = 5;
    public static final int DAY_OF_MONTH = 5;
    public static final int DAY_OF_YEAR = 6;
    public static final int DAY_OF_WEEK = 7;
    public static final int DAY_OF_WEEK_IN_MONTH = 8;
    public static final int AM_PM = 9;
    public static final int HOUR = 10;
    public static final int HOUR_OF_DAY = 11;
    public static final int MINUTE = 12;
    public static final int SECOND = 13;
    public static final int MILLISECOND = 14;
    public static final int ZONE_OFFSET = 15;
    public static final int DST_OFFSET = 16;
    public static final int FIELD_COUNT = 17;
    public static final int AM = 0;
    public static final int PM = 1;
    private static String[] fieldNames = new String[]{"ERA=", "YEAR=", "MONTH=", "WEEK_OF_YEAR=", "WEEK_OF_MONTH=", "DAY_OF_MONTH=", "DAY_OF_YEAR=", "DAY_OF_WEEK=", "DAY_OF_WEEK_IN_MONTH=", "AM_PM=", "HOUR=", "HOUR_OF_DAY", "MINUTE=", "SECOND=", "MILLISECOND=", "ZONE_OFFSET=", "DST_OFFSET="};
    private static final ObjectStreamField[] serialPersistentFields;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        ObjectStreamField[] objectStreamFieldArray = new ObjectStreamField[11];
        objectStreamFieldArray[0] = new ObjectStreamField("areFieldsSet", Boolean.TYPE);
        Class clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[I");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectStreamFieldArray[1] = new ObjectStreamField("fields", clazz);
        objectStreamFieldArray[2] = new ObjectStreamField("firstDayOfWeek", Integer.TYPE);
        Class clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("[Z");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectStreamFieldArray[3] = new ObjectStreamField("isSet", clazz2);
        objectStreamFieldArray[4] = new ObjectStreamField("isTimeSet", Boolean.TYPE);
        objectStreamFieldArray[5] = new ObjectStreamField("lenient", Boolean.TYPE);
        objectStreamFieldArray[6] = new ObjectStreamField("minimalDaysInFirstWeek", Integer.TYPE);
        objectStreamFieldArray[7] = new ObjectStreamField("nextStamp", Integer.TYPE);
        objectStreamFieldArray[8] = new ObjectStreamField("serialVersionOnStream", Integer.TYPE);
        objectStreamFieldArray[9] = new ObjectStreamField("time", Long.TYPE);
        Class clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("java.util.TimeZone");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectStreamFieldArray[10] = new ObjectStreamField("zone", clazz3);
        serialPersistentFields = objectStreamFieldArray;
    }

    protected Calendar() {
        this(TimeZone.getDefault(), Locale.getDefault());
    }

    Calendar(TimeZone timezone) {
        this.setLenient(true);
        this.setTimeZone(timezone);
    }

    protected Calendar(TimeZone timezone, Locale locale) {
        this(timezone);
        ExtendedResourceBundle bundle = (ExtendedResourceBundle)Locale.getBundle("Locale", locale);
        this.setFirstDayOfWeek((Integer)bundle.getObject(com.ibm.oti.locale.Locale.FIRST_DAY));
        this.setMinimalDaysInFirstWeek((Integer)bundle.getObject(com.ibm.oti.locale.Locale.MINIMAL_DAYS));
    }

    public abstract void add(int var1, int var2);

    public boolean after(Object calendar) {
        if (!(calendar instanceof Calendar)) {
            return false;
        }
        return this.getTimeInMillis() > ((Calendar)calendar).getTimeInMillis();
    }

    public boolean before(Object calendar) {
        if (!(calendar instanceof Calendar)) {
            return false;
        }
        return this.getTimeInMillis() < ((Calendar)calendar).getTimeInMillis();
    }

    public final void clear() {
        int i = 0;
        while (i < 17) {
            this.fields[i] = 0;
            this.isSet[i] = false;
            ++i;
        }
        this.isTimeSet = false;
        this.areFieldsSet = false;
    }

    public final void clear(int field) {
        this.fields[field] = 0;
        this.isSet[field] = false;
        this.isTimeSet = false;
        this.areFieldsSet = false;
    }

    public Object clone() {
        try {
            Calendar clone = (Calendar)super.clone();
            clone.fields = (int[])this.fields.clone();
            clone.isSet = (boolean[])this.isSet.clone();
            return clone;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    protected void complete() {
        if (!this.isTimeSet) {
            this.computeTime();
            this.isTimeSet = true;
        }
        if (this.areFieldsSet) {
            int i = 0;
            while (i < this.isSet.length) {
                this.isSet[i] = true;
                ++i;
            }
        } else {
            this.computeFields();
            this.areFieldsSet = true;
        }
    }

    protected abstract void computeFields();

    protected abstract void computeTime();

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Calendar)) {
            return false;
        }
        Calendar cal = (Calendar)object;
        return this.getTimeInMillis() == cal.getTimeInMillis() && this.isLenient() == cal.isLenient() && this.getFirstDayOfWeek() == cal.getFirstDayOfWeek() && this.getMinimalDaysInFirstWeek() == cal.getMinimalDaysInFirstWeek() && this.getTimeZone().equals(cal.getTimeZone());
    }

    public int get(int field) {
        this.complete();
        return this.fields[field];
    }

    public int getActualMaximum(int field) {
        int value;
        int next = this.getLeastMaximum(field);
        if (this.getMaximum(field) == next) {
            return next;
        }
        this.complete();
        long orgTime = this.time;
        this.set(field, next);
        do {
            value = next;
            this.roll(field, true);
        } while ((next = this.get(field)) > value);
        this.time = orgTime;
        this.areFieldsSet = false;
        return value;
    }

    public int getActualMinimum(int field) {
        int value;
        int next = this.getGreatestMinimum(field);
        if (this.getMinimum(field) == next) {
            return next;
        }
        this.complete();
        long orgTime = this.time;
        this.set(field, next);
        do {
            value = next;
            this.roll(field, false);
        } while ((next = this.get(field)) < value);
        this.time = orgTime;
        this.areFieldsSet = false;
        return value;
    }

    public static synchronized Locale[] getAvailableLocales() {
        return Locale.getAvailableLocales();
    }

    public int getFirstDayOfWeek() {
        return this.firstDayOfWeek;
    }

    public abstract int getGreatestMinimum(int var1);

    public static synchronized Calendar getInstance() {
        return new GregorianCalendar();
    }

    public static synchronized Calendar getInstance(Locale locale) {
        return new GregorianCalendar(locale);
    }

    public static synchronized Calendar getInstance(TimeZone timezone) {
        return new GregorianCalendar(timezone);
    }

    public static synchronized Calendar getInstance(TimeZone timezone, Locale locale) {
        return new GregorianCalendar(timezone, locale);
    }

    public abstract int getLeastMaximum(int var1);

    public abstract int getMaximum(int var1);

    public int getMinimalDaysInFirstWeek() {
        return this.minimalDaysInFirstWeek;
    }

    public abstract int getMinimum(int var1);

    public final Date getTime() {
        return new Date(this.getTimeInMillis());
    }

    public long getTimeInMillis() {
        if (!this.isTimeSet) {
            this.computeTime();
            this.isTimeSet = true;
        }
        return this.time;
    }

    public TimeZone getTimeZone() {
        return this.zone;
    }

    public int hashCode() {
        return (this.isLenient() ? 1237 : 1231) + this.getFirstDayOfWeek() + this.getMinimalDaysInFirstWeek() + this.getTimeZone().hashCode();
    }

    protected final int internalGet(int field) {
        return this.fields[field];
    }

    public boolean isLenient() {
        return this.lenient;
    }

    public final boolean isSet(int field) {
        return this.isSet[field];
    }

    public void roll(int field, int value) {
        boolean increment = value >= 0;
        int count = increment ? value : -value;
        int i = 0;
        while (i < count) {
            this.roll(field, increment);
            ++i;
        }
    }

    public abstract void roll(int var1, boolean var2);

    public void set(int field, int value) {
        this.fields[field] = value;
        this.isSet[field] = true;
        this.isTimeSet = false;
        this.areFieldsSet = false;
        if (field > 2 && field < 9) {
            this.lastDateFieldSet = field;
        }
        if (field == 10 || field == 11) {
            this.lastTimeFieldSet = field;
        }
    }

    public final void set(int year, int month, int day) {
        this.set(1, year);
        this.set(2, month);
        this.set(5, day);
    }

    public final void set(int year, int month, int day, int hourOfDay, int minute) {
        this.set(year, month, day);
        this.set(11, hourOfDay);
        this.set(12, minute);
    }

    public final void set(int year, int month, int day, int hourOfDay, int minute, int second) {
        this.set(year, month, day, hourOfDay, minute);
        this.set(13, second);
    }

    public void setFirstDayOfWeek(int value) {
        this.firstDayOfWeek = value;
    }

    public void setLenient(boolean value) {
        this.lenient = value;
    }

    public void setMinimalDaysInFirstWeek(int value) {
        this.minimalDaysInFirstWeek = value;
    }

    public final void setTime(Date date) {
        this.setTimeInMillis(date.getTime());
    }

    public void setTimeInMillis(long milliseconds) {
        this.time = milliseconds;
        this.isTimeSet = true;
        this.areFieldsSet = false;
        this.complete();
    }

    public void setTimeZone(TimeZone timezone) {
        this.zone = timezone;
        this.areFieldsSet = false;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(String.valueOf(this.getClass().getName()) + "[time=" + (this.isTimeSet ? String.valueOf(this.time) : "?") + ",areFieldsSet=" + this.areFieldsSet + ",lenient=" + this.lenient + ",zone=" + this.zone + ",firstDayOfWeek=" + this.firstDayOfWeek + ",minimalDaysInFirstWeek=" + this.minimalDaysInFirstWeek);
        int i = 0;
        while (i < 17) {
            result.append(',');
            result.append(fieldNames[i]);
            result.append('=');
            if (this.isSet[i]) {
                result.append(this.fields[i]);
            } else {
                result.append('?');
            }
            ++i;
        }
        result.append(']');
        return result.toString();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        this.complete();
        ObjectOutputStream.PutField fields = stream.putFields();
        fields.put("areFieldsSet", this.areFieldsSet);
        fields.put("fields", this.fields);
        fields.put("firstDayOfWeek", this.firstDayOfWeek);
        fields.put("isSet", this.isSet);
        fields.put("isTimeSet", this.isTimeSet);
        fields.put("lenient", this.lenient);
        fields.put("minimalDaysInFirstWeek", this.minimalDaysInFirstWeek);
        fields.put("nextStamp", 2);
        fields.put("serialVersionOnStream", 1);
        fields.put("time", this.time);
        fields.put("zone", this.zone);
        stream.writeFields();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = stream.readFields();
        this.areFieldsSet = fields.get("areFieldsSet", false);
        this.fields = (int[])fields.get("fields", null);
        this.firstDayOfWeek = fields.get("firstDayOfWeek", 1);
        this.isSet = (boolean[])fields.get("isSet", null);
        this.isTimeSet = fields.get("isTimeSet", false);
        this.lenient = fields.get("lenient", true);
        this.minimalDaysInFirstWeek = fields.get("minimalDaysInFirstWeek", 1);
        this.time = fields.get("time", 0L);
        this.zone = (TimeZone)fields.get("zone", null);
    }
}

