/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto.spec;

import java.security.spec.AlgorithmParameterSpec;

public class RC2ParameterSpec
implements AlgorithmParameterSpec {
    private static final int RC2_IV_LEN_BYTES = 8;
    private final int effectiveKeyBits;
    private final byte[] initializationVector;

    public RC2ParameterSpec(int effectiveKeyBits) {
        this(effectiveKeyBits, null, 0);
    }

    public RC2ParameterSpec(int effectiveKeyBits, byte[] initializationVector) {
        this(effectiveKeyBits, initializationVector, 0);
    }

    public RC2ParameterSpec(int effectiveKeyBits, byte[] initializationVector, int offset) {
        this.effectiveKeyBits = effectiveKeyBits;
        if (initializationVector != null) {
            this.initializationVector = new byte[8];
            System.arraycopy((Object)initializationVector, offset, (Object)this.initializationVector, 0, 8);
        } else {
            this.initializationVector = null;
        }
    }

    public int getEffectiveKeyBits() {
        return this.effectiveKeyBits;
    }

    public byte[] getIV() {
        return this.initializationVector;
    }

    public boolean equals(Object o) {
        if (!(o instanceof RC2ParameterSpec)) {
            return false;
        }
        RC2ParameterSpec other = (RC2ParameterSpec)o;
        if (this.effectiveKeyBits != other.effectiveKeyBits) {
            return false;
        }
        if (this.initializationVector == null && other.initializationVector == null) {
            return true;
        }
        int i = 0;
        while (i < 8) {
            if (this.initializationVector[i] != other.initializationVector[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        int i = 0;
        while (i < 8) {
            hashCode *= this.initializationVector[i];
            ++i;
        }
        return hashCode += this.effectiveKeyBits;
    }
}

