/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.iptransport;

import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.iptransport.DnsClientMoGen;
import se.ericsson.cello.mao.DomainNameFormatException;
import se.ericsson.cello.mao.DomainNameValidation;
import se.ericsson.cello.mao.IpAddress;
import se.ericsson.cello.mao.IpFormatException;
import se.ericsson.cello.mao.SetRequestContext;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.transaction.Coordinator;

public class DnsClientMoImpl
extends DnsClientMoGen {
    public DnsClientMoImpl(ManagedObject managedObject, AttrList attrList, String string, Coordinator coordinator, InitialMaoContext initialMaoContext, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        super(coordinator, managedObject, string, froProxy, initialMaoContext, attrList, maoFroIndicationHandler);
    }

    public DnsClientMoImpl(MoData moData, InitialMaoContext initialMaoContext, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoNameAlreadyTakenException {
        super(moData, initialMaoContext, froProxy, maoFroIndicationHandler);
    }

    protected void validateDnsServerIpv4Address(String[] stringArray, SetRequestContext setRequestContext) throws MoAccessException {
        super.validateDnsServerIpv4Address(stringArray, setRequestContext);
        for (int i = 0; i < stringArray.length; ++i) {
            IpAddress ipAddress = new IpAddress(stringArray[i]);
            if (ipAddress.toInt() != 0) continue;
            throw new IpFormatException("dnsServerIpv4Address can't contain the IP address 0.0.0.0.");
        }
    }

    protected void validateDefDomainName(String string, SetRequestContext setRequestContext) throws MoAccessException {
        super.validateDefDomainName(string, setRequestContext);
        if (!string.equals("")) {
            try {
                DomainNameValidation.validate((String)string);
            }
            catch (DomainNameFormatException domainNameFormatException) {
                throw new ValueOutOfRangeException("defDomainName", "DnsClient", domainNameFormatException.getMessage());
            }
        }
    }
}

